/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.builder;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.ContextEntry;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.constraint.BetaConstraint;
import org.drools.base.rule.constraint.Constraint;
import org.kie.api.runtime.rule.FactHandle;

public class InstanceNotEqualsConstraint
implements BetaConstraint<ContextEntry> {
    private static final long serialVersionUID = 510L;
    private Declaration[] declarations = new Declaration[0];
    private Pattern otherPattern;

    public InstanceNotEqualsConstraint() {
    }

    public InstanceNotEqualsConstraint(Pattern otherPattern) {
        this.otherPattern = otherPattern;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.declarations = (Declaration[])in.readObject();
        this.otherPattern = (Pattern)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.declarations);
        out.writeObject(this.otherPattern);
    }

    public Declaration[] getRequiredDeclarations() {
        return this.declarations;
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
    }

    public Pattern getOtherPattern() {
        return this.otherPattern;
    }

    public boolean isTemporal() {
        return false;
    }

    public ContextEntry createContext() {
        return new InstanceNotEqualsConstraintContextEntry(this.otherPattern);
    }

    public boolean isAllowed(ContextEntry entry) {
        InstanceNotEqualsConstraintContextEntry context = (InstanceNotEqualsConstraintContextEntry)entry;
        return context.left != context.right;
    }

    public boolean isAllowedCachedLeft(ContextEntry context, FactHandle handle) {
        return ((InstanceNotEqualsConstraintContextEntry)context).left != handle.getObject();
    }

    public boolean isAllowedCachedRight(BaseTuple tuple, ContextEntry context) {
        return tuple.getObject(this.otherPattern.getTupleIndex()) != ((InstanceNotEqualsConstraintContextEntry)context).right;
    }

    public String toString() {
        return "[InstanceEqualsConstraint otherPattern=" + this.otherPattern + " ]";
    }

    public int hashCode() {
        return this.otherPattern.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof InstanceNotEqualsConstraint)) {
            return false;
        }
        InstanceNotEqualsConstraint other = (InstanceNotEqualsConstraint)object;
        return this.otherPattern.equals((Object)other.otherPattern);
    }

    public InstanceNotEqualsConstraint clone() {
        return new InstanceNotEqualsConstraint(this.otherPattern);
    }

    public Constraint.ConstraintType getType() {
        return Constraint.ConstraintType.BETA;
    }

    public BetaConstraint cloneIfInUse() {
        return this;
    }

    public static class InstanceNotEqualsConstraintContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 510L;
        public Object left;
        public Object right;
        private Pattern pattern;
        private ContextEntry entry;

        public InstanceNotEqualsConstraintContextEntry() {
        }

        public InstanceNotEqualsConstraintContextEntry(Pattern pattern) {
            this.pattern = pattern;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.left = in.readObject();
            this.right = in.readObject();
            this.pattern = (Pattern)in.readObject();
            this.entry = (ContextEntry)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.left);
            out.writeObject(this.right);
            out.writeObject(this.pattern);
            out.writeObject(this.entry);
        }

        public ContextEntry getNext() {
            return this.entry;
        }

        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        public void updateFromTuple(ValueResolver valueResolver, BaseTuple tuple) {
            this.left = tuple.getObject(this.pattern.getTupleIndex());
        }

        public void updateFromFactHandle(ValueResolver valueResolver, FactHandle handle) {
            this.right = handle.getObject();
        }

        public void resetTuple() {
            this.left = null;
        }

        public void resetFactHandle() {
            this.right = null;
        }
    }
}

