/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.EvalCondition;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.TupleFactory;
import org.drools.core.reteoo.TupleImpl;

public class PhreakEvalNode {
    private static final String EVAL_LEFT_TUPLE_DELETED = "EVAL_LEFT_TUPLE_DELETED";

    public void doNode(EvalConditionNode evalNode, EvalConditionNode.EvalMemory em, LeftTupleSink sink, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples, TupleSets trgLeftTuples, TupleSets stagedLeftTuples) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(evalNode, em, sink, reteEvaluator, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(evalNode, em, sink, reteEvaluator, srcLeftTuples, trgLeftTuples);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(EvalConditionNode evalNode, EvalConditionNode.EvalMemory em, LeftTupleSink sink, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples, TupleSets trgLeftTuples) {
        EvalCondition condition = evalNode.getCondition();
        TupleImpl leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            boolean allowed = condition.isAllowed((BaseTuple)leftTuple, (ValueResolver)reteEvaluator, em.context);
            if (allowed) {
                boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(evalNode, leftTuple);
                trgLeftTuples.addInsert(TupleFactory.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), useLeftMemory));
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftUpdates(EvalConditionNode evalNode, EvalConditionNode.EvalMemory em, LeftTupleSink sink, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples, TupleSets trgLeftTuples, TupleSets stagedLeftTuples) {
        EvalCondition condition = evalNode.getCondition();
        TupleImpl leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            boolean wasPropagated = leftTuple.getFirstChild() != null && leftTuple.getContextObject() != EVAL_LEFT_TUPLE_DELETED;
            boolean allowed = condition.isAllowed((BaseTuple)leftTuple, (ValueResolver)reteEvaluator, em.context);
            if (allowed) {
                leftTuple.setContextObject(null);
                if (wasPropagated) {
                    childLeftTuple = leftTuple.getFirstChild();
                    childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
                    RuleNetworkEvaluator.normalizeStagedTuples(stagedLeftTuples, childLeftTuple);
                    trgLeftTuples.addUpdate(childLeftTuple);
                } else {
                    trgLeftTuples.addInsert(TupleFactory.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), true));
                }
            } else if (wasPropagated) {
                leftTuple.setContextObject(EVAL_LEFT_TUPLE_DELETED);
                childLeftTuple = leftTuple.getFirstChild();
                childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
                RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftDeletes(TupleSets srcLeftTuples, TupleSets trgLeftTuples, TupleSets stagedLeftTuples) {
        TupleImpl leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            TupleImpl childLeftTuple = leftTuple.getFirstChild();
            if (childLeftTuple != null) {
                childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
                RuleNetworkEvaluator.deleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }
}

