/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.ActivationsManager;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.ConditionalBranchEvaluator;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TupleFactory;
import org.drools.core.reteoo.TupleImpl;

public class PhreakBranchNode {
    public void doNode(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, ActivationsManager activationsManager, TupleSets srcLeftTuples, TupleSets trgLeftTuples, TupleSets stagedLeftTuples, RuleExecutor executor) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(sink, activationsManager, srcLeftTuples, trgLeftTuples, stagedLeftTuples, executor);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(branchNode, cbm, sink, activationsManager, srcLeftTuples, trgLeftTuples, stagedLeftTuples, executor);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(branchNode, cbm, sink, activationsManager, srcLeftTuples, trgLeftTuples, executor);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, ActivationsManager activationsManager, TupleSets srcLeftTuples, TupleSets trgLeftTuples, RuleExecutor executor) {
        ConditionalBranchEvaluator branchEvaluator = branchNode.getBranchEvaluator();
        RuleAgendaItem ruleAgendaItem = executor.getRuleAgendaItem();
        TupleImpl leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            boolean breaking = false;
            ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = branchEvaluator.evaluate(leftTuple, activationsManager.getReteEvaluator(), cbm.context);
            boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(branchNode, leftTuple);
            if (conditionalExecution != null) {
                RuleTerminalNode rtn = (RuleTerminalNode)conditionalExecution.getSink().getFirstLeftTupleSink();
                TupleImpl branchedLeftTuple = TupleFactory.createLeftTuple(leftTuple, rtn, leftTuple.getPropagationContext(), useLeftMemory);
                PhreakRuleTerminalNode.doLeftTupleInsert(rtn, executor, activationsManager, executor.getRuleAgendaItem(), branchedLeftTuple);
                breaking = conditionalExecution.isBreaking();
            }
            if (!breaking) {
                trgLeftTuples.addInsert(TupleFactory.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), useLeftMemory));
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftUpdates(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, ActivationsManager activationsManager, TupleSets srcLeftTuples, TupleSets trgLeftTuples, TupleSets stagedLeftTuples, RuleExecutor executor) {
        ConditionalBranchEvaluator branchEvaluator = branchNode.getBranchEvaluator();
        RuleAgendaItem ruleAgendaItem = executor.getRuleAgendaItem();
        TupleImpl leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            BranchTuples branchTuples = this.getBranchTuples(sink, leftTuple);
            RuleTerminalNode oldRtn = null;
            if (branchTuples.rtnLeftTuple != null) {
                oldRtn = (RuleTerminalNode)branchTuples.rtnLeftTuple.getSink();
            }
            ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = branchEvaluator.evaluate(leftTuple, activationsManager.getReteEvaluator(), cbm.context);
            RuleTerminalNode newRtn = null;
            boolean breaking = false;
            if (conditionalExecution != null) {
                newRtn = (RuleTerminalNode)conditionalExecution.getSink().getFirstLeftTupleSink();
                breaking = conditionalExecution.isBreaking();
            }
            if (oldRtn != null) {
                if (newRtn == null) {
                    if (branchTuples.rtnLeftTuple.getMemory() != null) {
                        executor.removeLeftTuple(branchTuples.rtnLeftTuple);
                    }
                    PhreakRuleTerminalNode.doLeftDelete(activationsManager, executor, branchTuples.rtnLeftTuple);
                } else if (newRtn == oldRtn) {
                    PhreakRuleTerminalNode.doLeftTupleUpdate(newRtn, executor, activationsManager, branchTuples.rtnLeftTuple);
                } else {
                    if (branchTuples.rtnLeftTuple.getMemory() != null) {
                        executor.removeLeftTuple(branchTuples.rtnLeftTuple);
                    }
                    PhreakRuleTerminalNode.doLeftDelete(activationsManager, executor, branchTuples.rtnLeftTuple);
                    branchTuples.rtnLeftTuple = TupleFactory.createLeftTuple(leftTuple, newRtn, leftTuple.getPropagationContext(), true);
                    PhreakRuleTerminalNode.doLeftTupleInsert(newRtn, executor, activationsManager, executor.getRuleAgendaItem(), branchTuples.rtnLeftTuple);
                }
            } else if (newRtn != null) {
                branchTuples.rtnLeftTuple = TupleFactory.createLeftTuple(leftTuple, newRtn, leftTuple.getPropagationContext(), true);
                PhreakRuleTerminalNode.doLeftTupleInsert(newRtn, executor, activationsManager, executor.getRuleAgendaItem(), branchTuples.rtnLeftTuple);
            }
            if (branchTuples.mainLeftTuple != null) {
                RuleNetworkEvaluator.normalizeStagedTuples(stagedLeftTuples, branchTuples.mainLeftTuple);
                if (!breaking) {
                    trgLeftTuples.addUpdate(branchTuples.mainLeftTuple);
                } else {
                    trgLeftTuples.addDelete(branchTuples.mainLeftTuple);
                }
            } else if (!breaking) {
                trgLeftTuples.addInsert(TupleFactory.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), true));
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftDeletes(LeftTupleSink sink, ActivationsManager activationsManager, TupleSets srcLeftTuples, TupleSets trgLeftTuples, TupleSets stagedLeftTuples, RuleExecutor executor) {
        TupleImpl leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            BranchTuples branchTuples = this.getBranchTuples(sink, leftTuple);
            if (branchTuples.rtnLeftTuple != null) {
                if (branchTuples.rtnLeftTuple.getMemory() != null) {
                    executor.removeLeftTuple(branchTuples.rtnLeftTuple);
                }
                PhreakRuleTerminalNode.doLeftDelete(activationsManager, executor, branchTuples.rtnLeftTuple);
            }
            if (branchTuples.mainLeftTuple != null) {
                RuleNetworkEvaluator.deleteChildLeftTuple(branchTuples.mainLeftTuple, trgLeftTuples, stagedLeftTuples);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    private BranchTuples getBranchTuples(LeftTupleSink sink, TupleImpl leftTuple) {
        BranchTuples branchTuples = new BranchTuples();
        TupleImpl child = leftTuple.getFirstChild();
        if (child != null) {
            if (child.getSink() == sink) {
                branchTuples.mainLeftTuple = child;
            } else {
                branchTuples.rtnLeftTuple = child;
            }
            child = child.getHandleNext();
            if (child != null) {
                if (child.getSink() == sink) {
                    branchTuples.mainLeftTuple = child;
                } else {
                    branchTuples.rtnLeftTuple = child;
                }
            }
        }
        return branchTuples;
    }

    private static class BranchTuples {
        TupleImpl rtnLeftTuple;
        TupleImpl mainLeftTuple;

        private BranchTuples() {
        }
    }
}

