/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import org.drools.base.factmodel.ClassDefinition;
import org.drools.base.rule.TypeDeclaration;
import org.drools.compiler.builder.impl.BuildResultCollector;
import org.drools.compiler.builder.impl.TypeDeclarationContext;
import org.drools.compiler.builder.impl.classbuilder.ClassBuilder;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.drl.ast.descr.AbstractClassTypeDeclarationDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.TypeDeclarationDescr;
import org.drools.util.ClassUtils;
import org.drools.util.TypeResolver;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class DeclaredClassBuilder {
    protected final TypeDeclarationContext typeDeclarationContext;
    protected final BuildResultCollector results;

    public DeclaredClassBuilder(TypeDeclarationContext typeDeclarationContext, BuildResultCollector results) {
        this.typeDeclarationContext = typeDeclarationContext;
        this.results = results;
    }

    public void generateBeanFromDefinition(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, PackageRegistry pkgRegistry, ClassDefinition def, ClassBuilder classBuilder) {
        if (type.isNovel()) {
            String fullName = typeDescr.getType().getFullName();
            JavaDialectRuntimeData dialect = (JavaDialectRuntimeData)pkgRegistry.getDialectRuntimeRegistry().getDialectData("java");
            if (this.ensureJavaTypeConsistency(typeDescr, def, pkgRegistry.getTypeResolver())) {
                String errorMessage = "Unable to compile declared " + type.getKind();
                this.buildClass(typeDescr, pkgRegistry, def, classBuilder, fullName, dialect, errorMessage);
            }
        }
    }

    private void buildClass(AbstractClassTypeDeclarationDescr typeDescr, PackageRegistry pkgRegistry, ClassDefinition def, ClassBuilder classBuilder, String fullName, JavaDialectRuntimeData dialect, String errorMessage) {
        try {
            byte[] bytecode = classBuilder.buildClass(def, this.typeDeclarationContext.getRootClassLoader());
            String resourceName = ClassUtils.convertClassToResourcePath((String)fullName);
            dialect.putClassDefinition(resourceName, bytecode);
            if (this.typeDeclarationContext.getKnowledgeBase() != null) {
                Class clazz = this.typeDeclarationContext.getKnowledgeBase().registerAndLoadTypeDefinition(fullName, bytecode);
                pkgRegistry.getTypeResolver().registerClass(fullName, clazz);
            } else if (this.typeDeclarationContext.getRootClassLoader() instanceof ProjectClassLoader) {
                Class clazz = ((ProjectClassLoader)this.typeDeclarationContext.getRootClassLoader()).defineClass(fullName, resourceName, bytecode);
                pkgRegistry.getTypeResolver().registerClass(fullName, clazz);
            } else {
                dialect.write(resourceName, bytecode);
            }
        }
        catch (Exception e) {
            this.results.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)typeDescr, String.format("%s%s: %s;", errorMessage, fullName, e.getMessage())));
        }
    }

    private boolean ensureJavaTypeConsistency(AbstractClassTypeDeclarationDescr typeDescr, ClassDefinition def, TypeResolver typeResolver) {
        try {
            if (typeDescr instanceof TypeDeclarationDescr && !((TypeDeclarationDescr)typeDescr).isTrait() && typeResolver.resolveType(def.getSuperClass()).isInterface()) {
                def.addInterface(def.getSuperClass());
                def.setSuperClass(null);
            }
            for (String sup : def.getInterfaces()) {
                if (typeResolver.resolveType(sup).isInterface()) continue;
                this.results.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)typeDescr, "Non-interface type used as super interface : " + sup));
                return false;
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.results.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)typeDescr, "Unable to resolve parent type :" + cnfe.getMessage()));
            return false;
        }
        return true;
    }
}

