/*
 * Decompiled with CFR 0.152.
 */
package org.drools.codegen.common;

import java.io.File;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import org.drools.codegen.common.AppPaths;
import org.drools.codegen.common.DroolsModelApplicationPropertyProvider;
import org.drools.codegen.common.di.DependencyInjectionAnnotator;
import org.drools.codegen.common.rest.RestAnnotator;

public interface DroolsModelBuildContext {
    public static final String APPLICATION_PROPERTIES_FILE_NAME = "application.properties";
    public static final String DEFAULT_PACKAGE_NAME = "org.kie.kogito.app";
    public static final String KOGITO_GENERATE_REST = "kogito.generate.rest";
    public static final String KOGITO_GENERATE_DI = "kogito.generate.di";

    public Optional<String> getApplicationProperty(String var1);

    public Collection<String> getApplicationProperties();

    public void setApplicationProperty(String var1, String var2);

    public void removeApplicationProperty(String var1);

    public String getPackageName();

    public ClassLoader getClassLoader();

    public AppPaths getAppPaths();

    public String name();

    public DependencyInjectionAnnotator getDependencyInjectionAnnotator();

    public RestAnnotator getRestAnnotator();

    public boolean hasRest();

    public boolean hasDI();

    default public boolean hasJackson() {
        return this.hasClassAvailable("com.fasterxml.jackson.core.JsonParser");
    }

    default public boolean hasJacksonDatabind() {
        return this.hasClassAvailable("com.fasterxml.jackson.databind.ObjectMapper");
    }

    default public boolean hasClassAvailable(String fqcn) {
        try {
            this.getClassLoader().loadClass(fqcn);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static interface Builder {
        public Builder withPackageName(String var1);

        public Builder withApplicationPropertyProvider(DroolsModelApplicationPropertyProvider var1);

        public Builder withApplicationProperties(Properties var1);

        public Builder withApplicationProperties(File ... var1);

        public Builder withClassAvailabilityResolver(Predicate<String> var1);

        public Builder withClassLoader(ClassLoader var1);

        public Builder withAppPaths(AppPaths var1);

        public DroolsModelBuildContext build();
    }
}

