/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.ruleunit;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.ruleunit.RuleUnitDescriptionLoader;
import org.kie.internal.ruleunit.RuleUnitDescription;

public class RuleUnitDescriptionRegistry {
    private State state = State.UNKNOWN;
    private final Map<String, RuleUnitDescription> ruleUnits = new ConcurrentHashMap<String, RuleUnitDescription>();

    public RuleUnitDescription getDescription(Object ruleUnit) {
        RuleUnitDescription ruleUnitDescr = this.ruleUnits.get(ruleUnit.getClass().getName());
        if (ruleUnitDescr == null) {
            throw new IllegalStateException("Unknown RuleUnitDescription: " + ruleUnit.getClass().getName());
        }
        return ruleUnitDescr;
    }

    public Optional<RuleUnitDescription> getDescription(String unitClassName) {
        return Optional.ofNullable(this.ruleUnits.get(unitClassName));
    }

    public Optional<RuleUnitDescription> getDescription(RuleImpl rule) {
        return this.getDescription(rule.getRuleUnitClassName());
    }

    public void add(RuleUnitDescriptionLoader loader) {
        if (loader != null) {
            this.ruleUnits.putAll(loader.getDescriptions());
            this.state = this.state.merge(loader.getState());
        }
    }

    public boolean hasUnits() {
        return !this.ruleUnits.isEmpty();
    }

    public static enum State {
        UNIT,
        NO_UNIT,
        UNKNOWN;


        State hasUnit(boolean hasUnit) {
            if (hasUnit) {
                if (this == NO_UNIT) {
                    throw new IllegalStateException("Cannot mix rules with and without unit");
                }
                return UNIT;
            }
            if (this == UNIT) {
                throw new IllegalStateException("Cannot mix rules with and without unit");
            }
            return NO_UNIT;
        }

        State merge(State other) {
            if (this == UNKNOWN) {
                return other;
            }
            if (other == UNKNOWN) {
                return this;
            }
            if (this != other) {
                throw new IllegalStateException("Cannot mix rules with and without unit");
            }
            return this;
        }
    }
}

