/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.util.index;

import org.drools.base.rule.IndexableConstraint;
import org.drools.base.rule.constraint.Constraint;
import org.drools.base.util.index.IndexUtil;
import org.kie.api.KieBaseConfiguration;

public enum ConstraintTypeOperator {
    EQUAL(true, "=="),
    NOT_EQUAL(false, "!="),
    GREATER_THAN(true, ">"),
    GREATER_OR_EQUAL(true, ">="),
    LESS_THAN(true, "<"),
    LESS_OR_EQUAL(true, "<="),
    RANGE(true, null),
    UNKNOWN(false, null);

    private final boolean indexable;
    private final String operator;

    private ConstraintTypeOperator(boolean indexable, String operator) {
        this.indexable = indexable;
        this.operator = operator;
    }

    public boolean isComparison() {
        return this.isAscending() || this.isDescending();
    }

    public boolean isEquality() {
        return this == EQUAL || this == NOT_EQUAL;
    }

    public boolean isAscending() {
        return this == GREATER_THAN || this == GREATER_OR_EQUAL;
    }

    public boolean isDescending() {
        return this == LESS_THAN || this == LESS_OR_EQUAL;
    }

    public boolean isIndexable() {
        return this.indexable;
    }

    public String getOperator() {
        return this.operator;
    }

    public boolean isIndexableForNode(int nodeType, IndexableConstraint constraint, KieBaseConfiguration config) {
        switch (this) {
            case EQUAL: {
                return true;
            }
            case NOT_EQUAL: 
            case UNKNOWN: {
                return false;
            }
        }
        return IndexUtil.canHaveRangeIndex(nodeType, constraint, config);
    }

    public ConstraintTypeOperator negate() {
        switch (this) {
            case EQUAL: {
                return NOT_EQUAL;
            }
            case NOT_EQUAL: {
                return EQUAL;
            }
            case GREATER_THAN: {
                return LESS_OR_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return LESS_THAN;
            }
            case LESS_OR_EQUAL: {
                return GREATER_THAN;
            }
            case LESS_THAN: {
                return GREATER_OR_EQUAL;
            }
        }
        return UNKNOWN;
    }

    public boolean canInverse() {
        switch (this) {
            case EQUAL: 
            case NOT_EQUAL: 
            case GREATER_THAN: 
            case GREATER_OR_EQUAL: 
            case LESS_OR_EQUAL: 
            case LESS_THAN: {
                return true;
            }
        }
        return false;
    }

    public ConstraintTypeOperator inverse() {
        switch (this) {
            case GREATER_THAN: {
                return LESS_THAN;
            }
            case GREATER_OR_EQUAL: {
                return LESS_OR_EQUAL;
            }
            case LESS_THAN: {
                return GREATER_THAN;
            }
            case LESS_OR_EQUAL: {
                return GREATER_OR_EQUAL;
            }
        }
        return this;
    }

    public static ConstraintTypeOperator decode(String operator) {
        return ConstraintTypeOperator.decode(operator, false);
    }

    public static ConstraintTypeOperator decode(String operator, boolean negated) {
        for (ConstraintTypeOperator c : ConstraintTypeOperator.values()) {
            if (c.getOperator() == null || !c.getOperator().equals(operator)) continue;
            return negated ? c.negate() : c;
        }
        return UNKNOWN;
    }

    public static ConstraintTypeOperator getType(Constraint constraint) {
        ConstraintTypeOperator constraintTypeOperator;
        if (constraint instanceof IndexableConstraint) {
            IndexableConstraint ic = (IndexableConstraint)constraint;
            constraintTypeOperator = ic.getConstraintType();
        } else {
            constraintTypeOperator = UNKNOWN;
        }
        return constraintTypeOperator;
    }
}

