/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.identity.impl.ldap;

import java.util.List;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.UserQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.identity.impl.ldap.LdapConfiguration;
import org.camunda.bpm.identity.impl.ldap.LdapIdentityProviderSession;

public class LdapUserQueryImpl
extends UserQueryImpl {
    private static final long serialVersionUID = 1L;
    private final LdapConfiguration ldapConfiguration;

    public LdapUserQueryImpl(LdapConfiguration ldapConfiguration) {
        this.ldapConfiguration = ldapConfiguration;
    }

    public LdapUserQueryImpl(CommandExecutor commandExecutor, LdapConfiguration ldapConfiguration) {
        super(commandExecutor);
        this.ldapConfiguration = ldapConfiguration;
    }

    public long executeCount(CommandContext commandContext) {
        LdapIdentityProviderSession provider = this.getLdapIdentityProvider(commandContext);
        return provider.findUserCountByQueryCriteria(this);
    }

    public List<User> executeList(CommandContext commandContext, Page page) {
        LdapIdentityProviderSession provider = this.getLdapIdentityProvider(commandContext);
        return provider.findUserByQueryCriteria(this);
    }

    protected LdapIdentityProviderSession getLdapIdentityProvider(CommandContext commandContext) {
        return (LdapIdentityProviderSession)commandContext.getReadOnlyIdentityProvider();
    }

    public UserQuery desc() {
        if (this.ldapConfiguration != null && !this.ldapConfiguration.isSortControlSupported()) {
            throw new UnsupportedOperationException("The LDAP identity provider does not support descending search order.");
        }
        return this;
    }
}

