/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.identity.impl.ldap;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.SortControl;
import javax.naming.ldap.SortKey;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.NativeUserQuery;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.impl.GroupQueryProperty;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.UserQueryImpl;
import org.camunda.bpm.engine.impl.UserQueryProperty;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.identity.IdentityProviderException;
import org.camunda.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.GroupEntity;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;
import org.camunda.bpm.identity.impl.ldap.LdapAuthenticationException;
import org.camunda.bpm.identity.impl.ldap.LdapConfiguration;
import org.camunda.bpm.identity.impl.ldap.LdapGroupEntity;
import org.camunda.bpm.identity.impl.ldap.LdapGroupQuery;
import org.camunda.bpm.identity.impl.ldap.LdapTenantQuery;
import org.camunda.bpm.identity.impl.ldap.LdapUserEntity;
import org.camunda.bpm.identity.impl.ldap.LdapUserQueryImpl;
import org.camunda.bpm.identity.impl.ldap.util.LdapPluginLogger;

public class LdapIdentityProviderSession
implements ReadOnlyIdentityProvider {
    protected LdapConfiguration ldapConfiguration;
    protected LdapContext initialContext;

    public LdapIdentityProviderSession(LdapConfiguration ldapConfiguration) {
        this.ldapConfiguration = ldapConfiguration;
    }

    public void flush() {
    }

    public void close() {
        this.closeLdapCtx(this.initialContext);
    }

    protected void closeLdapCtx(LdapContext context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (Exception e) {
                LdapPluginLogger.INSTANCE.exceptionWhenClosingLdapCOntext(e);
            }
        }
    }

    protected InitialLdapContext openContext(String userDn, String password) {
        Map<String, String> contextProperties;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.ldapConfiguration.getInitialContextFactory());
        env.put("java.naming.security.authentication", this.ldapConfiguration.getSecurityAuthentication());
        env.put("java.naming.provider.url", this.ldapConfiguration.getServerUrl());
        env.put("java.naming.security.principal", userDn);
        env.put("java.naming.security.credentials", password);
        if (this.ldapConfiguration.isAllowAnonymousLogin() && password.isEmpty()) {
            env.put("java.naming.security.authentication", "none");
        }
        if (this.ldapConfiguration.isUseSsl()) {
            env.put("java.naming.security.protocol", "ssl");
        }
        if ((contextProperties = this.ldapConfiguration.getContextProperties()) != null) {
            env.putAll(contextProperties);
        }
        try {
            return new InitialLdapContext(env, null);
        }
        catch (AuthenticationException e) {
            throw new LdapAuthenticationException("Could not authenticate with LDAP server", e);
        }
        catch (NamingException e) {
            throw new IdentityProviderException("Could not connect to LDAP server", (Throwable)e);
        }
    }

    protected void ensureContextInitialized() {
        if (this.initialContext == null) {
            this.initialContext = this.openContext(this.ldapConfiguration.getManagerDn(), this.ldapConfiguration.getManagerPassword());
        }
    }

    public User findUserById(String userId) {
        return (User)this.createUserQuery(Context.getCommandContext()).userId(userId).singleResult();
    }

    public UserQuery createUserQuery() {
        return new LdapUserQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired(), this.ldapConfiguration);
    }

    public UserQueryImpl createUserQuery(CommandContext commandContext) {
        return new LdapUserQueryImpl(this.ldapConfiguration);
    }

    public NativeUserQuery createNativeUserQuery() {
        throw new BadUserRequestException("Native user queries are not supported for LDAP identity service provider.");
    }

    public long findUserCountByQueryCriteria(LdapUserQueryImpl query) {
        this.ensureContextInitialized();
        return this.findUserByQueryCriteria(query).size();
    }

    public List<User> findUserByQueryCriteria(LdapUserQueryImpl query) {
        this.ensureContextInitialized();
        if (query.getEmailLike() != null) {
            query.userEmailLike(query.getEmailLike().replaceAll(LdapConfiguration.DB_QUERY_WILDCARD, LdapConfiguration.LDAP_QUERY_WILDCARD));
        }
        if (query.getFirstNameLike() != null) {
            query.userFirstNameLike(query.getFirstNameLike().replaceAll(LdapConfiguration.DB_QUERY_WILDCARD, LdapConfiguration.LDAP_QUERY_WILDCARD));
        }
        if (query.getLastNameLike() != null) {
            query.userLastNameLike(query.getLastNameLike().replaceAll(LdapConfiguration.DB_QUERY_WILDCARD, LdapConfiguration.LDAP_QUERY_WILDCARD));
        }
        if (query.getGroupId() != null) {
            return this.findUsersByGroupId(query);
        }
        String userBaseDn = this.composeDn(this.ldapConfiguration.getUserSearchBase(), this.ldapConfiguration.getBaseDn());
        return this.findUsersWithoutGroupId(query, userBaseDn, false);
    }

    protected List<User> findUsersByGroupId(LdapUserQueryImpl query) {
        StringBuilder resultLogger = new StringBuilder();
        if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("findUsersByGroupId: from ");
            resultLogger.append(query.getFirstResult());
        }
        String baseDn = this.getDnForGroup(query.getGroupId());
        String groupSearchFilter = "(& " + this.ldapConfiguration.getGroupSearchFilter() + ")";
        NamingEnumeration<SearchResult> enumeration = null;
        try {
            this.initializeControls((AbstractQuery<?, ?>)query, resultLogger);
            ArrayList<String> groupMemberList = new ArrayList<String>();
            int resultCount = 0;
            int pageNumber = 0;
            do {
                enumeration = this.initialContext.search(baseDn, groupSearchFilter, this.ldapConfiguration.getSearchControls());
                ++pageNumber;
                if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                    resultLogger.append(", (page:");
                    resultLogger.append(pageNumber);
                    resultLogger.append(")");
                }
                while (enumeration.hasMoreElements()) {
                    SearchResult result = (SearchResult)enumeration.nextElement();
                    Attribute memberAttribute = result.getAttributes().get(this.ldapConfiguration.getGroupMemberAttribute());
                    if (null == memberAttribute) continue;
                    NamingEnumeration<?> allMembers = memberAttribute.getAll();
                    while (allMembers.hasMoreElements()) {
                        if (resultCount >= query.getFirstResult()) {
                            groupMemberList.add((String)allMembers.nextElement());
                        }
                        ++resultCount;
                    }
                }
            } while (this.isNextPageDetected(resultLogger) && groupMemberList.size() < query.getMaxResults());
            ArrayList<User> userList = new ArrayList<User>();
            String userBaseDn = this.composeDn(this.ldapConfiguration.getUserSearchBase(), this.ldapConfiguration.getBaseDn());
            int memberCount = 0;
            for (String memberId : groupMemberList) {
                if (userList.size() < query.getMaxResults() && memberCount >= query.getFirstResult()) {
                    List<User> users;
                    if (this.ldapConfiguration.isUsePosixGroups()) {
                        query.userId(memberId);
                    }
                    List<User> list = users = this.ldapConfiguration.isUsePosixGroups() ? this.findUsersWithoutGroupId(query, userBaseDn, true) : this.findUsersWithoutGroupId(query, memberId, true);
                    if (!users.isEmpty()) {
                        userList.add(users.get(0));
                    }
                }
                ++memberCount;
            }
            if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                resultLogger.append("; Result size()=");
                resultLogger.append(userList.size());
                resultLogger.append(" FirstResult=");
                resultLogger.append(userList.isEmpty() ? "--" : ((User)userList.get(0)).getFirstName() + "]");
            }
            ArrayList<User> arrayList = userList;
            return arrayList;
        }
        catch (NamingException e) {
            if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                resultLogger.append("; Exception ");
                resultLogger.append(e);
            }
            throw new IdentityProviderException("Could not query for users " + resultLogger, (Throwable)e);
        }
        finally {
            try {
                if (enumeration != null) {
                    enumeration.close();
                }
            }
            catch (Exception exception) {}
            if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                resultLogger.append("]");
                LdapPluginLogger.INSTANCE.userQueryResult(resultLogger.toString());
            }
        }
    }

    public List<User> findUsersWithoutGroupId(LdapUserQueryImpl query, String userBaseDn, boolean ignorePagination) {
        StringBuilder resultLogger = new StringBuilder();
        if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("findUsersWithoutGroupId: from ");
            resultLogger.append(query.getFirstResult());
        }
        NamingEnumeration<SearchResult> enumeration = null;
        try {
            this.initializeControls((AbstractQuery<?, ?>)query, resultLogger);
            ArrayList<User> userList = new ArrayList<User>();
            int resultCount = 0;
            int pageNumber = 0;
            do {
                String filter = this.getUserSearchFilter(query);
                if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                    resultLogger.append(" search userBaseDn[");
                    resultLogger.append(userBaseDn);
                    resultLogger.append("] filter[");
                    resultLogger.append(filter);
                    resultLogger.append("];");
                }
                enumeration = this.initialContext.search(userBaseDn, filter, this.ldapConfiguration.getSearchControls());
                ++pageNumber;
                if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                    resultLogger.append(" (page:");
                    resultLogger.append(pageNumber);
                    resultLogger.append(") ");
                }
                while (enumeration.hasMoreElements() && (userList.size() < query.getMaxResults() || ignorePagination)) {
                    SearchResult result = (SearchResult)enumeration.nextElement();
                    LdapUserEntity user = this.transformUser(result);
                    String userId = user.getId();
                    if (userId == null) {
                        LdapPluginLogger.INSTANCE.invalidLdapUserReturned(user, result);
                        continue;
                    }
                    if (!this.isAuthenticatedUser(user) && !this.isAuthorized((Permission)Permissions.READ, (Resource)Resources.USER, userId)) continue;
                    if (resultCount >= query.getFirstResult() || ignorePagination) {
                        if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                            resultLogger.append("id=");
                            resultLogger.append(user.getId());
                            resultLogger.append(", firstName=");
                            resultLogger.append(user.getFirstName());
                            resultLogger.append(", lastName=");
                            resultLogger.append(user.getLastName());
                            resultLogger.append(" based on ");
                            resultLogger.append(result);
                            resultLogger.append(", ");
                        }
                        userList.add((User)user);
                    }
                    ++resultCount;
                }
            } while (this.isNextPageDetected(resultLogger) && userList.size() < query.getMaxResults());
            if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                resultLogger.append(";Result size()=");
                resultLogger.append(userList.size());
                resultLogger.append(" First[");
                resultLogger.append(userList.isEmpty() ? "--" : ((User)userList.get(0)).getFirstName() + "]");
            }
            ArrayList<User> arrayList = userList;
            return arrayList;
        }
        catch (NamingException e) {
            if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                resultLogger.append(";Exception: ");
                resultLogger.append(e);
            }
            throw new IdentityProviderException("Could not query for users " + resultLogger, (Throwable)e);
        }
        finally {
            try {
                if (enumeration != null) {
                    enumeration.close();
                }
            }
            catch (Exception exception) {}
            if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                resultLogger.append("]");
                LdapPluginLogger.INSTANCE.userQueryResult(resultLogger.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPassword(String userId, String password) {
        if (password == null) {
            return false;
        }
        if (userId == null || userId.isEmpty()) {
            return false;
        }
        if (!this.ldapConfiguration.isAllowAnonymousLogin() && password.equals("")) {
            return false;
        }
        LdapUserEntity user = (LdapUserEntity)this.findUserById(userId);
        this.close();
        if (user == null) {
            return false;
        }
        InitialLdapContext context = null;
        try {
            context = this.openContext(user.getDn(), password);
            boolean bl = true;
            this.closeLdapCtx(context);
            return bl;
        }
        catch (LdapAuthenticationException e) {
            try {
                boolean bl = false;
                this.closeLdapCtx(context);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeLdapCtx(context);
                throw throwable;
            }
        }
    }

    protected String getUserSearchFilter(LdapUserQueryImpl query) {
        StringWriter search = new StringWriter();
        search.write("(&");
        search.write(this.ldapConfiguration.getUserSearchFilter());
        if (query.getId() != null) {
            this.addFilter(this.ldapConfiguration.getUserIdAttribute(), this.escapeLDAPSearchFilter(query.getId()), search);
        }
        if (query.getIds() != null && query.getIds().length > 0) {
            search.write("(|");
            for (String userId : query.getIds()) {
                this.addFilter(this.ldapConfiguration.getUserIdAttribute(), this.escapeLDAPSearchFilter(userId), search);
            }
            search.write(")");
        }
        if (query.getEmail() != null) {
            this.addFilter(this.ldapConfiguration.getUserEmailAttribute(), query.getEmail(), search);
        }
        if (query.getEmailLike() != null) {
            this.addFilter(this.ldapConfiguration.getUserEmailAttribute(), query.getEmailLike(), search);
        }
        if (query.getFirstName() != null) {
            this.addFilter(this.ldapConfiguration.getUserFirstnameAttribute(), query.getFirstName(), search);
        }
        if (query.getFirstNameLike() != null) {
            this.addFilter(this.ldapConfiguration.getUserFirstnameAttribute(), query.getFirstNameLike(), search);
        }
        if (query.getLastName() != null) {
            this.addFilter(this.ldapConfiguration.getUserLastnameAttribute(), query.getLastName(), search);
        }
        if (query.getLastNameLike() != null) {
            this.addFilter(this.ldapConfiguration.getUserLastnameAttribute(), query.getLastNameLike(), search);
        }
        search.write(")");
        return search.toString();
    }

    public Group findGroupById(String groupId) {
        return (Group)this.createGroupQuery(Context.getCommandContext()).groupId(groupId).singleResult();
    }

    public GroupQuery createGroupQuery() {
        return new LdapGroupQuery(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    public GroupQuery createGroupQuery(CommandContext commandContext) {
        return new LdapGroupQuery();
    }

    public long findGroupCountByQueryCriteria(LdapGroupQuery ldapGroupQuery) {
        this.ensureContextInitialized();
        return this.findGroupByQueryCriteria(ldapGroupQuery).size();
    }

    public List<Group> findGroupByQueryCriteria(LdapGroupQuery query) {
        if (query.getNameLike() != null) {
            query.groupNameLike(query.getNameLike().replaceAll(LdapConfiguration.DB_QUERY_WILDCARD, LdapConfiguration.LDAP_QUERY_WILDCARD));
        }
        StringBuilder resultLogger = new StringBuilder();
        if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("findGroupByQueryCriteria: from ");
            resultLogger.append(query.getFirstResult());
        }
        this.ensureContextInitialized();
        String groupBaseDn = this.composeDn(this.ldapConfiguration.getGroupSearchBase(), this.ldapConfiguration.getBaseDn());
        NamingEnumeration<SearchResult> enumeration = null;
        try {
            this.initializeControls((AbstractQuery<?, ?>)query, resultLogger);
            String filter = this.getGroupSearchFilter(query);
            ArrayList<Group> groupList = new ArrayList<Group>();
            int resultCount = 0;
            int pageNumber = 0;
            do {
                enumeration = this.initialContext.search(groupBaseDn, filter, this.ldapConfiguration.getSearchControls());
                ++pageNumber;
                if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                    resultLogger.append("; (page:");
                    resultLogger.append(pageNumber);
                    resultLogger.append(") [");
                }
                while (enumeration.hasMoreElements() && groupList.size() < query.getMaxResults()) {
                    SearchResult result = (SearchResult)enumeration.nextElement();
                    GroupEntity group = this.transformGroup(result);
                    String groupId = group.getId();
                    if (groupId == null) {
                        LdapPluginLogger.INSTANCE.invalidLdapGroupReturned(group, result);
                        continue;
                    }
                    if (!this.isAuthorized((Permission)Permissions.READ, (Resource)Resources.GROUP, groupId)) continue;
                    if (resultCount >= query.getFirstResult()) {
                        if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                            resultLogger.append(group);
                            resultLogger.append(" based on ");
                            resultLogger.append(result);
                            resultLogger.append(", ");
                        }
                        groupList.add((Group)group);
                    }
                    ++resultCount;
                }
            } while (this.isNextPageDetected(resultLogger) && groupList.size() < query.getMaxResults());
            if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                resultLogger.append("; Result size()=");
                resultLogger.append(groupList.size());
                resultLogger.append(" FirstResult=");
                resultLogger.append(groupList.isEmpty() ? "--" : ((Group)groupList.get(0)).getName() + "]");
            }
            ArrayList<Group> arrayList = groupList;
            return arrayList;
        }
        catch (NamingException e) {
            if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                resultLogger.append("; Exception ");
                resultLogger.append(e);
            }
            throw new IdentityProviderException("Could not query for users " + resultLogger, (Throwable)e);
        }
        finally {
            try {
                if (enumeration != null) {
                    enumeration.close();
                }
            }
            catch (Exception exception) {}
            if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                resultLogger.append("]");
                LdapPluginLogger.INSTANCE.groupQueryResult(resultLogger.toString());
            }
        }
    }

    protected String getGroupSearchFilter(LdapGroupQuery query) {
        StringWriter search = new StringWriter();
        search.write("(&");
        search.write(this.ldapConfiguration.getGroupSearchFilter());
        if (query.getId() != null) {
            this.addFilter(this.ldapConfiguration.getGroupIdAttribute(), query.getId(), search);
        }
        if (query.getIds() != null && query.getIds().length > 0) {
            search.write("(|");
            for (String id : query.getIds()) {
                this.addFilter(this.ldapConfiguration.getGroupIdAttribute(), id, search);
            }
            search.write(")");
        }
        if (query.getName() != null) {
            this.addFilter(this.ldapConfiguration.getGroupNameAttribute(), query.getName(), search);
        }
        if (query.getNameLike() != null) {
            this.addFilter(this.ldapConfiguration.getGroupNameAttribute(), query.getNameLike(), search);
        }
        if (query.getUserId() != null) {
            String userDn = null;
            userDn = this.ldapConfiguration.isUsePosixGroups() ? query.getUserId() : this.getDnForUser(query.getUserId());
            this.addFilter(this.ldapConfiguration.getGroupMemberAttribute(), this.escapeLDAPSearchFilter(userDn), search);
        }
        search.write(")");
        return search.toString();
    }

    protected String getDnForUser(String userId) {
        LdapUserEntity user = (LdapUserEntity)((Object)this.createUserQuery(Context.getCommandContext()).userId(userId).singleResult());
        if (user == null) {
            return "";
        }
        return user.getDn();
    }

    protected String getDnForGroup(String groupId) {
        LdapGroupEntity group = (LdapGroupEntity)((Object)this.createGroupQuery(Context.getCommandContext()).groupId(groupId).singleResult());
        if (group == null) {
            return "";
        }
        return group.getDn();
    }

    protected String getStringAttributeValue(String attrName, Attributes attributes) throws NamingException {
        Attribute attribute = attributes.get(attrName);
        if (attribute != null) {
            return (String)attribute.get();
        }
        return null;
    }

    protected void addFilter(String attributeName, String attributeValue, StringWriter writer) {
        writer.write("(");
        writer.write(attributeName);
        writer.write("=");
        writer.write(attributeValue);
        writer.write(")");
    }

    protected LdapUserEntity transformUser(SearchResult result) throws NamingException {
        Attributes attributes = result.getAttributes();
        LdapUserEntity user = new LdapUserEntity();
        user.setDn(result.getNameInNamespace());
        user.setId(this.getStringAttributeValue(this.ldapConfiguration.getUserIdAttribute(), attributes));
        user.setFirstName(this.getStringAttributeValue(this.ldapConfiguration.getUserFirstnameAttribute(), attributes));
        user.setLastName(this.getStringAttributeValue(this.ldapConfiguration.getUserLastnameAttribute(), attributes));
        user.setEmail(this.getStringAttributeValue(this.ldapConfiguration.getUserEmailAttribute(), attributes));
        return user;
    }

    protected GroupEntity transformGroup(SearchResult result) throws NamingException {
        Attributes attributes = result.getAttributes();
        LdapGroupEntity group = new LdapGroupEntity();
        group.setDn(result.getNameInNamespace());
        group.setId(this.getStringAttributeValue(this.ldapConfiguration.getGroupIdAttribute(), attributes));
        group.setName(this.getStringAttributeValue(this.ldapConfiguration.getGroupNameAttribute(), attributes));
        group.setType(this.getStringAttributeValue(this.ldapConfiguration.getGroupTypeAttribute(), attributes));
        return group;
    }

    protected List<Control> getSortingControls(AbstractQuery<?, ?> query, StringBuilder resultLogger) {
        try {
            ArrayList<Control> controls = new ArrayList<Control>();
            List orderBy = query.getOrderingProperties();
            if (orderBy != null) {
                for (QueryOrderingProperty orderingProperty : orderBy) {
                    String propertyName = orderingProperty.getQueryProperty().getName();
                    if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                        resultLogger.append(", OrderBy[");
                        resultLogger.append(propertyName);
                        resultLogger.append("-");
                        resultLogger.append(orderingProperty.getDirection() == null ? "no_direction(desc)" : orderingProperty.getDirection().getName());
                        resultLogger.append("]");
                    }
                    SortKey sortKey = null;
                    if (query instanceof LdapUserQueryImpl) {
                        if (UserQueryProperty.USER_ID.getName().equals(propertyName)) {
                            sortKey = new SortKey(this.ldapConfiguration.getUserIdAttribute(), Direction.ASCENDING.equals(orderingProperty.getDirection()), null);
                        } else if (UserQueryProperty.EMAIL.getName().equals(propertyName)) {
                            sortKey = new SortKey(this.ldapConfiguration.getUserEmailAttribute(), Direction.ASCENDING.equals(orderingProperty.getDirection()), null);
                        } else if (UserQueryProperty.FIRST_NAME.getName().equals(propertyName)) {
                            sortKey = new SortKey(this.ldapConfiguration.getUserFirstnameAttribute(), Direction.ASCENDING.equals(orderingProperty.getDirection()), null);
                        } else if (UserQueryProperty.LAST_NAME.getName().equals(propertyName)) {
                            sortKey = new SortKey(this.ldapConfiguration.getUserLastnameAttribute(), Direction.ASCENDING.equals(orderingProperty.getDirection()), null);
                        }
                    } else if (query instanceof LdapGroupQuery) {
                        if (GroupQueryProperty.GROUP_ID.getName().equals(propertyName)) {
                            sortKey = new SortKey(this.ldapConfiguration.getGroupIdAttribute(), Direction.ASCENDING.equals(orderingProperty.getDirection()), null);
                        } else if (GroupQueryProperty.NAME.getName().equals(propertyName)) {
                            sortKey = new SortKey(this.ldapConfiguration.getGroupNameAttribute(), Direction.ASCENDING.equals(orderingProperty.getDirection()), null);
                        }
                    }
                    if (sortKey == null) continue;
                    controls.add(new SortControl(new SortKey[]{sortKey}, true));
                }
            }
            return controls;
        }
        catch (IOException e) {
            throw new IdentityProviderException("Exception while setting paging settings", (Throwable)e);
        }
    }

    protected String composeDn(String ... parts) {
        StringWriter resultDn = new StringWriter();
        for (String s : parts) {
            String currentDn;
            String part = s;
            if (part == null || part.length() == 0) continue;
            if (part.endsWith(",")) {
                part = part.substring(part.length() - 2, part.length() - 1);
            }
            if (part.startsWith(",")) {
                part = part.substring(1);
            }
            if (!(currentDn = resultDn.toString()).endsWith(",") && currentDn.length() > 0) {
                resultDn.write(",");
            }
            resultDn.write(part);
        }
        return resultDn.toString();
    }

    protected boolean isAuthenticatedUser(UserEntity user) {
        if (user.getId() == null) {
            return false;
        }
        return user.getId().equalsIgnoreCase(Context.getCommandContext().getAuthenticatedUserId());
    }

    protected boolean isAuthorized(Permission permission, Resource resource, String resourceId) {
        return !this.ldapConfiguration.isAuthorizationCheckEnabled() || Context.getCommandContext().getAuthorizationManager().isAuthorized(permission, resource, resourceId);
    }

    protected final String escapeLDAPSearchFilter(String filter) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < filter.length(); ++i) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }

    protected void initializeControls(AbstractQuery<?, ?> query, StringBuilder resultLogger) throws NamingException {
        block12: {
            if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                resultLogger.append(query.getFirstResult());
                resultLogger.append(" ");
                resultLogger.append(query);
                resultLogger.append(" ");
                resultLogger.append(this.ldapConfiguration.isSortControlSupported() ? " -sort-" : "-nosort-");
                if (!this.isPaginationSupported()) {
                    resultLogger.append(" -noPagination");
                } else {
                    resultLogger.append(" -pagination(");
                    resultLogger.append(this.ldapConfiguration.getPageSize());
                    resultLogger.append(")");
                }
            }
            ArrayList<Control> listControls = new ArrayList<Control>();
            if (this.ldapConfiguration.isSortControlSupported()) {
                listControls.addAll(this.getSortingControls(query, resultLogger));
            }
            try {
                if (this.isPaginationSupported()) {
                    listControls.add(new PagedResultsControl(this.getPageSize(), false));
                }
                if (!listControls.isEmpty()) {
                    this.initialContext.setRequestControls(listControls.toArray(new Control[0]));
                }
            }
            catch (IOException | NamingException e) {
                if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                    resultLogger.append("Unsupported page Control;");
                }
                if (listControls.isEmpty()) break block12;
                try {
                    this.initialContext.setRequestControls(listControls.toArray(new Control[0]));
                }
                catch (NamingException ne) {
                    if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                        resultLogger.append("Unsupported Control;");
                    }
                    throw ne;
                }
            }
        }
    }

    protected boolean isNextPageDetected(StringBuilder resultLogger) {
        if (!this.isPaginationSupported()) {
            return false;
        }
        try {
            Control[] controls = this.initialContext.getResponseControls();
            if (controls == null) {
                if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                    resultLogger.append("No-controls-from-the-server");
                }
                return false;
            }
            ArrayList<PagedResultsControl> newControlList = new ArrayList<PagedResultsControl>();
            boolean newPageDetected = false;
            for (Control control : controls) {
                if (!(control instanceof PagedResultsResponseControl)) continue;
                PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                byte[] cookie = prrc.getCookie();
                if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                    resultLogger.append("; End-of-page? ");
                    resultLogger.append(cookie == null ? "No-more-page" : "Next-page-detected");
                }
                try {
                    newControlList.add(new PagedResultsControl(this.getPageSize(), cookie, true));
                }
                catch (IOException e) {
                    if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                        resultLogger.append("Error-when-set-again-the-new-cookie ");
                        resultLogger.append(e);
                    }
                    return false;
                }
                newPageDetected = cookie != null;
            }
            if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                resultLogger.append("; SetAgain controlList.size()=");
                resultLogger.append(newControlList.size());
            }
            if (!newControlList.isEmpty()) {
                this.initialContext.setRequestControls(newControlList.toArray(new Control[0]));
            }
            if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                resultLogger.append("; Done. NewPageDetected=");
                resultLogger.append(newPageDetected);
            }
            return newPageDetected;
        }
        catch (NamingException ne) {
            if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                resultLogger.append("Could not manage ResponseControl; ");
                resultLogger.append(ne);
            }
            return false;
        }
    }

    protected boolean isPaginationSupported() {
        return this.getPageSize() != null;
    }

    protected Integer getPageSize() {
        return this.ldapConfiguration.getPageSize();
    }

    public TenantQuery createTenantQuery() {
        return new LdapTenantQuery(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    public TenantQuery createTenantQuery(CommandContext commandContext) {
        return new LdapTenantQuery();
    }

    public Tenant findTenantById(String id) {
        return null;
    }
}

