/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public abstract class ExternalTaskCmd
implements Command<Void> {
    protected String externalTaskId;

    public ExternalTaskCmd(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("externalTaskId", (Object)this.externalTaskId);
        this.validateInput();
        ExternalTaskEntity externalTask = commandContext.getExternalTaskManager().findExternalTaskById(this.externalTaskId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "Cannot find external task with id " + this.externalTaskId, "externalTask", (Object)externalTask);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessInstanceById(externalTask.getProcessInstanceId());
        }
        this.writeUserOperationLog(commandContext, externalTask, this.getUserOperationLogOperationType(), this.getUserOperationLogPropertyChanges(externalTask));
        this.execute(externalTask);
        return null;
    }

    protected void writeUserOperationLog(CommandContext commandContext, ExternalTaskEntity externalTask, String operationType, List<PropertyChange> propertyChanges) {
        if (operationType != null) {
            commandContext.getOperationLogManager().logExternalTaskOperation(operationType, externalTask, propertyChanges == null || propertyChanges.isEmpty() ? Collections.singletonList(PropertyChange.EMPTY_CHANGE) : propertyChanges);
        }
    }

    protected String getUserOperationLogOperationType() {
        return null;
    }

    protected List<PropertyChange> getUserOperationLogPropertyChanges(ExternalTaskEntity externalTask) {
        return Collections.emptyList();
    }

    protected abstract void execute(ExternalTaskEntity var1);

    protected abstract void validateInput();
}

