/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.variables;

import camundajar.impl.com.google.gson.JsonObject;
import java.util.List;
import org.camunda.bpm.engine.impl.batch.AbstractBatchConfigurationObjectConverter;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.DeploymentMappingJsonConverter;
import org.camunda.bpm.engine.impl.batch.DeploymentMappings;
import org.camunda.bpm.engine.impl.util.JsonUtil;

public class SetVariablesJsonConverter
extends AbstractBatchConfigurationObjectConverter<BatchConfiguration> {
    public static final SetVariablesJsonConverter INSTANCE = new SetVariablesJsonConverter();
    protected static final String IDS = "ids";
    protected static final String ID_MAPPINGS = "idMappings";

    @Override
    public JsonObject writeConfiguration(BatchConfiguration configuration) {
        JsonObject json = JsonUtil.createObject();
        JsonUtil.addListField(json, IDS, configuration.getIds());
        JsonUtil.addListField(json, ID_MAPPINGS, DeploymentMappingJsonConverter.INSTANCE, configuration.getIdMappings());
        return json;
    }

    @Override
    public BatchConfiguration readConfiguration(JsonObject jsonObject) {
        List<String> instanceIds = JsonUtil.asStringList(JsonUtil.getArray(jsonObject, IDS));
        DeploymentMappings mappings = JsonUtil.asList(JsonUtil.getArray(jsonObject, ID_MAPPINGS), DeploymentMappingJsonConverter.INSTANCE, DeploymentMappings::new);
        return new BatchConfiguration(instanceIds, mappings);
    }
}

