/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status.protobuf.sql;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.streaming.SourceProgress;
import org.apache.spark.sql.streaming.StateOperatorProgress;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.status.protobuf.StoreTypes;
import org.apache.spark.status.protobuf.Utils$;
import org.apache.spark.status.protobuf.sql.SinkProgressSerializer$;
import org.apache.spark.status.protobuf.sql.SourceProgressSerializer$;
import org.apache.spark.status.protobuf.sql.StateOperatorProgressSerializer$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.runtime.BoxedUnit;

public final class StreamingQueryProgressSerializer$ {
    public static final StreamingQueryProgressSerializer$ MODULE$ = new StreamingQueryProgressSerializer$();
    private static final JsonMapper mapper = (JsonMapper)JsonMapper.builder().addModule((Module)DefaultScalaModule$.MODULE$).build();

    private JsonMapper mapper() {
        return mapper;
    }

    public StoreTypes.StreamingQueryProgress serialize(StreamingQueryProgress process) {
        StoreTypes.StreamingQueryProgress.Builder builder = StoreTypes.StreamingQueryProgress.newBuilder();
        Object object = process.id() != null ? builder.setId(process.id().toString()) : BoxedUnit.UNIT;
        Object object2 = process.runId() != null ? builder.setRunId(process.runId().toString()) : BoxedUnit.UNIT;
        Utils$.MODULE$.setStringField(process.name(), (Function1 & Serializable)x$1 -> builder.setName(x$1));
        Utils$.MODULE$.setStringField(process.timestamp(), (Function1 & Serializable)x$1 -> builder.setTimestamp(x$1));
        builder.setBatchId(process.batchId());
        builder.setBatchDuration(process.batchDuration());
        Utils$.MODULE$.setJMapField(process.durationMs(), (Function1 & Serializable)x$1 -> builder.putAllDurationMs(x$1));
        Utils$.MODULE$.setJMapField(process.eventTime(), (Function1 & Serializable)x$1 -> builder.putAllEventTime(x$1));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])process.stateOperators()), (Function1 & Serializable)s -> builder.addStateOperators(StateOperatorProgressSerializer$.MODULE$.serialize((StateOperatorProgress)s)));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])process.sources()), (Function1 & Serializable)s -> builder.addSources(SourceProgressSerializer$.MODULE$.serialize((SourceProgress)s)));
        builder.setSink(SinkProgressSerializer$.MODULE$.serialize(process.sink()));
        Utils$.MODULE$.setJMapField(process.observedMetrics(), (Function1 & Serializable)x$1 -> {
            StreamingQueryProgressSerializer$.MODULE$.putAllObservedMetrics(builder, x$1);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public StreamingQueryProgress deserialize(StoreTypes.StreamingQueryProgress process) {
        UUID id = process.hasId() ? UUID.fromString(process.getId()) : null;
        UUID runId = process.hasId() ? UUID.fromString(process.getRunId()) : null;
        return new StreamingQueryProgress(id, runId, Utils$.MODULE$.getStringField(process.hasName(), (Function0 & Serializable)() -> process.getName()), Utils$.MODULE$.getStringField(process.hasTimestamp(), (Function0 & Serializable)() -> process.getTimestamp()), process.getBatchId(), process.getBatchDuration(), new HashMap<String, Long>(process.getDurationMsMap()), new HashMap<String, String>(process.getEventTimeMap()), StateOperatorProgressSerializer$.MODULE$.deserializeToArray(process.getStateOperatorsList()), SourceProgressSerializer$.MODULE$.deserializeToArray(process.getSourcesList()), SinkProgressSerializer$.MODULE$.deserialize(process.getSink()), this.convertToObservedMetrics(process.getObservedMetricsMap()));
    }

    private void putAllObservedMetrics(StoreTypes.StreamingQueryProgress.Builder builder, Map<String, Row> observedMetrics) {
        observedMetrics.forEach((x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Row v = (Row)tuple2._2();
                builder.putObservedMetrics(k, MODULE$.mapper().writeValueAsString((Object)v));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private HashMap<String, Row> convertToObservedMetrics(Map<String, String> input) {
        HashMap<String, Row> observedMetrics = new HashMap<String, Row>(input.size());
        Class<GenericRowWithSchema> classType = GenericRowWithSchema.class;
        input.forEach((x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                observedMetrics.put(k, (Row)MODULE$.mapper().readValue(v, classType));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return observedMetrics;
    }

    private StreamingQueryProgressSerializer$() {
    }
}

