/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.CreateTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OptionList;
import org.apache.spark.sql.catalyst.plans.logical.TableSpecBase;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedTableSpec;
import org.apache.spark.sql.catalyst.streaming.InternalOutputModes$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.catalog.V2TableWithV1Fallback;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.sources.ForeachBatchSink;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterTable;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterTable$;
import org.apache.spark.sql.execution.streaming.sources.MemoryPlan;
import org.apache.spark.sql.execution.streaming.sources.MemorySink;
import org.apache.spark.sql.streaming.DataStreamWriter$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\r\rh\u0001B(Q\u0005mC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\u0007g\u0002!\tA\u0015;\t\u000fa\u0004!\u0019!C\u0005s\"9\u00111\u0001\u0001!\u0002\u0013Q\bbBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003\u000b\u0001A\u0011AA\t\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!a\u000e\u0001\t\u0003\tI\u0004C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0004bBA1\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003C\u0002A\u0011AA=\u0011\u001d\t\t\u0007\u0001C\u0001\u0003\u000bCq!!%\u0001\t\u0003\t\u0019\nC\u0004\u0002\u0012\u0002!\t!a)\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\"9\u0011Q\u0017\u0001\u0005\u0002\u0005\r\u0007b\u0002B\u0003\u0001\u0011\u0005!q\u0001\u0005\b\u0005K\u0001A\u0011\u0002B\u0014\u0011%\u00119\u0005AI\u0001\n\u0013\u0011I\u0005C\u0004\u0003\\\u0001!IA!\u0018\t\u0013\tu\u0005!%A\u0005\n\t}\u0005\"\u0003BR\u0001E\u0005I\u0011\u0002BS\u0011%\u0011I\u000bAI\u0001\n\u0013\u0011I\u0005C\u0004\u0003,\u0002!IA!,\t\u000f\t\u0005\u0007\u0001\"\u0001\u0003D\"A!q\u001a\u0001\u0005\u0002I\u0013\t\u000e\u0003\u0006\u0003j\u0002\t\n\u0011\"\u0001S\u0005WDqAa<\u0001\t\u0003\u0011\t\u0010C\u0004\u0003p\u0002!\ta!\u0002\t\u000f\r\u0015\u0002\u0001\"\u0003\u0004(!91q\u0007\u0001\u0005\n\re\u0002bBB\"\u0001\u0011%1Q\t\u0005\n\u0003\u0007\u0002\u0001\u0019!C\u0005\u0003?D\u0011ba\u0013\u0001\u0001\u0004%Ia!\u0014\t\u0011\rM\u0003\u0001)Q\u0005\u0003+A\u0011Ba\u0003\u0001\u0001\u0004%I!a8\t\u0013\rU\u0003\u00011A\u0005\n\r]\u0003\u0002CB.\u0001\u0001\u0006K!!\u0006\t\u0013\u0005\u0015\u0001\u00011A\u0005\n\ru\u0003\"CB0\u0001\u0001\u0007I\u0011BB1\u0011!\u0019)\u0007\u0001Q!\n\u0005-\u0001\"CA\u0016\u0001\u0001\u0007I\u0011BB4\u0011%\u0019I\u0007\u0001a\u0001\n\u0013\u0019Y\u0007\u0003\u0005\u0004p\u0001\u0001\u000b\u0015BA\u0019\u0011%\u0019\t\b\u0001a\u0001\n\u0013\u0019\u0019\bC\u0005\u0004v\u0001\u0001\r\u0011\"\u0003\u0004x!A11\u0010\u0001!B\u0013\u0011)\bC\u0005\u0004~\u0001\u0001\r\u0011\"\u0003\u0004\u0000!I1\u0011\u0011\u0001A\u0002\u0013%11\u0011\u0005\t\u0007\u000f\u0003\u0001\u0015)\u0003\u0003V\"I1\u0011\u0012\u0001A\u0002\u0013%11\u0012\u0005\n\u0007\u001b\u0003\u0001\u0019!C\u0005\u0007\u001fC\u0001ba%\u0001A\u0003&!Q\u001c\u0005\n\u0007+\u0003\u0001\u0019!C\u0005\u0007/C\u0011b!'\u0001\u0001\u0004%Iaa'\t\u0011\r}\u0005\u0001)Q\u0005\u0005oD\u0011b!)\u0001\u0001\u0004%Iaa\n\t\u0013\r\r\u0006\u00011A\u0005\n\r\u0015\u0006\u0002CBU\u0001\u0001\u0006Ka!\u000b\b\u000f\r5\u0006\u000b#\u0001\u00040\u001a1q\n\u0015E\u0001\u0007cCaa] \u0005\u0002\rM\u0006\"CB[\u007f\t\u0007I\u0011AB\\\u0011!\u0019il\u0010Q\u0001\n\re\u0006\"CB`\u007f\t\u0007I\u0011AB\\\u0011!\u0019\tm\u0010Q\u0001\n\re\u0006\"CBb\u007f\t\u0007I\u0011AB\\\u0011!\u0019)m\u0010Q\u0001\n\re\u0006\"CBd\u007f\t\u0007I\u0011AB\\\u0011!\u0019Im\u0010Q\u0001\n\re\u0006\"CBf\u007f\t\u0007I\u0011AB\\\u0011!\u0019im\u0010Q\u0001\n\re\u0006\"CBh\u007f\t\u0007I\u0011AB\\\u0011!\u0019\tn\u0010Q\u0001\n\re\u0006\"CBj\u007f\t\u0007I\u0011ABk\u0011!\u0019\to\u0010Q\u0001\n\r]'\u0001\u0005#bi\u0006\u001cFO]3b[^\u0013\u0018\u000e^3s\u0015\t\t&+A\u0005tiJ,\u0017-\\5oO*\u00111\u000bV\u0001\u0004gFd'BA+W\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0006,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0006\u0019qN]4\u0004\u0001U\u0011AL[\n\u0003\u0001u\u0003\"AX1\u000e\u0003}S\u0011\u0001Y\u0001\u0006g\u000e\fG.Y\u0005\u0003E~\u0013a!\u00118z%\u00164\u0017A\u00013t!\r)g\r[\u0007\u0002%&\u0011qM\u0015\u0002\b\t\u0006$\u0018m]3u!\tI'\u000e\u0004\u0001\u0005\u000b-\u0004!\u0019\u00017\u0003\u0003Q\u000b\"!\u001c9\u0011\u0005ys\u0017BA8`\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AX9\n\u0005I|&aA!os\u00061A(\u001b8jiz\"\"!^<\u0011\u0007Y\u0004\u0001.D\u0001Q\u0011\u0015\u0019'\u00011\u0001e\u0003\t!g-F\u0001{!\tYhP\u0004\u0002fy&\u0011QPU\u0001\ba\u0006\u001c7.Y4f\u0013\ry\u0018\u0011\u0001\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!! *\u0002\u0007\u00114\u0007%\u0001\u0006pkR\u0004X\u000f^'pI\u0016$2!^A\u0005\u0011\u001d\t)!\u0002a\u0001\u0003\u0017\u00012A^A\u0007\u0013\r\ty\u0001\u0015\u0002\u000b\u001fV$\b/\u001e;N_\u0012,GcA;\u0002\u0014!9\u0011Q\u0001\u0004A\u0002\u0005U\u0001\u0003BA\f\u0003KqA!!\u0007\u0002\"A\u0019\u00111D0\u000e\u0005\u0005u!bAA\u00105\u00061AH]8pizJ1!a\t`\u0003\u0019\u0001&/\u001a3fM&!\u0011qEA\u0015\u0005\u0019\u0019FO]5oO*\u0019\u00111E0\u0002\u000fQ\u0014\u0018nZ4feR\u0019Q/a\f\t\u000f\u0005-r\u00011\u0001\u00022A\u0019a/a\r\n\u0007\u0005U\u0002KA\u0004Ue&<w-\u001a:\u0002\u0013E,XM]=OC6,GcA;\u0002<!9\u0011q\u0007\u0005A\u0002\u0005U\u0011A\u00024pe6\fG\u000fF\u0002v\u0003\u0003Bq!a\u0011\n\u0001\u0004\t)\"\u0001\u0004t_V\u00148-Z\u0001\fa\u0006\u0014H/\u001b;j_:\u0014\u0015\u0010F\u0002v\u0003\u0013Bq!a\u0013\u000b\u0001\u0004\ti%\u0001\u0005d_2t\u0015-\\3t!\u0015q\u0016qJA\u000b\u0013\r\t\tf\u0018\u0002\u000byI,\u0007/Z1uK\u0012t\u0004f\u0001\u0006\u0002VA!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\}\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ty&!\u0017\u0003\u000fY\f'/\u0019:hg\u00061q\u000e\u001d;j_:$R!^A3\u0003SBq!a\u001a\f\u0001\u0004\t)\"A\u0002lKfDq!a\u001b\f\u0001\u0004\t)\"A\u0003wC2,X\rF\u0003v\u0003_\n\t\bC\u0004\u0002h1\u0001\r!!\u0006\t\u000f\u0005-D\u00021\u0001\u0002tA\u0019a,!\u001e\n\u0007\u0005]tLA\u0004C_>dW-\u00198\u0015\u000bU\fY(! \t\u000f\u0005\u001dT\u00021\u0001\u0002\u0016!9\u00111N\u0007A\u0002\u0005}\u0004c\u00010\u0002\u0002&\u0019\u00111Q0\u0003\t1{gn\u001a\u000b\u0006k\u0006\u001d\u0015\u0011\u0012\u0005\b\u0003Or\u0001\u0019AA\u000b\u0011\u001d\tYG\u0004a\u0001\u0003\u0017\u00032AXAG\u0013\r\tyi\u0018\u0002\u0007\t>,(\r\\3\u0002\u000f=\u0004H/[8ogR\u0019Q/!&\t\u000f\u0005Eu\u00021\u0001\u0002\u0018BA\u0011\u0011TAP\u0003+\t)\"\u0004\u0002\u0002\u001c*\u0019\u0011QT0\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\"\u0006m%aA'baR\u0019Q/!*\t\u000f\u0005E\u0005\u00031\u0001\u0002(BA\u0011\u0011VAZ\u0003+\t)\"\u0004\u0002\u0002,*!\u0011QVAX\u0003\u0011)H/\u001b7\u000b\u0005\u0005E\u0016\u0001\u00026bm\u0006LA!!)\u0002,\u0006)1\u000f^1siR!\u0011\u0011XA`!\r1\u00181X\u0005\u0004\u0003{\u0003&AD*ue\u0016\fW.\u001b8h#V,'/\u001f\u0005\b\u0003\u0003\f\u0002\u0019AA\u000b\u0003\u0011\u0001\u0018\r\u001e5\u0015\u0005\u0005e\u0006&\u0002\n\u0002H\u0006e\u0007#\u00020\u0002J\u00065\u0017bAAf?\n1A\u000f\u001b:poN\u0004B!a4\u0002V6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\fY+\u0001\u0006d_:\u001cWO\u001d:f]RLA!a6\u0002R\n\u0001B+[7f_V$X\t_2faRLwN\\\u0019\b=\u0005U\u00111\u001cB\u0002c%\u0019\u0013Q\\Ar\u0003s\f)/\u0006\u0003\u0002`\u0006\u0005XCAA\u000b\t\u0019Y'L1\u0001\u0002l&!\u0011Q]At\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u0011\u0011^0\u0002\rQD'o\\<t#\ri\u0017Q\u001e\t\u0005\u0003_\f\u0019PD\u0002_\u0003cL!!`0\n\t\u0005U\u0018q\u001f\u0002\n)\"\u0014xn^1cY\u0016T!!`02\u0013\r\nY0!@\u0002\u0000\u0006%hb\u00010\u0002~&\u0019\u0011\u0011^02\u000b\trvL!\u0001\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\ni-A\u0004u_R\u000b'\r\\3\u0015\t\u0005e&\u0011\u0002\u0005\b\u0005\u0017\u0019\u0002\u0019AA\u000b\u0003%!\u0018M\u00197f\u001d\u0006lW\rK\u0002\u0014\u0005\u001f\u0001BA!\u0005\u0003\u00165\u0011!1\u0003\u0006\u0004\u00037\"\u0016\u0002\u0002B\f\u0005'\u0011\u0001\"\u0012<pYZLgn\u001a\u0015\u0006'\u0005\u001d'1D\u0019\b=\u0005U!Q\u0004B\u0012c%\u0019\u0013Q\\Ar\u0005?\t)/M\u0005$\u0003w\fiP!\t\u0002jF*!EX0\u0003\u0002E\u001aa%!4\u0002\u001bM$\u0018M\u001d;J]R,'O\\1m)\u0019\tIL!\u000b\u00032!9\u0011\u0011\u0019\u000bA\u0002\t-\u0002#\u00020\u0003.\u0005U\u0011b\u0001B\u0018?\n1q\n\u001d;j_:D\u0011Ba\r\u0015!\u0003\u0005\rA!\u000e\u0002\u0019\r\fG/\u00197pOR\u000b'\r\\3\u0011\u000by\u0013iCa\u000e\u0011\t\te\"1I\u0007\u0003\u0005wQAA!\u0010\u0003@\u000591-\u0019;bY><'b\u0001B!%\u0006A1-\u0019;bYf\u001cH/\u0003\u0003\u0003F\tm\"\u0001D\"bi\u0006dwn\u001a+bE2,\u0017aF:uCJ$\u0018J\u001c;fe:\fG\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011YE\u000b\u0003\u00036\t53F\u0001B(!\u0011\u0011\tFa\u0016\u000e\u0005\tM#\u0002\u0002B+\u00033\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\n\t\te#1\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AC:uCJ$\u0018+^3ssRa\u0011\u0011\u0018B0\u0005c\u0012yHa!\u0003\u001c\"9!\u0011\r\fA\u0002\t\r\u0014\u0001B:j].\u0004BA!\u001a\u0003n5\u0011!q\r\u0006\u0005\u0005{\u0011IGC\u0002\u0003lI\u000b\u0011bY8o]\u0016\u001cGo\u001c:\n\t\t=$q\r\u0002\u0006)\u0006\u0014G.\u001a\u0005\b\u0005g2\u0002\u0019\u0001B;\u0003)qWm^(qi&|gn\u001d\t\u0007\u0005o\u0012Y(!\u0006\u000e\u0005\te$\u0002BAW\u0005\u007fIAA! \u0003z\t\u00112)Y:f\u0013:\u001cXM\\:ji&4X-T1q\u0011%\u0011\tI\u0006I\u0001\u0002\u0004\t\u0019(A\u000bsK\u000e|g/\u001a:Ge>l7\t[3dWB|\u0017N\u001c;\t\u0013\t\u0015e\u0003%AA\u0002\t\u001d\u0015aD2bi\u0006dwnZ!oI&#WM\u001c;\u0011\u000by\u0013iC!#\u0011\u000fy\u0013YIa$\u0003\u0016&\u0019!QR0\u0003\rQ+\b\u000f\\33!\u0011\u0011)G!%\n\t\tM%q\r\u0002\r)\u0006\u0014G.Z\"bi\u0006dwn\u001a\t\u0005\u0005K\u00129*\u0003\u0003\u0003\u001a\n\u001d$AC%eK:$\u0018NZ5fe\"I!1\u0007\f\u0011\u0002\u0003\u0007!QG\u0001\u0015gR\f'\u000f^)vKJLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\u0005&\u0006BA:\u0005\u001b\nAc\u001d;beR\fV/\u001a:zI\u0011,g-Y;mi\u0012\"TC\u0001BTU\u0011\u00119I!\u0014\u0002)M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00031\u0019'/Z1uKZ\u000b4+\u001b8l)\u0011\u0011yK!0\u0011\t\tE&\u0011X\u0007\u0003\u0005gS1!\u0015B[\u0015\r\u00119LU\u0001\nKb,7-\u001e;j_:LAAa/\u00034\n!1+\u001b8l\u0011\u001d\u0011yL\u0007a\u0001\u0005k\nqb\u001c9uS>t7oV5uQB\u000bG\u000f[\u0001\bM>\u0014X-Y2i)\r)(Q\u0019\u0005\b\u0005\u000f\\\u0002\u0019\u0001Be\u0003\u00199(/\u001b;feB!QMa3i\u0013\r\u0011iM\u0015\u0002\u000e\r>\u0014X-Y2i/JLG/\u001a:\u0002+\u0019|'/Z1dQ&k\u0007\u000f\\3nK:$\u0018\r^5p]R)QOa5\u0003X\"9!q\u0019\u000fA\u0002\tU\u0007\u0003B3\u0003LBD\u0011B!7\u001d!\u0003\u0005\rAa7\u0002\u000f\u0015t7m\u001c3feB)aL!\f\u0003^B)!q\u001cBsa6\u0011!\u0011\u001d\u0006\u0005\u0005G\u0014y$\u0001\u0005f]\u000e|G-\u001a:t\u0013\u0011\u00119O!9\u0003#\u0015C\bO]3tg&|g.\u00128d_\u0012,'/A\u0010g_J,\u0017m\u00195J[BdW-\\3oi\u0006$\u0018n\u001c8%I\u00164\u0017-\u001e7uII*\"A!<+\t\tm'QJ\u0001\rM>\u0014X-Y2i\u0005\u0006$8\r\u001b\u000b\u0004k\nM\bb\u0002B{=\u0001\u0007!q_\u0001\tMVt7\r^5p]BAaL!?e\u0003\u007f\u0012i0C\u0002\u0003|~\u0013\u0011BR;oGRLwN\u001c\u001a\u0011\u0007y\u0013y0C\u0002\u0004\u0002}\u0013A!\u00168ji\"\u001aaDa\u0004\u0015\u0007U\u001c9\u0001C\u0004\u0003v~\u0001\ra!\u0003\u0011\u000f\r-1Q\u00033\u0004\u001a5\u00111Q\u0002\u0006\u0005\u0005k\u001cyA\u0003\u0003\u00022\u000eE!bAB\n)\u0006\u0019\u0011\r]5\n\t\r]1Q\u0002\u0002\u000e->LGMR;oGRLwN\u001c\u001a\u0011\t\rm1\u0011E\u0007\u0003\u0007;QAaa\b\u00020\u0006!A.\u00198h\u0013\u0011\t\u0019i!\b)\u0007}\u0011y!A\to_Jl\u0017\r\\5{K\u0012\u0004\u0016M]\"pYN,\"a!\u000b\u0011\u000by\u0013ica\u000b\u0011\r\r521GA\u000b\u001d\u0011\u0019y#!=\u000f\t\u0005m1\u0011G\u0005\u0002A&!1QGA|\u0005\r\u0019V-]\u0001\n]>\u0014X.\u00197ju\u0016$b!!\u0006\u0004<\r}\u0002bBB\u001fC\u0001\u0007\u0011QC\u0001\u000bG>dW/\u001c8OC6,\u0007bBB!C\u0001\u0007\u0011QC\u0001\u000bG>dW/\u001c8UsB,\u0017\u0001F1tg\u0016\u0014HOT8u!\u0006\u0014H/\u001b;j_:,G\r\u0006\u0003\u0003~\u000e\u001d\u0003bBB%E\u0001\u0007\u0011QC\u0001\n_B,'/\u0019;j_:\f!b]8ve\u000e,w\fJ3r)\u0011\u0011ipa\u0014\t\u0013\rEC%!AA\u0002\u0005U\u0011a\u0001=%c\u000591o\\;sG\u0016\u0004\u0013!\u0004;bE2,g*Y7f?\u0012*\u0017\u000f\u0006\u0003\u0003~\u000ee\u0003\"CB)O\u0005\u0005\t\u0019AA\u000b\u0003)!\u0018M\u00197f\u001d\u0006lW\rI\u000b\u0003\u0003\u0017\tab\\;uaV$Xj\u001c3f?\u0012*\u0017\u000f\u0006\u0003\u0003~\u000e\r\u0004\"CB)U\u0005\u0005\t\u0019AA\u0006\u0003-yW\u000f\u001e9vi6{G-\u001a\u0011\u0016\u0005\u0005E\u0012a\u0003;sS\u001e<WM]0%KF$BA!@\u0004n!I1\u0011K\u0017\u0002\u0002\u0003\u0007\u0011\u0011G\u0001\tiJLwmZ3sA\u0005aQ\r\u001f;sC>\u0003H/[8ogV\u0011!QO\u0001\u0011Kb$(/Y(qi&|gn]0%KF$BA!@\u0004z!I1\u0011\u000b\u0019\u0002\u0002\u0003\u0007!QO\u0001\u000eKb$(/Y(qi&|gn\u001d\u0011\u0002\u001b\u0019|'/Z1dQ^\u0013\u0018\u000e^3s+\t\u0011).A\tg_J,\u0017m\u00195Xe&$XM]0%KF$BA!@\u0004\u0006\"I1\u0011K\u001a\u0002\u0002\u0003\u0007!Q[\u0001\u000fM>\u0014X-Y2i/JLG/\u001a:!\u0003Q1wN]3bG\"<&/\u001b;fe\u0016s7m\u001c3feV\u0011!Q\\\u0001\u0019M>\u0014X-Y2i/JLG/\u001a:F]\u000e|G-\u001a:`I\u0015\fH\u0003\u0002B\u007f\u0007#C\u0011b!\u00157\u0003\u0003\u0005\rA!8\u0002+\u0019|'/Z1dQ^\u0013\u0018\u000e^3s\u000b:\u001cw\u000eZ3sA\u0005\u0011bm\u001c:fC\u000eD')\u0019;dQ^\u0013\u0018\u000e^3s+\t\u001190\u0001\fg_J,\u0017m\u00195CCR\u001c\u0007n\u0016:ji\u0016\u0014x\fJ3r)\u0011\u0011ip!(\t\u0013\rE\u0013(!AA\u0002\t]\u0018a\u00054pe\u0016\f7\r\u001b\"bi\u000eDwK]5uKJ\u0004\u0013a\u00059beRLG/[8oS:<7i\u001c7v[:\u001c\u0018a\u00069beRLG/[8oS:<7i\u001c7v[:\u001cx\fJ3r)\u0011\u0011ipa*\t\u0013\rEC(!AA\u0002\r%\u0012\u0001\u00069beRLG/[8oS:<7i\u001c7v[:\u001c\b\u0005K\u0002\u0001\u0005\u001f\t\u0001\u0003R1uCN#(/Z1n/JLG/\u001a:\u0011\u0005Y|4CA ^)\t\u0019y+\u0001\nT\u001fV\u00136)R0O\u00036+u,T#N\u001fJKVCAB]!\u0011\u0019Yba/\n\t\u0005\u001d2QD\u0001\u0014'>+&kQ#`\u001d\u0006kUiX'F\u001b>\u0013\u0016\fI\u0001\u0014'>+&kQ#`\u001d\u0006kUi\u0018$P%\u0016\u000b5\tS\u0001\u0015'>+&kQ#`\u001d\u0006kUi\u0018$P%\u0016\u000b5\t\u0013\u0011\u00023M{UKU\"F?:\u000bU*R0G\u001fJ+\u0015i\u0011%`\u0005\u0006#6\tS\u0001\u001b'>+&kQ#`\u001d\u0006kUi\u0018$P%\u0016\u000b5\tS0C\u0003R\u001b\u0005\nI\u0001\u0014'>+&kQ#`\u001d\u0006kUiX\"P\u001dN{E*R\u0001\u0015'>+&kQ#`\u001d\u0006kUiX\"P\u001dN{E*\u0012\u0011\u0002#M{UKU\"F?:\u000bU*R0U\u0003\ncU)\u0001\nT\u001fV\u00136)R0O\u00036+u\fV!C\u0019\u0016\u0003\u0013\u0001E*P+J\u001bUi\u0018(B\u001b\u0016{fjT(Q\u0003E\u0019v*\u0016*D\u000b~s\u0015)T#`\u001d>{\u0005\u000bI\u0001\u001d'>+&kQ#T?\u0006cEjT,`\u001f:+u\fV%N\u000b~\u000bV+\u0012*Z+\t\u00199\u000e\u0005\u0004\u0004Z\u000e}7\u0011X\u0007\u0003\u00077TAa!8\u0002\u001c\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0007k\u0019Y.A\u000fT\u001fV\u00136)R*`\u00032cujV0P\u001d\u0016{F+S'F?F+VIU-!\u0001")
public final class DataStreamWriter<T> {
    private final Dataset<T> ds;
    private final Dataset<Row> df;
    private String source;
    private String tableName;
    private OutputMode outputMode;
    private Trigger trigger;
    private CaseInsensitiveMap<String> extraOptions;
    private ForeachWriter<Object> foreachWriter;
    private ExpressionEncoder<Object> foreachWriterEncoder;
    private Function2<Dataset<T>, Object, BoxedUnit> foreachBatchWriter;
    private Option<Seq<String>> partitioningColumns;

    public static Seq<String> SOURCES_ALLOW_ONE_TIME_QUERY() {
        return DataStreamWriter$.MODULE$.SOURCES_ALLOW_ONE_TIME_QUERY();
    }

    public static String SOURCE_NAME_NOOP() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_NOOP();
    }

    public static String SOURCE_NAME_TABLE() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_TABLE();
    }

    public static String SOURCE_NAME_CONSOLE() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_CONSOLE();
    }

    public static String SOURCE_NAME_FOREACH_BATCH() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH();
    }

    public static String SOURCE_NAME_FOREACH() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH();
    }

    public static String SOURCE_NAME_MEMORY() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY();
    }

    public DataStreamWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataStreamWriter<T> outputMode(OutputMode outputMode) {
        this.outputMode_$eq(outputMode);
        return this;
    }

    public DataStreamWriter<T> outputMode(String outputMode) {
        this.outputMode_$eq(InternalOutputModes$.MODULE$.apply(outputMode));
        return this;
    }

    public DataStreamWriter<T> trigger(Trigger trigger) {
        this.trigger_$eq(trigger);
        return this;
    }

    public DataStreamWriter<T> queryName(String queryName) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"queryName"), (Object)queryName)));
        return this;
    }

    public DataStreamWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataStreamWriter<T> option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataStreamWriter<T> option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataStreamWriter<T> option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataStreamWriter<T> option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public DataStreamWriter<T> options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataStreamWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(options).asScala());
        return this;
    }

    public StreamingQuery start(String path) {
        if (!this.df().sparkSession().sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw QueryCompilationErrors$.MODULE$.setPathOptionAndCallWithPathParameterError("start");
        }
        return this.startInternal((Option<String>)new Some((Object)path), this.startInternal$default$2());
    }

    public StreamingQuery start() throws TimeoutException {
        return this.startInternal((Option<String>)None$.MODULE$, this.startInternal$default$2());
    }

    @Evolving
    public StreamingQuery toTable(String tableName) throws TimeoutException {
        SupportsWrite supportsWrite;
        Table tableInstance;
        Option option;
        Seq originalMultipartIdentifier;
        this.tableName_$eq(tableName);
        Seq seq = originalMultipartIdentifier = this.df().sparkSession().sessionState().sqlParser().parseMultipartIdentifier(tableName);
        if (seq == null || (option = this.df().sparkSession().sessionState().analyzer().CatalogAndIdentifier().unapply(seq)).isEmpty()) {
            throw new MatchError((Object)seq);
        }
        CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option.get())._1();
        Identifier identifier = (Identifier)((Tuple2)option.get())._2();
        Tuple2 tuple2 = new Tuple2((Object)catalog, (Object)identifier);
        CatalogPlugin catalog2 = (CatalogPlugin)tuple2._1();
        Identifier identifier2 = (Identifier)tuple2._2();
        if (this.df().sparkSession().sessionState().catalog().isTempView(originalMultipartIdentifier)) {
            throw QueryCompilationErrors$.MODULE$.tempViewNotSupportStreamingWriteError(tableName);
        }
        if (!CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog().tableExists(identifier2)) {
            UnresolvedTableSpec tableSpec = new UnresolvedTableSpec(Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), new OptionList((Seq)package$.MODULE$.Seq().empty()), this.extraOptions().get("path"), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
            CreateTable cmd = new CreateTable((LogicalPlan)new UnresolvedIdentifier(originalMultipartIdentifier, UnresolvedIdentifier$.MODULE$.apply$default$2()), this.df().schema().asNullable(), ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])CatalogV2Implicits$.MODULE$.PartitionTypeHelper((Seq)this.partitioningColumns().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$)).asTransforms())), (TableSpecBase)tableSpec, false);
            v0 = Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)cmd);
        } else {
            v0 = BoxedUnit.UNIT;
        }
        Table table = tableInstance = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog().loadTable(identifier2);
        if (table instanceof SupportsWrite && DataSourceV2Implicits$.MODULE$.TableHelper((Table)(supportsWrite = (SupportsWrite)table)).supports(TableCapability.STREAMING_WRITE)) {
            SupportsWrite x$1 = supportsWrite;
            CaseInsensitiveMap<String> x$2 = this.extraOptions();
            Some x$3 = new Some((Object)new Tuple2((Object)CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog(), (Object)identifier2));
            boolean x$4 = this.startQuery$default$3();
            Option<CatalogTable> x$5 = this.startQuery$default$5();
            return this.startQuery((Table)x$1, x$2, x$4, (Option<Tuple2<TableCatalog, Identifier>>)x$3, x$5);
        }
        if (table instanceof V2TableWithV1Fallback) {
            V2TableWithV1Fallback v2TableWithV1Fallback = (V2TableWithV1Fallback)table;
            return this.writeToV1Table$1(v2TableWithV1Fallback.v1Table(), tableName);
        }
        if (table instanceof V1Table) {
            V1Table v1Table = (V1Table)table;
            return this.writeToV1Table$1(v1Table.v1Table(), tableName);
        }
        throw QueryCompilationErrors$.MODULE$.tableNotSupportStreamingWriteError(tableName, table);
    }

    private StreamingQuery startInternal(Option<String> path, Option<CatalogTable> catalogTable) {
        SupportsWrite supportsWrite;
        None$ outputSchema;
        scala.collection.immutable.Map<String, String> sessionOptions;
        scala.collection.immutable.Map finalOptions;
        CaseInsensitiveStringMap dsOptions;
        TableProvider provider;
        Table table;
        Table table2;
        Sink sink;
        CaseInsensitiveMap optionsWithPath;
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("write");
        }
        String string3 = this.source();
        String string4 = DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY());
            if (this.extraOptions().get("queryName").isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.queryNameNotSpecifiedForMemorySinkError();
            }
            MemorySink sink2 = new MemorySink();
            Dataset<Row> resultDf = Dataset$.MODULE$.ofRows(this.df().sparkSession(), new MemoryPlan(sink2, (Seq<Attribute>)DataTypeUtils$.MODULE$.toAttributes(this.df().schema())));
            OutputMode outputMode = this.outputMode();
            OutputMode outputMode2 = OutputMode.Complete();
            boolean recoverFromCheckpoint = !(outputMode != null ? !outputMode.equals(outputMode2) : outputMode2 != null);
            MemorySink x$1 = sink2;
            CaseInsensitiveMap<String> x$22 = this.extraOptions();
            boolean x$3 = recoverFromCheckpoint;
            Option<CatalogTable> x$4 = catalogTable;
            Option<Tuple2<TableCatalog, Identifier>> x$5 = this.startQuery$default$4();
            StreamingQuery query = this.startQuery(x$1, x$22, x$3, x$5, x$4);
            resultDf.createOrReplaceTempView(query.name());
            return query;
        }
        String string5 = this.source();
        String string6 = DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH();
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            ForeachWriterTable<?> sink3;
            this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH());
            ForeachWriterTable<?> x$6 = sink3 = ForeachWriterTable$.MODULE$.apply(this.foreachWriter(), this.foreachWriterEncoder());
            CaseInsensitiveMap<String> x$7 = this.extraOptions();
            Option<CatalogTable> x$8 = catalogTable;
            boolean x$9 = this.startQuery$default$3();
            Option<Tuple2<TableCatalog, Identifier>> x$10 = this.startQuery$default$4();
            return this.startQuery(x$6, x$7, x$9, x$10, x$8);
        }
        String string7 = this.source();
        String string8 = DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH();
        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
            ForeachBatchSink<T> sink4;
            this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH());
            if (this.trigger() instanceof ContinuousTrigger) {
                throw QueryCompilationErrors$.MODULE$.sourceNotSupportedWithContinuousTriggerError(this.source());
            }
            ForeachBatchSink<T> x$11 = sink4 = new ForeachBatchSink<T>(this.foreachBatchWriter(), this.ds.exprEnc());
            CaseInsensitiveMap<String> x$12 = this.extraOptions();
            Option<CatalogTable> x$13 = catalogTable;
            boolean x$14 = this.startQuery$default$3();
            Option<Tuple2<TableCatalog, Identifier>> x$15 = this.startQuery$default$4();
            return this.startQuery(x$11, x$12, x$14, x$15, x$13);
        }
        Class<?> cls = DataSource$.MODULE$.lookupDataSource(this.source(), this.df().sparkSession().sessionState().conf());
        Seq disabledSources = Utils$.MODULE$.stringToSeq(this.df().sparkSession().sqlContext().conf().disabledV2StreamingWriters());
        boolean useV1Source = disabledSources.contains((Object)cls.getCanonicalName()) || FileDataSourceV2.class.isAssignableFrom(cls);
        CaseInsensitiveMap caseInsensitiveMap = optionsWithPath = path.isEmpty() ? this.extraOptions() : this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), path.get()));
        Sink x$16 = sink = TableProvider.class.isAssignableFrom(cls) && !useV1Source ? ((table2 = (table = DataSourceV2Utils$.MODULE$.getTableFromProvider(provider = (TableProvider)cls.getConstructor(new Class[0]).newInstance(new Object[0]), dsOptions = new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)(finalOptions = (scala.collection.immutable.Map)(sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(provider, this.df().sparkSession().sessionState().conf())).view().filterKeys((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataStreamWriter.$anonfun$startInternal$1(optionsWithPath, x$2))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)optionsWithPath.originalMap()))).asJava()), (Option<StructType>)(outputSchema = provider.supportsExternalMetadata() ? new Some((Object)this.df().schema()) : None$.MODULE$)))) instanceof SupportsWrite && DataSourceV2Implicits$.MODULE$.TableHelper((Table)(supportsWrite = (SupportsWrite)table2)).supports(TableCapability.STREAMING_WRITE) ? supportsWrite : this.createV1Sink((CaseInsensitiveMap<String>)optionsWithPath)) : this.createV1Sink((CaseInsensitiveMap<String>)optionsWithPath);
        CaseInsensitiveMap x$17 = optionsWithPath;
        Option<CatalogTable> x$18 = catalogTable;
        boolean x$19 = this.startQuery$default$3();
        Option<Tuple2<TableCatalog, Identifier>> x$20 = this.startQuery$default$4();
        return this.startQuery(x$16, (CaseInsensitiveMap<String>)x$17, x$19, x$20, x$18);
    }

    private Option<CatalogTable> startInternal$default$2() {
        return None$.MODULE$;
    }

    private StreamingQuery startQuery(Table sink, CaseInsensitiveMap<String> newOptions, boolean recoverFromCheckpoint, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent, Option<CatalogTable> catalogTable) {
        boolean useTempCheckpointLocation = DataStreamWriter$.MODULE$.SOURCES_ALLOW_ONE_TIME_QUERY().contains((Object)this.source());
        Option x$1 = newOptions.get("queryName");
        Option x$2 = newOptions.get("checkpointLocation");
        Dataset<Row> x$3 = this.df();
        scala.collection.immutable.Map x$4 = newOptions.originalMap();
        Table x$5 = sink;
        OutputMode x$6 = this.outputMode();
        boolean x$7 = useTempCheckpointLocation;
        boolean x$8 = recoverFromCheckpoint;
        Trigger x$9 = this.trigger();
        Option<Tuple2<TableCatalog, Identifier>> x$10 = catalogAndIdent;
        Option<CatalogTable> x$11 = catalogTable;
        Clock x$12 = this.df().sparkSession().sessionState().streamingQueryManager().startQuery$default$10();
        return this.df().sparkSession().sessionState().streamingQueryManager().startQuery((Option<String>)x$1, (Option<String>)x$2, x$3, (scala.collection.immutable.Map<String, String>)x$4, x$5, x$6, x$7, x$8, x$9, x$12, x$10, x$11);
    }

    private boolean startQuery$default$3() {
        return true;
    }

    private Option<Tuple2<TableCatalog, Identifier>> startQuery$default$4() {
        return None$.MODULE$;
    }

    private Option<CatalogTable> startQuery$default$5() {
        return None$.MODULE$;
    }

    private Sink createV1Sink(CaseInsensitiveMap<String> optionsWithPath) {
        SparkSession x$1 = this.df().sparkSession();
        String x$2 = this.source();
        scala.collection.immutable.Map x$3 = optionsWithPath.originalMap();
        Seq x$4 = (Seq)this.normalizedParCols().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource ds = new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$4, x$7, (scala.collection.immutable.Map<String, String>)x$3, x$8);
        return ds.createSink(this.outputMode());
    }

    public DataStreamWriter<T> foreach(ForeachWriter<T> writer) {
        return this.foreachImplementation(writer, this.foreachImplementation$default$2());
    }

    public DataStreamWriter<T> foreachImplementation(ForeachWriter<Object> writer, Option<ExpressionEncoder<Object>> encoder) {
        this.source_$eq(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH());
        if (writer == null) {
            throw new IllegalArgumentException("foreach writer cannot be null");
        }
        this.foreachWriter_$eq((ForeachWriter)this.ds.sparkSession().sparkContext().clean(writer, this.ds.sparkSession().sparkContext().clean$default$2()));
        encoder.foreach((Function1 & Serializable)e -> {
            this.foreachWriterEncoder_$eq((ExpressionEncoder<Object>)e);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public Option<ExpressionEncoder<Object>> foreachImplementation$default$2() {
        return None$.MODULE$;
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(Function2<Dataset<T>, Object, BoxedUnit> function) {
        this.source_$eq(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH());
        if (function == null) {
            throw new IllegalArgumentException("foreachBatch function cannot be null");
        }
        this.foreachBatchWriter_$eq(function);
        return this;
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(VoidFunction2<Dataset<T>, Long> function) {
        return this.foreachBatch((Function2 & Serializable)(batchDs, batchId) -> {
            function.call((Object)batchDs, (Object)Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)batchId)));
            return BoxedUnit.UNIT;
        });
    }

    private Option<Seq<String>> normalizedParCols() {
        return this.partitioningColumns().map((Function1 & Serializable)cols -> (Seq)cols.map((Function1 & Serializable)x$3 -> this.normalize((String)x$3, "Partition")));
    }

    private String normalize(String columnName, String columnType) {
        Seq validColumnNames = (Seq)this.df().logicalPlan().output().map((Function1 & Serializable)x$4 -> x$4.name());
        return (String)validColumnNames.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DataStreamWriter.$anonfun$normalize$2(this, columnName, x$5))).getOrElse((Function0 & Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.columnNotFoundInExistingColumnsError(columnType, columnName, validColumnNames);
        });
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.operationNotSupportPartitioningError(operation);
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private String tableName() {
        return this.tableName;
    }

    private void tableName_$eq(String x$1) {
        this.tableName = x$1;
    }

    private OutputMode outputMode() {
        return this.outputMode;
    }

    private void outputMode_$eq(OutputMode x$1) {
        this.outputMode = x$1;
    }

    private Trigger trigger() {
        return this.trigger;
    }

    private void trigger_$eq(Trigger x$1) {
        this.trigger = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    private ForeachWriter<Object> foreachWriter() {
        return this.foreachWriter;
    }

    private void foreachWriter_$eq(ForeachWriter<Object> x$1) {
        this.foreachWriter = x$1;
    }

    private ExpressionEncoder<Object> foreachWriterEncoder() {
        return this.foreachWriterEncoder;
    }

    private void foreachWriterEncoder_$eq(ExpressionEncoder<Object> x$1) {
        this.foreachWriterEncoder = x$1;
    }

    private Function2<Dataset<T>, Object, BoxedUnit> foreachBatchWriter() {
        return this.foreachBatchWriter;
    }

    private void foreachBatchWriter_$eq(Function2<Dataset<T>, Object, BoxedUnit> x$1) {
        this.foreachBatchWriter = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private final StreamingQuery writeToV1Table$1(CatalogTable table, String tableName$1) {
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw QueryCompilationErrors$.MODULE$.streamingIntoViewNotSupportedError(tableName$1);
        }
        Predef$.MODULE$.require(table.provider().isDefined());
        String string = this.source();
        Object object = table.provider().get();
        if (string == null ? object != null : !string.equals(object)) {
            throw QueryCompilationErrors$.MODULE$.inputSourceDiffersFromDataSourceProviderError(this.source(), tableName$1, table);
        }
        return super.startInternal((Option<String>)new Some((Object)new Path(table.location()).toString()), (Option<CatalogTable>)new Some((Object)table));
    }

    public static final /* synthetic */ boolean $anonfun$startInternal$1(CaseInsensitiveMap optionsWithPath$1, String x$2) {
        return !optionsWithPath$1.contains(x$2);
    }

    public static final /* synthetic */ boolean $anonfun$normalize$2(DataStreamWriter $this, String columnName$1, String x$5) {
        return BoxesRunTime.unboxToBoolean((Object)$this.df().sparkSession().sessionState().analyzer().resolver().apply((Object)x$5, (Object)columnName$1));
    }

    public DataStreamWriter(Dataset<T> ds) {
        this.ds = ds;
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.tableName = null;
        this.outputMode = OutputMode.Append();
        this.trigger = Trigger.ProcessingTime((long)0L);
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        this.foreachWriter = null;
        this.foreachWriterEncoder = ds.exprEnc();
        this.foreachBatchWriter = null;
        this.partitioningColumns = None$.MODULE$;
    }
}

