/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.streaming.StreamingRelationV2;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.json.JsonUtils$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.execution.datasources.xml.XmlUtils$;
import org.apache.spark.sql.execution.streaming.StreamingRelation$;
import org.apache.spark.sql.sources.StreamSourceProvider;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001\u0002\u0011\"\u00051B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0007}\u0001!\taI \t\u000b\r\u0003A\u0011\u0001#\t\u000bI\u0003A\u0011A*\t\u000bI\u0003A\u0011A.\t\u000by\u0003A\u0011A0\t\u000by\u0003A\u0011\u00013\t\u000by\u0003A\u0011\u00016\t\u000by\u0003A\u0011\u00019\t\u000bY\u0004A\u0011A<\t\u000bY\u0004A\u0011A@\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBA\t\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002X\u0001!\t!!\u0017\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0004bBA6\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003c\u0002A\u0011AA:\u0011!1\u0005\u00011A\u0005\n\u0005u\u0004\"CA@\u0001\u0001\u0007I\u0011BAA\u0011\u001d\ti\t\u0001Q!\n\u001dC\u0011\"a$\u0001\u0001\u0004%I!!%\t\u0013\u0005U\u0005\u00011A\u0005\n\u0005]\u0005\u0002CAN\u0001\u0001\u0006K!a%\t\u0013\u0005u\u0005\u00011A\u0005\n\u0005}\u0005\"CAX\u0001\u0001\u0007I\u0011BAY\u0011!\t)\f\u0001Q!\n\u0005\u0005&\u0001\u0005#bi\u0006\u001cFO]3b[J+\u0017\rZ3s\u0015\t\u00113%A\u0005tiJ,\u0017-\\5oO*\u0011A%J\u0001\u0004gFd'B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!t'D\u00016\u0015\t1T%\u0001\u0005j]R,'O\\1m\u0013\tATGA\u0004M_\u001e<\u0017N\\4\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005mbT\"A\u0012\n\u0005u\u001a#\u0001D*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0002A\u0005B\u0011\u0011\tA\u0007\u0002C!)\u0011H\u0001a\u0001u\u00051am\u001c:nCR$\"\u0001Q#\t\u000b\u0019\u001b\u0001\u0019A$\u0002\rM|WO]2f!\tAuJ\u0004\u0002J\u001bB\u0011!jL\u0007\u0002\u0017*\u0011AjK\u0001\u0007yI|w\u000e\u001e \n\u00059{\u0013A\u0002)sK\u0012,g-\u0003\u0002Q#\n11\u000b\u001e:j]\u001eT!AT\u0018\u0002\rM\u001c\u0007.Z7b)\t\u0001E\u000bC\u0003S\t\u0001\u0007Q\u000b\u0005\u0002W36\tqK\u0003\u0002YG\u0005)A/\u001f9fg&\u0011!l\u0016\u0002\u000b'R\u0014Xo\u0019;UsB,GC\u0001!]\u0011\u0015iV\u00011\u0001H\u00031\u00198\r[3nCN#(/\u001b8h\u0003\u0019y\u0007\u000f^5p]R\u0019\u0001\t\u00192\t\u000b\u00054\u0001\u0019A$\u0002\u0007-,\u0017\u0010C\u0003d\r\u0001\u0007q)A\u0003wC2,X\rF\u0002AK\u001aDQ!Y\u0004A\u0002\u001dCQaY\u0004A\u0002\u001d\u0004\"A\f5\n\u0005%|#a\u0002\"p_2,\u0017M\u001c\u000b\u0004\u0001.d\u0007\"B1\t\u0001\u00049\u0005\"B2\t\u0001\u0004i\u0007C\u0001\u0018o\u0013\tywF\u0001\u0003M_:<Gc\u0001!re\")\u0011-\u0003a\u0001\u000f\")1-\u0003a\u0001gB\u0011a\u0006^\u0005\u0003k>\u0012a\u0001R8vE2,\u0017aB8qi&|gn\u001d\u000b\u0003\u0001bDQA\u001e\u0006A\u0002e\u0004BA_?H\u000f6\t1P\u0003\u0002}_\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005y\\(aA'baR\u0019\u0001)!\u0001\t\rY\\\u0001\u0019AA\u0002!\u0019\t)!a\u0004H\u000f6\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003vi&d'BAA\u0007\u0003\u0011Q\u0017M^1\n\u0007y\f9!\u0001\u0003m_\u0006$GCAA\u000b!\u0011\t9\"!\f\u000f\t\u0005e\u0011\u0011\u0006\b\u0005\u00037\t9C\u0004\u0003\u0002\u001e\u0005\u0015b\u0002BA\u0010\u0003Gq1ASA\u0011\u0013\u0005Q\u0013B\u0001\u0015*\u0013\t1s%\u0003\u0002%K%\u0019\u00111F\u0012\u0002\u000fA\f7m[1hK&!\u0011qFA\u0019\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0002,\r\nA\u0002\\8bI&sG/\u001a:oC2$B!!\u0006\u00028!9\u0011\u0011H\u0007A\u0002\u0005m\u0012\u0001\u00029bi\"\u0004BALA\u001f\u000f&\u0019\u0011qH\u0018\u0003\r=\u0003H/[8o)\u0011\t)\"a\u0011\t\r\u0005eb\u00021\u0001H\u0003\u0011Q7o\u001c8\u0015\t\u0005U\u0011\u0011\n\u0005\u0007\u0003sy\u0001\u0019A$\u0002\u0007\r\u001ch\u000f\u0006\u0003\u0002\u0016\u0005=\u0003BBA\u001d!\u0001\u0007q)A\u0002y[2$B!!\u0006\u0002V!1\u0011\u0011H\tA\u0002\u001d\u000b1a\u001c:d)\u0011\t)\"a\u0017\t\r\u0005e\"\u00031\u0001H\u0003\u001d\u0001\u0018M]9vKR$B!!\u0006\u0002b!1\u0011\u0011H\nA\u0002\u001d\u000bQ\u0001^1cY\u0016$B!!\u0006\u0002h!1\u0011\u0011\u000e\u000bA\u0002\u001d\u000b\u0011\u0002^1cY\u0016t\u0015-\\3\u0002\tQ,\u0007\u0010\u001e\u000b\u0005\u0003+\ty\u0007\u0003\u0004\u0002:U\u0001\raR\u0001\ti\u0016DHOR5mKR!\u0011QOA>!\u0011Y\u0014qO$\n\u0007\u0005e4EA\u0004ECR\f7/\u001a;\t\r\u0005eb\u00031\u0001H+\u00059\u0015AC:pkJ\u001cWm\u0018\u0013fcR!\u00111QAE!\rq\u0013QQ\u0005\u0004\u0003\u000f{#\u0001B+oSRD\u0001\"a#\u0019\u0003\u0003\u0005\raR\u0001\u0004q\u0012\n\u0014aB:pkJ\u001cW\rI\u0001\u0014kN,'o\u00159fG&4\u0017.\u001a3TG\",W.Y\u000b\u0003\u0003'\u0003BALA\u001f+\u00069Ro]3s'B,7-\u001b4jK\u0012\u001c6\r[3nC~#S-\u001d\u000b\u0005\u0003\u0007\u000bI\nC\u0005\u0002\fn\t\t\u00111\u0001\u0002\u0014\u0006!Ro]3s'B,7-\u001b4jK\u0012\u001c6\r[3nC\u0002\nA\"\u001a=ue\u0006|\u0005\u000f^5p]N,\"!!)\u0011\u000b\u0005\r\u00161V$\u000e\u0005\u0005\u0015&\u0002BA\u0005\u0003OS1!!+$\u0003!\u0019\u0017\r^1msN$\u0018\u0002BAW\u0003K\u0013!cQ1tK&s7/\u001a8tSRLg/Z'ba\u0006\u0001R\r\u001f;sC>\u0003H/[8og~#S-\u001d\u000b\u0005\u0003\u0007\u000b\u0019\fC\u0005\u0002\fz\t\t\u00111\u0001\u0002\"\u0006iQ\r\u001f;sC>\u0003H/[8og\u0002B3\u0001AA]!\u0011\tY,!1\u000e\u0005\u0005u&bAA`K\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0017Q\u0018\u0002\t\u000bZ|GN^5oO\u0002")
public final class DataStreamReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private CaseInsensitiveMap<String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DataStreamReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamReader schema(StructType schema) {
        block0: {
            if (schema == null) break block0;
            StructType replaced = (StructType)CharVarcharUtils$.MODULE$.failIfHasCharVarchar((DataType)schema);
            this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)replaced));
        }
        return this;
    }

    public DataStreamReader schema(String schemaString) {
        return this.schema(StructType$.MODULE$.fromDDL(schemaString));
    }

    public DataStreamReader option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataStreamReader option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataStreamReader option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataStreamReader option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public DataStreamReader options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataStreamReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(options).asScala());
        return this;
    }

    public Dataset<Row> load() {
        return this.loadInternal((Option<String>)None$.MODULE$);
    }

    private Dataset<Row> loadInternal(Option<String> path) {
        TableProvider tableProvider;
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("read");
        }
        CaseInsensitiveMap optionsWithPath = path.isEmpty() ? this.extraOptions() : this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), path.get()));
        Object ds = DataSource$.MODULE$.lookupDataSource(this.source(), this.sparkSession.sqlContext().conf()).getConstructor(new Class[0]).newInstance(new Object[0]);
        SparkSession x$12 = this.sparkSession;
        Option<StructType> x$2 = this.userSpecifiedSchema();
        String x$3 = this.source();
        scala.collection.immutable.Map x$4 = optionsWithPath.originalMap();
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource v1DataSource = new DataSource(x$12, x$3, x$5, x$2, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$4, x$8);
        Object obj = ds;
        Some v1Relation = obj instanceof StreamSourceProvider ? new Some((Object)StreamingRelation$.MODULE$.apply(v1DataSource)) : None$.MODULE$;
        Object obj2 = ds;
        if (obj2 instanceof TableProvider && !((tableProvider = (TableProvider)obj2) instanceof FileDataSourceV2)) {
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(tableProvider, this.sparkSession.sessionState().conf());
            scala.collection.immutable.Map finalOptions = (scala.collection.immutable.Map)sessionOptions.view().filterKeys((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataStreamReader.$anonfun$loadInternal$1(optionsWithPath, x$1))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)optionsWithPath.originalMap());
            CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)finalOptions).asJava());
            Table table = DataSourceV2Utils$.MODULE$.getTableFromProvider(tableProvider, dsOptions, this.userSpecifiedSchema());
            Table table2 = table;
            if (table2 instanceof SupportsRead && DataSourceV2Implicits$.MODULE$.TableHelper(table).supportsAny((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableCapability[]{TableCapability.MICRO_BATCH_READ, TableCapability.CONTINUOUS_READ}))) {
                return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new StreamingRelationV2((Option)new Some((Object)tableProvider), this.source(), table, dsOptions, DataTypeUtils$.MODULE$.toAttributes(CatalogV2Implicits$.MODULE$.ColumnsHelper(table.columns()).asSchema()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)v1Relation));
            }
            return Dataset$.MODULE$.ofRows(this.sparkSession, StreamingRelation$.MODULE$.apply(v1DataSource));
        }
        return Dataset$.MODULE$.ofRows(this.sparkSession, StreamingRelation$.MODULE$.apply(v1DataSource));
    }

    public Dataset<Row> load(String path) {
        if (!this.sparkSession.sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw QueryCompilationErrors$.MODULE$.setPathOptionAndCallWithPathParameterError("load");
        }
        return this.loadInternal((Option<String>)new Some((Object)path));
    }

    public Dataset<Row> json(String path) {
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            JsonUtils$.MODULE$.checkJsonSchema(schema);
            return BoxedUnit.UNIT;
        });
        return this.format("json").load(path);
    }

    public Dataset<Row> csv(String path) {
        return this.format("csv").load(path);
    }

    public Dataset<Row> xml(String path) {
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            XmlUtils$.MODULE$.checkXmlSchema(schema);
            return BoxedUnit.UNIT;
        });
        return this.format("xml").load(path);
    }

    public Dataset<Row> orc(String path) {
        return this.format("orc").load(path);
    }

    public Dataset<Row> parquet(String path) {
        return this.format("parquet").load(path);
    }

    public Dataset<Row> table(String tableName) {
        Predef$.MODULE$.require(tableName != null, (Function0 & Serializable)() -> "The table name can't be null");
        Seq identifier = this.sparkSession.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new UnresolvedRelation(identifier, new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)this.extraOptions().toMap()).asJava()), true));
    }

    public Dataset<Row> text(String path) {
        return this.format("text").load(path);
    }

    public Dataset<String> textFile(String path) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.userSpecifiedSchemaUnsupportedError("textFile");
        }
        return this.text(path).select("value", (Seq<String>)Nil$.MODULE$).as(this.sparkSession.implicits().newStringEncoder());
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadInternal$1(CaseInsensitiveMap optionsWithPath$1, String x$1) {
        return !optionsWithPath$1.contains(x$1);
    }

    public DataStreamReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
    }
}

