/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.MySQLDialect;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class MySQLDialect$
extends JdbcDialect
implements SQLConfHelper,
Product {
    public static final MySQLDialect$ MODULE$ = new MySQLDialect$();
    private static final Set<String> org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions;
    private static final Set<String> supportedAggregateFunctions;
    private static final Set<String> supportedFunctions;

    static {
        SQLConfHelper.$init$((SQLConfHelper)MODULE$);
        Product.$init$((Product)MODULE$);
        org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}));
        supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG"}))).$plus$plus(MODULE$.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions());
        supportedFunctions = MODULE$.supportedAggregateFunctions();
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:mysql");
    }

    public Set<String> org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions() {
        return org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        MySQLDialect.MySQLSQLBuilder mysqlSQLBuilder = new MySQLDialect.MySQLSQLBuilder();
        try {
            some = new Some((Object)mysqlSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", e);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        if (sqlType == -3 && typeName.equals("BIT") && size != 1) {
            md.putLong("binarylong", 1L);
            return Option$.MODULE$.apply((Object)LongType$.MODULE$);
        }
        if (sqlType == -7 && typeName.equals("TINYINT")) {
            return Option$.MODULE$.apply((Object)BooleanType$.MODULE$);
        }
        if ("TINYTEXT".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (sqlType == 12 && typeName.equals("JSON")) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (sqlType == -6 && typeName.equals("TINYINT")) {
            return new Some((Object)ByteType$.MODULE$);
        }
        return None$.MODULE$;
    }

    @Override
    public String quoteIdentifier(String colName) {
        return "`" + colName + "`";
    }

    @Override
    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        return ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])this.listSchemas(conn, options)), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MySQLDialect$.$anonfun$schemasExists$1(schema, x$1)));
    }

    @Override
    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, "SHOW SCHEMAS", (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                MySQLDialect$.$anonfun$listSchemas$1(schemaBuilder, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot show schemas.");
        }
        return (String[][])schemaBuilder.result();
    }

    @Override
    public String getTableExistsQuery(String table) {
        return "SELECT 1 FROM " + table + " LIMIT 1";
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " MODIFY COLUMN " + this.quoteIdentifier(columnName) + " " + newDataType;
    }

    @Override
    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        if (dbMajorVersion >= 8) {
            return "ALTER TABLE " + tableName + " RENAME COLUMN " + this.quoteIdentifier(columnName) + " TO " + this.quoteIdentifier(newName);
        }
        throw QueryExecutionErrors$.MODULE$.renameColumnUnsupportedForOlderMySQLError();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        throw QueryExecutionErrors$.MODULE$.unsupportedUpdateColumnNullabilityError();
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        return "ALTER TABLE " + table + " COMMENT = '" + comment + "'";
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (FloatType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("FLOAT", 6));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("LONGTEXT", -1));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("TINYINT", -6));
        }
        return JdbcUtils$.MODULE$.getCommonJDBCType(dt);
    }

    @Override
    public String getSchemaCommentQuery(String schema, String comment) {
        throw QueryExecutionErrors$.MODULE$.unsupportedCommentNamespaceError(schema);
    }

    @Override
    public String removeSchemaCommentQuery(String schema) {
        throw QueryExecutionErrors$.MODULE$.unsupportedRemoveNamespaceCommentError(schema);
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> MODULE$.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "mysql");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String[] indexPropertyList = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)indexPropertyList);
        String indexType2 = (String)tuple22._1();
        String[] indexPropertyList2 = (String[])tuple22._2();
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " " + indexType2 + " ON " + this.quoteIdentifier(tableIdent.name()) + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ") " + Predef$.MODULE$.wrapRefArray((Object[])indexPropertyList2).mkString(" ");
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SHOW INDEXES FROM " + this.quoteIdentifier(tableIdent.name()) + " WHERE key_name = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.quoteIdentifier(indexName) + " ON " + tableIdent.name();
    }

    @Override
    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        String sql = "SHOW INDEXES FROM " + tableIdent.name();
        ObjectRef indexMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, sql, (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                MySQLDialect$.$anonfun$listIndexes$1(indexMap, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot retrieved index info.");
        }
        return (TableIndex[])((scala.collection.immutable.Map)indexMap.elem).values().toArray(ClassTag$.MODULE$.apply(TableIndex.class));
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 1061: {
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?s)Failed to create index (.*) in (.*)"));
                    String indexName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(1);
                    String tableName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(2);
                    throw new IndexAlreadyExistsException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 1091: {
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?s)Failed to drop index (.*) in (.*)"));
                    String indexName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(1);
                    String tableName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(2);
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
            }
            return super.classifyException(message, e);
        }
        if (throwable instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
            throw unsupportedOperationException;
        }
        return super.classifyException(message, e);
    }

    @Override
    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return "DROP SCHEMA " + this.quoteIdentifier(schema);
        }
        throw QueryExecutionErrors$.MODULE$.unsupportedDropNamespaceError(schema);
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new MySQLDialect.MySQLSQLQueryBuilder(this, options);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    public String productPrefix() {
        return "MySQLDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MySQLDialect$;
    }

    public int hashCode() {
        return 1790277476;
    }

    public String toString() {
        return "MySQLDialect";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MySQLDialect$.class);
    }

    public static final /* synthetic */ boolean $anonfun$schemasExists$1(String schema$1, String[] x$1) {
        Object object = ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$1));
        String string = schema$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$listSchemas$1(ArrayBuilder schemaBuilder$1, ResultSet rs) {
        while (rs.next()) {
            schemaBuilder$1.$plus$eq((Object)new String[]{rs.getString("Database")});
        }
    }

    public static final /* synthetic */ void $anonfun$listIndexes$1(ObjectRef indexMap$1, ResultSet rs) {
        while (rs.next()) {
            String indexName = rs.getString("key_name");
            String colName = rs.getString("column_name");
            String indexType = rs.getString("index_type");
            String indexComment = rs.getString("index_comment");
            if (((scala.collection.immutable.Map)indexMap$1.elem).contains((Object)indexName)) {
                TableIndex index = (TableIndex)((scala.collection.immutable.Map)indexMap$1.elem).get((Object)indexName).get();
                TableIndex newIndex = new TableIndex(indexName, indexType, (NamedReference[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])index.columns()), (Object)FieldReference$.MODULE$.apply(colName), ClassTag$.MODULE$.apply(NamedReference.class)), index.columnProperties(), index.properties());
                indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)newIndex));
                continue;
            }
            Properties properties = new Properties();
            Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(indexComment)) ? properties.put("COMMENT", indexComment) : BoxedUnit.UNIT;
            TableIndex index = new TableIndex(indexName, indexType, (NamedReference[])((Object[])new NamedReference[]{FieldReference$.MODULE$.apply(colName)}), new HashMap(), properties);
            indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)index));
        }
    }

    private MySQLDialect$() {
    }
}

