/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.MsSqlServerDialect;
import org.apache.spark.sql.jdbc.MsSqlServerDialect$SpecificTypes$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class MsSqlServerDialect$
extends JdbcDialect {
    public static final MsSqlServerDialect$ MODULE$ = new MsSqlServerDialect$();
    private static final Set<String> supportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}));
    private static final Set<String> supportedFunctions = MODULE$.supportedAggregateFunctions();

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:sqlserver");
    }

    @Override
    public Object compileValue(Object value) {
        Object object = value;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            if (bl) {
                return BoxesRunTime.boxToInteger((int)1);
            }
            return BoxesRunTime.boxToInteger((int)0);
        }
        return super.compileValue(object);
    }

    private Set<String> supportedAggregateFunctions() {
        return supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        MsSqlServerDialect.MsSqlServerSQLBuilder msSqlServerSQLBuilder = new MsSqlServerDialect.MsSqlServerSQLBuilder();
        try {
            some = new Some((Object)msSqlServerSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", e);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        if (typeName.contains("datetimeoffset")) {
            return Option$.MODULE$.apply((Object)StringType$.MODULE$);
        }
        if (SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled()) {
            return None$.MODULE$;
        }
        int n = sqlType;
        if (5 == n ? true : -6 == n) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if (7 == n) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if (MsSqlServerDialect$SpecificTypes$.MODULE$.GEOMETRY() == n ? true : MsSqlServerDialect$SpecificTypes$.MODULE$.GEOGRAPHY() == n) {
            return new Some((Object)BinaryType$.MODULE$);
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (TimestampType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("DATETIME", 93));
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("DATETIME", 93));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NVARCHAR(MAX)", -9));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BIT", -7));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("VARBINARY(MAX)", -3));
        }
        if (ShortType$.MODULE$.equals(dataType) && !SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled()) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String renameTable(Identifier oldTable, Identifier newTable) {
        return "EXEC sp_rename " + this.getFullyQualifiedQuotedTableName(oldTable) + ", " + this.getFullyQualifiedQuotedTableName(newTable);
    }

    @Override
    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return "ALTER TABLE " + tableName + " ADD " + this.quoteIdentifier(columnName) + " " + dataType;
    }

    @Override
    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return "EXEC sp_rename '" + tableName + "." + this.quoteIdentifier(columnName) + "', " + this.quoteIdentifier(newName) + ", 'COLUMN'";
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        throw QueryExecutionErrors$.MODULE$.unsupportedUpdateColumnNullabilityError();
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        throw QueryExecutionErrors$.MODULE$.commentOnTableUnsupportedError();
    }

    @Override
    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return "TOP (" + limit + ")";
        }
        return "";
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 3729: {
                    throw new NonEmptyNamespaceException(message, (Option)new Some((Object)e));
                }
            }
            return super.classifyException(message, e);
        }
        return super.classifyException(message, e);
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new MsSqlServerDialect.MsSqlServerSQLQueryBuilder(this, options);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MsSqlServerDialect$.class);
    }

    private MsSqlServerDialect$() {
    }
}

