/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.QueryContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.util.V2ExpressionSQLBuilder;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.jdbc.connection.ConnectionProvider$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0005\u0011\u001dh!B!C\u0003\u0003i\u0005\"\u00024\u0001\t\u00039\u0007\"\u00026\u0001\r\u0003Y\u0007\"B=\u0001\t\u0003Q\bbBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002|\u0001!\t!! \t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\"9\u0011q\u0016\u0001\u0005\u0002\u0005E\u0006bBAj\u0001\u0011\u0005\u0011Q\u001b\u0005\b\u0003c\u0004A\u0011AAz\u0011\u001d\t9\u0010\u0001C\u0001\u0003sDqAa\u0001\u0001\t\u0003\u0011)\u0001C\u0004\u0003\u0004\u0001!\tAa\u0004\t\u0013\t}\u0001!%A\u0005\u0002\t\u0005\u0002b\u0002B\u001b\u0001\u0011\u0005!q\u0007\u0005\t\u0005\u000f\u0002A\u0011\u0003\"\u0003J!9!\u0011\u000b\u0001\u0005\u0002\tMca\u0002B0\u0001\u0001\u0011%\u0011\r\u0005\u0007MR!\tAa\u001d\t\u000f\teD\u0003\"\u0011\u0003|!9!q\u0014\u000b\u0005B\t\u0005\u0006b\u0002BW)\u0011\u0005#q\u0016\u0005\b\u0005s#B\u0011\tB^\u0011\u001d\u00119\r\u0006C!\u0005\u0013DqAa5\u0015\t#\u0011)\u000eC\u0004\u0003ZR!\tEa7\t\u000f\t}G\u0003\"\u0011\u0003b\"q!\u0011\u001e\u000b\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0003l\u000e5\u0001bBB\b\u0001\u0011\u00051\u0011\u0003\u0005\b\u0007/\u0001A\u0011AB\r\u0011\u001d\u0019I\u0003\u0001C\u0001\u0007WAqaa\u0015\u0001\t\u0003\u0019)\u0006C\u0004\u0004r\u0001!\taa\u001d\t\u000f\r}\u0004\u0001\"\u0001\u0004\u0002\"911\u0012\u0001\u0005\u0002\r5\u0005bBBK\u0001\u0011\u00051q\u0013\u0005\b\u00073\u0003A\u0011ABN\u0011\u001d\u0019I\n\u0001C\u0001\u0007WCqaa/\u0001\t\u0003\u0019i\fC\u0004\u0004R\u0002!\taa5\t\u000f\ru\u0007\u0001\"\u0001\u0004`\"911\u001e\u0001\u0005\u0002\r5\bbBBz\u0001\u0011\u00051Q\u001f\u0005\b\u0007\u007f\u0004A\u0011\u0001C\u0001\u0011\u001d!Y\u0001\u0001C\u0001\t\u001bAq\u0001b\u0005\u0001\t\u0003!)\u0002C\u0004\u0005\u001c\u0001!\t\u0001\"\b\t\u000f\u0011\u0005\u0002\u0001\"\u0001\u0005$!9A\u0011\u0006\u0001\u0005\u0002\u0011-\u0002b\u0002C\u0019\u0001\u0011\u0005A1\u0007\u0005\b\t'\u0002A\u0011\u0001C+\u0011\u001d!y\u0006\u0001C\u0001\tCBq\u0001b\u001a\u0001\t\u0003!I\u0007C\u0004\u0005\u0000\u0001!\t\u0001\"!\t\u000f\u0011]\u0005\u0001\"\u0001\u0005\u001a\"9AQ\u0015\u0001\u0005\u0002\u0011\u001d\u0006b\u0002CW\u0001\u0011\u0005Aq\u0016\u0005\b\ts\u0003A\u0011\u0001C^\u0011\u001d!i\f\u0001C\u0001\twCq\u0001b0\u0001\t\u0003!Y\fC\u0004\u0005B\u0002!\t\u0001b1\t\u000f\u0011U\u0007\u0001\"\u0001\u0005X\nY!\n\u001a2d\t&\fG.Z2u\u0015\t\u0019E)\u0001\u0003kI\n\u001c'BA#G\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f\"\u000bQa\u001d9be.T!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO\u000e\u00011\u0003\u0002\u0001O)\u0002\u0004\"a\u0014*\u000e\u0003AS\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u0013a!\u00118z%\u00164\u0007CA+^\u001d\t16L\u0004\u0002X56\t\u0001L\u0003\u0002Z\u0019\u00061AH]8pizJ\u0011!U\u0005\u00039B\u000bq\u0001]1dW\u0006<W-\u0003\u0002_?\na1+\u001a:jC2L'0\u00192mK*\u0011A\f\u0015\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\u001a\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003K\n\u0014q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002QB\u0011\u0011\u000eA\u0007\u0002\u0005\u0006I1-\u00198IC:$G.\u001a\u000b\u0003Y>\u0004\"aT7\n\u00059\u0004&a\u0002\"p_2,\u0017M\u001c\u0005\u0006a\n\u0001\r!]\u0001\u0004kJd\u0007C\u0001:w\u001d\t\u0019H\u000f\u0005\u0002X!&\u0011Q\u000fU\u0001\u0007!J,G-\u001a4\n\u0005]D(AB*ue&twM\u0003\u0002v!\u0006yq-\u001a;DCR\fG._:u)f\u0004X\rF\u0005|\u0003\u0013\t\u0019\"a\u0006\u0002\u001cA\u0019q\n @\n\u0005u\u0004&AB(qi&|g\u000eE\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rA)A\u0003usB,7/\u0003\u0003\u0002\b\u0005\u0005!\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005-1\u00011\u0001\u0002\u000e\u000591/\u001d7UsB,\u0007cA(\u0002\u0010%\u0019\u0011\u0011\u0003)\u0003\u0007%sG\u000f\u0003\u0004\u0002\u0016\r\u0001\r!]\u0001\tif\u0004XMT1nK\"9\u0011\u0011D\u0002A\u0002\u00055\u0011\u0001B:ju\u0016Dq!!\b\u0004\u0001\u0004\ty\"\u0001\u0002nIB\u0019q0!\t\n\t\u0005\r\u0012\u0011\u0001\u0002\u0010\u001b\u0016$\u0018\rZ1uC\n+\u0018\u000e\u001c3fe\u0006Yq-\u001a;K\t\n\u001bE+\u001f9f)\u0011\tI#!\r\u0011\t=c\u00181\u0006\t\u0004S\u00065\u0012bAA\u0018\u0005\nA!\n\u001a2d)f\u0004X\r\u0003\u0004\u00024\u0011\u0001\rA`\u0001\u0003IR\fqdY8om\u0016\u0014HOS1wCRKW.Z:uC6\u0004Hk\u001c+j[\u0016\u001cH/Y7q)\u0011\tI$a\u0012\u0011\t\u0005m\u00121I\u0007\u0003\u0003{Q1!RA \u0015\t\t\t%\u0001\u0003kCZ\f\u0017\u0002BA#\u0003{\u0011\u0011\u0002V5nKN$\u0018-\u001c9\t\u000f\u0005%S\u00011\u0001\u0002:\u0005\tA\u000fK\u0003\u0006\u0003\u001b\nI\u0006\u0005\u0003\u0002P\u0005USBAA)\u0015\r\t\u0019FR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA,\u0003#\u0012QaU5oG\u0016\f#!a\u0017\u0002\u000bMrSG\f\u0019\u0002E\r|gN^3si*\u000bg/\u0019+j[\u0016\u001cH/Y7q)>$\u0016.\\3ti\u0006l\u0007O\u0014+[)\u0011\t\t'!\u001c\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KRA!a\u001a\u0002@\u0005!A/[7f\u0013\u0011\tY'!\u001a\u0003\u001b1{7-\u00197ECR,G+[7f\u0011\u001d\tIE\u0002a\u0001\u0003sASABA'\u00033\n!eY8om\u0016\u0014H\u000fV5nKN$\u0018-\u001c9O)j#vNS1wCRKW.Z:uC6\u0004H\u0003BA\u001d\u0003kBq!a\u001e\b\u0001\u0004\t\t'A\u0002mIRDSaBA'\u00033\nqc\u0019:fCR,7i\u001c8oK\u000e$\u0018n\u001c8GC\u000e$xN]=\u0015\t\u0005}\u00141\u0012\t\b\u001f\u0006\u0005\u0015QBAC\u0013\r\t\u0019\t\u0015\u0002\n\rVt7\r^5p]F\u0002B!a\u000f\u0002\b&!\u0011\u0011RA\u001f\u0005)\u0019uN\u001c8fGRLwN\u001c\u0005\b\u0003\u001bC\u0001\u0019AAH\u0003\u001dy\u0007\u000f^5p]N\u0004B!!%\u0002\u001e6\u0011\u00111\u0013\u0006\u0004\u0007\u0006U%\u0002BAL\u00033\u000b1\u0002Z1uCN|WO]2fg*\u0019\u00111\u0014#\u0002\u0013\u0015DXmY;uS>t\u0017\u0002BAP\u0003'\u00131B\u0013#C\u0007>\u0003H/[8og\"*\u0001\"!\u0014\u0002$\u0006\u0012\u0011QU\u0001\u0006g9\u001ad\u0006M\u0001\u0010cV|G/Z%eK:$\u0018NZ5feR\u0019\u0011/a+\t\r\u00055\u0016\u00021\u0001r\u0003\u001d\u0019w\u000e\u001c(b[\u0016\f1b\u0019:fCR,G+\u00192mKRQ\u00111WA]\u0003\u0007\f9-a3\u0011\u0007=\u000b),C\u0002\u00028B\u0013A!\u00168ji\"9\u00111\u0018\u0006A\u0002\u0005u\u0016!C:uCR,W.\u001a8u!\u0011\tY$a0\n\t\u0005\u0005\u0017Q\b\u0002\n'R\fG/Z7f]RDa!!2\u000b\u0001\u0004\t\u0018!\u0003;bE2,g*Y7f\u0011\u0019\tIM\u0003a\u0001c\u0006I1\u000f\u001e:TG\",W.\u0019\u0005\b\u0003\u001bS\u0001\u0019AAg!\u0011\t\t*a4\n\t\u0005E\u00171\u0013\u0002\u0013\u0015\u0012\u00147m\u00149uS>t7/\u00138Xe&$X-A\bj]N,'\u000f^%oi>$\u0016M\u00197f)\u0015\t\u0018q[An\u0011\u0019\tIn\u0003a\u0001c\u0006)A/\u00192mK\"9\u0011Q\\\u0006A\u0002\u0005}\u0017A\u00024jK2$7\u000fE\u0003P\u0003C\f)/C\u0002\u0002dB\u0013Q!\u0011:sCf\u00042a`At\u0013\u0011\tI/!\u0001\u0003\u0017M#(/^2u\r&,G\u000e\u001a\u0015\u0006\u0017\u00055\u0013Q^\u0011\u0003\u0003_\fQ\u0001\u000e\u00181]A\n1cZ3u)\u0006\u0014G.Z#ySN$8/U;fef$2!]A{\u0011\u0019\tI\u000e\u0004a\u0001c\u0006qq-\u001a;TG\",W.Y)vKJLHcA9\u0002|\"1\u0011\u0011\\\u0007A\u0002EDS!DA'\u0003\u007f\f#A!\u0001\u0002\u000bIr\u0013G\f\u0019\u0002!\u001d,G\u000f\u0016:v]\u000e\fG/Z)vKJLHcA9\u0003\b!1\u0011\u0011\u001c\bA\u0002EDSADA'\u0005\u0017\t#A!\u0004\u0002\u000bIr3G\f\u0019\u0015\u000bE\u0014\tBa\u0005\t\r\u0005ew\u00021\u0001r\u0011%\u0011)b\u0004I\u0001\u0002\u0004\u00119\"A\u0004dCN\u001c\u0017\rZ3\u0011\u0007=cH\u000eK\u0003\u0010\u0003\u001b\u0012Y\"\t\u0002\u0003\u001e\u0005)!G\f\u001b/a\u0005Qr-\u001a;UeVt7-\u0019;f#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0005\u0016\u0005\u0005/\u0011)c\u000b\u0002\u0003(A!!\u0011\u0006B\u0019\u001b\t\u0011YC\u0003\u0003\u0003.\t=\u0012!C;oG\",7m[3e\u0015\r\t\u0019\u0006U\u0005\u0005\u0005g\u0011YCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1BY3g_J,g)\u001a;dQR1\u00111\u0017B\u001d\u0005{AqAa\u000f\u0012\u0001\u0004\t))\u0001\u0006d_:tWm\u0019;j_:DqAa\u0010\u0012\u0001\u0004\u0011\t%\u0001\u0006qe>\u0004XM\u001d;jKN\u0004RA\u001dB\"cFL1A!\u0012y\u0005\ri\u0015\r]\u0001\nKN\u001c\u0017\r]3Tc2$2!\u001dB&\u0011\u0019\u0011iE\u0005a\u0001c\u0006)a/\u00197vK\"*!#!\u0014\u0003\f\u0005a1m\\7qS2,g+\u00197vKR!!Q\u000bB.!\ry%qK\u0005\u0004\u00053\u0002&aA!os\"9!QJ\nA\u0002\tU\u0003&B\n\u0002N\t-!A\u0004&E\u0005\u000e\u001b\u0016\u000b\u0014\"vS2$WM]\n\u0004)\t\r\u0004\u0003\u0002B3\u0005_j!Aa\u001a\u000b\t\t%$1N\u0001\u0005kRLGNC\u0002\u0003n\u0011\u000b\u0011bY8o]\u0016\u001cGo\u001c:\n\t\tE$q\r\u0002\u0017-J*\u0005\u0010\u001d:fgNLwN\\*R\u0019\n+\u0018\u000e\u001c3feR\u0011!Q\u000f\t\u0004\u0005o\"R\"\u0001\u0001\u0002\u0019YL7/\u001b;MSR,'/\u00197\u0015\u0007E\u0014i\bC\u0004\u0003\u0000Y\u0001\rA!!\u0002\u000f1LG/\u001a:bYB\"!1\u0011BJ!\u0019\u0011)Ia#\u0003\u00106\u0011!q\u0011\u0006\u0005\u0005\u0013\u0013Y'A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002\u0002BG\u0005\u000f\u0013q\u0001T5uKJ\fG\u000e\u0005\u0003\u0003\u0012\nME\u0002\u0001\u0003\r\u0005+\u0013i(!A\u0001\u0002\u000b\u0005!q\u0013\u0002\u0004?\u0012\n\u0014\u0003\u0002BM\u0005+\u00022a\u0014BN\u0013\r\u0011i\n\u0015\u0002\b\u001d>$\b.\u001b8h\u0003M1\u0018n]5u\u001d\u0006lW\r\u001a*fM\u0016\u0014XM\\2f)\r\t(1\u0015\u0005\b\u0005K;\u0002\u0019\u0001BT\u0003!q\u0017-\\3e%\u00164\u0007\u0003\u0002BC\u0005SKAAa+\u0003\b\nqa*Y7fIJ+g-\u001a:f]\u000e,\u0017!\u0003<jg&$8)Y:u)\u0015\t(\u0011\u0017B[\u0011\u0019\u0011\u0019\f\u0007a\u0001c\u0006\tA\u000e\u0003\u0004\u00038b\u0001\rA`\u0001\tI\u0006$\u0018\rV=qK\u0006\u0001b/[:jiN\u000bFJR;oGRLwN\u001c\u000b\u0006c\nu&\u0011\u0019\u0005\u0007\u0005\u007fK\u0002\u0019A9\u0002\u0011\u0019,hn\u0019(b[\u0016DqAa1\u001a\u0001\u0004\u0011)-\u0001\u0004j]B,Ho\u001d\t\u0005\u001f\u0006\u0005\u0018/\u0001\fwSNLG/Q4he\u0016<\u0017\r^3Gk:\u001cG/[8o)\u001d\t(1\u001aBg\u0005#DaAa0\u001b\u0001\u0004\t\bB\u0002Bh5\u0001\u0007A.\u0001\u0006jg\u0012K7\u000f^5oGRDqAa1\u001b\u0001\u0004\u0011)-A\neS\u0006dWm\u0019;Gk:\u001cG/[8o\u001d\u0006lW\rF\u0002r\u0005/DaAa0\u001c\u0001\u0004\t\u0018\u0001\u0004<jg&$xJ^3sY\u0006LHcA9\u0003^\"9!1\u0019\u000fA\u0002\t\u0015\u0017!\u0003<jg&$HK]5n)\u0015\t(1\u001dBt\u0011\u0019\u0011)/\ba\u0001c\u0006IA-\u001b:fGRLwN\u001c\u0005\b\u0005\u0007l\u0002\u0019\u0001Bc\u0003I\u0019X\u000f]3sIYL7/\u001b;MSR,'/\u00197\u0015\t\t5(q\u001f\t\u0005\u0005_\u0014)0\u0004\u0002\u0003r*!!1_A \u0003\u0011a\u0017M\\4\n\u0007]\u0014\t\u0010C\u0005\u0003zz\t\t\u00111\u0001\u0003|\u0006\u0019\u0001\u0010J\u00191\t\tu8\u0011\u0001\t\u0007\u0005\u000b\u0013YIa@\u0011\t\tE5\u0011\u0001\u0003\r\u0007\u0007\u001190!A\u0001\u0002\u000b\u00051Q\u0001\u0002\u0003\u007fA\nBA!'\u0004\bA!!q^B\u0005\u0013\u0011\u0019YA!=\u0003\r=\u0013'.Z2u\u0013\u0011\u0011IHa\u001c\u0002'%\u001c8+\u001e9q_J$X\r\u001a$v]\u000e$\u0018n\u001c8\u0015\u00071\u001c\u0019\u0002\u0003\u0004\u0003@~\u0001\r!\u001d\u0015\u0006?\u00055\u00131U\u0001\u0012G>l\u0007/\u001b7f\u000bb\u0004(/Z:tS>tG\u0003BB\u000e\u0007;\u00012a\u0014?r\u0011\u001d\u0019y\u0002\ta\u0001\u0007C\tA!\u001a=qeB!!QQB\u0012\u0013\u0011\u0019)Ca\"\u0003\u0015\u0015C\bO]3tg&|g\u000eK\u0003!\u0003\u001b\n\u0019+\u0001\td_6\u0004\u0018\u000e\\3BO\u001e\u0014XmZ1uKR!11DB\u0017\u0011\u001d\u0019y#\ta\u0001\u0007c\t1\"Y4h\rVt7\r^5p]B!11GB\u001d\u001b\t\u0019)D\u0003\u0003\u00048\t\u001d\u0015!C1hOJ,w-\u0019;f\u0013\u0011\u0019Yd!\u000e\u0003\u001b\u0005;wM]3hCR,g)\u001e8dQ\u0015\t\u0013QJARQ-\t3\u0011IB$\u0007\u0013\u001aiea\u0014\u0011\u0007=\u001b\u0019%C\u0002\u0004FA\u0013!\u0002Z3qe\u0016\u001c\u0017\r^3e\u0003\u001diWm]:bO\u0016\f#aa\u0013\u0002\tV\u001cX\rI8sO:\n\u0007/Y2iK:\u001a\b/\u0019:l]M\fHN\f6eE\u000et#\n\u001a2d\t&\fG.Z2u]\r|W\u000e]5mK\u0016C\bO]3tg&|g\u000eI5ogR,\u0017\r\u001a\u0018\u0002\u000bMLgnY3\"\u0005\rE\u0013!B\u001a/i9\u0002\u0014!\u00034v]\u000e$\u0018n\u001c8t+\t\u00199\u0006E\u0003V\u00073\u001ai&C\u0002\u0004\\}\u00131aU3r!\u0019y5qL9\u0004d%\u00191\u0011\r)\u0003\rQ+\b\u000f\\33!\u0011\u0019)g!\u001c\u000e\u0005\r\u001d$\u0002BB*\u0007SRAaa\u001b\u0003l\u000591-\u0019;bY><\u0017\u0002BB8\u0007O\u0012q\"\u00168c_VtGMR;oGRLwN\\\u0001\rGJ,\u0017\r^3TG\",W.\u0019\u000b\t\u0003g\u001b)ha\u001e\u0004|!9\u00111X\u0012A\u0002\u0005u\u0006BBB=G\u0001\u0007\u0011/\u0001\u0004tG\",W.\u0019\u0005\u0007\u0007{\u001a\u0003\u0019A9\u0002\u000f\r|W.\\3oi\u0006i1o\u00195f[\u0006\u001cX\t_5tiN$r\u0001\\BB\u0007\u000f\u001bI\tC\u0004\u0004\u0006\u0012\u0002\r!!\"\u0002\t\r|gN\u001c\u0005\b\u0003\u001b#\u0003\u0019AAH\u0011\u0019\u0019I\b\na\u0001c\u0006YA.[:u'\u000eDW-\\1t)\u0019\u0019yi!%\u0004\u0014B)q*!9\u0003F\"91QQ\u0013A\u0002\u0005\u0015\u0005bBAGK\u0001\u0007\u0011qR\u0001\u0019SN\u001c\u0015m]2bI&tw\r\u0016:v]\u000e\fG/\u001a+bE2,GC\u0001B\f\u0003-\u0011XM\\1nKR\u000b'\r\\3\u0015\u000bE\u001cij!)\t\r\r}u\u00051\u0001r\u0003!yG\u000e\u001a+bE2,\u0007BBBRO\u0001\u0007\u0011/\u0001\u0005oK^$\u0016M\u00197fQ-93\u0011IB$\u0007O\u001bi%!\u0017\"\u0005\r%\u0016a\r)mK\u0006\u001cX\rI8wKJ\u0014\u0018\u000eZ3!e\u0016t\u0017-\\3UC\ndW\rI7fi\"|G\rI<ji\"\u0004\u0013\u000eZ3oi&4\u0017.\u001a:t)\u0015\t8QVB\\\u0011\u001d\u0019y\n\u000ba\u0001\u0007_\u0003Ba!-\u000446\u00111\u0011N\u0005\u0005\u0007k\u001bIG\u0001\u0006JI\u0016tG/\u001b4jKJDqaa))\u0001\u0004\u0019y\u000bK\u0003)\u0003\u001b\nI&\u0001\u0006bYR,'\u000fV1cY\u0016$\u0002B!2\u0004@\u000e\u00057Q\u001a\u0005\u0007\u0003\u000bL\u0003\u0019A9\t\u000f\r\r\u0017\u00061\u0001\u0004F\u000691\r[1oO\u0016\u001c\b#B+\u0004Z\r\u001d\u0007\u0003BBY\u0007\u0013LAaa3\u0004j\tYA+\u00192mK\u000eC\u0017M\\4f\u0011\u001d\u0019y-\u000ba\u0001\u0003\u001b\ta\u0002\u001a2NC*|'OV3sg&|g.A\thKR\fE\rZ\"pYVlg.U;fef$r!]Bk\u0007/\u001cY\u000e\u0003\u0004\u0002F*\u0002\r!\u001d\u0005\u0007\u00073T\u0003\u0019A9\u0002\u0015\r|G.^7o\u001d\u0006lW\r\u0003\u0004\u00038*\u0002\r!]\u0001\u0015O\u0016$(+\u001a8b[\u0016\u001cu\u000e\\;n]F+XM]=\u0015\u0013E\u001c\toa9\u0004f\u000e%\bBBAcW\u0001\u0007\u0011\u000f\u0003\u0004\u0004Z.\u0002\r!\u001d\u0005\u0007\u0007O\\\u0003\u0019A9\u0002\u000f9,wOT1nK\"91qZ\u0016A\u0002\u00055\u0011\u0001F4fi\u0012+G.\u001a;f\u0007>dW/\u001c8Rk\u0016\u0014\u0018\u0010F\u0003r\u0007_\u001c\t\u0010\u0003\u0004\u0002F2\u0002\r!\u001d\u0005\u0007\u00073d\u0003\u0019A9\u00021\u001d,G/\u00169eCR,7i\u001c7v[:$\u0016\u0010]3Rk\u0016\u0014\u0018\u0010F\u0004r\u0007o\u001cIpa?\t\r\u0005\u0015W\u00061\u0001r\u0011\u0019\u0019I.\fa\u0001c\"11Q`\u0017A\u0002E\f1B\\3x\t\u0006$\u0018\rV=qK\u0006yr-\u001a;Va\u0012\fG/Z\"pYVlgNT;mY\u0006\u0014\u0017\u000e\\5usF+XM]=\u0015\u000fE$\u0019\u0001\"\u0002\u0005\b!1\u0011Q\u0019\u0018A\u0002EDaa!7/\u0001\u0004\t\bB\u0002C\u0005]\u0001\u0007A.\u0001\u0006jg:+H\u000e\\1cY\u0016\fAcZ3u)\u0006\u0014G.Z\"p[6,g\u000e^)vKJLH#B9\u0005\u0010\u0011E\u0001BBAm_\u0001\u0007\u0011\u000f\u0003\u0004\u0004~=\u0002\r!]\u0001\u0016O\u0016$8k\u00195f[\u0006\u001cu.\\7f]R\fV/\u001a:z)\u0015\tHq\u0003C\r\u0011\u0019\u0019I\b\ra\u0001c\"11Q\u0010\u0019A\u0002E\f\u0001D]3n_Z,7k\u00195f[\u0006\u001cu.\\7f]R\fV/\u001a:z)\r\tHq\u0004\u0005\u0007\u0007s\n\u0004\u0019A9\u0002\u0015\u0011\u0014x\u000e]*dQ\u0016l\u0017\rF\u0003r\tK!9\u0003\u0003\u0004\u0004zI\u0002\r!\u001d\u0005\u0007\u0005+\u0011\u0004\u0019\u00017\u0002\u0013\u0011\u0014x\u000e\u001d+bE2,GcA9\u0005.!1\u0011\u0011\\\u001aA\u0002EDSaMA'\u0003[\f1b\u0019:fCR,\u0017J\u001c3fqRY\u0011\u000f\"\u000e\u0005:\u0011uB1\tC)\u0011\u0019!9\u0004\u000ea\u0001c\u0006I\u0011N\u001c3fq:\u000bW.\u001a\u0005\b\tw!\u0004\u0019ABX\u0003)!\u0018M\u00197f\u0013\u0012,g\u000e\u001e\u0005\b\t\u007f!\u0004\u0019\u0001C!\u0003\u001d\u0019w\u000e\\;n]N\u0004RaTAq\u0005OCq\u0001\"\u00125\u0001\u0004!9%A\td_2,XN\\:Qe>\u0004XM\u001d;jKN\u0004\u0002\u0002\"\u0013\u0005N\t\u001dFqJ\u0007\u0003\t\u0017RAA!\u001b\u0002@%!!Q\tC&!\u0019!I\u0005\"\u0014rc\"9!q\b\u001bA\u0002\u0011=\u0013aC5oI\u0016DX\t_5tiN$\u0012\u0002\u001cC,\t3\"Y\u0006\"\u0018\t\u000f\r\u0015U\u00071\u0001\u0002\u0006\"1AqG\u001bA\u0002EDq\u0001b\u000f6\u0001\u0004\u0019y\u000bC\u0004\u0002\u000eV\u0002\r!a$\u0002\u0013\u0011\u0014x\u000e]%oI\u0016DH#B9\u0005d\u0011\u0015\u0004B\u0002C\u001cm\u0001\u0007\u0011\u000fC\u0004\u0005<Y\u0002\raa,\u0002\u00171L7\u000f^%oI\u0016DXm\u001d\u000b\t\tW\"I\bb\u001f\u0005~A)q*!9\u0005nA!Aq\u000eC;\u001b\t!\tH\u0003\u0003\u0005t\r%\u0014!B5oI\u0016D\u0018\u0002\u0002C<\tc\u0012!\u0002V1cY\u0016Le\u000eZ3y\u0011\u001d\u0019)i\u000ea\u0001\u0003\u000bCq\u0001b\u000f8\u0001\u0004\u0019y\u000bC\u0004\u0002\u000e^\u0002\r!a$\u0002#\rd\u0017m]:jMf,\u0005pY3qi&|g\u000e\u0006\u0004\u0005\u0004\u0012-EQ\u0012\t\u0005\t\u000b#9)D\u0001E\u0013\r!I\t\u0012\u0002\u0012\u0003:\fG._:jg\u0016C8-\u001a9uS>t\u0007BBB$q\u0001\u0007\u0011\u000fC\u0004\u0005\u0010b\u0002\r\u0001\"%\u0002\u0003\u0015\u00042!\u0016CJ\u0013\r!)j\u0018\u0002\n)\"\u0014xn^1cY\u0016\fabZ3u\u0019&l\u0017\u000e^\"mCV\u001cX\rF\u0002r\t7Cq\u0001\"(:\u0001\u0004!y*A\u0003mS6LG\u000f\u0005\u0003\u0003p\u0012\u0005\u0016\u0002\u0002CR\u0005c\u0014q!\u00138uK\u001e,'/A\bhKR|eMZ:fi\u000ec\u0017-^:f)\r\tH\u0011\u0016\u0005\b\tWS\u0004\u0019\u0001CP\u0003\u0019ygMZ:fi\u00061r-\u001a;KI\n\u001c7+\u0015'Rk\u0016\u0014\u0018PQ;jY\u0012,'\u000f\u0006\u0003\u00052\u0012]\u0006cA5\u00054&\u0019AQ\u0017\"\u0003')#'mY*R\u0019F+XM]=Ck&dG-\u001a:\t\u000f\u000555\b1\u0001\u0002\u0010\u0006i1/\u001e9q_J$8\u000fT5nSR,\u0012\u0001\\\u0001\u000fgV\u0004\bo\u001c:ug>3gm]3u\u0003M\u0019X\u000f\u001d9peR\u001cH+\u00192mKN\u000bW\u000e\u001d7f\u000399W\r\u001e+bE2,7+Y7qY\u0016$2!\u001dCc\u0011\u001d!9m\u0010a\u0001\t\u0013\faa]1na2,\u0007\u0003\u0002Cf\t#l!\u0001\"4\u000b\t\u0011=\u0017QS\u0001\u0003mJJA\u0001b5\u0005N\nyA+\u00192mKN\u000bW\u000e\u001d7f\u0013:4w.\u0001\u0011hKR4U\u000f\u001c7z#V\fG.\u001b4jK\u0012\fVo\u001c;fIR\u000b'\r\\3OC6,GcA9\u0005Z\"9A1\u001c!A\u0002\r=\u0016!B5eK:$\b&\u0002!\u0002N\u0005e\u0003f\u0001\u0001\u0005bB!\u0011q\nCr\u0013\u0011!)/!\u0015\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5")
public abstract class JdbcDialect
implements Serializable,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract boolean canHandle(String var1);

    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        return None$.MODULE$;
    }

    public Option<JdbcType> getJDBCType(DataType dt) {
        return None$.MODULE$;
    }

    public Timestamp convertJavaTimestampToTimestamp(Timestamp t) {
        return t;
    }

    public LocalDateTime convertJavaTimestampToTimestampNTZ(Timestamp t) {
        return DateTimeUtils$.MODULE$.microsToLocalDateTime(DateTimeUtils$.MODULE$.fromJavaTimestampNoRebase(t));
    }

    public Timestamp convertTimestampNTZToJavaTimestamp(LocalDateTime ldt) {
        long micros = DateTimeUtils$.MODULE$.localDateTimeToMicros(ldt);
        return DateTimeUtils$.MODULE$.toJavaTimestampNoRebase(micros);
    }

    public Function1<Object, Connection> createConnectionFactory(JDBCOptions options) {
        String driverClass = options.driverClass();
        return (Function1 & Serializable)partitionId -> JdbcDialect.$anonfun$createConnectionFactory$1(driverClass, options, BoxesRunTime.unboxToInt((Object)partitionId));
    }

    public String quoteIdentifier(String colName) {
        return "\"" + colName + "\"";
    }

    public void createTable(Statement statement, String tableName, String strSchema, JdbcOptionsInWrite options) {
        String createTableOptions = options.createTableOptions();
        statement.executeUpdate("CREATE TABLE " + tableName + " (" + strSchema + ") " + createTableOptions);
    }

    public String insertIntoTable(String table, StructField[] fields) {
        String placeholders = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x$1 -> "?", ClassTag$.MODULE$.apply(String.class))).mkString(",");
        String columns = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x -> this.quoteIdentifier(x.name()), ClassTag$.MODULE$.apply(String.class))).mkString(",");
        return "INSERT INTO " + table + " (" + columns + ") VALUES (" + placeholders + ")";
    }

    public String getTableExistsQuery(String table) {
        return "SELECT * FROM " + table + " WHERE 1=0";
    }

    public String getSchemaQuery(String table) {
        return "SELECT * FROM " + table + " WHERE 1=0";
    }

    public String getTruncateQuery(String table) {
        return this.getTruncateQuery(table, this.isCascadingTruncateTable());
    }

    public String getTruncateQuery(String table, Option<Object> cascade) {
        return "TRUNCATE TABLE " + table;
    }

    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
    }

    public String escapeSql(String value) {
        if (value == null) {
            return null;
        }
        return StringUtils.replace((String)value, (String)"'", (String)"''");
    }

    public Object compileValue(Object value2) {
        Object object = value2;
        if (object instanceof String) {
            String string = (String)object;
            return "'" + this.escapeSql(string) + "'";
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return "'" + timestamp + "'";
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
            return "'" + timestampFormatter.format(instant) + "'";
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return "'" + date + "'";
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return "'" + DateFormatter$.MODULE$.apply().format(localDate) + "'";
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)objectArray), (Function1 & Serializable)value -> this.compileValue(value), ClassTag$.MODULE$.Any())).mkString(", ");
        }
        return value2;
    }

    public boolean isSupportedFunction(String funcName) {
        return false;
    }

    public Option<String> compileExpression(Expression expr) {
        Some some;
        JDBCSQLBuilder jdbcSQLBuilder = new JDBCSQLBuilder();
        try {
            some = new Some((Object)jdbcSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", e);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        return this.compileExpression((Expression)aggFunction);
    }

    public Seq<Tuple2<String, UnboundFunction>> functions() {
        return Nil$.MODULE$;
    }

    public void createSchema(Statement statement, String schema, String comment) {
        String schemaCommentQuery = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(comment)) ? this.getSchemaCommentQuery(schema, comment) : comment;
        statement.executeUpdate("CREATE SCHEMA " + this.quoteIdentifier(schema));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(comment))) {
            statement.executeUpdate(schemaCommentQuery);
            return;
        }
    }

    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        ResultSet rs = conn.getMetaData().getSchemas(null, schema);
        while (rs.next()) {
            String string = rs.getString(1);
            String string2 = schema;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }

    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        ResultSet rs = conn.getMetaData().getSchemas();
        while (rs.next()) {
            schemaBuilder.$plus$eq((Object)new String[]{rs.getString(1)});
        }
        return (String[][])schemaBuilder.result();
    }

    public Option<Object> isCascadingTruncateTable() {
        return None$.MODULE$;
    }

    public String renameTable(String oldTable, String newTable) {
        return "ALTER TABLE " + oldTable + " RENAME TO " + newTable;
    }

    public String renameTable(Identifier oldTable, Identifier newTable) {
        return "ALTER TABLE " + this.getFullyQualifiedQuotedTableName(oldTable) + " RENAME TO " + this.getFullyQualifiedQuotedTableName(newTable);
    }

    public String[] alterTable(String tableName, Seq<TableChange> changes, int dbMajorVersion) {
        ArrayBuilder updateClause = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(String.class));
        changes.foreach((Function1 & Serializable)change -> {
            TableChange.UpdateColumnNullability updateColumnNullability;
            TableChange.UpdateColumnType updateColumnType;
            TableChange.DeleteColumn deleteColumn;
            TableChange.RenameColumn renameColumn;
            TableChange.AddColumn addColumn;
            TableChange tableChange = change;
            if (tableChange instanceof TableChange.AddColumn && (addColumn = (TableChange.AddColumn)tableChange).fieldNames().length == 1) {
                String dataType = JdbcUtils$.MODULE$.getJdbcType(addColumn.dataType(), this).databaseTypeDefinition();
                String[] name = addColumn.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getAddColumnQuery(tableName, name[0], dataType));
            }
            if (tableChange instanceof TableChange.RenameColumn && (renameColumn = (TableChange.RenameColumn)tableChange).fieldNames().length == 1) {
                String[] name = renameColumn.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getRenameColumnQuery(tableName, name[0], renameColumn.newName(), dbMajorVersion));
            }
            if (tableChange instanceof TableChange.DeleteColumn && (deleteColumn = (TableChange.DeleteColumn)tableChange).fieldNames().length == 1) {
                String[] name = deleteColumn.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getDeleteColumnQuery(tableName, name[0]));
            }
            if (tableChange instanceof TableChange.UpdateColumnType && (updateColumnType = (TableChange.UpdateColumnType)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnType.fieldNames();
                String dataType = JdbcUtils$.MODULE$.getJdbcType(updateColumnType.newDataType(), this).databaseTypeDefinition();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnTypeQuery(tableName, name[0], dataType));
            }
            if (tableChange instanceof TableChange.UpdateColumnNullability && (updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnNullability.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnNullabilityQuery(tableName, name[0], updateColumnNullability.nullable()));
            }
            throw QueryCompilationErrors$.MODULE$.unsupportedTableChangeInJDBCCatalogError(change);
        });
        return (String[])updateClause.result();
    }

    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return "ALTER TABLE " + tableName + " ADD COLUMN " + this.quoteIdentifier(columnName) + " " + dataType;
    }

    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return "ALTER TABLE " + tableName + " RENAME COLUMN " + this.quoteIdentifier(columnName) + " TO " + this.quoteIdentifier(newName);
    }

    public String getDeleteColumnQuery(String tableName, String columnName) {
        return "ALTER TABLE " + tableName + " DROP COLUMN " + this.quoteIdentifier(columnName);
    }

    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " " + newDataType;
    }

    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " SET " + nullable;
    }

    public String getTableCommentQuery(String table, String comment) {
        return "COMMENT ON TABLE " + table + " IS '" + comment + "'";
    }

    public String getSchemaCommentQuery(String schema, String comment) {
        return "COMMENT ON SCHEMA " + this.quoteIdentifier(schema) + " IS '" + comment + "'";
    }

    public String removeSchemaCommentQuery(String schema) {
        return "COMMENT ON SCHEMA " + this.quoteIdentifier(schema) + " IS NULL";
    }

    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return "DROP SCHEMA " + this.quoteIdentifier(schema) + " CASCADE";
        }
        return "DROP SCHEMA " + this.quoteIdentifier(schema);
    }

    public String dropTable(String table) {
        return "DROP TABLE " + table;
    }

    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        throw new UnsupportedOperationException("createIndex is not supported");
    }

    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        throw new UnsupportedOperationException("indexExists is not supported");
    }

    public String dropIndex(String indexName, Identifier tableIdent) {
        throw new UnsupportedOperationException("dropIndex is not supported");
    }

    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        throw new UnsupportedOperationException("listIndexes is not supported");
    }

    public AnalysisException classifyException(String message, Throwable e) {
        String x$1 = message;
        Some x$2 = new Some((Object)e);
        Option x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$5();
        scala.collection.immutable.Map x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        QueryContext[] x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        return new AnalysisException(x$1, x$3, x$4, (Option)x$2, x$5, x$6, x$7);
    }

    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return "LIMIT " + limit;
        }
        return "";
    }

    public String getOffsetClause(Integer offset) {
        if (Predef$.MODULE$.Integer2int(offset) > 0) {
            return "OFFSET " + offset;
        }
        return "";
    }

    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new JdbcSQLQueryBuilder(this, options);
    }

    public boolean supportsLimit() {
        return false;
    }

    public boolean supportsOffset() {
        return false;
    }

    public boolean supportsTableSample() {
        return false;
    }

    public String getTableSample(TableSampleInfo sample) {
        throw new UnsupportedOperationException("TableSample is not supported by this data source");
    }

    public String getFullyQualifiedQuotedTableName(Identifier ident) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)ident.name(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)colName -> this.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    public static final /* synthetic */ Connection $anonfun$createConnectionFactory$1(String driverClass$1, JDBCOptions options$1, int partitionId) {
        DriverRegistry$.MODULE$.register(driverClass$1);
        Driver driver = DriverRegistry$.MODULE$.get(driverClass$1);
        Connection connection = ConnectionProvider$.MODULE$.create(driver, (scala.collection.immutable.Map<String, String>)options$1.parameters(), options$1.connectionProviderName());
        Predef$.MODULE$.require(connection != null, (Function0 & Serializable)() -> "The driver could not open a JDBC connection. Check the URL: " + options$1.url());
        return connection;
    }

    public JdbcDialect() {
        Logging.$init$((Logging)this);
    }

    public class JDBCSQLBuilder
    extends V2ExpressionSQLBuilder {
        private /* synthetic */ String super$visitLiteral(Literal x$1) {
            return super.visitLiteral(x$1);
        }

        public String visitLiteral(Literal<?> literal) {
            return (String)Option$.MODULE$.apply(literal.value()).map((Function1 & Serializable)v -> this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().compileValue(CatalystTypeConverters$.MODULE$.convertToScala(v, literal.dataType())).toString()).getOrElse((Function0 & Serializable)() -> this.super$visitLiteral(literal));
        }

        public String visitNamedReference(NamedReference namedRef) {
            if (namedRef.fieldNames().length > 1) {
                throw QueryCompilationErrors$.MODULE$.commandNotSupportNestedColumnError("Filter push down", namedRef.toString());
            }
            return this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])namedRef.fieldNames())));
        }

        public String visitCast(String l, DataType dataType) {
            String databaseTypeDefinition = (String)this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().getJDBCType(dataType).map((Function1 & Serializable)x$2 -> x$2.databaseTypeDefinition()).getOrElse((Function0 & Serializable)() -> dataType.typeName());
            return "CAST(" + l + " AS " + databaseTypeDefinition + ")";
        }

        public String visitSQLFunction(String funcName, String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                return this.dialectFunctionName(funcName) + "(" + Predef$.MODULE$.wrapRefArray((Object[])inputs).mkString(", ") + ")";
            }
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support function: " + funcName);
        }

        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                return super.visitAggregateFunction(this.dialectFunctionName(funcName), isDistinct, inputs);
            }
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support aggregate function: " + funcName);
        }

        public String dialectFunctionName(String funcName) {
            return funcName;
        }

        public String visitOverlay(String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction("OVERLAY")) {
                return super.visitOverlay(inputs);
            }
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support function: OVERLAY");
        }

        public String visitTrim(String direction, String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction("TRIM")) {
                return super.visitTrim(direction, inputs);
            }
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support function: TRIM");
        }

        public /* synthetic */ JdbcDialect org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer() {
            return JdbcDialect.this;
        }

        public JDBCSQLBuilder() {
            if (JdbcDialect.this == null) {
                throw null;
            }
        }
    }
}

