/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.H2Dialect;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class H2Dialect$
extends JdbcDialect {
    public static final H2Dialect$ MODULE$ = new H2Dialect$();
    private static final Set<String> org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
    private static final Set<String> supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}))).$plus$plus(MODULE$.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions());
    private static final Set<String> supportedFunctions = (Set)MODULE$.supportedAggregateFunctions().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ABS", "COALESCE", "GREATEST", "LEAST", "RAND", "LOG", "LOG10", "LN", "EXP", "POWER", "SQRT", "FLOOR", "CEIL", "ROUND", "SIN", "SINH", "COS", "COSH", "TAN", "TANH", "COT", "ASIN", "ACOS", "ATAN", "ATAN2", "DEGREES", "RADIANS", "SIGN", "PI", "SUBSTRING", "UPPER", "LOWER", "TRANSLATE", "TRIM", "MD5", "SHA1", "SHA2", "BIT_LENGTH", "CHAR_LENGTH", "CONCAT"})));
    private static final Map<String, UnboundFunction> functionMap = new ConcurrentHashMap<String, UnboundFunction>();

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:h2");
    }

    public Set<String> org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions() {
        return org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)new JdbcType("NUMERIC(" + decimalType.precision() + "," + decimalType.scale() + ")", 2));
        }
        return JdbcUtils$.MODULE$.getCommonJDBCType(dt);
    }

    private Map<String, UnboundFunction> functionMap() {
        return functionMap;
    }

    public UnboundFunction registerFunction(String name, UnboundFunction fn) {
        return this.functionMap().put(name, fn);
    }

    @Override
    public Seq<Tuple2<String, UnboundFunction>> functions() {
        return CollectionConverters$.MODULE$.MapHasAsScala(this.functionMap()).asScala().toSeq();
    }

    public void clearFunctions() {
        this.functionMap().clear();
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> MODULE$.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "h2");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String indexType2 = indexType;
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " " + indexType2 + " ON " + this.tableNameWithSchema(tableIdent) + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ")";
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.indexNameWithSchema(tableIdent, indexName);
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SELECT * FROM INFORMATION_SCHEMA.INDEXES WHERE TABLE_SCHEMA = '" + ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])tableIdent.namespace())) + "' AND TABLE_NAME = '" + tableIdent.name() + "' AND INDEX_NAME = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        String sql = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         | SELECT\n         |   i.INDEX_CATALOG AS INDEX_CATALOG,\n         |   i.INDEX_SCHEMA AS INDEX_SCHEMA,\n         |   i.INDEX_NAME AS INDEX_NAME,\n         |   i.INDEX_TYPE_NAME AS INDEX_TYPE_NAME,\n         |   i.REMARKS as REMARKS,\n         |   ic.COLUMN_NAME AS COLUMN_NAME\n         | FROM INFORMATION_SCHEMA.INDEXES i, INFORMATION_SCHEMA.INDEX_COLUMNS ic\n         | WHERE i.TABLE_CATALOG = ic.TABLE_CATALOG\n         | AND i.TABLE_SCHEMA = ic.TABLE_SCHEMA\n         | AND i.TABLE_NAME = ic.TABLE_NAME\n         | AND i.INDEX_CATALOG = ic.INDEX_CATALOG\n         | AND i.INDEX_SCHEMA = ic.INDEX_SCHEMA\n         | AND i.INDEX_NAME = ic.INDEX_NAME\n         | AND i.TABLE_NAME = '" + tableIdent.name() + "'\n         | AND i.INDEX_SCHEMA = '" + ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])tableIdent.namespace())) + "'\n         |"));
        ObjectRef indexMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, sql, (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                H2Dialect$.$anonfun$listIndexes$1(indexMap, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot retrieved index info.");
        }
        return (TableIndex[])((scala.collection.immutable.Map)indexMap.elem).values().toArray(ClassTag$.MODULE$.apply(TableIndex.class));
    }

    private String tableNameWithSchema(Identifier ident) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)ident.name(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)colName -> MODULE$.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    private String indexNameWithSchema(Identifier ident, String indexName) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)indexName, ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)colName -> MODULE$.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        block7: {
            Throwable throwable = e;
            if (!(throwable instanceof SQLException)) break block7;
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 42101: {
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"((?:[^\"\\\\]|\\\\[\\\\\"ntbrf])+)\""));
                    String name = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)e.getMessage()).get()).group(1);
                    String quotedName = package$.MODULE$.quoteIdentifier(name);
                    throw new TableAlreadyExistsException("TABLE_OR_VIEW_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)quotedName)})), (Option)new Some((Object)e));
                }
                case 42102: {
                    String quotedName = package$.MODULE$.quoteNameParts(UnresolvedAttribute$.MODULE$.parseAttributeName(message));
                    throw new NoSuchTableException("TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)quotedName)})));
                }
                case 90079: {
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"((?:[^\"\\\\]|\\\\[\\\\\"ntbrf])+)\""));
                    String name = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)e.getMessage()).get()).group(1);
                    String quotedName = package$.MODULE$.quoteIdentifier(name);
                    throw new NoSuchNamespaceException("SCHEMA_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)quotedName)})));
                }
                case 42111: {
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?s)Failed to create index (.*) in (.*)"));
                    String indexName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(1);
                    String tableName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(2);
                    throw new IndexAlreadyExistsException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 42112: {
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?s)Failed to drop index (.*) in (.*)"));
                    String indexName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(1);
                    String tableName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(2);
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
            }
        }
        return super.classifyException(message, e);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        H2Dialect.H2SQLBuilder h2SQLBuilder = new H2Dialect.H2SQLBuilder();
        try {
            some = new Some((Object)h2SQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", e);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(H2Dialect$.class);
    }

    public static final /* synthetic */ void $anonfun$listIndexes$1(ObjectRef indexMap$1, ResultSet rs) {
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            String colName = rs.getString("COLUMN_NAME");
            String indexType = rs.getString("INDEX_TYPE_NAME");
            String indexComment = rs.getString("REMARKS");
            if (((scala.collection.immutable.Map)indexMap$1.elem).contains((Object)indexName)) {
                TableIndex index = (TableIndex)((scala.collection.immutable.Map)indexMap$1.elem).apply((Object)indexName);
                TableIndex newIndex = new TableIndex(indexName, indexType, (NamedReference[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])index.columns()), (Object)FieldReference$.MODULE$.apply(colName), ClassTag$.MODULE$.apply(NamedReference.class)), index.columnProperties(), index.properties());
                indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)newIndex));
                continue;
            }
            Properties properties = new Properties();
            Object object = StringUtils.isNotEmpty((CharSequence)indexComment) ? properties.put("COMMENT", indexComment) : BoxedUnit.UNIT;
            TableIndex index = new TableIndex(indexName, indexType, (NamedReference[])((Object[])new NamedReference[]{FieldReference$.MODULE$.apply(colName)}), new HashMap(), properties);
            indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)index));
        }
    }

    private H2Dialect$() {
    }
}

