/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class DatabricksDialect$
extends JdbcDialect
implements Product {
    public static final DatabricksDialect$ MODULE$ = new DatabricksDialect$();

    static {
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:databricks");
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case -6: {
                return new Some((Object)ByteType$.MODULE$);
            }
            case 5: {
                return new Some((Object)ShortType$.MODULE$);
            }
            case 7: {
                return new Some((Object)FloatType$.MODULE$);
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("DOUBLE", 8));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("STRING", 12));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BINARY", -2));
        }
        return None$.MODULE$;
    }

    @Override
    public String quoteIdentifier(String colName) {
        return "`" + colName + "`";
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsTableSample() {
        return true;
    }

    @Override
    public String getTableSample(TableSampleInfo sample) {
        return "TABLESAMPLE (" + (sample.upperBound() - sample.lowerBound()) * (double)100 + ") REPEATABLE (" + sample.seed() + ")";
    }

    @Override
    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        PreparedStatement stmt = conn.prepareStatement("SHOW SCHEMAS");
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            String string = rs.getString(1);
            String string2 = schema;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        PreparedStatement stmt = conn.prepareStatement("SHOW SCHEMAS");
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            schemaBuilder.$plus$eq((Object)new String[]{rs.getString(1)});
        }
        return (String[][])schemaBuilder.result();
    }

    public String productPrefix() {
        return "DatabricksDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DatabricksDialect$;
    }

    public int hashCode() {
        return -537824790;
    }

    public String toString() {
        return "DatabricksDialect";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DatabricksDialect$.class);
    }

    private DatabricksDialect$() {
    }
}

