/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.jdbc.DB2Dialect;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.SetOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class DB2Dialect$
extends JdbcDialect {
    public static final DB2Dialect$ MODULE$ = new DB2Dialect$();
    private static final Set<String> org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"COVAR_POP", "COVAR_SAMP", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
    private static final Set<String> supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}))).$plus$plus(MODULE$.org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions());
    private static final Set<String> supportedFunctions = MODULE$.supportedAggregateFunctions();

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:db2");
    }

    public Set<String> org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions() {
        return org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        DB2Dialect.DB2SQLBuilder db2SQLBuilder = new DB2Dialect.DB2SQLBuilder();
        try {
            some = new Some((Object)db2SQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", e);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case 7: {
                return Option$.MODULE$.apply((Object)FloatType$.MODULE$);
            }
            case 1111: {
                String string = typeName;
                switch (string == null ? 0 : string.hashCode()) {
                    case 87031: {
                        if (!"XML".equals(string)) break;
                        return Option$.MODULE$.apply((Object)StringType$.MODULE$);
                    }
                    case 1345372058: {
                        if (!"DECFLOAT".equals(string)) break;
                        return Option$.MODULE$.apply((Object)new DecimalType(38, 18));
                    }
                }
                if (string.startsWith("TIMESTAMP")) {
                    return Option$.MODULE$.apply((Object)TimestampType$.MODULE$);
                }
                return None$.MODULE$;
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CHAR(1)", 1));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        return "TRUNCATE TABLE " + table + " IMMEDIATE";
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String renameTable(Identifier oldTable, Identifier newTable) {
        return "RENAME TABLE " + this.getFullyQualifiedQuotedTableName(oldTable) + " TO " + this.getFullyQualifiedQuotedTableName(newTable);
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " SET DATA TYPE " + newDataType;
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " " + nullable;
    }

    @Override
    public String removeSchemaCommentQuery(String schema) {
        return "COMMENT ON SCHEMA " + this.quoteIdentifier(schema) + " IS ''";
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            String string = sQLException.getSQLState();
            switch (string == null ? 0 : string.hashCode()) {
                case 49568276: {
                    if (!"42893".equals(string)) break;
                    throw new NonEmptyNamespaceException(message, (Option)new Some((Object)e));
                }
            }
            return super.classifyException(message, e);
        }
        return super.classifyException(message, e);
    }

    @Override
    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return "DROP SCHEMA " + this.quoteIdentifier(schema) + " CASCADE";
        }
        return "DROP SCHEMA " + this.quoteIdentifier(schema) + " RESTRICT";
    }

    @Override
    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return "FETCH FIRST " + limit + " ROWS ONLY";
        }
        return "";
    }

    @Override
    public String getOffsetClause(Integer offset) {
        if (Predef$.MODULE$.Integer2int(offset) > 0) {
            return "OFFSET " + offset + " ROWS";
        }
        return "";
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new DB2Dialect.DB2SQLQueryBuilder(this, options);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DB2Dialect$.class);
    }

    private DB2Dialect$() {
    }
}

