/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.state.SchemaHelper;
import org.apache.spark.sql.execution.streaming.state.SchemaHelper$SchemaReader$;
import org.apache.spark.sql.execution.streaming.state.SchemaHelper$SchemaWriter$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaNotCompatible;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001\u0002\r\u001a\u0001!B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!)1\t\u0001C\u0001\t\"9\u0001\n\u0001b\u0001\n\u0013I\u0005B\u0002)\u0001A\u0003%!\nC\u0004R\u0001\t\u0007I\u0011\u0002*\t\r]\u0003\u0001\u0015!\u0003T\u0011\u001dA\u0006A1A\u0005\n%Ca!\u0017\u0001!\u0002\u0013Q\u0005b\u0002.\u0001\u0005\u0004%Ia\u0017\u0005\u0007i\u0002\u0001\u000b\u0011\u0002/\t\u000bU\u0004A\u0011\u0001<\t\rU\u0004A\u0011AA\u0005\u0011\u001d\tI\u0002\u0001C\u0005\u00037A\u0001\"!\n\u0001\t\u0003y\u0012q\u0005\u0005\b\u0003_\u0001A\u0011BA\u0019\u0011!\ty\u0003\u0001C\u0001?\u0005]\u0002bBA \u0001\u0011%\u0011\u0011I\u0004\b\u0003\u000bJ\u0002\u0012AA$\r\u0019A\u0012\u0004#\u0001\u0002J!11\t\u0006C\u0001\u0003\u0017B\u0011\"!\u0014\u0015\u0005\u0004%\t!a\u0014\t\u0011\u0005]C\u0003)A\u0005\u0003#\u0012qd\u0015;bi\u0016\u001c6\r[3nC\u000e{W\u000e]1uS\nLG.\u001b;z\u0007\",7m[3s\u0015\tQ2$A\u0003ti\u0006$XM\u0003\u0002\u001d;\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003=}\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u0001\n\u0013aA:rY*\u0011!eI\u0001\u0006gB\f'o\u001b\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Is\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VM\u001a\t\u0003aMj\u0011!\r\u0006\u0003e\u0005\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003iE\u0012q\u0001T8hO&tw-\u0001\u0006qe>4\u0018\u000eZ3s\u0013\u0012\u0004\"a\u000e\u001d\u000e\u0003eI!!O\r\u0003)M#\u0018\r^3Ti>\u0014X\r\u0015:pm&$WM]%e\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nAaY8oM*\u0011\u0001iI\u0001\u0007Q\u0006$wn\u001c9\n\u0005\tk$!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004\u000b\u001a;\u0005CA\u001c\u0001\u0011\u0015)4\u00011\u00017\u0011\u0015Q4\u00011\u0001<\u0003=\u0019Ho\u001c:f\u0007BdunY1uS>tW#\u0001&\u0011\u0005-sU\"\u0001'\u000b\u00055{\u0014A\u00014t\u0013\tyEJ\u0001\u0003QCRD\u0017\u0001E:u_J,7\t\u001d'pG\u0006$\u0018n\u001c8!\u0003\t1W.F\u0001T!\t!V+D\u0001\u001c\u0013\t16DA\u000bDQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3NC:\fw-\u001a:\u0002\u0007\u0019l\u0007%\u0001\ntG\",W.\u0019$jY\u0016dunY1uS>t\u0017aE:dQ\u0016l\u0017MR5mK2{7-\u0019;j_:\u0004\u0013\u0001D:dQ\u0016l\u0017m\u0016:ji\u0016\u0014X#\u0001/\u0011\u0005u\u000bhB\u00010p\u001d\tyfN\u0004\u0002a[:\u0011\u0011\r\u001c\b\u0003E.t!a\u00196\u000f\u0005\u0011LgBA3i\u001b\u00051'BA4(\u0003\u0019a$o\\8u}%\ta%\u0003\u0002%K%\u0011!eI\u0005\u0003A\u0005J!AH\u0010\n\u0005qi\u0012B\u0001\u000e\u001c\u0013\t\u0001\u0018$\u0001\u0007TG\",W.\u0019%fYB,'/\u0003\u0002sg\na1k\u00195f[\u0006<&/\u001b;fe*\u0011\u0001/G\u0001\u000eg\u000eDW-\\1Xe&$XM\u001d\u0011\u0002\u000b\rDWmY6\u0015\t]T\u0018Q\u0001\t\u0003UaL!!_\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u0006w2\u0001\r\u0001`\u0001\nW\u0016L8k\u00195f[\u0006\u00042!`A\u0001\u001b\u0005q(BA@ \u0003\u0015!\u0018\u0010]3t\u0013\r\t\u0019A \u0002\u000b'R\u0014Xo\u0019;UsB,\u0007BBA\u0004\u0019\u0001\u0007A0A\u0006wC2,XmU2iK6\fGcB<\u0002\f\u00055\u0011q\u0002\u0005\u0006w6\u0001\r\u0001 \u0005\u0007\u0003\u000fi\u0001\u0019\u0001?\t\u000f\u0005EQ\u00021\u0001\u0002\u0014\u0005\t\u0012n\u001a8pe\u00164\u0016\r\\;f'\u000eDW-\\1\u0011\u0007)\n)\"C\u0002\u0002\u0018-\u0012qAQ8pY\u0016\fg.A\ttG\",W.Y:D_6\u0004\u0018\r^5cY\u0016$b!a\u0005\u0002\u001e\u0005\u0005\u0002BBA\u0010\u001d\u0001\u0007A0\u0001\u0007ti>\u0014X\rZ*dQ\u0016l\u0017\r\u0003\u0004\u0002$9\u0001\r\u0001`\u0001\u0007g\u000eDW-\\1\u0002\u001dI,\u0017\rZ*dQ\u0016l\u0017MR5mKR\u0011\u0011\u0011\u0006\t\u0006U\u0005-B\u0010`\u0005\u0004\u0003[Y#A\u0002+va2,''\u0001\tde\u0016\fG/Z*dQ\u0016l\u0017MR5mKR)q/a\r\u00026!)1\u0010\u0005a\u0001y\"1\u0011q\u0001\tA\u0002q$ra^A\u001d\u0003w\ti\u0004C\u0003|#\u0001\u0007A\u0010\u0003\u0004\u0002\bE\u0001\r\u0001 \u0005\u00065F\u0001\r\u0001X\u0001\u000bg\u000eDW-\\1GS2,Gc\u0001&\u0002D!)\u0001J\u0005a\u0001\u0015\u0006y2\u000b^1uKN\u001b\u0007.Z7b\u0007>l\u0007/\u0019;jE&d\u0017\u000e^=DQ\u0016\u001c7.\u001a:\u0011\u0005]\"2C\u0001\u000b*)\t\t9%A\u0004W\u000bJ\u001b\u0016j\u0014(\u0016\u0005\u0005E\u0003c\u0001\u0016\u0002T%\u0019\u0011QK\u0016\u0003\u0007%sG/\u0001\u0005W\u000bJ\u001b\u0016j\u0014(!\u0001")
public class StateSchemaCompatibilityChecker
implements Logging {
    private final StateStoreProviderId providerId;
    private final Path storeCpLocation;
    private final CheckpointFileManager fm;
    private final Path schemaFileLocation;
    private final SchemaHelper.SchemaWriter schemaWriter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int VERSION() {
        return StateSchemaCompatibilityChecker$.MODULE$.VERSION();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Path storeCpLocation() {
        return this.storeCpLocation;
    }

    private CheckpointFileManager fm() {
        return this.fm;
    }

    private Path schemaFileLocation() {
        return this.schemaFileLocation;
    }

    private SchemaHelper.SchemaWriter schemaWriter() {
        return this.schemaWriter;
    }

    public void check(StructType keySchema, StructType valueSchema) {
        this.check(keySchema, valueSchema, false);
    }

    public void check(StructType keySchema, StructType valueSchema, boolean ignoreValueSchema) {
        if (this.fm().exists(this.schemaFileLocation())) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Schema file for provider " + $this.providerId + " exists. Comparing with provided schema.");
            Tuple2<StructType, StructType> tuple2 = this.readSchemaFile();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            StructType storedKeySchema = (StructType)tuple2._1();
            StructType storedValueSchema = (StructType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)storedKeySchema, (Object)storedValueSchema);
            StructType storedKeySchema2 = (StructType)tuple22._1();
            StructType storedValueSchema2 = (StructType)tuple22._2();
            if (storedKeySchema2.equals((Object)keySchema) && (ignoreValueSchema || storedValueSchema2.equals((Object)valueSchema))) {
                return;
            }
            if (!this.schemasCompatible(storedKeySchema2, keySchema) || !ignoreValueSchema && !this.schemasCompatible(storedValueSchema2, valueSchema)) {
                String errorMsgForKeySchema = "- Provided key schema: " + keySchema + "\n- Existing key schema: " + storedKeySchema2 + "\n";
                String errorMsgForValueSchema = !ignoreValueSchema ? "- Provided value schema: " + valueSchema + "\n- Existing value schema: " + storedValueSchema2 + "\n" : "";
                String errorMsg = "Provided schema doesn't match to the schema for existing state! Please note that Spark allow difference of field name: check count of fields and data type of each field.\n" + errorMsgForKeySchema + errorMsgForValueSchema + "If you want to force running query without schema validation, please set " + SQLConf$.MODULE$.STATE_SCHEMA_CHECK_ENABLED().key() + " to false.\nPlease note running query with incompatible schema could cause indeterministic behavior.";
                this.logError((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                throw new StateSchemaNotCompatible(errorMsg);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Detected schema change which is compatible. Allowing to put rows.");
            return;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Schema file for provider " + $this.providerId + " doesn't exist. Creating one.");
        this.createSchemaFile(keySchema, valueSchema);
    }

    private boolean schemasCompatible(StructType storedSchema, StructType schema) {
        return DataType$.MODULE$.equalsIgnoreNameAndCompatibleNullability((DataType)schema, (DataType)storedSchema);
    }

    public Tuple2<StructType, StructType> readSchemaFile() {
        Tuple2<StructType, StructType> tuple2;
        try (FSDataInputStream inStream = this.fm().open(this.schemaFileLocation());){
            try {
                String versionStr = inStream.readUTF();
                SchemaHelper.SchemaReader schemaReader = SchemaHelper$SchemaReader$.MODULE$.createSchemaReader(versionStr);
                tuple2 = schemaReader.read(inStream);
            }
            catch (Throwable e) {
                this.logError((Function0<String>)(Function0 & Serializable)() -> "Fail to read schema file from " + this.schemaFileLocation(), e);
                throw e;
            }
        }
        return tuple2;
    }

    private void createSchemaFile(StructType keySchema, StructType valueSchema) {
        this.createSchemaFile(keySchema, valueSchema, this.schemaWriter());
    }

    public void createSchemaFile(StructType keySchema, StructType valueSchema, SchemaHelper.SchemaWriter schemaWriter) {
        CheckpointFileManager.CancellableFSDataOutputStream outStream = this.fm().createAtomic(this.schemaFileLocation(), false);
        try {
            schemaWriter.write(keySchema, valueSchema, outStream);
            outStream.close();
        }
        catch (Throwable e) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> "Fail to write schema file to " + this.schemaFileLocation(), e);
            outStream.cancel();
            throw e;
        }
    }

    private Path schemaFile(Path storeCpLocation) {
        return new Path(new Path(storeCpLocation, "_metadata"), "schema");
    }

    public StateSchemaCompatibilityChecker(StateStoreProviderId providerId, Configuration hadoopConf) {
        this.providerId = providerId;
        Logging.$init$((Logging)this);
        this.storeCpLocation = providerId.storeId().storeCheckpointLocation();
        this.fm = CheckpointFileManager$.MODULE$.create(this.storeCpLocation(), hadoopConf);
        this.schemaFileLocation = this.schemaFile(this.storeCpLocation());
        this.schemaWriter = SchemaHelper$SchemaWriter$.MODULE$.createSchemaWriter(StateSchemaCompatibilityChecker$.MODULE$.VERSION());
        this.fm().mkdirs(this.schemaFileLocation().getParent());
    }
}

