/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoder;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoder;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateEncoder;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateStoreProvider$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.Platform;

public final class RocksDBStateEncoder$ {
    public static final RocksDBStateEncoder$ MODULE$ = new RocksDBStateEncoder$();

    public RocksDBStateEncoder getEncoder(StructType keySchema, StructType valueSchema, int numColsPrefixKey) {
        if (numColsPrefixKey > 0) {
            return new PrefixKeyScanStateEncoder(keySchema, valueSchema, numColsPrefixKey);
        }
        return new NoPrefixKeyStateEncoder(keySchema, valueSchema);
    }

    public byte[] encodeUnsafeRow(UnsafeRow row) {
        byte[] bytesToEncode = row.getBytes();
        byte[] encodedBytes = new byte[bytesToEncode.length + RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES()];
        Platform.putByte((Object)encodedBytes, (long)Platform.BYTE_ARRAY_OFFSET, (byte)RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_VERSION());
        Platform.copyMemory((Object)bytesToEncode, (long)Platform.BYTE_ARRAY_OFFSET, (Object)encodedBytes, (long)(Platform.BYTE_ARRAY_OFFSET + RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES()), (long)bytesToEncode.length);
        return encodedBytes;
    }

    public UnsafeRow decodeToUnsafeRow(byte[] bytes, int numFields) {
        if (bytes != null) {
            UnsafeRow row = new UnsafeRow(numFields);
            return this.decodeToUnsafeRow(bytes, row);
        }
        return null;
    }

    public UnsafeRow decodeToUnsafeRow(byte[] bytes, UnsafeRow reusedRow) {
        if (bytes != null) {
            reusedRow.pointTo((Object)bytes, (long)(Platform.BYTE_ARRAY_OFFSET + RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES()), bytes.length - RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES());
            return reusedRow;
        }
        return null;
    }

    private RocksDBStateEncoder$() {
    }
}

