/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadata;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadataV1$;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000593A\u0001C\u0005\u00011!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0011\u0015)\u0004\u0001\"\u00017\u0011\u001dY\u0004A1A\u0005\nqBa!\u0010\u0001!\u0002\u00131\u0003\u0002\u0003 \u0001\u0011\u000b\u0007I\u0011B \t\u000b\u0011\u0003A\u0011A#\u00037=\u0003XM]1u_J\u001cF/\u0019;f\u001b\u0016$\u0018\rZ1uC^\u0013\u0018\u000e^3s\u0015\tQ1\"A\u0003ti\u0006$XM\u0003\u0002\r\u001b\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u001d=\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005A\t\u0012aA:rY*\u0011!cE\u0001\u0006gB\f'o\u001b\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Ir\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\rj\u0011!\t\u0006\u0003EE\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003I\u0005\u0012q\u0001T8hO&tw-A\nti\u0006$Xm\u00115fG.\u0004x.\u001b8u!\u0006$\b\u000e\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005\u0011am\u001d\u0006\u0003WM\ta\u0001[1e_>\u0004\u0018BA\u0017)\u0005\u0011\u0001\u0016\r\u001e5\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u00021g5\t\u0011G\u0003\u00023U\u0005!1m\u001c8g\u0013\t!\u0014GA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007]J$\b\u0005\u00029\u00015\t\u0011\u0002C\u0003&\u0007\u0001\u0007a\u0005C\u0003/\u0007\u0001\u0007q&\u0001\tnKR\fG-\u0019;b\r&dW\rU1uQV\ta%A\tnKR\fG-\u0019;b\r&dW\rU1uQ\u0002\n!AZ7\u0016\u0003\u0001\u0003\"!\u0011\"\u000e\u0003-I!aQ\u0006\u0003+\rCWmY6q_&tGOR5mK6\u000bg.Y4fe\u0006)qO]5uKR\u0011a)\u0013\t\u00035\u001dK!\u0001S\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0015\u001e\u0001\raS\u0001\u0011_B,'/\u0019;pe6+G/\u00193bi\u0006\u0004\"\u0001\u000f'\n\u00055K!!F(qKJ\fGo\u001c:Ti\u0006$X-T3uC\u0012\fG/\u0019")
public class OperatorStateMetadataWriter
implements Logging {
    private CheckpointFileManager fm;
    private Path stateCheckpointPath;
    private Configuration hadoopConf;
    private final Path metadataFilePath;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Path metadataFilePath() {
        return this.metadataFilePath;
    }

    private CheckpointFileManager fm$lzycompute() {
        OperatorStateMetadataWriter operatorStateMetadataWriter = this;
        synchronized (operatorStateMetadataWriter) {
            if (!this.bitmap$0) {
                this.fm = CheckpointFileManager$.MODULE$.create(this.stateCheckpointPath, this.hadoopConf);
                this.bitmap$0 = true;
            }
        }
        this.stateCheckpointPath = null;
        this.hadoopConf = null;
        return this.fm;
    }

    private CheckpointFileManager fm() {
        if (!this.bitmap$0) {
            return this.fm$lzycompute();
        }
        return this.fm;
    }

    public void write(OperatorStateMetadata operatorMetadata) {
        if (this.fm().exists(this.metadataFilePath())) {
            return;
        }
        this.fm().mkdirs(this.metadataFilePath().getParent());
        CheckpointFileManager.CancellableFSDataOutputStream outputStream = this.fm().createAtomic(this.metadataFilePath(), false);
        try {
            outputStream.write(("v" + operatorMetadata.version() + "\n").getBytes(StandardCharsets.UTF_8));
            OperatorStateMetadataV1$.MODULE$.serialize(outputStream, operatorMetadata);
            outputStream.close();
        }
        catch (Throwable e) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> "Fail to write state metadata file to " + this.metadataFilePath(), e);
            outputStream.cancel();
            throw e;
        }
    }

    public OperatorStateMetadataWriter(Path stateCheckpointPath, Configuration hadoopConf) {
        this.stateCheckpointPath = stateCheckpointPath;
        this.hadoopConf = hadoopConf;
        Logging.$init$((Logging)this);
        this.metadataFilePath = OperatorStateMetadataV1$.MODULE$.metadataFilePath(stateCheckpointPath);
    }
}

