/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.SparkDataStream;
import org.apache.spark.sql.connector.read.streaming.SupportsAdmissionControl;
import org.apache.spark.sql.connector.read.streaming.SupportsTriggerAvailableNow;
import org.apache.spark.sql.execution.streaming.Source;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005Y4A\u0001E\t\u0001=!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015a\u0004\u0001\"\u0001>\u0011%\t\u0005\u00011AA\u0002\u0013%!\tC\u0005G\u0001\u0001\u0007\t\u0019!C\u0005\u000f\"I\u0001\u000b\u0001a\u0001\u0002\u0003\u0006Ka\u0011\u0005\u0006#\u0002!\tE\u0015\u0005\u0006'\u0002!\t\u0005\u0016\u0005\u0006E\u0002!\te\u0019\u0005\u0006M\u0002!\te\u001a\u0005\u0006Q\u0002!IA\u0011\u0005\u0006S\u0002!\te\u001a\u0005\u0006U\u0002!\te\u001b\u0005\u0006_\u0002!\t\u0005\u001d\u0005\u0006k\u0002!\tE\u0015\u0002\u001e\u0003Z\f\u0017\u000e\\1cY\u0016tun\u001e#bi\u0006\u001cFO]3b[^\u0013\u0018\r\u001d9fe*\u0011!cE\u0001\ngR\u0014X-Y7j]\u001eT!\u0001F\u000b\u0002\u0013\u0015DXmY;uS>t'B\u0001\f\u0018\u0003\r\u0019\u0018\u000f\u001c\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u00011#\u0002\u0001 OA\u001a\u0004C\u0001\u0011&\u001b\u0005\t#B\u0001\u0012$\u0003\u0011a\u0017M\\4\u000b\u0003\u0011\nAA[1wC&\u0011a%\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005!rS\"A\u0015\u000b\u0005IQ#BA\u0016-\u0003\u0011\u0011X-\u00193\u000b\u00055*\u0012!C2p]:,7\r^8s\u0013\ty\u0013FA\bTa\u0006\u00148\u000eR1uCN#(/Z1n!\tA\u0013'\u0003\u00023S\tY2+\u001e9q_J$8\u000f\u0016:jO\u001e,'/\u0011<bS2\f'\r\\3O_^\u0004\"\u0001N\u001c\u000e\u0003UR!AN\f\u0002\u0011%tG/\u001a:oC2L!\u0001O\u001b\u0003\u000f1{wmZ5oO\u0006AA-\u001a7fO\u0006$X-F\u0001(\u0003%!W\r\\3hCR,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003}\u0001\u0003\"a\u0010\u0001\u000e\u0003EAQ!O\u0002A\u0002\u001d\nQBZ3uG\",Gm\u00144gg\u0016$X#A\"\u0011\u0005!\"\u0015BA#*\u0005\u0019yeMZ:fi\u0006\tb-\u001a;dQ\u0016$wJ\u001a4tKR|F%Z9\u0015\u0005!s\u0005CA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%\u0001B+oSRDqaT\u0003\u0002\u0002\u0003\u00071)A\u0002yIE\naBZ3uG\",Gm\u00144gg\u0016$\b%A\u0007j]&$\u0018.\u00197PM\u001a\u001cX\r\u001e\u000b\u0002\u0007\u0006\tB-Z:fe&\fG.\u001b>f\u001f\u001a47/\u001a;\u0015\u0005\r+\u0006\"\u0002,\t\u0001\u00049\u0016\u0001\u00026t_:\u0004\"\u0001W0\u000f\u0005ek\u0006C\u0001.K\u001b\u0005Y&B\u0001/\u001e\u0003\u0019a$o\\8u}%\u0011aLS\u0001\u0007!J,G-\u001a4\n\u0005\u0001\f'AB*ue&twM\u0003\u0002_\u0015\u000611m\\7nSR$\"\u0001\u00133\t\u000b\u0015L\u0001\u0019A\"\u0002\u0007\u0015tG-\u0001\u0003ti>\u0004H#\u0001%\u0002!\u001d,G/\u00138ji&\fGn\u00144gg\u0016$\u0018!\b9sKB\f'/\u001a$peR\u0013\u0018nZ4fe\u00063\u0018-\u001b7bE2,gj\\<\u0002'\u001d,G\u000fR3gCVdGOU3bI2KW.\u001b;\u0015\u00031\u0004\"\u0001K7\n\u00059L#!\u0003*fC\u0012d\u0015.\\5u\u00031a\u0017\r^3ti>3gm]3u)\r\u0019\u0015o\u001d\u0005\u0006e:\u0001\raQ\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0003u\u001d\u0001\u0007A.A\u0003mS6LG/\u0001\nsKB|'\u000f\u001e'bi\u0016\u001cHo\u00144gg\u0016$\b")
public class AvailableNowDataStreamWrapper
implements SupportsTriggerAvailableNow,
Logging {
    private final SparkDataStream delegate;
    private Offset fetchedOffset;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkDataStream delegate() {
        return this.delegate;
    }

    private Offset fetchedOffset() {
        return this.fetchedOffset;
    }

    private void fetchedOffset_$eq(Offset x$1) {
        this.fetchedOffset = x$1;
    }

    public Offset initialOffset() {
        return this.delegate().initialOffset();
    }

    public Offset deserializeOffset(String json) {
        return this.delegate().deserializeOffset(json);
    }

    public void commit(Offset end) {
        this.delegate().commit(end);
    }

    public void stop() {
        this.delegate().stop();
    }

    private Offset getInitialOffset() {
        SparkDataStream sparkDataStream = this.delegate();
        if (sparkDataStream instanceof Source) {
            return null;
        }
        if (sparkDataStream instanceof MicroBatchStream) {
            MicroBatchStream microBatchStream = (MicroBatchStream)sparkDataStream;
            return microBatchStream.initialOffset();
        }
        throw new MatchError((Object)sparkDataStream);
    }

    public void prepareForTriggerAvailableNow() {
        Offset offset;
        SparkDataStream sparkDataStream = this.delegate();
        if (sparkDataStream instanceof SupportsAdmissionControl) {
            SupportsAdmissionControl supportsAdmissionControl = (SupportsAdmissionControl)sparkDataStream;
            offset = supportsAdmissionControl.latestOffset(this.getInitialOffset(), ReadLimit.allAvailable());
        } else if (sparkDataStream instanceof Source) {
            Source source = (Source)sparkDataStream;
            offset = (Offset)source.getOffset().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        } else if (sparkDataStream instanceof MicroBatchStream) {
            MicroBatchStream microBatchStream = (MicroBatchStream)sparkDataStream;
            offset = microBatchStream.latestOffset();
        } else {
            throw new IllegalStateException("Unexpected source: " + sparkDataStream);
        }
        this.fetchedOffset_$eq(offset);
    }

    public ReadLimit getDefaultReadLimit() {
        SparkDataStream sparkDataStream = this.delegate();
        if (sparkDataStream instanceof SupportsAdmissionControl) {
            ReadLimit limit;
            SupportsAdmissionControl supportsAdmissionControl = (SupportsAdmissionControl)sparkDataStream;
            ReadLimit readLimit = limit = supportsAdmissionControl.getDefaultReadLimit();
            ReadLimit readLimit2 = ReadLimit.allAvailable();
            if (readLimit == null ? readLimit2 != null : !readLimit.equals(readLimit2)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "The read limit " + limit + " is ignored because source " + this.delegate() + " does not support running Trigger.AvailableNow queries.");
            }
            return ReadLimit.allAvailable();
        }
        return ReadLimit.allAvailable();
    }

    public Offset latestOffset(Offset startOffset, ReadLimit limit) {
        return this.fetchedOffset();
    }

    public Offset reportLatestOffset() {
        SparkDataStream sparkDataStream = this.delegate();
        if (sparkDataStream instanceof SupportsAdmissionControl) {
            SupportsAdmissionControl supportsAdmissionControl = (SupportsAdmissionControl)sparkDataStream;
            return supportsAdmissionControl.reportLatestOffset();
        }
        if (sparkDataStream instanceof Source) {
            Source source = (Source)sparkDataStream;
            return (Offset)source.getOffset().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        if (sparkDataStream instanceof MicroBatchStream) {
            MicroBatchStream microBatchStream = (MicroBatchStream)sparkDataStream;
            return microBatchStream.latestOffset();
        }
        throw new MatchError((Object)sparkDataStream);
    }

    public AvailableNowDataStreamWrapper(SparkDataStream delegate) {
        this.delegate = delegate;
        Logging.$init$((Logging)this);
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Activating the wrapper implementation of Trigger.AvailableNow for source [" + this.delegate() + "]. Note that this might introduce possibility of deduplication, dataloss, correctness issue. Enable the config with extreme care. We strongly recommend to contact the data source developer to support Trigger.AvailableNow.");
    }
}

