/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.python;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import net.razorvine.pickle.Pickler;
import org.apache.spark.api.python.PythonFunction;
import org.apache.spark.api.python.PythonWorkerUtils$;
import org.apache.spark.api.python.SpecialLengths$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.python.PythonDataSourceCreationResult;
import org.apache.spark.sql.execution.python.PythonPlannerRunner;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005=a\u0001B\u0006\r\u0001eA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!a\u0005A!A!\u0002\u0013i\u0005\"B+\u0001\t\u00031\u0006bB/\u0001\u0005\u0004%\tE\u0018\u0005\u0007M\u0002\u0001\u000b\u0011B0\t\u000b\u001d\u0004A\u0011\u000b5\t\u000f\u0005\u0005\u0001\u0001\"\u0015\u0002\u0004\t\tSk]3s\t\u00164\u0017N\\3e!f$\bn\u001c8ECR\f7k\\;sG\u0016\u0014VO\u001c8fe*\u0011QBD\u0001\u0007af$\bn\u001c8\u000b\u0005=\u0001\u0012!C3yK\u000e,H/[8o\u0015\t\t\"#A\u0002tc2T!a\u0005\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005U1\u0012AB1qC\u000eDWMC\u0001\u0018\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0004E\u0002\u001c9yi\u0011\u0001D\u0005\u0003;1\u00111\u0003U=uQ>t\u0007\u000b\\1o]\u0016\u0014(+\u001e8oKJ\u0004\"aG\u0010\n\u0005\u0001b!A\b)zi\"|g\u000eR1uCN{WO]2f\u0007J,\u0017\r^5p]J+7/\u001e7u\u00035!\u0017\r^1T_V\u00148-Z\"mgB\u00111eJ\u0007\u0002I)\u0011Q\"\n\u0006\u0003MI\t1!\u00199j\u0013\tACE\u0001\bQsRDwN\u001c$v]\u000e$\u0018n\u001c8\u0002\u0011A\u0014xN^5eKJ\u0004\"a\u000b\u001b\u000f\u00051\u0012\u0004CA\u00171\u001b\u0005q#BA\u0018\u0019\u0003\u0019a$o\\8u})\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019\u0004'A\u0003qCRD7\u000fE\u0002:})r!A\u000f\u001f\u000f\u00055Z\u0014\"A\u0019\n\u0005u\u0002\u0014a\u00029bG.\fw-Z\u0005\u0003\u007f\u0001\u00131aU3r\u0015\ti\u0004'A\nvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017\rE\u0002D\t\u001ak\u0011\u0001M\u0005\u0003\u000bB\u0012aa\u00149uS>t\u0007CA$K\u001b\u0005A%BA%\u0011\u0003\u0015!\u0018\u0010]3t\u0013\tY\u0005J\u0001\u0006TiJ,8\r\u001e+za\u0016\fqa\u001c9uS>t7\u000fE\u0002O'*j\u0011a\u0014\u0006\u0003!F\u000bA!\u001e;jY*\u0011!\u000bE\u0001\tG\u0006$\u0018\r\\=ti&\u0011Ak\u0014\u0002\u0013\u0007\u0006\u001cX-\u00138tK:\u001c\u0018\u000e^5wK6\u000b\u0007/\u0001\u0004=S:LGO\u0010\u000b\u0007/bK&l\u0017/\u0011\u0005m\u0001\u0001\"B\u0011\u0007\u0001\u0004\u0011\u0003\"B\u0015\u0007\u0001\u0004Q\u0003\"B\u001c\u0007\u0001\u0004A\u0004\"B!\u0007\u0001\u0004\u0011\u0005\"\u0002'\u0007\u0001\u0004i\u0015\u0001D<pe.,'/T8ek2,W#A0\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001\u00027b]\u001eT\u0011\u0001Z\u0001\u0005U\u00064\u0018-\u0003\u00026C\u0006iqo\u001c:lKJlu\u000eZ;mK\u0002\nQb\u001e:ji\u0016$v\u000eU=uQ>tGcA5miB\u00111I[\u0005\u0003WB\u0012A!\u00168ji\")Q.\u0003a\u0001]\u00069A-\u0019;b\u001fV$\bCA8s\u001b\u0005\u0001(BA9d\u0003\tIw.\u0003\u0002ta\n\u0001B)\u0019;b\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\u0006k&\u0001\rA^\u0001\ba&\u001c7\u000e\\3s!\t9h0D\u0001y\u0015\tI(0\u0001\u0004qS\u000e\\G.\u001a\u0006\u0003wr\f\u0011B]1{_J4\u0018N\\3\u000b\u0003u\f1A\\3u\u0013\ty\bPA\u0004QS\u000e\\G.\u001a:\u0002#I,7-Z5wK\u001a\u0013x.\u001c)zi\"|g\u000eF\u0002\u001f\u0003\u000bAq!a\u0002\u000b\u0001\u0004\tI!\u0001\u0004eCR\f\u0017J\u001c\t\u0004_\u0006-\u0011bAA\u0007a\nyA)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fW\u000e")
public class UserDefinedPythonDataSourceRunner
extends PythonPlannerRunner<PythonDataSourceCreationResult> {
    private final PythonFunction dataSourceCls;
    private final String provider;
    private final Seq<String> paths;
    private final Option<StructType> userSpecifiedSchema;
    private final CaseInsensitiveMap<String> options;
    private final String workerModule;

    @Override
    public String workerModule() {
        return this.workerModule;
    }

    @Override
    public void writeToPython(DataOutputStream dataOut, Pickler pickler) {
        PythonWorkerUtils$.MODULE$.writePythonFunction(this.dataSourceCls, dataOut);
        PythonWorkerUtils$.MODULE$.writeUTF(this.provider, dataOut);
        dataOut.writeInt(this.paths.length());
        this.paths.foreach((Function1 & Serializable)x$1 -> {
            PythonWorkerUtils$.MODULE$.writeUTF(x$1, dataOut);
            return BoxedUnit.UNIT;
        });
        dataOut.writeBoolean(this.userSpecifiedSchema.isDefined());
        this.userSpecifiedSchema.map((Function1 & Serializable)x$2 -> x$2.json()).foreach((Function1 & Serializable)x$3 -> {
            PythonWorkerUtils$.MODULE$.writeUTF(x$3, dataOut);
            return BoxedUnit.UNIT;
        });
        dataOut.writeInt(this.options.size());
        this.options.iterator().foreach((Function1 & Serializable)x0$1 -> {
            UserDefinedPythonDataSourceRunner.$anonfun$writeToPython$4(dataOut, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public PythonDataSourceCreationResult receiveFromPython(DataInputStream dataIn) {
        DataType schema;
        int length = dataIn.readInt();
        if (length == SpecialLengths$.MODULE$.PYTHON_EXCEPTION_THROWN()) {
            String msg = PythonWorkerUtils$.MODULE$.readUTF(dataIn);
            throw QueryCompilationErrors$.MODULE$.failToPlanDataSourceError("create", "instance", msg);
        }
        byte[] pickledDataSourceInstance = PythonWorkerUtils$.MODULE$.readBytes(length, dataIn);
        int isDDLString = dataIn.readInt();
        String schemaStr = PythonWorkerUtils$.MODULE$.readUTF(dataIn);
        DataType dataType = schema = isDDLString == 1 ? DataType$.MODULE$.fromDDL(schemaStr) : DataType$.MODULE$.fromJson(schemaStr);
        if (!(schema instanceof StructType)) {
            throw QueryCompilationErrors$.MODULE$.schemaIsNotStructTypeError(schemaStr, schema);
        }
        return new PythonDataSourceCreationResult(pickledDataSourceInstance, (StructType)schema);
    }

    public static final /* synthetic */ void $anonfun$writeToPython$4(DataOutputStream dataOut$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            PythonWorkerUtils$.MODULE$.writeUTF(key, dataOut$1);
            PythonWorkerUtils$.MODULE$.writeUTF(value, dataOut$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public UserDefinedPythonDataSourceRunner(PythonFunction dataSourceCls, String provider, Seq<String> paths, Option<StructType> userSpecifiedSchema, CaseInsensitiveMap<String> options) {
        this.dataSourceCls = dataSourceCls;
        this.provider = provider;
        this.paths = paths;
        this.userSpecifiedSchema = userSpecifiedSchema;
        this.options = options;
        super(dataSourceCls);
        this.workerModule = "pyspark.sql.worker.create_data_source";
    }
}

