/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.FunctionCatalog;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalogCapability;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRDD$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.v2.jdbc.JDBCTable;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tea\u0001\u0002\u0012$\u0001QBQ!\u0015\u0001\u0005\u0002ICq!\u0016\u0001A\u0002\u0013%a\u000bC\u0004e\u0001\u0001\u0007I\u0011B3\t\r1\u0004\u0001\u0015)\u0003X\u0011%i\u0007\u00011AA\u0002\u0013%a\u000eC\u0005u\u0001\u0001\u0007\t\u0019!C\u0005k\"Iq\u000f\u0001a\u0001\u0002\u0003\u0006Ka\u001c\u0005\nq\u0002\u0001\r\u00111A\u0005\neD!b \u0001A\u0002\u0003\u0007I\u0011BA\u0001\u0011)\t)\u0001\u0001a\u0001\u0002\u0003\u0006KA\u001f\u0005\f\u0003\u000f\u0001\u0001\u0019!a\u0001\n\u0013\tI\u0001C\u0006\u0002\u001c\u0001\u0001\r\u00111A\u0005\n\u0005u\u0001bCA\u0011\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0017Aq!a\t\u0001\t\u0003\n)\u0003C\u0004\u0002(\u0001!\t%!\u000b\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0003bBA0\u0001\u0011\u0005\u0013\u0011\r\u0005\b\u0003K\u0002A\u0011IA4\u0011\u001d\t\t\b\u0001C!\u0003gBq!! \u0001\t\u0003\ny\bC\u0004\u00022\u0002!\t%a-\t\u000f\u0005\u001d\u0007\u0001\"\u0011\u0002J\"9\u0011Q\u001a\u0001\u0005B\u0005=\u0007bBAg\u0001\u0011\u0005\u00131\u001b\u0005\b\u0003/\u0004A\u0011IAm\u0011\u001d\ti\u000e\u0001C!\u0003?Dq!a:\u0001\t\u0003\nI\u000fC\u0004\u0002x\u0002!\t%!?\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004!9!q\u0001\u0001\u0005\n\t%\u0001b\u0002B\u0007\u0001\u0011\u0005#q\u0002\u0005\b\u0005'\u0001A\u0011\tB\u000b\u0005AQEIQ\"UC\ndWmQ1uC2|wM\u0003\u0002%K\u0005!!\u000e\u001a2d\u0015\t1s%\u0001\u0002we)\u0011\u0001&K\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002+W\u0005IQ\r_3dkRLwN\u001c\u0006\u0003Y5\n1a]9m\u0015\tqs&A\u0003ta\u0006\u00148N\u0003\u00021c\u00051\u0011\r]1dQ\u0016T\u0011AM\u0001\u0004_J<7\u0001A\n\u0007\u0001UjT\tS&\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014\u0001\u00027b]\u001eT\u0011AO\u0001\u0005U\u00064\u0018-\u0003\u0002=o\t1qJ\u00196fGR\u0004\"AP\"\u000e\u0003}R!\u0001Q!\u0002\u000f\r\fG/\u00197pO*\u0011!iK\u0001\nG>tg.Z2u_JL!\u0001R \u0003\u0019Q\u000b'\r\\3DCR\fGn\\4\u0011\u0005y2\u0015BA$@\u0005I\u0019V\u000f\u001d9peR\u001ch*Y7fgB\f7-Z:\u0011\u0005yJ\u0015B\u0001&@\u0005=1UO\\2uS>t7)\u0019;bY><\u0007C\u0001'P\u001b\u0005i%B\u0001(.\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001)N\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A*\u0011\u0005Q\u0003Q\"A\u0012\u0002\u0017\r\fG/\u00197pO:\u000bW.Z\u000b\u0002/B\u0011\u0001,\u0019\b\u00033~\u0003\"AW/\u000e\u0003mS!\u0001X\u001a\u0002\rq\u0012xn\u001c;?\u0015\u0005q\u0016!B:dC2\f\u0017B\u00011^\u0003\u0019\u0001&/\u001a3fM&\u0011!m\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001l\u0016aD2bi\u0006dwn\u001a(b[\u0016|F%Z9\u0015\u0005\u0019T\u0007CA4i\u001b\u0005i\u0016BA5^\u0005\u0011)f.\u001b;\t\u000f-\u001c\u0011\u0011!a\u0001/\u0006\u0019\u0001\u0010J\u0019\u0002\u0019\r\fG/\u00197pO:\u000bW.\u001a\u0011\u0002\u000f=\u0004H/[8ogV\tq\u000e\u0005\u0002qe6\t\u0011O\u0003\u0002%O%\u00111/\u001d\u0002\f\u0015\u0012\u00135i\u00149uS>t7/A\u0006paRLwN\\:`I\u0015\fHC\u00014w\u0011\u001dYg!!AA\u0002=\f\u0001b\u001c9uS>t7\u000fI\u0001\bI&\fG.Z2u+\u0005Q\bCA>~\u001b\u0005a(B\u0001\u0013,\u0013\tqHPA\u0006KI\n\u001cG)[1mK\u000e$\u0018a\u00033jC2,7\r^0%KF$2AZA\u0002\u0011\u001dY\u0017\"!AA\u0002i\f\u0001\u0002Z5bY\u0016\u001cG\u000fI\u0001\nMVt7\r^5p]N,\"!a\u0003\u0011\ra\u000biaVA\t\u0013\r\tya\u0019\u0002\u0004\u001b\u0006\u0004\b\u0003BA\n\u0003/i!!!\u0006\u000b\u0007\u0005\u001dq(\u0003\u0003\u0002\u001a\u0005U!aD+oE>,h\u000e\u001a$v]\u000e$\u0018n\u001c8\u0002\u001b\u0019,hn\u0019;j_:\u001cx\fJ3r)\r1\u0017q\u0004\u0005\tW2\t\t\u00111\u0001\u0002\f\u0005Qa-\u001e8di&|gn\u001d\u0011\u0002\t9\fW.\u001a\u000b\u0002/\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u000b\u0019\fY#!\f\t\r\u0005\rr\u00021\u0001X\u0011\u0019iw\u00021\u0001\u00020A!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026-\nA!\u001e;jY&!\u0011\u0011HA\u001a\u0005a\u0019\u0015m]3J]N,gn]5uSZ,7\u000b\u001e:j]\u001el\u0015\r]\u0001\u000bY&\u001cH\u000fV1cY\u0016\u001cH\u0003BA \u0003\u0017\u0002RaZA!\u0003\u000bJ1!a\u0011^\u0005\u0015\t%O]1z!\rq\u0014qI\u0005\u0004\u0003\u0013z$AC%eK:$\u0018NZ5fe\"9\u0011Q\n\tA\u0002\u0005=\u0013!\u00038b[\u0016\u001c\b/Y2f!\u00119\u0017\u0011I,\u0002\u0017Q\f'\r\\3Fq&\u001cHo\u001d\u000b\u0005\u0003+\nY\u0006E\u0002h\u0003/J1!!\u0017^\u0005\u001d\u0011un\u001c7fC:Dq!!\u0018\u0012\u0001\u0004\t)%A\u0003jI\u0016tG/A\u0005ee>\u0004H+\u00192mKR!\u0011QKA2\u0011\u001d\tiF\u0005a\u0001\u0003\u000b\n1B]3oC6,G+\u00192mKR)a-!\u001b\u0002n!9\u00111N\nA\u0002\u0005\u0015\u0013\u0001C8mI&#WM\u001c;\t\u000f\u0005=4\u00031\u0001\u0002F\u0005Aa.Z<JI\u0016tG/A\u0005m_\u0006$G+\u00192mKR!\u0011QOA>!\rq\u0014qO\u0005\u0004\u0003sz$!\u0002+bE2,\u0007bBA/)\u0001\u0007\u0011QI\u0001\fGJ,\u0017\r^3UC\ndW\r\u0006\u0006\u0002v\u0005\u0005\u00151QAJ\u0003KCq!!\u0018\u0016\u0001\u0004\t)\u0005C\u0004\u0002\u0006V\u0001\r!a\"\u0002\rM\u001c\u0007.Z7b!\u0011\tI)a$\u000e\u0005\u0005-%bAAGW\u0005)A/\u001f9fg&!\u0011\u0011SAF\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003++\u0002\u0019AAL\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0006O\u0006\u0005\u0013\u0011\u0014\t\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*\u0019\u0011qT!\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003G\u000biJA\u0005Ue\u0006t7OZ8s[\"9\u0011qU\u000bA\u0002\u0005%\u0016A\u00039s_B,'\u000f^5fgB1\u00111VAX/^k!!!,\u000b\u0007\u0005U\u0012(\u0003\u0003\u0002\u0010\u00055\u0016AC1mi\u0016\u0014H+\u00192mKR1\u0011QOA[\u0003oCq!!\u0018\u0017\u0001\u0004\t)\u0005C\u0004\u0002:Z\u0001\r!a/\u0002\u000f\rD\u0017M\\4fgB)q-!0\u0002B&\u0019\u0011qX/\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0002?\u0003\u0007L1!!2@\u0005-!\u0016M\u00197f\u0007\"\fgnZ3\u0002\u001f9\fW.Z:qC\u000e,W\t_5tiN$B!!\u0016\u0002L\"9\u0011QJ\fA\u0002\u0005=\u0013A\u00047jgRt\u0015-\\3ta\u0006\u001cWm\u001d\u000b\u0003\u0003#\u0004RaZA!\u0003\u001f\"B!!5\u0002V\"9\u0011QJ\rA\u0002\u0005=\u0013!\u00067pC\u0012t\u0015-\\3ta\u0006\u001cW-T3uC\u0012\fG/\u0019\u000b\u0005\u0003S\u000bY\u000eC\u0004\u0002Ni\u0001\r!a\u0014\u0002\u001f\r\u0014X-\u0019;f\u001d\u0006lWm\u001d9bG\u0016$RAZAq\u0003GDq!!\u0014\u001c\u0001\u0004\ty\u0005C\u0004\u0002fn\u0001\r!!+\u0002\u00115,G/\u00193bi\u0006\fa\"\u00197uKJt\u0015-\\3ta\u0006\u001cW\rF\u0003g\u0003W\fi\u000fC\u0004\u0002Nq\u0001\r!a\u0014\t\u000f\u0005eF\u00041\u0001\u0002pB)q-!0\u0002rB\u0019a(a=\n\u0007\u0005UxHA\bOC6,7\u000f]1dK\u000eC\u0017M\\4f\u00035!'o\u001c9OC6,7\u000f]1dKR1\u0011QKA~\u0003{Dq!!\u0014\u001e\u0001\u0004\ty\u0005C\u0004\u0002\u0000v\u0001\r!!\u0016\u0002\u000f\r\f7oY1eK\u0006q1\r[3dW:\u000bW.Z:qC\u000e,Gc\u00014\u0003\u0006!9\u0011Q\n\u0010A\u0002\u0005=\u0013\u0001D4fiR\u000b'\r\\3OC6,GcA,\u0003\f!9\u0011QL\u0010A\u0002\u0005\u0015\u0013!\u00047jgR4UO\\2uS>t7\u000f\u0006\u0003\u0002@\tE\u0001bBA'A\u0001\u0007\u0011qJ\u0001\rY>\fGMR;oGRLwN\u001c\u000b\u0005\u0003#\u00119\u0002C\u0004\u0002^\u0005\u0002\r!!\u0012")
public class JDBCTableCatalog
implements TableCatalog,
SupportsNamespaces,
FunctionCatalog,
Logging {
    private String catalogName;
    private JDBCOptions options;
    private JdbcDialect dialect;
    private scala.collection.immutable.Map<String, UnboundFunction> functions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean functionExists(Identifier x$1) {
        return super.functionExists(x$1);
    }

    public Set<TableCatalogCapability> capabilities() {
        return super.capabilities();
    }

    public Table loadTable(Identifier x$1, String x$2) throws NoSuchTableException {
        return super.loadTable(x$1, x$2);
    }

    public Table loadTable(Identifier x$1, long x$2) throws NoSuchTableException {
        return super.loadTable(x$1, x$2);
    }

    public void invalidateTable(Identifier x$1) {
        super.invalidateTable(x$1);
    }

    public Table createTable(Identifier x$1, Column[] x$2, Transform[] x$3, Map<String, String> x$4) throws TableAlreadyExistsException, NoSuchNamespaceException {
        return super.createTable(x$1, x$2, x$3, x$4);
    }

    public boolean useNullableQuerySchema() {
        return super.useNullableQuerySchema();
    }

    public boolean purgeTable(Identifier x$1) throws UnsupportedOperationException {
        return super.purgeTable(x$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String catalogName() {
        return this.catalogName;
    }

    private void catalogName_$eq(String x$1) {
        this.catalogName = x$1;
    }

    private JDBCOptions options() {
        return this.options;
    }

    private void options_$eq(JDBCOptions x$1) {
        this.options = x$1;
    }

    private JdbcDialect dialect() {
        return this.dialect;
    }

    private void dialect_$eq(JdbcDialect x$1) {
        this.dialect = x$1;
    }

    private scala.collection.immutable.Map<String, UnboundFunction> functions() {
        return this.functions;
    }

    private void functions_$eq(scala.collection.immutable.Map<String, UnboundFunction> x$1) {
        this.functions = x$1;
    }

    public String name() {
        Predef$.MODULE$.require(this.catalogName() != null, (Function0 & Serializable)() -> "The JDBC table catalog is not initialed");
        return this.catalogName();
    }

    public void initialize(String name, CaseInsensitiveStringMap options) {
        Predef$.MODULE$.assert(this.catalogName() == null, (Function0 & Serializable)() -> "The JDBC table catalog is already initialed");
        this.catalogName_$eq(name);
        scala.collection.immutable.Map map = CollectionConverters$.MODULE$.MapHasAsScala(options.asCaseSensitiveMap()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.options_$eq(new JDBCOptions((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)"__invalid_dbtable")))));
        this.dialect_$eq(JdbcDialects$.MODULE$.get(this.options().url()));
        this.functions_$eq((scala.collection.immutable.Map<String, UnboundFunction>)this.dialect().functions().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public Identifier[] listTables(String[] namespace) {
        this.checkNamespace(namespace);
        return (Identifier[])JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable)conn -> {
            String schemaPattern = namespace.length == 1 ? (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])namespace)) : null;
            ResultSet rs = conn.getMetaData().getTables(null, schemaPattern, "%", (String[])((Object[])new String[]{"TABLE"}));
            return (Identifier[])new Iterator<Identifier>(null, rs, namespace){
                private final ResultSet rs$1;
                private final String[] namespace$1;

                public final boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public final Iterator<Identifier> iterator() {
                    return Iterator.iterator$((Iterator)this);
                }

                public Option<Identifier> nextOption() {
                    return Iterator.nextOption$((Iterator)this);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public BufferedIterator<Identifier> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator<B> padTo(int len, B elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Tuple2<Iterator<Identifier>, Iterator<Identifier>> partition(Function1<Identifier, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, Identifier, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<Identifier, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public int indexWhere(Function1<Identifier, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public int indexWhere$default$2() {
                    return Iterator.indexWhere$default$2$((Iterator)this);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public final int length() {
                    return Iterator.length$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public Iterator<Identifier> filter(Function1<Identifier, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public Iterator<Identifier> filterNot(Function1<Identifier, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public Iterator<Identifier> filterImpl(Function1<Identifier, Object> p, boolean isFlipped) {
                    return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
                }

                public Iterator<Identifier> withFilter(Function1<Identifier, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<Identifier, B> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public Iterator<Identifier> distinct() {
                    return Iterator.distinct$((Iterator)this);
                }

                public <B> Iterator<Identifier> distinctBy(Function1<Identifier, B> f) {
                    return Iterator.distinctBy$((Iterator)this, f);
                }

                public <B> Iterator<B> map(Function1<Identifier, B> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B> Iterator<B> flatMap(Function1<Identifier, IterableOnce<B>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public <B> Iterator<B> flatten(Function1<Identifier, IterableOnce<B>> ev) {
                    return Iterator.flatten$((Iterator)this, ev);
                }

                public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                    return Iterator.concat$((Iterator)this, xs);
                }

                public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                    return Iterator.$plus$plus$((Iterator)this, xs);
                }

                public Iterator<Identifier> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<Identifier> takeWhile(Function1<Identifier, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Iterator<Identifier> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<Identifier> dropWhile(Function1<Identifier, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<Identifier>, Iterator<Identifier>> span(Function1<Identifier, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<Identifier> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<Identifier> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<Tuple2<Identifier, B>> zip(IterableOnce<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public Iterator<Tuple2<Identifier, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B> boolean sameElements(IterableOnce<B> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Tuple2<Iterator<Identifier>, Iterator<Identifier>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <U$> Iterator<Identifier> tapEach(Function1<Identifier, U$> f) {
                    return Iterator.tapEach$((Iterator)this, f);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public Iterator<Identifier> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public Tuple2<Iterator<Identifier>, Iterator<Identifier>> splitAt(int n) {
                    return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
                }

                public boolean isTraversableAgain() {
                    return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
                }

                public <U$> void foreach(Function1<Identifier, U$> f) {
                    IterableOnceOps.foreach$((IterableOnceOps)this, f);
                }

                public boolean forall(Function1<Identifier, Object> p) {
                    return IterableOnceOps.forall$((IterableOnceOps)this, p);
                }

                public boolean exists(Function1<Identifier, Object> p) {
                    return IterableOnceOps.exists$((IterableOnceOps)this, p);
                }

                public int count(Function1<Identifier, Object> p) {
                    return IterableOnceOps.count$((IterableOnceOps)this, p);
                }

                public Option<Identifier> find(Function1<Identifier, Object> p) {
                    return IterableOnceOps.find$((IterableOnceOps)this, p);
                }

                public <B> B foldLeft(B z, Function2<B, Identifier, B> op) {
                    return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
                }

                public <B> B foldRight(B z, Function2<Identifier, B, B> op) {
                    return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
                }

                public final <B> B $div$colon(B z, Function2<B, Identifier, B> op) {
                    return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
                }

                public final <B> B $colon$bslash(B z, Function2<Identifier, B, B> op) {
                    return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
                }

                public <B> B reduce(Function2<B, B, B> op) {
                    return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                    return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
                }

                public <B> B reduceLeft(Function2<B, Identifier, B> op) {
                    return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
                }

                public <B> B reduceRight(Function2<Identifier, B, B> op) {
                    return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, Identifier, B> op) {
                    return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<Identifier, B, B> op) {
                    return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
                }

                public boolean nonEmpty() {
                    return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
                }

                public int size() {
                    return IterableOnceOps.size$((IterableOnceOps)this);
                }

                public final <B> void copyToBuffer(Buffer<B> dest) {
                    IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
                }

                public <B> int copyToArray(Object xs) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
                }

                public <B> int copyToArray(Object xs, int start) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
                }

                public <B> int copyToArray(Object xs, int start, int len) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
                }

                public Object min(Ordering ord) {
                    return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
                }

                public <B> Option<Identifier> minOption(Ordering<B> ord) {
                    return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
                }

                public Object max(Ordering ord) {
                    return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
                }

                public <B> Option<Identifier> maxOption(Ordering<B> ord) {
                    return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
                }

                public Object maxBy(Function1 f, Ordering ord) {
                    return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
                }

                public <B> Option<Identifier> maxByOption(Function1<Identifier, B> f, Ordering<B> ord) {
                    return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
                }

                public Object minBy(Function1 f, Ordering ord) {
                    return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
                }

                public <B> Option<Identifier> minByOption(Function1<Identifier, B> f, Ordering<B> ord) {
                    return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
                }

                public <B> Option<B> collectFirst(PartialFunction<Identifier, B> pf) {
                    return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, Identifier, B> seqop, Function2<B, B, B> combop) {
                    return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
                }

                public <B> boolean corresponds(IterableOnce<B> that, Function2<Identifier, B, Object> p) {
                    return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
                }

                public final String mkString(String start, String sep, String end) {
                    return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
                }

                public final String mkString(String sep) {
                    return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
                }

                public final String mkString() {
                    return IterableOnceOps.mkString$((IterableOnceOps)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public final StringBuilder addString(StringBuilder b, String sep) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
                }

                public final StringBuilder addString(StringBuilder b) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
                }

                public <C1> C1 to(Factory<Identifier, C1> factory) {
                    return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
                }

                public final Iterator<Identifier> toIterator() {
                    return IterableOnceOps.toIterator$((IterableOnceOps)this);
                }

                public List<Identifier> toList() {
                    return IterableOnceOps.toList$((IterableOnceOps)this);
                }

                public Vector<Identifier> toVector() {
                    return IterableOnceOps.toVector$((IterableOnceOps)this);
                }

                public <K, V> scala.collection.immutable.Map<K, V> toMap(.less.colon.less<Identifier, Tuple2<K, V>> ev) {
                    return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
                }

                public <B> scala.collection.immutable.Set<B> toSet() {
                    return IterableOnceOps.toSet$((IterableOnceOps)this);
                }

                public Seq<Identifier> toSeq() {
                    return IterableOnceOps.toSeq$((IterableOnceOps)this);
                }

                public IndexedSeq<Identifier> toIndexedSeq() {
                    return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
                }

                public final Stream<Identifier> toStream() {
                    return IterableOnceOps.toStream$((IterableOnceOps)this);
                }

                public final <B> Buffer<B> toBuffer() {
                    return IterableOnceOps.toBuffer$((IterableOnceOps)this);
                }

                public <B> Object toArray(ClassTag<B> evidence$2) {
                    return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
                }

                public Iterable<Identifier> reversed() {
                    return IterableOnceOps.reversed$((IterableOnceOps)this);
                }

                public <S extends Stepper<?>> S stepper(StepperShape<Identifier, S> shape) {
                    return (S)IterableOnce.stepper$((IterableOnce)this, shape);
                }

                public int knownSize() {
                    return IterableOnce.knownSize$((IterableOnce)this);
                }

                public boolean hasNext() {
                    return this.rs$1.next();
                }

                public Identifier next() {
                    return Identifier.of((String[])this.namespace$1, (String)this.rs$1.getString("TABLE_NAME"));
                }
                {
                    this.rs$1 = rs$1;
                    this.namespace$1 = namespace$1;
                    IterableOnce.$init$((IterableOnce)this);
                    IterableOnceOps.$init$((IterableOnceOps)this);
                    Iterator.$init$((Iterator)this);
                }
            }.toArray(ClassTag$.MODULE$.apply(Identifier.class));
        });
    }

    public boolean tableExists(Identifier ident) {
        this.checkNamespace(ident.namespace());
        JdbcOptionsInWrite writeOptions = new JdbcOptionsInWrite((CaseInsensitiveMap<String>)this.options().parameters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)this.getTableName(ident))));
        return BoxesRunTime.unboxToBoolean(JdbcUtils$.MODULE$.classifyException("Failed table existence check: " + ident, this.dialect(), (JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean(JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)JdbcUtils$.MODULE$.tableExists(x$4, writeOptions))))));
    }

    public boolean dropTable(Identifier ident) {
        this.checkNamespace(ident.namespace());
        return BoxesRunTime.unboxToBoolean(JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JDBCTableCatalog.$anonfun$dropTable$1(this, ident, conn))));
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) {
        this.checkNamespace(oldIdent.namespace());
        JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable)conn -> {
            JdbcUtils$.MODULE$.classifyException("Failed table renaming from " + oldIdent + " to " + newIdent, this.dialect(), (JFunction0.mcV.sp & Serializable)() -> JdbcUtils$.MODULE$.renameTable(conn, oldIdent, newIdent, this.options()));
            return BoxedUnit.UNIT;
        });
    }

    public Table loadTable(Identifier ident) {
        JDBCTable jDBCTable;
        this.checkNamespace(ident.namespace());
        JDBCOptions optionsWithTableName = new JDBCOptions((CaseInsensitiveMap<String>)this.options().parameters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)this.getTableName(ident))));
        try {
            StructType schema = JDBCRDD$.MODULE$.resolveTable(optionsWithTableName);
            jDBCTable = new JDBCTable(ident, schema, optionsWithTableName);
        }
        catch (SQLException sQLException) {
            throw QueryCompilationErrors$.MODULE$.noSuchTableError(ident);
        }
        return jDBCTable;
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) {
        this.checkNamespace(ident.namespace());
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])partitions))) {
            throw QueryExecutionErrors$.MODULE$.cannotCreateJDBCTableWithPartitionsError();
        }
        CaseInsensitiveMap tableOptions = this.options().parameters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)this.getTableName(ident)));
        ObjectRef tableComment = ObjectRef.create((Object)"");
        ObjectRef tableProperties = ObjectRef.create((Object)"");
        if (!properties.isEmpty()) {
            CollectionConverters$.MODULE$.MapHasAsScala(properties).asScala().foreach((Function1 & Serializable)x0$1 -> {
                JDBCTableCatalog.$anonfun$createTable$1(tableComment, tableProperties, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        String string = (String)tableComment.elem;
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            tableOptions = tableOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_COMMENT()), (Object)((String)tableComment.elem)));
        }
        String string3 = (String)tableProperties.elem;
        String string4 = "";
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            tableOptions = tableOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_CREATE_TABLE_OPTIONS()), (Object)((String)tableProperties.elem)));
        }
        JdbcOptionsInWrite writeOptions = new JdbcOptionsInWrite((CaseInsensitiveMap<String>)tableOptions);
        boolean caseSensitive = SQLConf$.MODULE$.get().caseSensitiveAnalysis();
        JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable)conn -> {
            JdbcUtils$.MODULE$.classifyException("Failed table creation: " + ident, this.dialect(), (JFunction0.mcV.sp & Serializable)() -> JdbcUtils$.MODULE$.createTable(conn, this.getTableName(ident), schema, caseSensitive, writeOptions));
            return BoxedUnit.UNIT;
        });
        return new JDBCTable(ident, schema, writeOptions);
    }

    public Table alterTable(Identifier ident, Seq<TableChange> changes) {
        this.checkNamespace(ident.namespace());
        return (Table)JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable)conn -> {
            JdbcUtils$.MODULE$.classifyException("Failed table altering: " + ident, this.dialect(), (JFunction0.mcV.sp & Serializable)() -> JdbcUtils$.MODULE$.alterTable((Connection)conn, this.getTableName(ident), changes, this.options()));
            return this.loadTable(ident);
        });
    }

    public boolean namespaceExists(String[] namespace) {
        Object object;
        String[] stringArray = namespace;
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
            String db = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            return BoxesRunTime.unboxToBoolean(JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JdbcUtils$.MODULE$.schemaExists(conn, this.options(), db))));
        }
        return false;
    }

    public String[][] listNamespaces() {
        return (String[][])JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable)conn -> JdbcUtils$.MODULE$.listSchemas((Connection)conn, this.options()));
    }

    public String[][] listNamespaces(String[] namespace) {
        Object object;
        Object object2;
        String[] stringArray = namespace;
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0) == 0) {
            return this.listNamespaces();
        }
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0 && this.namespaceExists(namespace)) {
            return (String[][])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        }
        throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) {
        Object object;
        String[] stringArray = namespace;
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
            String db = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            if (!this.namespaceExists(namespace)) {
                throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError((String[])((Object[])new String[]{db}));
            }
            return CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava();
        }
        throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) {
        Object object;
        Object object2;
        String[] stringArray = namespace;
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1) == 0) {
            String db = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
            if (!this.namespaceExists(namespace)) {
                ObjectRef comment = ObjectRef.create((Object)"");
                if (!metadata.isEmpty()) {
                    CollectionConverters$.MODULE$.MapHasAsScala(metadata).asScala().foreach((Function1 & Serializable)x0$1 -> {
                        JDBCTableCatalog.$anonfun$createNamespace$1(comment, x0$1);
                        return BoxedUnit.UNIT;
                    });
                }
                BoxedUnit cfr_ignored_0 = (BoxedUnit)JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable)conn -> {
                    JdbcUtils$.MODULE$.classifyException("Failed create name space: " + db, this.dialect(), (JFunction0.mcV.sp & Serializable)() -> JdbcUtils$.MODULE$.createSchema(conn, this.options(), db, (String)comment$1.elem));
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
            throw QueryCompilationErrors$.MODULE$.namespaceAlreadyExistsError(namespace);
        }
        throw QueryExecutionErrors$.MODULE$.invalidNamespaceNameError(namespace);
    }

    public void alterNamespace(String[] namespace, Seq<NamespaceChange> changes) {
        Object object;
        String[] stringArray = namespace;
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
            String db = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            changes.foreach((Function1 & Serializable)x0$1 -> {
                JDBCTableCatalog.$anonfun$alterNamespace$1(this, db, changes, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) {
        Object object;
        String[] stringArray = namespace;
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
            String db = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            if (this.namespaceExists(namespace)) {
                return BoxesRunTime.unboxToBoolean(JdbcUtils$.MODULE$.withConnection(this.options(), (Function1 & Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JDBCTableCatalog.$anonfun$dropNamespace$1(this, db, cascade, conn))));
            }
        }
        throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
    }

    private void checkNamespace(String[] namespace) {
        if (namespace.length > 1) {
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        }
    }

    private String getTableName(Identifier ident) {
        JdbcDialect jdbcDialect = this.dialect();
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)ident.name(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)colName -> jdbcDialect.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    public Identifier[] listFunctions(String[] namespace) {
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])namespace))) {
            return (Identifier[])((IterableOnceOps)this.functions().keys().map((Function1 & Serializable)x$5 -> Identifier.of((String[])namespace, (String)x$5))).toArray(ClassTag$.MODULE$.apply(Identifier.class));
        }
        return (Identifier[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Identifier.class));
    }

    public UnboundFunction loadFunction(Identifier ident) {
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()))) {
            throw QueryCompilationErrors$.MODULE$.noSuchFunctionError(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asFunctionIdentifier());
        }
        Option option = this.functions().get((Object)ident.name());
        if (option instanceof Some) {
            Some some = (Some)option;
            UnboundFunction func = (UnboundFunction)some.value();
            return func;
        }
        throw new NoSuchFunctionException(ident);
    }

    public void alterNamespace(String[] namespace, NamespaceChange[] changes) {
        this.alterNamespace(namespace, (Seq<NamespaceChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])changes));
    }

    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])changes));
    }

    public static final /* synthetic */ boolean $anonfun$dropTable$1(JDBCTableCatalog $this, Identifier ident$1, Connection conn) {
        boolean bl;
        try {
            JdbcUtils$.MODULE$.dropTable(conn, $this.getTableName(ident$1), $this.options());
            bl = true;
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$createTable$1(ObjectRef tableComment$1, ObjectRef tableProperties$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = k;
            switch (string == null ? 0 : string.hashCode()) {
                case -987494927: {
                    if (!"provider".equals(string)) break;
                    throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCTableUsingProviderError();
                }
                case 106164915: {
                    if (!"owner".equals(string)) break;
                    return;
                }
                case 950398559: {
                    if (!"comment".equals(string)) break;
                    tableComment$1.elem = v;
                    return;
                }
                case 1901043637: {
                    if (!"location".equals(string)) break;
                    throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCTableUsingLocationError();
                }
            }
            tableProperties$1.elem = (String)tableProperties$1.elem + " " + k + " " + v;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$createNamespace$1(ObjectRef comment$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = k;
            switch (string == null ? 0 : string.hashCode()) {
                case 106164915: {
                    if (!"owner".equals(string)) break;
                    return;
                }
                case 950398559: {
                    if (!"comment".equals(string)) break;
                    comment$1.elem = v;
                    return;
                }
                case 1901043637: {
                    if (!"location".equals(string)) break;
                    throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCNamespaceUsingProviderError();
                }
            }
            throw QueryCompilationErrors$.MODULE$.cannotCreateJDBCNamespaceWithPropertyError(k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$alterNamespace$1(JDBCTableCatalog $this, String db$3, Seq changes$2, NamespaceChange x0$1) {
        NamespaceChange namespaceChange = x0$1;
        if (namespaceChange instanceof NamespaceChange.SetProperty) {
            NamespaceChange.SetProperty setProperty = (NamespaceChange.SetProperty)namespaceChange;
            String string = setProperty.property();
            String string2 = "comment";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)JdbcUtils$.MODULE$.withConnection($this.options(), (Function1 & Serializable)conn -> {
                    JdbcUtils$.MODULE$.classifyException("Failed create comment on name space: " + db$3, $this.dialect(), (JFunction0.mcV.sp & Serializable)() -> JdbcUtils$.MODULE$.alterSchemaComment(conn, $this.options(), db$3, setProperty.value()));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw QueryCompilationErrors$.MODULE$.cannotSetJDBCNamespaceWithPropertyError(setProperty.property());
        }
        if (namespaceChange instanceof NamespaceChange.RemoveProperty) {
            NamespaceChange.RemoveProperty removeProperty = (NamespaceChange.RemoveProperty)namespaceChange;
            String string = removeProperty.property();
            String string3 = "comment";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)JdbcUtils$.MODULE$.withConnection($this.options(), (Function1 & Serializable)conn -> {
                    JdbcUtils$.MODULE$.classifyException("Failed remove comment on name space: " + db$3, $this.dialect(), (JFunction0.mcV.sp & Serializable)() -> JdbcUtils$.MODULE$.removeSchemaComment(conn, $this.options(), db$3));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw QueryCompilationErrors$.MODULE$.cannotUnsetJDBCNamespaceWithPropertyError(removeProperty.property());
        }
        throw QueryCompilationErrors$.MODULE$.unsupportedJDBCNamespaceChangeInCatalogError(changes$2);
    }

    public static final /* synthetic */ boolean $anonfun$dropNamespace$1(JDBCTableCatalog $this, String db$4, boolean cascade$1, Connection conn) {
        return BoxesRunTime.unboxToBoolean(JdbcUtils$.MODULE$.classifyException("Failed drop name space: " + db$4, $this.dialect(), (JFunction0.mcZ.sp & Serializable)() -> {
            JdbcUtils$.MODULE$.dropSchema(conn, $this.options(), db$4, cascade$1);
            return true;
        }));
    }

    public JDBCTableCatalog() {
        Logging.$init$((Logging)this);
        this.catalogName = null;
    }
}

