/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.OutputCommitCoordinator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.v2.DataWritingSparkTaskResult;
import org.apache.spark.sql.execution.metric.CustomMetrics$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005q4q\u0001B\u0003\u0011\u0002\u0007\u0005A\u0003C\u0003/\u0001\u0011\u0005q\u0006C\u00034\u0001\u0019EA\u0007C\u0003O\u0001\u0011\u0005qJ\u0001\tXe&$\u0018N\\4Ta\u0006\u00148\u000eV1tW*\u0011aaB\u0001\u0003mJR!\u0001C\u0005\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u0015-\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u00051i\u0011aA:rY*\u0011abD\u0001\u0006gB\f'o\u001b\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005UI4\u0003\u0002\u0001\u00179\t\u0002\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u000e\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0011\u001f\u0005\u001daunZ4j]\u001e\u0004\"aI\u0016\u000f\u0005\u0011JcBA\u0013)\u001b\u00051#BA\u0014\u0014\u0003\u0019a$o\\8u}%\t\u0011$\u0003\u0002+1\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u0017.\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tQ\u0003$\u0001\u0004%S:LG\u000f\n\u000b\u0002aA\u0011q#M\u0005\u0003ea\u0011A!\u00168ji\u0006)qO]5uKR\u0019\u0001'\u000e'\t\u000bY\u0012\u0001\u0019A\u001c\u0002\r]\u0014\u0018\u000e^3s!\tA\u0014\b\u0004\u0001\u0005\u000bi\u0002!\u0019A\u001e\u0003\u0003]\u000b\"\u0001P \u0011\u0005]i\u0014B\u0001 \u0019\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001\u0011#G\u001b\u0005\t%BA\u001aC\u0015\t\u00195\"A\u0005d_:tWm\u0019;pe&\u0011Q)\u0011\u0002\u000b\t\u0006$\u0018m\u0016:ji\u0016\u0014\bCA$K\u001b\u0005A%BA%\f\u0003!\u0019\u0017\r^1msN$\u0018BA&I\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000b5\u0013\u0001\u0019\u0001$\u0002\u0007I|w/A\u0002sk:$b\u0001\u0015+Z?\u0012L\u0007CA)S\u001b\u0005)\u0011BA*\u0006\u0005i!\u0015\r^1Xe&$\u0018N\\4Ta\u0006\u00148\u000eV1tWJ+7/\u001e7u\u0011\u0015)6\u00011\u0001W\u000359(/\u001b;fe\u001a\u000b7\r^8ssB\u0011\u0001iV\u0005\u00031\u0006\u0013\u0011\u0003R1uC^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z\u0011\u0015Q6\u00011\u0001\\\u0003\u001d\u0019wN\u001c;fqR\u0004\"\u0001X/\u000e\u00035I!AX\u0007\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010\u001e\u0005\u0006A\u000e\u0001\r!Y\u0001\u0005SR,'\u000fE\u0002$E\u001aK!aY\u0017\u0003\u0011%#XM]1u_JDQ!Z\u0002A\u0002\u0019\fA#^:f\u0007>lW.\u001b;D_>\u0014H-\u001b8bi>\u0014\bCA\fh\u0013\tA\u0007DA\u0004C_>dW-\u00198\t\u000b)\u001c\u0001\u0019A6\u0002\u001b\r,8\u000f^8n\u001b\u0016$(/[2t!\u0011a\u0007o\u001d<\u000f\u00055t\u0007CA\u0013\u0019\u0013\ty\u0007$\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u00141!T1q\u0015\ty\u0007\u0004\u0005\u0002mi&\u0011QO\u001d\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005]TX\"\u0001=\u000b\u0005eL\u0011AB7fiJL7-\u0003\u0002|q\nI1+\u0015'NKR\u0014\u0018n\u0019")
public interface WritingSparkTask<W extends DataWriter<InternalRow>>
extends Logging,
Serializable {
    public void write(W var1, InternalRow var2);

    public static /* synthetic */ DataWritingSparkTaskResult run$(WritingSparkTask $this, DataWriterFactory writerFactory, TaskContext context, Iterator iter, boolean useCommitCoordinator, Map customMetrics) {
        return $this.run(writerFactory, context, (Iterator<InternalRow>)iter, useCommitCoordinator, (Map<String, SQLMetric>)customMetrics);
    }

    default public DataWritingSparkTaskResult run(DataWriterFactory writerFactory, TaskContext context, Iterator<InternalRow> iter, boolean useCommitCoordinator, Map<String, SQLMetric> customMetrics) {
        int stageId = context.stageId();
        int stageAttempt = context.stageAttemptNumber();
        int partId = context.partitionId();
        long taskId = context.taskAttemptId();
        int attemptId = context.attemptNumber();
        DataWriter dataWriter = writerFactory.createWriter(partId, taskId);
        LongRef count = LongRef.create((long)0L);
        return (DataWritingSparkTaskResult)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0 & Serializable)() -> {
            WriterCommitMessage writerCommitMessage;
            while (iter.hasNext()) {
                if (count$1.elem % (long)CustomMetrics$.MODULE$.NUM_ROWS_PER_UPDATE() == 0L) {
                    CustomMetrics$.MODULE$.updateMetrics((Seq<CustomTaskMetric>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)dataWriter.currentMetricsValues()), customMetrics);
                }
                ++count$1.elem;
                this.write(dataWriter, (InternalRow)iter.next());
            }
            CustomMetrics$.MODULE$.updateMetrics((Seq<CustomTaskMetric>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)dataWriter.currentMetricsValues()), customMetrics);
            if (useCommitCoordinator) {
                OutputCommitCoordinator coordinator = SparkEnv$.MODULE$.get().outputCommitCoordinator();
                boolean commitAuthorized = coordinator.canCommit(stageId, stageAttempt, partId, attemptId);
                if (!commitAuthorized) {
                    Throwable commitDeniedException = QueryExecutionErrors$.MODULE$.commitDeniedError(partId, taskId, attemptId, stageId, stageAttempt);
                    this.logInfo((Function0 & Serializable)() -> commitDeniedException.getMessage());
                    throw commitDeniedException;
                }
                this.logInfo((Function0 & Serializable)() -> "Commit authorized for partition " + partId + " (task " + taskId + ", attempt " + attemptId + ", stage " + stageId + "." + stageAttempt + ")");
                writerCommitMessage = dataWriter.commit();
            } else {
                this.logInfo((Function0 & Serializable)() -> "Writer for partition " + context.partitionId() + " is committing.");
                writerCommitMessage = dataWriter.commit();
            }
            WriterCommitMessage msg = writerCommitMessage;
            this.logInfo((Function0 & Serializable)() -> "Committed partition " + partId + " (task " + taskId + ", attempt " + attemptId + ", stage " + stageId + "." + stageAttempt + ")");
            return new DataWritingSparkTaskResult(count$1.elem, msg);
        }, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.logError((Function0 & Serializable)() -> "Aborting commit for partition " + partId + " (task " + taskId + ", attempt " + attemptId + ", stage " + stageId + "." + stageAttempt + ")");
            dataWriter.abort();
            this.logError((Function0 & Serializable)() -> "Aborted commit for partition " + partId + " (task " + taskId + ", attempt " + attemptId + ", stage " + stageId + "." + stageAttempt + ")");
        }, (Function0)(JFunction0.mcV.sp & Serializable)() -> dataWriter.close());
    }

    public static void $init$(WritingSparkTask $this) {
    }
}

