/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001\u0002\t\u0012\u0001\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A1\b\u0001B\u0001B\u0003%\u0001\u0006C\u0003=\u0001\u0011\u0005Q\bC\u0003=\u0001\u0011\u00051\tC\u0003=\u0001\u0011\u0005\u0011\nC\u0003S\u0001\u0011\u00051\u000bC\u0003d\u0001\u0011\u0005A\rC\u0003d\u0001\u0011%QnB\u0004y#\u0005\u0005\t\u0012A=\u0007\u000fA\t\u0012\u0011!E\u0001u\")Ah\u0003C\u0001w\"9ApCI\u0001\n\u0003i\b\"CA\t\u0017E\u0005I\u0011AA\n\u0011!\t9bCI\u0001\n\u0003i(!H*qCJ\\Gk\u001c)beF,X\r^*dQ\u0016l\u0017mQ8om\u0016\u0014H/\u001a:\u000b\u0005I\u0019\u0012a\u00029beF,X\r\u001e\u0006\u0003)U\t1\u0002Z1uCN|WO]2fg*\u0011acF\u0001\nKb,7-\u001e;j_:T!\u0001G\r\u0002\u0007M\fHN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g\u0003a9(/\u001b;f\u0019\u0016<\u0017mY=QCJ\fX/\u001a;G_Jl\u0017\r\u001e\t\u0003E%J!AK\u0012\u0003\u000f\t{w\u000e\\3b]\u0006\u0019r.\u001e;qkR$\u0016.\\3ti\u0006l\u0007\u000fV=qKB\u0011Qf\u000e\b\u0003]Qr!a\f\u001a\u000e\u0003AR!!M\f\u0002\u0011%tG/\u001a:oC2L!a\r\u0019\u0002\u000fM\u000bFjQ8oM&\u0011QGN\u0001\u001b!\u0006\u0014\u0018/^3u\u001fV$\b/\u001e;US6,7\u000f^1naRK\b/\u001a\u0006\u0003gAJ!\u0001O\u001d\u0003\u000bY\u000bG.^3\n\u0005i\u001a#aC#ok6,'/\u0019;j_:\f!\"^:f\r&,G\u000eZ%e\u0003\u0019a\u0014N\\5u}Q!a\bQ!C!\ty\u0004!D\u0001\u0012\u0011\u001d9C\u0001%AA\u0002!Bqa\u000b\u0003\u0011\u0002\u0003\u0007A\u0006C\u0004<\tA\u0005\t\u0019\u0001\u0015\u0015\u0005y\"\u0005\"B#\u0006\u0001\u00041\u0015\u0001B2p]\u001a\u0004\"aL$\n\u0005!\u0003$aB*R\u0019\u000e{gN\u001a\u000b\u0003})CQ!\u0012\u0004A\u0002-\u0003\"\u0001\u0014)\u000e\u00035S!!\u0012(\u000b\u0005=[\u0012A\u00025bI>|\u0007/\u0003\u0002R\u001b\ni1i\u001c8gS\u001e,(/\u0019;j_:\fqaY8om\u0016\u0014H\u000f\u0006\u0002U7B\u0011Q+W\u0007\u0002-*\u0011q\u000bW\u0001\u0007g\u000eDW-\\1\u000b\u0005IY\u0012B\u0001.W\u0005-iUm]:bO\u0016$\u0016\u0010]3\t\u000bq;\u0001\u0019A/\u0002\u001d\r\fG/\u00197zgR\u001c6\r[3nCB\u0011a,Y\u0007\u0002?*\u0011\u0001mF\u0001\u0006if\u0004Xm]\u0005\u0003E~\u0013!b\u0015;sk\u000e$H+\u001f9f\u00031\u0019wN\u001c<feR4\u0015.\u001a7e)\t)\u0007\u000e\u0005\u0002VM&\u0011qM\u0016\u0002\u0005)f\u0004X\rC\u0003j\u0011\u0001\u0007!.A\u0003gS\u0016dG\r\u0005\u0002_W&\u0011An\u0018\u0002\f'R\u0014Xo\u0019;GS\u0016dG\rF\u0002f]>DQ![\u0005A\u0002)DQ\u0001]\u0005A\u0002E\f!B]3qKRLG/[8o!\t\u0011XO\u0004\u0002Vg&\u0011AOV\u0001\u0005)f\u0004X-\u0003\u0002wo\nQ!+\u001a9fi&$\u0018n\u001c8\u000b\u0005Q4\u0016!H*qCJ\\Gk\u001c)beF,X\r^*dQ\u0016l\u0017mQ8om\u0016\u0014H/\u001a:\u0011\u0005}Z1CA\u0006\")\u0005I\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'F\u0001\u007fU\tAsp\u000b\u0002\u0002\u0002A!\u00111AA\u0007\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011!C;oG\",7m[3e\u0015\r\tYaI\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\b\u0003\u000b\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0003\u0016\u0003Y}\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004")
public class SparkToParquetSchemaConverter {
    private final boolean writeLegacyParquetFormat;
    private final Enumeration.Value outputTimestampType;
    private final boolean useFieldId;

    public static boolean $lessinit$greater$default$3() {
        return SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public static Enumeration.Value $lessinit$greater$default$2() {
        return SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public MessageType convert(StructType catalystSchema) {
        return (MessageType)Types.buildMessage().addFields((Type[])((IterableOnceOps)catalystSchema.map((Function1 & Serializable)field -> this.convertField((StructField)field))).toArray(ClassTag$.MODULE$.apply(Type.class))).named(ParquetSchemaConverter$.MODULE$.SPARK_PARQUET_SCHEMA_NAME());
    }

    public Type convertField(StructField field) {
        Type converted = this.convertField(field, field.nullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED);
        if (this.useFieldId && ParquetUtils$.MODULE$.hasFieldId(field)) {
            return converted.withId(ParquetUtils$.MODULE$.getFieldId(field));
        }
        return converted;
    }

    private Type convertField(StructField field2, Type.Repetition repetition) {
        Option option;
        Option option2;
        Option option3;
        boolean bl = false;
        DecimalType decimalType = null;
        boolean bl2 = false;
        ArrayType arrayType = null;
        boolean bl3 = false;
        MapType mapType = null;
        DataType dataType = field2.dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(field2.name());
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true)).named(field2.name());
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true)).named(field2.name());
        }
        if (IntegerType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(field2.name());
        }
        if (LongType$.MODULE$.equals(dataType) ? true : dataType instanceof DayTimeIntervalType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(field2.name());
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(field2.name());
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(field2.name());
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType()).named(field2.name());
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType()).named(field2.name());
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            Enumeration.Value value = this.outputTimestampType;
            Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(field2.name());
            }
            Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)).named(field2.name());
            }
            Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS)).named(field2.name());
            }
            throw new MatchError((Object)value);
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)).named(field2.name());
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(field2.name());
        }
        if (dataType instanceof DecimalType) {
            bl = true;
            decimalType = (DecimalType)dataType;
            Option option4 = DecimalType.Fixed$.MODULE$.unapply(decimalType);
            if (!option4.isEmpty()) {
                int precision = ((Tuple2)option4.get())._1$mcI$sp();
                int scale = ((Tuple2)option4.get())._2$mcI$sp();
                if (this.writeLegacyParquetFormat) {
                    return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision))).length(Decimal$.MODULE$.minBytesForPrecision()[precision]).named(field2.name());
                }
            }
        }
        if (bl && !(option3 = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option3.get())._1$mcI$sp();
            int scale = ((Tuple2)option3.get())._2$mcI$sp();
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS() && !this.writeLegacyParquetFormat) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision)).named(field2.name());
            }
        }
        if (bl && !(option2 = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option2.get())._1$mcI$sp();
            int scale = ((Tuple2)option2.get())._2$mcI$sp();
            if (precision <= Decimal$.MODULE$.MAX_LONG_DIGITS() && !this.writeLegacyParquetFormat) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision)).named(field2.name());
            }
        }
        if (bl && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            if (!this.writeLegacyParquetFormat) {
                return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision))).length(Decimal$.MODULE$.minBytesForPrecision()[precision]).named(field2.name());
            }
        }
        if (dataType instanceof ArrayType) {
            bl2 = true;
            arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean bl4 = arrayType.containsNull();
            if (bl4 && this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)Types.buildGroup((Type.Repetition)Type.Repetition.REPEATED).addField(this.convertField(new StructField("array", elementType, true, StructField$.MODULE$.apply$default$4()))).named("bag")).named(field2.name());
            }
        }
        if (bl2) {
            DataType elementType = arrayType.elementType();
            boolean bl5 = arrayType.containsNull();
            if (!bl5 && this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField(this.convertField(new StructField("array", elementType, false, StructField$.MODULE$.apply$default$4()), Type.Repetition.REPEATED)).named(field2.name());
            }
        }
        if (dataType instanceof MapType) {
            bl3 = true;
            mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            if (this.writeLegacyParquetFormat) {
                return ConversionPatterns.mapType((Type.Repetition)repetition, (String)field2.name(), (Type)this.convertField(new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4())), (Type)this.convertField(new StructField("value", valueType, valueContainsNull, StructField$.MODULE$.apply$default$4())));
            }
        }
        if (bl2) {
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            if (!this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("element", elementType, containsNull, StructField$.MODULE$.apply$default$4()))).named("list")).named(field2.name());
            }
        }
        if (bl3) {
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.mapType())).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4()))).addField(this.convertField(new StructField("value", valueType, valueContainsNull, StructField$.MODULE$.apply$default$4()))).named("key_value")).named(field2.name());
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            return (Type)((Types.Builder)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Object)Types.buildGroup((Type.Repetition)repetition), (Function2 & Serializable)(builder, field) -> (Types.GroupBuilder)builder.addField(this.convertField((StructField)field)))).named(field2.name());
        }
        if (dataType instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            DataType x$1 = userDefinedType.sqlType();
            String x$2 = field2.copy$default$1();
            boolean x$3 = field2.copy$default$3();
            Metadata x$4 = field2.copy$default$4();
            return this.convertField(field2.copy(x$2, x$1, x$3, x$4));
        }
        throw QueryCompilationErrors$.MODULE$.cannotConvertDataTypeToParquetTypeError(field2);
    }

    public SparkToParquetSchemaConverter(boolean writeLegacyParquetFormat, Enumeration.Value outputTimestampType, boolean useFieldId) {
        this.writeLegacyParquetFormat = writeLegacyParquetFormat;
        this.outputTimestampType = outputTimestampType;
        this.useFieldId = useFieldId;
    }

    public SparkToParquetSchemaConverter(SQLConf conf) {
        this(conf.writeLegacyParquetFormat(), conf.parquetOutputTimestampType(), conf.parquetFieldIdWriteEnabled());
    }

    public SparkToParquetSchemaConverter(Configuration conf) {
        this(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))), SQLConf.ParquetOutputTimestampType$.MODULE$.withName(conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key())), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_FIELD_ID_WRITE_ENABLED().key()))));
    }
}

