/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.math.BigInteger;
import org.apache.parquet.column.Dictionary;

public final class ParquetDictionary
implements org.apache.spark.sql.execution.vectorized.Dictionary {
    private Dictionary dictionary;
    private boolean needTransform = false;

    public ParquetDictionary(Dictionary dictionary, boolean needTransform) {
        this.dictionary = dictionary;
        this.needTransform = needTransform;
    }

    @Override
    public int decodeToInt(int id) {
        if (this.needTransform) {
            return (int)this.dictionary.decodeToLong(id);
        }
        return this.dictionary.decodeToInt(id);
    }

    @Override
    public long decodeToLong(int id) {
        if (this.needTransform) {
            return Integer.toUnsignedLong(this.dictionary.decodeToInt(id));
        }
        return this.dictionary.decodeToLong(id);
    }

    @Override
    public float decodeToFloat(int id) {
        return this.dictionary.decodeToFloat(id);
    }

    @Override
    public double decodeToDouble(int id) {
        return this.dictionary.decodeToDouble(id);
    }

    @Override
    public byte[] decodeToBinary(int id) {
        if (this.needTransform) {
            long signed = this.dictionary.decodeToLong(id);
            return new BigInteger(Long.toUnsignedString(signed)).toByteArray();
        }
        return this.dictionary.decodeToBinary(id).getBytes();
    }
}

