/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnVector;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

public class OrcAtomicColumnVector
extends OrcColumnVector {
    private final boolean isTimestamp;
    private final boolean isDate;
    private LongColumnVector longData;
    private DoubleColumnVector doubleData;
    private BytesColumnVector bytesData;
    private DecimalColumnVector decimalData;
    private TimestampColumnVector timestampData;

    OrcAtomicColumnVector(DataType type, org.apache.hadoop.hive.ql.exec.vector.ColumnVector vector) {
        super(type, vector);
        this.isTimestamp = type instanceof TimestampType;
        this.isDate = type instanceof DateType;
        if (vector instanceof LongColumnVector) {
            this.longData = (LongColumnVector)vector;
        } else if (vector instanceof DoubleColumnVector) {
            this.doubleData = (DoubleColumnVector)vector;
        } else if (vector instanceof BytesColumnVector) {
            this.bytesData = (BytesColumnVector)vector;
        } else if (vector instanceof DecimalColumnVector) {
            this.decimalData = (DecimalColumnVector)vector;
        } else if (vector instanceof TimestampColumnVector) {
            this.timestampData = (TimestampColumnVector)vector;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public boolean getBoolean(int rowId) {
        return this.longData.vector[this.getRowIndex(rowId)] == 1L;
    }

    public byte getByte(int rowId) {
        return (byte)this.longData.vector[this.getRowIndex(rowId)];
    }

    public short getShort(int rowId) {
        return (short)this.longData.vector[this.getRowIndex(rowId)];
    }

    public int getInt(int rowId) {
        int value = (int)this.longData.vector[this.getRowIndex(rowId)];
        if (this.isDate) {
            return RebaseDateTime.rebaseJulianToGregorianDays((int)value);
        }
        return value;
    }

    public long getLong(int rowId) {
        int index = this.getRowIndex(rowId);
        if (this.isTimestamp) {
            return DateTimeUtils.fromJavaTimestamp((Timestamp)this.timestampData.asScratchTimestamp(index));
        }
        return this.longData.vector[index];
    }

    public float getFloat(int rowId) {
        return (float)this.doubleData.vector[this.getRowIndex(rowId)];
    }

    public double getDouble(int rowId) {
        return this.doubleData.vector[this.getRowIndex(rowId)];
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        BigDecimal data = this.decimalData.vector[this.getRowIndex(rowId)].getHiveDecimal().bigDecimalValue();
        return Decimal.apply((BigDecimal)data, (int)precision, (int)scale);
    }

    public UTF8String getUTF8String(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        int index = this.getRowIndex(rowId);
        BytesColumnVector col = this.bytesData;
        return UTF8String.fromBytes((byte[])col.vector[index], (int)col.start[index], (int)col.length[index]);
    }

    public byte[] getBinary(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        int index = this.getRowIndex(rowId);
        byte[] binary = new byte[this.bytesData.length[index]];
        System.arraycopy(this.bytesData.vector[index], this.bytesData.start[index], binary, 0, binary.length);
        return binary;
    }

    public ColumnarArray getArray(int rowId) {
        throw new UnsupportedOperationException();
    }

    public ColumnarMap getMap(int rowId) {
        throw new UnsupportedOperationException();
    }

    public ColumnVector getChild(int ordinal) {
        throw new UnsupportedOperationException();
    }
}

