/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.sql.Connection;
import org.apache.spark.Partition;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.types.StructType;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t4A!\u0002\u0004\u0001+!)\u0001\u0006\u0001C\u0001S!)A\u0006\u0001C![!)\u0011\b\u0001C!u!)\u0011\b\u0001C!\u0013\n!\"\n\u001a2d%\u0016d\u0017\r^5p]B\u0013xN^5eKJT!a\u0002\u0005\u0002\t)$'m\u0019\u0006\u0003\u0013)\t1\u0002Z1uCN|WO]2fg*\u00111\u0002D\u0001\nKb,7-\u001e;j_:T!!\u0004\b\u0002\u0007M\fHN\u0003\u0002\u0010!\u0005)1\u000f]1sW*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\f\u001dE\u0015\u0002\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f!\u001b\u0005q\"BA\u0010\r\u0003\u001d\u0019x.\u001e:dKNL!!\t\u0010\u00033\r\u0013X-\u0019;bE2,'+\u001a7bi&|g\u000e\u0015:pm&$WM\u001d\t\u0003;\rJ!\u0001\n\u0010\u0003!I+G.\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\bCA\u000f'\u0013\t9cD\u0001\nECR\f7k\\;sG\u0016\u0014VmZ5ti\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001+!\tY\u0003!D\u0001\u0007\u0003%\u0019\bn\u001c:u\u001d\u0006lW\rF\u0001/!\tycG\u0004\u00021iA\u0011\u0011\u0007G\u0007\u0002e)\u00111\u0007F\u0001\u0007yI|w\u000e\u001e \n\u0005UB\u0012A\u0002)sK\u0012,g-\u0003\u00028q\t11\u000b\u001e:j]\u001eT!!\u000e\r\u0002\u001d\r\u0014X-\u0019;f%\u0016d\u0017\r^5p]R\u00191H\u0010#\u0011\u0005ua\u0014BA\u001f\u001f\u00051\u0011\u0015m]3SK2\fG/[8o\u0011\u0015y4\u00011\u0001A\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003\u0003\nk\u0011\u0001D\u0005\u0003\u00072\u0011!bU)M\u0007>tG/\u001a=u\u0011\u0015)5\u00011\u0001G\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005_\u001dsc&\u0003\u0002Iq\t\u0019Q*\u00199\u0015\u000bmR5\nU)\t\u000b}\"\u0001\u0019\u0001!\t\u000b1#\u0001\u0019A'\u0002\t5|G-\u001a\t\u0003\u0003:K!a\u0014\u0007\u0003\u0011M\u000bg/Z'pI\u0016DQ!\u0012\u0003A\u0002\u0019CQA\u0015\u0003A\u0002M\u000b!\u0001\u001a4\u0011\u0005Q{fBA+^\u001d\t1FL\u0004\u0002X7:\u0011\u0001L\u0017\b\u0003ceK\u0011aE\u0005\u0003#II!a\u0004\t\n\u00055q\u0011B\u00010\r\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Y1\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u00010\r\u0001")
public class JdbcRelationProvider
implements CreatableRelationProvider,
RelationProvider,
DataSourceRegister {
    @Override
    public String shortName() {
        return "jdbc";
    }

    @Override
    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        JDBCOptions jdbcOptions = new JDBCOptions(parameters);
        Function2 resolver = sqlContext.conf().resolver();
        String timeZoneId = sqlContext.conf().sessionLocalTimeZone();
        StructType schema = JDBCRelation$.MODULE$.getSchema((Function2<String, String, Object>)resolver, jdbcOptions);
        Partition[] parts = JDBCRelation$.MODULE$.columnPartition(schema, (Function2<String, String, Object>)resolver, timeZoneId, jdbcOptions);
        return new JDBCRelation(schema, parts, jdbcOptions, sqlContext.sparkSession());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> parameters, Dataset<Row> df) {
        JdbcOptionsInWrite options = new JdbcOptionsInWrite(parameters);
        boolean isCaseSensitive = sqlContext.conf().caseSensitiveAnalysis();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(options.url());
        try (Connection conn = (Connection)dialect.createConnectionFactory(options).apply((Object)BoxesRunTime.boxToInteger((int)-1));){
            boolean tableExists = JdbcUtils$.MODULE$.tableExists(conn, options);
            if (tableExists) {
                SaveMode saveMode = mode;
                if (SaveMode.Overwrite.equals(saveMode)) {
                    if (options.isTruncate()) {
                        Option<Object> option = JdbcUtils$.MODULE$.isCascadingTruncateTable(options.url());
                        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
                        if (!(option != null ? !option.equals((Object)some) : some != null)) {
                            JdbcUtils$.MODULE$.truncateTable(conn, options);
                            Option<StructType> tableSchema = JdbcUtils$.MODULE$.getSchemaOption(conn, options);
                            JdbcUtils$.MODULE$.saveTable(df, tableSchema, isCaseSensitive, options);
                            return this.createRelation(sqlContext, parameters);
                        }
                    }
                    JdbcUtils$.MODULE$.dropTable(conn, options.table(), options);
                    JdbcUtils$.MODULE$.createTable(conn, options.table(), df.schema(), isCaseSensitive, options);
                    JdbcUtils$.MODULE$.saveTable(df, (Option<StructType>)new Some((Object)df.schema()), isCaseSensitive, options);
                    return this.createRelation(sqlContext, parameters);
                }
                if (SaveMode.Append.equals(saveMode)) {
                    Option<StructType> tableSchema = JdbcUtils$.MODULE$.getSchemaOption(conn, options);
                    JdbcUtils$.MODULE$.saveTable(df, tableSchema, isCaseSensitive, options);
                    return this.createRelation(sqlContext, parameters);
                }
                if (SaveMode.ErrorIfExists.equals(saveMode)) {
                    throw QueryCompilationErrors$.MODULE$.tableOrViewAlreadyExistsError(options.table());
                }
                if (!SaveMode.Ignore.equals(saveMode)) throw new MatchError((Object)saveMode);
                return this.createRelation(sqlContext, parameters);
            }
            JdbcUtils$.MODULE$.createTable(conn, options.table(), df.schema(), isCaseSensitive, options);
            JdbcUtils$.MODULE$.saveTable(df, (Option<StructType>)new Some((Object)df.schema()), isCaseSensitive, options);
            return this.createRelation(sqlContext, parameters);
        }
    }
}

