/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import com.univocity.parsers.csv.CsvParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.input.PortableDataStream;
import org.apache.spark.input.StreamInputFormat;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.BinaryFileRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVInferSchema;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.csv.UnivocityParser$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class MultiLineCSVDataSource$
extends CSVDataSource
implements Logging {
    public static final MultiLineCSVDataSource$ MODULE$ = new MultiLineCSVDataSource$();
    private static final boolean isSplitable;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        isSplitable = false;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public boolean isSplitable() {
        return isSplitable;
    }

    @Override
    public Iterator<InternalRow> readFile(Configuration conf, PartitionedFile file, UnivocityParser parser, CSVHeaderChecker headerChecker, StructType requiredSchema) {
        return UnivocityParser$.MODULE$.parseStream(CodecStreams$.MODULE$.createInputStreamWithCloseResource(conf, file.toPath()), parser, headerChecker, requiredSchema);
    }

    @Override
    public StructType infer(SparkSession sparkSession, Seq<FileStatus> inputPaths, CSVOptions parsedOptions) {
        RDD<PortableDataStream> csv = this.createBaseRdd(sparkSession, inputPaths, parsedOptions);
        boolean ignoreCorruptFiles = parsedOptions.ignoreCorruptFiles();
        boolean ignoreMissingFiles = parsedOptions.ignoreMissingFiles();
        Option option = ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])csv.flatMap((Function1 & Serializable)lines -> {
            Iterator iterator;
            try {
                Path path = new Path(lines.getPath());
                iterator = UnivocityParser$.MODULE$.tokenizeStream(CodecStreams$.MODULE$.createInputStreamWithCloseResource(lines.getConfiguration(), path), false, new CsvParser(parsedOptions.asParserSettings()), parsedOptions.charset());
            }
            catch (Throwable throwable) {
                boolean bl = false;
                FileNotFoundException fileNotFoundException = null;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof FileNotFoundException) {
                    bl = true;
                    fileNotFoundException = (FileNotFoundException)throwable2;
                    if (ignoreMissingFiles) {
                        MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipped missing file: " + lines.getPath(), fileNotFoundException);
                        iterator = Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
                    }
                }
                if (bl && !ignoreMissingFiles) {
                    throw fileNotFoundException;
                }
                if ((throwable2 instanceof RuntimeException ? true : throwable2 instanceof IOException) && ignoreCorruptFiles) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipped the rest of the content in the corrupted file: " + lines.getPath(), throwable2);
                    iterator = Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
                }
                throw throwable;
            }
            return iterator;
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).take(1)));
        if (option instanceof Some) {
            Some some = (Some)option;
            String[] firstRow = (String[])some.value();
            boolean caseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
            String[] header = CSVUtils$.MODULE$.makeSafeHeader(firstRow, caseSensitive, parsedOptions);
            RDD tokenRDD = csv.flatMap((Function1 & Serializable)lines -> UnivocityParser$.MODULE$.tokenizeStream(CodecStreams$.MODULE$.createInputStreamWithCloseResource(lines.getConfiguration(), new Path(lines.getPath())), parsedOptions.headerFlag(), new CsvParser(parsedOptions.asParserSettings()), parsedOptions.charset()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
            RDD<String[]> sampled = CSVUtils$.MODULE$.sample((RDD<String[]>)tokenRDD, parsedOptions);
            return (StructType)SQLExecution$.MODULE$.withSQLConfPropagated(sparkSession, (Function0 & Serializable)() -> new CSVInferSchema(parsedOptions).infer(sampled, header));
        }
        if (None$.MODULE$.equals(option)) {
            return StructType$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    private RDD<PortableDataStream> createBaseRdd(SparkSession sparkSession, Seq<FileStatus> inputPaths, CSVOptions options) {
        Seq paths = (Seq)inputPaths.map((Function1 & Serializable)x$5 -> x$5.getPath());
        String name = paths.mkString(",");
        Job job = Job.getInstance((Configuration)sparkSession.sessionState().newHadoopConfWithOptions((Map<String, String>)options.parameters()));
        FileInputFormat.setInputPaths((Job)job, (Path[])((Path[])paths.toArray(ClassTag$.MODULE$.apply(Path.class))));
        Configuration conf = job.getConfiguration();
        BinaryFileRDD rdd = new BinaryFileRDD(sparkSession.sparkContext(), StreamInputFormat.class, String.class, PortableDataStream.class, conf, sparkSession.sparkContext().defaultMinPartitions());
        return RDD$.MODULE$.rddToPairRDDFunctions(rdd.setName("CSVFile: " + name), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PortableDataStream.class), (Ordering)Ordering.String$.MODULE$).values();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MultiLineCSVDataSource$.class);
    }

    private MultiLineCSVDataSource$() {
    }
}

