/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.csv.CSVExprUtils$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CSVUtils$ {
    public static final CSVUtils$ MODULE$ = new CSVUtils$();

    public Dataset<String> filterCommentAndEmpty(Dataset<String> lines, CSVOptions options) {
        Dataset<Row> aliased = lines.toDF((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}));
        Dataset<Row> nonEmptyLines = aliased.filter(functions$.MODULE$.length(functions$.MODULE$.trim(lines.sqlContext().implicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((scala.collection.immutable.Seq<Object>)Nil$.MODULE$))).$greater(BoxesRunTime.boxToInteger((int)0)));
        if (options.isCommentSet()) {
            return nonEmptyLines.filter(lines.sqlContext().implicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((scala.collection.immutable.Seq<Object>)Nil$.MODULE$).startsWith(Character.toString(options.comment())).unary_$bang()).as(lines.sqlContext().implicits().newStringEncoder());
        }
        return nonEmptyLines.as(lines.sqlContext().implicits().newStringEncoder());
    }

    public Iterator<String> filterHeaderLine(Iterator<String> iter, String firstLine, CSVOptions options) {
        if (options.headerFlag()) {
            return iter.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CSVUtils$.$anonfun$filterHeaderLine$1(firstLine, x$1)));
        }
        return iter;
    }

    public String[] makeSafeHeader(String[] row, boolean caseSensitive, CSVOptions options) {
        if (options.headerFlag()) {
            String[] headerNames = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])row), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CSVUtils$.$anonfun$makeSafeHeader$1(x$2)))), (Function1 & Serializable)name -> {
                if (caseSensitive) {
                    return name;
                }
                return name.toLowerCase();
            }, ClassTag$.MODULE$.apply(String.class));
            String[] duplicates = (String[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.diff$extension(Predef$.MODULE$.refArrayOps((Object[])headerNames), (Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])headerNames))))));
            return (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])row))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2;
                block5: {
                    int index;
                    String value;
                    block7: {
                        block6: {
                            tuple2 = x0$1;
                            if (tuple2 == null) break block5;
                            value = (String)tuple2._1();
                            index = tuple2._2$mcI$sp();
                            if (value == null || value.isEmpty()) break block6;
                            String string = value;
                            String string2 = options.nullValue();
                            if (string != null ? !string.equals(string2) : string2 != null) break block7;
                        }
                        return "_c" + index;
                    }
                    if (!caseSensitive && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])duplicates), (Object)value.toLowerCase())) {
                        return value + index;
                    }
                    if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])duplicates), (Object)value)) {
                        return value + index;
                    }
                    return value;
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(String.class));
        }
        return (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])row))), (Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int index = tuple2._2$mcI$sp();
                return "_c" + index;
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(String.class));
    }

    public Dataset<String> sample(Dataset<String> csv, CSVOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0 & Serializable)() -> "samplingRatio (" + options.samplingRatio() + ") should be greater than 0");
        if (options.samplingRatio() > 0.99) {
            return csv;
        }
        return csv.sample(false, options.samplingRatio(), 1L);
    }

    public RDD<String[]> sample(RDD<String[]> csv, CSVOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0 & Serializable)() -> "samplingRatio (" + options.samplingRatio() + ") should be greater than 0");
        if (options.samplingRatio() > 0.99) {
            return csv;
        }
        return csv.sample(false, options.samplingRatio(), 1L);
    }

    public Iterator<String> filterCommentAndEmpty(Iterator<String> iter, CSVOptions options) {
        return CSVExprUtils$.MODULE$.filterCommentAndEmpty(iter, options);
    }

    public static final /* synthetic */ boolean $anonfun$filterHeaderLine$1(String firstLine$1, String x$1) {
        String string = x$1;
        String string2 = firstLine$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$makeSafeHeader$1(String x$2) {
        return x$2 != null;
    }

    private CSVUtils$() {
    }
}

