/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.paths.SparkPath;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.FileSourceConstantMetadataStructField$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.TimestampType$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class FileFormat$ {
    public static final FileFormat$ MODULE$ = new FileFormat$();
    private static final String FILE_PATH = "file_path";
    private static final String FILE_NAME = "file_name";
    private static final String FILE_BLOCK_START = "file_block_start";
    private static final String FILE_BLOCK_LENGTH = "file_block_length";
    private static final String FILE_SIZE = "file_size";
    private static final String FILE_MODIFICATION_TIME = "file_modification_time";
    private static final String METADATA_NAME = "_metadata";
    private static final String OPTION_RETURNING_BATCH = "returning_batch";
    private static final Seq<StructField> BASE_METADATA_FIELDS = new .colon.colon((Object)FileSourceConstantMetadataStructField$.MODULE$.apply(MODULE$.FILE_PATH(), (DataType)StringType$.MODULE$, false), (List)new .colon.colon((Object)FileSourceConstantMetadataStructField$.MODULE$.apply(MODULE$.FILE_NAME(), (DataType)StringType$.MODULE$, false), (List)new .colon.colon((Object)FileSourceConstantMetadataStructField$.MODULE$.apply(MODULE$.FILE_SIZE(), (DataType)LongType$.MODULE$, false), (List)new .colon.colon((Object)FileSourceConstantMetadataStructField$.MODULE$.apply(MODULE$.FILE_BLOCK_START(), (DataType)LongType$.MODULE$, false), (List)new .colon.colon((Object)FileSourceConstantMetadataStructField$.MODULE$.apply(MODULE$.FILE_BLOCK_LENGTH(), (DataType)LongType$.MODULE$, false), (List)new .colon.colon((Object)FileSourceConstantMetadataStructField$.MODULE$.apply(MODULE$.FILE_MODIFICATION_TIME(), (DataType)TimestampType$.MODULE$, false), (List)Nil$.MODULE$))))));
    private static final Map<String, Function1<PartitionedFile, Object>> BASE_METADATA_EXTRACTORS = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.FILE_PATH()), (Function1 & Serializable)pf -> new Path(pf.filePath().toPath().toString()).toUri().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.FILE_NAME()), (Function1 & Serializable)pf -> (String)ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.refArrayOps((Object[])pf.filePath().toUri().getRawPath().split("/"))).getOrElse((Function0 & Serializable)() -> "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.FILE_SIZE()), (Function1 & Serializable)pf -> BoxesRunTime.boxToLong((long)pf.fileSize())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.FILE_BLOCK_START()), (Function1 & Serializable)pf -> BoxesRunTime.boxToLong((long)pf.start())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.FILE_BLOCK_LENGTH()), (Function1 & Serializable)pf -> BoxesRunTime.boxToLong((long)pf.length())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.FILE_MODIFICATION_TIME()), (Function1 & Serializable)pf -> BoxesRunTime.boxToLong((long)FileFormat$.$anonfun$BASE_METADATA_EXTRACTORS$7(pf)))}));

    public String FILE_PATH() {
        return FILE_PATH;
    }

    public String FILE_NAME() {
        return FILE_NAME;
    }

    public String FILE_BLOCK_START() {
        return FILE_BLOCK_START;
    }

    public String FILE_BLOCK_LENGTH() {
        return FILE_BLOCK_LENGTH;
    }

    public String FILE_SIZE() {
        return FILE_SIZE;
    }

    public String FILE_MODIFICATION_TIME() {
        return FILE_MODIFICATION_TIME;
    }

    public String METADATA_NAME() {
        return METADATA_NAME;
    }

    public String OPTION_RETURNING_BATCH() {
        return OPTION_RETURNING_BATCH;
    }

    public Seq<StructField> BASE_METADATA_FIELDS() {
        return BASE_METADATA_FIELDS;
    }

    public Map<String, Function1<PartitionedFile, Object>> BASE_METADATA_EXTRACTORS() {
        return BASE_METADATA_EXTRACTORS;
    }

    public Literal getFileConstantMetadataColumnValue(String name, PartitionedFile file, Map<String, Function1<PartitionedFile, Object>> metadataExtractors) {
        Function1 extractor = (Function1)metadataExtractors.getOrElse((Object)name, (Function0 & Serializable)() -> (Function1 & Serializable)pf -> pf.otherConstantMetadataColumnValues().get((Object)name).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return Literal$.MODULE$.apply(extractor.apply((Object)file));
    }

    public InternalRow createMetadataInternalRow(InternalRow partitionValues, Seq<String> fieldNames, SparkPath filePath, long fileSize, long fileModificationTime) {
        Set validFieldNames = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.FILE_PATH(), this.FILE_NAME(), this.FILE_SIZE(), this.FILE_MODIFICATION_TIME()}));
        Map extractors = this.BASE_METADATA_EXTRACTORS().view().filterKeys((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validFieldNames.contains((Object)elem))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Predef$.MODULE$.assert(fieldNames.forall((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validFieldNames.contains((Object)elem))));
        PartitionedFile pf = new PartitionedFile(partitionValues, filePath, 0L, fileSize, (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), fileModificationTime, fileSize, (Map<String, Object>)Predef$.MODULE$.Map().empty());
        return this.updateMetadataInternalRow((InternalRow)new GenericInternalRow(fieldNames.length()), fieldNames, pf, (Map<String, Function1<PartitionedFile, Object>>)extractors);
    }

    public InternalRow updateMetadataInternalRow(InternalRow row, Seq<String> fieldNames, PartitionedFile file, Map<String, Function1<PartitionedFile, Object>> metadataExtractors) {
        ((IterableOnceOps)fieldNames.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            FileFormat$.$anonfun$updateMetadataInternalRow$1(file, metadataExtractors, row, x0$1);
            return BoxedUnit.UNIT;
        });
        return row;
    }

    public static final /* synthetic */ long $anonfun$BASE_METADATA_EXTRACTORS$7(PartitionedFile pf) {
        return pf.modificationTime() * 1000L;
    }

    public static final /* synthetic */ void $anonfun$updateMetadataInternalRow$1(PartitionedFile file$2, Map metadataExtractors$1, InternalRow row$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object object;
            String name = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Literal literal = MODULE$.getFileConstantMetadataColumnValue(name, file$2, (Map<String, Function1<PartitionedFile, Object>>)metadataExtractors$1);
            if (literal != null && (object = literal.value()) == null) {
                row$1.setNullAt(i);
            } else {
                row$1.update(i, literal.value());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private FileFormat$() {
    }
}

