/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.StructType;
import scala.Function5;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005i4A!\u0003\u0006\u0001/!)a\u0004\u0001C\u0001?\u0015!!\u0005\u0001\u0003$\u0011\u001d9\u0006A1A\u0005\naCa\u0001\u001a\u0001!\u0002\u0013I\u0006\"B3\u0001\t\u00131\u0007\"B5\u0001\t\u0003Q\u0007\"B9\u0001\t\u0003\u0011\b\"\u0002;\u0001\t\u0003)(!\u0005#bi\u0006\u001cv.\u001e:dK6\u000bg.Y4fe*\u00111\u0002D\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u000e\u001d\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u001fA\t1a]9m\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u000b\u0005E!\u0015\r^1T_V\u00148-\u001a\"vS2$WM\u001d\t\t3\u00112#&\u000e H\u001f&\u0011QE\u0007\u0002\n\rVt7\r^5p]V\u0002\"a\n\u0015\u000e\u00039I!!\u000b\b\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005-\u0012dB\u0001\u00171!\ti#$D\u0001/\u0015\tyc#\u0001\u0004=e>|GOP\u0005\u0003ci\ta\u0001\u0015:fI\u00164\u0017BA\u001a5\u0005\u0019\u0019FO]5oO*\u0011\u0011G\u0007\t\u0004mmRcBA\u001c:\u001d\ti\u0003(C\u0001\u001c\u0013\tQ$$A\u0004qC\u000e\\\u0017mZ3\n\u0005qj$aA*fc*\u0011!H\u0007\t\u00043}\n\u0015B\u0001!\u001b\u0005\u0019y\u0005\u000f^5p]B\u0011!)R\u0007\u0002\u0007*\u0011AID\u0001\u0006if\u0004Xm]\u0005\u0003\r\u000e\u0013!b\u0015;sk\u000e$H+\u001f9f!\rAUJK\u0007\u0002\u0013*\u0011!jS\u0001\u0005kRLGN\u0003\u0002M\u001d\u0005A1-\u0019;bYf\u001cH/\u0003\u0002O\u0013\n\u00112)Y:f\u0013:\u001cXM\\:ji&4X-T1q!\t\u0001V+D\u0001R\u0015\t\u00116+A\u0004m_\u001eL7-\u00197\u000b\u0005Q[\u0015!\u00029mC:\u001c\u0018B\u0001,R\u0005-aunZ5dC2\u0004F.\u00198\u0002%\u0011\fG/Y*pkJ\u001cWMQ;jY\u0012,'o]\u000b\u00023B!!\f\u0019\u0016c\u001b\u0005Y&B\u0001/^\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u0015zS\u0011aX\u0001\u0005U\u00064\u0018-\u0003\u0002b7\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005\r\u0014Q\"\u0001\u0001\u0002'\u0011\fG/Y*pkJ\u001cWMQ;jY\u0012,'o\u001d\u0011\u0002\u00139|'/\\1mSj,GC\u0001\u0016h\u0011\u0015AW\u00011\u0001+\u0003\u0011q\u0017-\\3\u0002%I,w-[:uKJ$\u0015\r^1T_V\u00148-\u001a\u000b\u0004W:|\u0007CA\rm\u0013\ti'D\u0001\u0003V]&$\b\"\u00025\u0007\u0001\u0004Q\u0003\"\u00029\u0007\u0001\u0004\u0011\u0017a\u00022vS2$WM]\u0001\u0011Y>|7.\u001e9ECR\f7k\\;sG\u0016$\"AY:\t\u000b!<\u0001\u0019\u0001\u0016\u0002!\u0011\fG/Y*pkJ\u001cW-\u0012=jgR\u001cHC\u0001<z!\tIr/\u0003\u0002y5\t9!i\\8mK\u0006t\u0007\"\u00025\t\u0001\u0004Q\u0003")
public class DataSourceManager {
    private final ConcurrentHashMap<String, Function5<SparkSession, String, Seq<String>, Option<StructType>, CaseInsensitiveMap<String>, LogicalPlan>> dataSourceBuilders = new ConcurrentHashMap();

    private ConcurrentHashMap<String, Function5<SparkSession, String, Seq<String>, Option<StructType>, CaseInsensitiveMap<String>, LogicalPlan>> dataSourceBuilders() {
        return this.dataSourceBuilders;
    }

    private String normalize(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public void registerDataSource(String name, Function5<SparkSession, String, Seq<String>, Option<StructType>, CaseInsensitiveMap<String>, LogicalPlan> builder) {
        String normalizedName = this.normalize(name);
        if (this.dataSourceBuilders().containsKey(normalizedName)) {
            throw QueryCompilationErrors$.MODULE$.dataSourceAlreadyExists(name);
        }
        this.dataSourceBuilders().put(normalizedName, builder);
    }

    public Function5<SparkSession, String, Seq<String>, Option<StructType>, CaseInsensitiveMap<String>, LogicalPlan> lookupDataSource(String name) {
        if (this.dataSourceExists(name)) {
            return this.dataSourceBuilders().get(this.normalize(name));
        }
        throw QueryCompilationErrors$.MODULE$.dataSourceDoesNotExist(name);
    }

    public boolean dataSourceExists(String name) {
        return this.dataSourceBuilders().containsKey(this.normalize(name));
    }
}

