/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class BucketingUtils$ {
    public static final BucketingUtils$ MODULE$ = new BucketingUtils$();
    private static final Regex bucketedFileName = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*_(\\d+)(?:\\..*)?$"));
    private static final String optionForHiveCompatibleBucketWrite = "__hive_compatible_bucketed_table_insertion__";

    private Regex bucketedFileName() {
        return bucketedFileName;
    }

    public String optionForHiveCompatibleBucketWrite() {
        return optionForHiveCompatibleBucketWrite;
    }

    public Option<Object> getBucketId(String fileName) {
        Option option;
        String string = fileName;
        if (string != null && !(option = this.bucketedFileName().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String bucketId = (String)((LinearSeqOps)option.get()).apply(0);
            return new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(bucketId))));
        }
        return None$.MODULE$;
    }

    public int getBucketIdFromValue(Attribute bucketColumn, int numBuckets, Object value) {
        SpecificInternalRow mutableInternalRow = new SpecificInternalRow((Seq)new .colon.colon((Object)bucketColumn.dataType(), (List)Nil$.MODULE$));
        mutableInternalRow.update(0, value);
        Expression expression = new HashPartitioning((Seq)new .colon.colon((Object)bucketColumn, (List)Nil$.MODULE$), numBuckets).partitionIdExpression();
        Attribute attribute = bucketColumn;
        UnsafeProjection bucketIdGenerator = UnsafeProjection$.MODULE$.create((Seq)Nil$.MODULE$.$colon$colon((Object)expression), (Seq)Nil$.MODULE$.$colon$colon((Object)attribute));
        return bucketIdGenerator.apply((InternalRow)mutableInternalRow).getInt(0);
    }

    public String bucketIdToString(int id) {
        return StringOps$.MODULE$.format$extension("_%05d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)}));
    }

    private BucketingUtils$() {
    }
}

