/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.TaskContext$;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker$;
import org.apache.spark.sql.execution.datasources.BasicWriteTaskStats;
import org.apache.spark.sql.execution.datasources.BasicWriteTaskStatsTracker$;
import org.apache.spark.sql.execution.datasources.WriteTaskStats;
import org.apache.spark.sql.execution.datasources.WriteTaskStatsTracker;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001\u0002\f\u0018\u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!)\u0001\n\u0001C\u0001\u0013\"1Q\n\u0001Q\u0001\n9Ca\u0001\u0018\u0001!B\u0013i\u0006B\u00021\u0001A\u0003&Q\f\u0003\u0004b\u0001\u0001\u0006KA\u0019\u0005\u0007K\u0002\u0001\u000b\u0015\u00022\t\r\u0019\u0004\u0001\u0015!\u0003h\u0011\u0015)\b\u0001\"\u0003w\u0011\u0019)\b\u0001\"\u0001\u0018u\"9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003G\u0001A\u0011IA\u0013\u0011\u001d\tI\u0003\u0001C\u0005\u0003WAq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u0002:\u0001!\t%a\u000f\b\u0013\u0005\u001ds#!A\t\u0002\u0005%c\u0001\u0003\f\u0018\u0003\u0003E\t!a\u0013\t\r!\u001bB\u0011AA'\u0011%\tyeEI\u0001\n\u0003\t\tF\u0001\u000eCCNL7m\u0016:ji\u0016$\u0016m]6Ti\u0006$8\u000f\u0016:bG.,'O\u0003\u0002\u00193\u0005YA-\u0019;bg>,(oY3t\u0015\tQ2$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011A$H\u0001\u0004gFd'B\u0001\u0010 \u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0013%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0005\u0019qN]4\u0004\u0001M!\u0001!J\u00160!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0019\te.\u001f*fMB\u0011A&L\u0007\u0002/%\u0011af\u0006\u0002\u0016/JLG/\u001a+bg.\u001cF/\u0019;t)J\f7m[3s!\t\u00014'D\u00012\u0015\t\u0011T$\u0001\u0005j]R,'O\\1m\u0013\t!\u0014GA\u0004M_\u001e<\u0017N\\4\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005!1m\u001c8g\u0015\tYt$\u0001\u0004iC\u0012|w\u000e]\u0005\u0003{a\u0012QbQ8oM&<WO]1uS>t\u0017\u0001\u0006;bg.\u001cu.\\7jiRKW.Z'fiJL7\rE\u0002'\u0001\nK!!Q\u0014\u0003\r=\u0003H/[8o!\t\u0019e)D\u0001E\u0015\t)\u0015$\u0001\u0004nKR\u0014\u0018nY\u0005\u0003\u000f\u0012\u0013\u0011bU)M\u001b\u0016$(/[2\u0002\rqJg.\u001b;?)\rQ5\n\u0014\t\u0003Y\u0001AQ!N\u0002A\u0002YBqAP\u0002\u0011\u0002\u0003\u0007q(\u0001\u0006qCJ$\u0018\u000e^5p]N\u00042a\u0014+W\u001b\u0005\u0001&BA)S\u0003\u001diW\u000f^1cY\u0016T!aU\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002V!\nY\u0011I\u001d:bs\n+hMZ3s!\t9&,D\u0001Y\u0015\tI6$\u0001\u0005dCR\fG._:u\u0013\tY\u0006LA\u0006J]R,'O\\1m%><\u0018\u0001\u00038v[\u001aKG.Z:\u0011\u0005\u0019r\u0016BA0(\u0005\rIe\u000e^\u0001\u0012]Vl7+\u001e2nSR$X\r\u001a$jY\u0016\u001c\u0018\u0001\u00038v[\nKH/Z:\u0011\u0005\u0019\u001a\u0017B\u00013(\u0005\u0011auN\\4\u0002\u000f9,XNU8xg\u0006q1/\u001e2nSR$X\r\u001a$jY\u0016\u001c\bcA(iU&\u0011\u0011\u000e\u0015\u0002\b\u0011\u0006\u001c\bnU3u!\tY'O\u0004\u0002maB\u0011QnJ\u0007\u0002]*\u0011qnI\u0001\u0007yI|w\u000e\u001e \n\u0005E<\u0013A\u0002)sK\u0012,g-\u0003\u0002ti\n11\u000b\u001e:j]\u001eT!!]\u0014\u0002\u0017\u001d,GOR5mKNK'0\u001a\u000b\u0003ob\u00042A\n!c\u0011\u0015I(\u00021\u0001k\u0003!1\u0017\u000e\\3QCRDG\u0003B<|\u0003\u000bAQ\u0001`\u0006A\u0002u\f!AZ:\u0011\u0007y\f\t!D\u0001\u0000\u0015\ta((C\u0002\u0002\u0004}\u0014!BR5mKNK8\u000f^3n\u0011\u001d\t9a\u0003a\u0001\u0003\u0013\tA\u0001]1uQB\u0019a0a\u0003\n\u0007\u00055qP\u0001\u0003QCRD\u0017\u0001\u00048foB\u000b'\u000f^5uS>tG\u0003BA\n\u00033\u00012AJA\u000b\u0013\r\t9b\n\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u001c1\u0001\rAV\u0001\u0010a\u0006\u0014H/\u001b;j_:4\u0016\r\\;fg\u00069a.Z<GS2,G\u0003BA\n\u0003CAQ!_\u0007A\u0002)\f\u0011b\u00197pg\u00164\u0015\u000e\\3\u0015\t\u0005M\u0011q\u0005\u0005\u0006s:\u0001\rA[\u0001\u0010kB$\u0017\r^3GS2,7\u000b^1ugR!\u00111CA\u0017\u0011\u0015Ix\u00021\u0001k\u0003\u0019qWm\u001e*poR1\u00111CA\u001a\u0003kAQ!\u001f\tA\u0002)Da!a\u000e\u0011\u0001\u00041\u0016a\u0001:po\u0006iq-\u001a;GS:\fGn\u0015;biN$B!!\u0010\u0002DA\u0019A&a\u0010\n\u0007\u0005\u0005sC\u0001\bXe&$X\rV1tWN#\u0018\r^:\t\r\u0005\u0015\u0013\u00031\u0001c\u00039!\u0018m]6D_6l\u0017\u000e\u001e+j[\u0016\f!DQ1tS\u000e<&/\u001b;f)\u0006\u001c8n\u0015;biN$&/Y2lKJ\u0004\"\u0001L\n\u0014\u0005M)CCAA%\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u000b\u0016\u0004\u007f\u0005U3FAA,!\u0011\tI&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003?\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005t%\u0001\u0006b]:|G/\u0019;j_:LA!!\u001a\u0002\\\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class BasicWriteTaskStatsTracker
implements WriteTaskStatsTracker,
Logging {
    private final Configuration hadoopConf;
    private final Option<SQLMetric> taskCommitTimeMetric;
    private final ArrayBuffer<InternalRow> partitions;
    private int numFiles;
    private int numSubmittedFiles;
    private long numBytes;
    private long numRows;
    private final HashSet<String> submittedFiles;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<SQLMetric> $lessinit$greater$default$2() {
        return BasicWriteTaskStatsTracker$.MODULE$.$lessinit$greater$default$2();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<Object> getFileSize(String filePath) {
        Path path = new Path(filePath);
        FileSystem fs = path.getFileSystem(this.hadoopConf);
        return this.getFileSize(fs, path);
    }

    public Option<Object> getFileSize(FileSystem fs, Path path) {
        try {
            long len = fs.getFileStatus(path).getLen();
            if (len > 0L) {
                return new Some((Object)BoxesRunTime.boxToLong((long)len));
            }
        }
        catch (FileNotFoundException e) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "File " + path + " is not yet visible", e);
            return None$.MODULE$;
        }
        long len = 0L;
        try {
            byte[] attr = fs.getXAttr(path, BasicWriteJobStatsTracker$.MODULE$.FILE_LENGTH_XATTR());
            if (attr != null && ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.byteArrayOps(attr))) {
                String str = new String(attr, StandardCharsets.UTF_8);
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "File Length statistics for " + path + " retrieved from XAttr: " + str);
                long l = Long.parseLong(str);
                if (l > 0L) {
                    len = l;
                } else {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Ignoring negative value in XAttr file length");
                }
            }
        }
        catch (NumberFormatException e) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Failed to parse " + BasicWriteJobStatsTracker$.MODULE$.FILE_LENGTH_XATTR() + ":" + e + "; bytes written may be under-reported");
        }
        catch (UnsupportedOperationException e) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "XAttr not supported on path " + path, e);
        }
        catch (Exception e) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "XAttr processing failure on " + path, e);
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)len));
    }

    @Override
    public void newPartition(InternalRow partitionValues) {
        this.partitions.append((Object)partitionValues);
    }

    @Override
    public void newFile(String filePath) {
        this.submittedFiles.$plus$eq((Object)filePath);
        ++this.numSubmittedFiles;
    }

    @Override
    public void closeFile(String filePath) {
        this.updateFileStats(filePath);
        this.submittedFiles.remove((Object)filePath);
    }

    private void updateFileStats(String filePath) {
        this.getFileSize(filePath).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)len -> {
            $this.numBytes += len;
            ++$this.numFiles;
        });
    }

    @Override
    public void newRow(String filePath, InternalRow row) {
        ++this.numRows;
    }

    @Override
    public WriteTaskStats getFinalStats(long taskCommitTime) {
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable)x$1 -> x$1.taskMetrics().outputMetrics()).foreach((Function1 & Serializable)outputMetrics -> {
            BasicWriteTaskStatsTracker.$anonfun$getFinalStats$2(this, outputMetrics);
            return BoxedUnit.UNIT;
        });
        if (this.numSubmittedFiles != this.numFiles) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Expected " + $this.numSubmittedFiles + " files, but only saw " + $this.numFiles + ". This could be due to the output format not writing empty files, or files being not immediately visible in the filesystem.");
        }
        this.taskCommitTimeMetric.foreach((Function1 & Serializable)x$2 -> {
            x$2.$plus$eq(taskCommitTime);
            return BoxedUnit.UNIT;
        });
        return new BasicWriteTaskStats((Seq<InternalRow>)this.partitions.toSeq(), this.numFiles, this.numBytes, this.numRows);
    }

    public static final /* synthetic */ void $anonfun$getFinalStats$2(BasicWriteTaskStatsTracker $this, OutputMetrics outputMetrics) {
        outputMetrics.setBytesWritten($this.numBytes);
        outputMetrics.setRecordsWritten($this.numRows);
    }

    public BasicWriteTaskStatsTracker(Configuration hadoopConf, Option<SQLMetric> taskCommitTimeMetric) {
        this.hadoopConf = hadoopConf;
        this.taskCommitTimeMetric = taskCommitTimeMetric;
        Logging.$init$((Logging)this);
        this.partitions = ArrayBuffer$.MODULE$.empty();
        this.numFiles = 0;
        this.numSubmittedFiles = 0;
        this.numBytes = 0L;
        this.numRows = 0L;
        this.submittedFiles = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

