/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.aggregate;

import java.io.Serializable;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.MutableProjection;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateMode;
import org.apache.spark.sql.catalyst.expressions.aggregate.Complete$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Final$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.Partial$;
import org.apache.spark.sql.catalyst.expressions.aggregate.PartialMerge$;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.execution.UnsafeKVExternalSorter;
import org.apache.spark.sql.execution.aggregate.AggregationBufferEntry;
import org.apache.spark.sql.execution.aggregate.AggregationIterator;
import org.apache.spark.sql.execution.aggregate.ObjectAggregationMap;
import org.apache.spark.sql.execution.aggregate.SortBasedAggregator;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001B\u000f\u001f\u0001-B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u0011!q\u0006A!A!\u0002\u0013q\u0004\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011\u0001\u0004!\u0011!Q\u0001\nMC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\tY\u0002\u0011\t\u0011)A\u0005}!AQ\u000e\u0001B\u0001B\u0003%a\u000e\u0003\u0005v\u0001\t\u0005\t\u0015!\u00038\u0011!1\bA!A!\u0002\u00139\b\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011B<\t\u0011y\u0004!\u0011!Q\u0001\n]Daa \u0001\u0005\u0002\u0005\u0005\u0001\u0002CA\u0011\u0001\u0001\u0006K!a\t\t\u0017\u0005%\u0002\u00011A\u0001B\u0003&\u00111\u0006\u0005\n\u0003g\u0001!\u0019!C\u0005\u0003kA\u0001\"!\u0010\u0001A\u0003%\u0011q\u0007\u0005\n\u0003\u007f\u0001!\u0019!C\u0005\u0003\u0003B\u0001\"a\u0013\u0001A\u0003%\u00111\t\u0005\b\u0003\u001b\u0002AQIA(\u0011\u001d\t\t\u0006\u0001C#\u0003'Bq!a\u0017\u0001\t\u0003\t\u0019\u0006C\u0004\u0002^\u0001!I!a\u0018\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004bBAA\u0001\u0011%\u00111\u0011\u0002\u001a\u001f\nTWm\u0019;BO\u001e\u0014XmZ1uS>t\u0017\n^3sCR|'O\u0003\u0002 A\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003C\t\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a\u0003\u0007\u0005\u0002.]5\ta$\u0003\u00020=\t\u0019\u0012iZ4sK\u001e\fG/[8o\u0013R,'/\u0019;peB\u0011\u0011\u0007N\u0007\u0002e)\u00111\u0007J\u0001\tS:$XM\u001d8bY&\u0011QG\r\u0002\b\u0019><w-\u001b8h\u0003%\u0001\u0018M\u001d;J]\u0012,\u0007\u0010\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0002J]R\f\u0001c\\;uaV$\u0018\t\u001e;sS\n,H/Z:\u0011\u0007}:%J\u0004\u0002A\u000b:\u0011\u0011\tR\u0007\u0002\u0005*\u00111IK\u0001\u0007yI|w\u000e\u001e \n\u0003iJ!AR\u001d\u0002\u000fA\f7m[1hK&\u0011\u0001*\u0013\u0002\u0004'\u0016\f(B\u0001$:!\tY\u0005+D\u0001M\u0015\tie*A\u0006fqB\u0014Xm]:j_:\u001c(BA(#\u0003!\u0019\u0017\r^1msN$\u0018BA)M\u0005%\tE\u000f\u001e:jEV$X-A\nhe>,\b/\u001b8h\u000bb\u0004(/Z:tS>t7\u000fE\u0002@\u000fR\u0003\"aS+\n\u0005Yc%a\u0004(b[\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8\u0002)\u0005<wM]3hCR,W\t\u001f9sKN\u001c\u0018n\u001c8t!\ryt)\u0017\t\u00035rk\u0011a\u0017\u0006\u0003?1K!!X.\u0003'\u0005;wM]3hCR,W\t\u001f9sKN\u001c\u0018n\u001c8\u0002'\u0005<wM]3hCR,\u0017\t\u001e;sS\n,H/Z:\u00021%t\u0017\u000e^5bY&s\u0007/\u001e;Ck\u001a4WM](gMN,G/A\tsKN,H\u000e^#yaJ,7o]5p]N\fAC\\3x\u001bV$\u0018M\u00197f!J|'.Z2uS>t\u0007#\u0002\u001ddKzJ\u0017B\u00013:\u0005%1UO\\2uS>t'\u0007E\u0002@\u000f\u001a\u0004\"aS4\n\u0005!d%AC#yaJ,7o]5p]B\u00111J[\u0005\u0003W2\u0013\u0011#T;uC\ndW\r\u0015:pU\u0016\u001cG/[8o\u0003]y'/[4j]\u0006d\u0017J\u001c9vi\u0006#HO]5ckR,7/A\u0005j]B,HOU8xgB\u0019qh\\9\n\u0005AL%\u0001C%uKJ\fGo\u001c:\u0011\u0005I\u001cX\"\u0001(\n\u0005Qt%aC%oi\u0016\u0014h.\u00197S_^\faCZ1mY\n\f7m[\"pk:$H\u000b\u001b:fg\"|G\u000eZ\u0001\u000e]Vlw*\u001e;qkR\u0014vn^:\u0011\u0005a\\X\"A=\u000b\u0005i\u0004\u0013AB7fiJL7-\u0003\u0002}s\nI1+\u0015'NKR\u0014\u0018nY\u0001\ngBLG\u000e\\*ju\u0016\f!C\\;n)\u0006\u001c8n\u001d$bY2\u0014\u0015mY6fI\u00061A(\u001b8jiz\"b$a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014\u0005U\u0011qCA\r\u00037\ti\"a\b\u0011\u00055\u0002\u0001\"\u0002\u001c\u0010\u0001\u00049\u0004\"B\u001f\u0010\u0001\u0004q\u0004\"\u0002*\u0010\u0001\u0004\u0019\u0006\"B,\u0010\u0001\u0004A\u0006\"\u00020\u0010\u0001\u0004q\u0004\"B0\u0010\u0001\u00049\u0004\"\u00021\u0010\u0001\u0004\u0019\u0006\"B1\u0010\u0001\u0004\u0011\u0007\"\u00027\u0010\u0001\u0004q\u0004\"B7\u0010\u0001\u0004q\u0007\"B;\u0010\u0001\u00049\u0004\"\u0002<\u0010\u0001\u00049\b\"B?\u0010\u0001\u00049\b\"\u0002@\u0010\u0001\u00049\u0018!C:peR\u0014\u0015m]3e!\rA\u0014QE\u0005\u0004\u0003OI$a\u0002\"p_2,\u0017M\\\u0001\u0012C\u001e<')\u001e4gKJLE/\u001a:bi>\u0014\b\u0003B p\u0003[\u00012!LA\u0018\u0013\r\t\tD\b\u0002\u0017\u0003\u001e<'/Z4bi&|gNQ;gM\u0016\u0014XI\u001c;ss\u0006y1\u000f]5mYNK'0\u001a\"fM>\u0014X-\u0006\u0002\u00028A\u0019\u0001(!\u000f\n\u0007\u0005m\u0012H\u0001\u0003M_:<\u0017\u0001E:qS2d7+\u001b>f\u0005\u00164wN]3!\u0003]iWM]4f\u0003\u001e<'/Z4bi&|gNQ;gM\u0016\u00148/\u0006\u0002\u0002DA1\u0001hY9r\u0003\u000b\u00022\u0001OA$\u0013\r\tI%\u000f\u0002\u0005+:LG/\u0001\rnKJ<W-Q4he\u0016<\u0017\r^5p]\n+hMZ3sg\u0002\nq\u0001[1t\u001d\u0016DH/\u0006\u0002\u0002$\u0005!a.\u001a=u)\t\t)\u0006E\u0002L\u0003/J1!!\u0017M\u0005%)fn]1gKJ{w/A\u0013pkR\u0004X\u000f\u001e$pe\u0016k\u0007\u000f^=He>,\b/\u001b8h\u0017\u0016Lx+\u001b;i_V$\u0018J\u001c9vi\u0006Q2M]3bi\u0016tUm^!hOJ,w-\u0019;j_:\u0014UO\u001a4feR\u0011\u0011\u0011\r\t\u0004\u0017\u0006\r\u0014bAA3\u0019\n\u00192\u000b]3dS\u001aL7-\u00138uKJt\u0017\r\u001c*po\u0006)\u0012N\\5u\u0003\u001e<'/Z4bi&|gNQ;gM\u0016\u0014H\u0003BA#\u0003WBq!!\u001c\u001b\u0001\u0004\t\t'\u0001\u0004ck\u001a4WM]\u0001\u001aO\u0016$\u0018iZ4sK\u001e\fG/[8o\u0005V4g-\u001a:Cs.+\u0017\u0010F\u0003r\u0003g\ni\bC\u0004\u0002vm\u0001\r!a\u001e\u0002\u000f!\f7\u000f['baB\u0019Q&!\u001f\n\u0007\u0005mdD\u0001\u000bPE*,7\r^!hOJ,w-\u0019;j_:l\u0015\r\u001d\u0005\b\u0003\u007fZ\u0002\u0019AA+\u0003-9'o\\;qS:<7*Z=\u0002\u001bA\u0014xnY3tg&s\u0007/\u001e;t)\t\t)\u0005")
public class ObjectAggregationIterator
extends AggregationIterator {
    private final Seq<NamedExpression> groupingExpressions;
    private final Seq<Attribute> originalInputAttributes;
    private final Iterator<InternalRow> inputRows;
    private final int fallbackCountThreshold;
    private final SQLMetric numOutputRows;
    private final SQLMetric spillSize;
    private final SQLMetric numTasksFallBacked;
    private boolean sortBased;
    private Iterator<AggregationBufferEntry> aggBufferIterator;
    private final long spillSizeBefore;
    private final Function2<InternalRow, InternalRow, BoxedUnit> mergeAggregationBuffers;

    private long spillSizeBefore() {
        return this.spillSizeBefore;
    }

    private Function2<InternalRow, InternalRow, BoxedUnit> mergeAggregationBuffers() {
        return this.mergeAggregationBuffers;
    }

    public final boolean hasNext() {
        return this.aggBufferIterator.hasNext();
    }

    public final UnsafeRow next() {
        AggregationBufferEntry entry = (AggregationBufferEntry)this.aggBufferIterator.next();
        UnsafeRow res = (UnsafeRow)this.generateOutput().apply((Object)entry.groupingKey(), (Object)entry.aggregationBuffer());
        this.numOutputRows.$plus$eq(1L);
        return res;
    }

    public UnsafeRow outputForEmptyGroupingKeyWithoutInput() {
        if (this.groupingExpressions.isEmpty()) {
            SpecificInternalRow defaultAggregationBuffer = this.createNewAggregationBuffer();
            return (UnsafeRow)this.generateOutput().apply((Object)UnsafeRow.createFromByteArray((int)0, (int)0), (Object)defaultAggregationBuffer);
        }
        throw new IllegalStateException("This method should not be called when groupingExpressions is not empty.");
    }

    private SpecificInternalRow createNewAggregationBuffer() {
        DataType[] bufferFieldTypes = (DataType[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])this.aggregateFunctions()), (Function1 & Serializable)x$4 -> (Seq)x$4.aggBufferAttributes().map((Function1 & Serializable)x$5 -> x$5.dataType()), ClassTag$.MODULE$.apply(DataType.class));
        SpecificInternalRow buffer = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)bufferFieldTypes));
        this.initAggregationBuffer(buffer);
        return buffer;
    }

    private void initAggregationBuffer(SpecificInternalRow buffer) {
        this.expressionAggInitialProjection().target((InternalRow)buffer).apply((Object)package$.MODULE$.EmptyRow());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.collect$extension(Predef$.MODULE$.refArrayOps((Object[])this.aggregateFunctions()), (PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends AggregateFunction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ImperativeAggregate) {
                    ImperativeAggregate imperativeAggregate = (ImperativeAggregate)A1;
                    return (B1)imperativeAggregate;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(AggregateFunction x1) {
                AggregateFunction aggregateFunction = x1;
                return aggregateFunction instanceof ImperativeAggregate;
            }
        }, ClassTag$.MODULE$.apply(ImperativeAggregate.class))), (Function1 & Serializable)x$6 -> {
            x$6.initialize((InternalRow)buffer);
            return BoxedUnit.UNIT;
        });
    }

    private InternalRow getAggregationBufferByKey(ObjectAggregationMap hashMap, UnsafeRow groupingKey) {
        InternalRow aggBuffer;
        block0: {
            aggBuffer = hashMap.getAggregationBuffer(groupingKey);
            if (aggBuffer != null) break block0;
            aggBuffer = this.createNewAggregationBuffer();
            hashMap.putAggregationBuffer(groupingKey.copy(), aggBuffer);
        }
        return aggBuffer;
    }

    private void processInputs() {
        ObjectAggregationMap hashMap = new ObjectAggregationMap();
        SortBasedAggregator sortBasedAggregationStore = null;
        if (this.groupingExpressions.isEmpty()) {
            UnsafeRow groupingKey = this.groupingProjection().apply(null);
            InternalRow buffer = this.getAggregationBufferByKey(hashMap, groupingKey);
            while (this.inputRows.hasNext()) {
                this.processRow().apply((Object)buffer, this.inputRows.next());
            }
        } else {
            while (this.inputRows.hasNext() && !this.sortBased) {
                InternalRow newInput = (InternalRow)this.inputRows.next();
                UnsafeRow groupingKey = this.groupingProjection().apply(newInput);
                InternalRow buffer = this.getAggregationBufferByKey(hashMap, groupingKey);
                this.processRow().apply((Object)buffer, (Object)newInput);
                if (hashMap.size() < this.fallbackCountThreshold || !this.inputRows.hasNext()) continue;
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Aggregation hash map size " + hashMap.size() + " reaches threshold capacity (" + $this.fallbackCountThreshold + " entries), spilling and falling back to sort based aggregation. You may change the threshold by adjust option " + SQLConf$.MODULE$.OBJECT_AGG_SORT_BASED_FALLBACK_THRESHOLD().key());
                this.sortBased = true;
                this.numTasksFallBacked.$plus$eq(1L);
            }
            if (this.sortBased) {
                UnsafeKVExternalSorter.KVSorterIterator sortIteratorFromHashMap = hashMap.dumpToExternalSorter(this.groupingAttributes(), (Seq<AggregateFunction>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)this.aggregateFunctions())).sortedIterator();
                sortBasedAggregationStore = new SortBasedAggregator(sortIteratorFromHashMap, DataTypeUtils$.MODULE$.fromAttributes(this.originalInputAttributes), DataTypeUtils$.MODULE$.fromAttributes(this.groupingAttributes()), this.processRow(), this.mergeAggregationBuffers(), (Function0<InternalRow>)(Function0 & Serializable)() -> this.createNewAggregationBuffer());
                while (this.inputRows.hasNext()) {
                    UnsafeRow unsafeInputRow = (UnsafeRow)this.inputRows.next();
                    UnsafeRow groupingKey = this.groupingProjection().apply((InternalRow)unsafeInputRow);
                    sortBasedAggregationStore.addInput(groupingKey, unsafeInputRow);
                }
            }
        }
        if (this.sortBased) {
            this.aggBufferIterator = sortBasedAggregationStore.destructiveIterator();
            return;
        }
        this.aggBufferIterator = hashMap.destructiveIterator();
    }

    public ObjectAggregationIterator(int partIndex, Seq<Attribute> outputAttributes, Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> aggregateExpressions, Seq<Attribute> aggregateAttributes, int initialInputBufferOffset, Seq<NamedExpression> resultExpressions, Function2<Seq<Expression>, Seq<Attribute>, MutableProjection> newMutableProjection, Seq<Attribute> originalInputAttributes, Iterator<InternalRow> inputRows, int fallbackCountThreshold, SQLMetric numOutputRows, SQLMetric spillSize, SQLMetric numTasksFallBacked) {
        this.groupingExpressions = groupingExpressions;
        this.originalInputAttributes = originalInputAttributes;
        this.inputRows = inputRows;
        this.fallbackCountThreshold = fallbackCountThreshold;
        this.numOutputRows = numOutputRows;
        this.spillSize = spillSize;
        this.numTasksFallBacked = numTasksFallBacked;
        super(partIndex, groupingExpressions, originalInputAttributes, aggregateExpressions, aggregateAttributes, initialInputBufferOffset, resultExpressions, newMutableProjection);
        this.sortBased = false;
        this.spillSizeBefore = TaskContext$.MODULE$.get().taskMetrics().memoryBytesSpilled();
        Seq newExpressions = (Seq)aggregateExpressions.map((Function1 & Serializable)x0$1 -> {
            AggregateMode aggregateMode;
            AggregateMode aggregateMode2;
            AggregateExpression aggregateExpression = x0$1;
            if (aggregateExpression != null && Partial$.MODULE$.equals(aggregateMode2 = aggregateExpression.mode())) {
                PartialMerge$ x$1 = PartialMerge$.MODULE$;
                AggregateFunction x$2 = aggregateExpression.copy$default$1();
                boolean x$3 = aggregateExpression.copy$default$3();
                Option x$4 = aggregateExpression.copy$default$4();
                ExprId x$5 = aggregateExpression.copy$default$5();
                return aggregateExpression.copy(x$2, (AggregateMode)x$1, x$3, x$4, x$5);
            }
            if (aggregateExpression != null && Complete$.MODULE$.equals(aggregateMode = aggregateExpression.mode())) {
                Final$ x$6 = Final$.MODULE$;
                AggregateFunction x$7 = aggregateExpression.copy$default$1();
                boolean x$8 = aggregateExpression.copy$default$3();
                Option x$9 = aggregateExpression.copy$default$4();
                ExprId x$10 = aggregateExpression.copy$default$5();
                return aggregateExpression.copy(x$7, (AggregateMode)x$6, x$8, x$9, x$10);
            }
            return aggregateExpression;
        });
        AggregateFunction[] newFunctions = this.initializeAggregateFunctions((Seq<AggregateExpression>)newExpressions, 0);
        AttributeReference[] newInputAttributes = (AttributeReference[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])newFunctions), (Function1 & Serializable)x$2 -> x$2.inputAggBufferAttributes(), ClassTag$.MODULE$.apply(AttributeReference.class));
        this.mergeAggregationBuffers = this.generateProcessRow((Seq<AggregateExpression>)newExpressions, (Seq<AggregateFunction>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)newFunctions), (Seq<Attribute>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)newInputAttributes));
        this.processInputs();
        TaskContext$.MODULE$.get().addTaskCompletionListener((Function1 & Serializable)x$3 -> {
            this.spillSize.set(TaskContext$.MODULE$.get().taskMetrics().memoryBytesSpilled() - this.spillSizeBefore());
            return BoxedUnit.UNIT;
        });
    }
}

