/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Observation$;
import org.apache.spark.sql.ObservationListener;
import org.apache.spark.sql.catalyst.plans.logical.CollectMetrics;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.QueryExecution;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001\u0002\r\u001a\u0001\tB\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005W!)q\u0007\u0001C\u0001q!)q\u0007\u0001C\u0001y!9Q\b\u0001b\u0001\n\u0013q\u0004B\u0002\"\u0001A\u0003%q\bC\u0004D\u0001\u0001\u0007I\u0011\u0002#\t\u000fq\u0003\u0001\u0019!C\u0005;\"1\u0001\u000b\u0001Q!\n\u0015Cq\u0001\u001b\u0001A\u0002\u0013%\u0011\u000eC\u0004o\u0001\u0001\u0007I\u0011B8\t\rE\u0004\u0001\u0015)\u0003k\u0011\u0019\u0019\b\u0001\"\u0001\u001ci\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA-\u0001\u0011\u0005\u00111\f\u0005\b\u0003o\u0002A\u0011BA=\u0011\u001d\t9\t\u0001C\u0005\u0003\u0013C\u0001\"a#\u0001\t\u0003Y\u0012QR\u0004\b\u0003?K\u0002\u0012AAQ\r\u0019A\u0012\u0004#\u0001\u0002$\"1q\u0007\u0006C\u0001\u0003KCa!a*\u0015\t\u0003a\u0004bBAT)\u0011\u0005\u0011\u0011\u0016\u0002\f\u001f\n\u001cXM\u001d<bi&|gN\u0003\u0002\u001b7\u0005\u00191/\u001d7\u000b\u0005qi\u0012!B:qCJ\\'B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001GA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\fAA\\1nKV\t1\u0006\u0005\u0002-g9\u0011Q&\r\t\u0003]\u0015j\u0011a\f\u0006\u0003a\u0005\na\u0001\u0010:p_Rt\u0014B\u0001\u001a&\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I*\u0013!\u00028b[\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002:wA\u0011!\bA\u0007\u00023!)\u0011f\u0001a\u0001WQ\t\u0011(\u0001\u0005mSN$XM\\3s+\u0005y\u0004C\u0001\u001eA\u0013\t\t\u0015DA\nPEN,'O^1uS>tG*[:uK:,'/A\u0005mSN$XM\\3sA\u0005\u0011Am]\u000b\u0002\u000bB\u0019AE\u0012%\n\u0005\u001d+#AB(qi&|g\u000e\r\u0002J\u001dB\u0019!H\u0013'\n\u0005-K\"a\u0002#bi\u0006\u001cX\r\u001e\t\u0003\u001b:c\u0001\u0001B\u0005P\u0013\u0005\u0005\t\u0011!B\u0001+\n\u0019q\fJ\u0019\u0002\u0007\u0011\u001c\b\u0005\u000b\u0002\n%B\u0011AeU\u0005\u0003)\u0016\u0012\u0001B^8mCRLG.Z\t\u0003-f\u0003\"\u0001J,\n\u0005a+#a\u0002(pi\"Lgn\u001a\t\u0003IiK!aW\u0013\u0003\u0007\u0005s\u00170\u0001\u0004eg~#S-\u001d\u000b\u0003=\u0006\u0004\"\u0001J0\n\u0005\u0001,#\u0001B+oSRDqA\u0019\u0005\u0002\u0002\u0003\u00071-A\u0002yIE\u00022\u0001\n$ea\t)w\rE\u0002;\u0015\u001a\u0004\"!T4\u0005\u0013=\u000b\u0017\u0011!A\u0001\u0006\u0003)\u0016aB7fiJL7m]\u000b\u0002UB\u0019AER6\u0011\t1b7&W\u0005\u0003[V\u00121!T1q\u0003-iW\r\u001e:jGN|F%Z9\u0015\u0005y\u0003\bb\u00022\f\u0003\u0003\u0005\rA[\u0001\t[\u0016$(/[2tA!\u0012ABU\u0001\u0003_:,\"!\u001e=\u0015\u000bYT80!\u0001\u0011\u0007iRu\u000f\u0005\u0002Nq\u0012)\u00110\u0004b\u0001+\n\tA\u000bC\u0003D\u001b\u0001\u0007a\u000fC\u0003}\u001b\u0001\u0007Q0\u0001\u0003fqB\u0014\bC\u0001\u001e\u007f\u0013\ty\u0018D\u0001\u0004D_2,XN\u001c\u0005\b\u0003\u0007i\u0001\u0019AA\u0003\u0003\u0015)\u0007\u0010\u001d:t!\u0011!\u0013qA?\n\u0007\u0005%QE\u0001\u0006=e\u0016\u0004X-\u0019;fIz\n1aZ3u+\t\ty\u0001\r\u0003\u0002\u0012\u0005U\u0001#\u0002\u0017mW\u0005M\u0001cA'\u0002\u0016\u0011Q\u0011q\u0003\b\u0002\u0002\u0003\u0005)\u0011A+\u0003\u0007}##\u0007K\u0003\u000f\u00037\t\u0019\u0004E\u0003%\u0003;\t\t#C\u0002\u0002 \u0015\u0012a\u0001\u001e5s_^\u001c\b\u0003BA\u0012\u0003[qA!!\n\u0002*9\u0019a&a\n\n\u0003\u0019J1!a\u000b&\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\f\u00022\t!\u0012J\u001c;feJ,\b\u000f^3e\u000bb\u001cW\r\u001d;j_:T1!a\u000b&c\u0019q2&!\u000e\u0002XEJ1%a\u000e\u0002<\u00055\u0013QH\u000b\u0004U\u0005eBAB=\"\u0005\u0004\t\u0019%\u0003\u0003\u0002>\u0005}\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002B\u0015\na\u0001\u001e5s_^\u001c\u0018c\u0001,\u0002FA!\u0011qIA%\u001d\r!\u0013\u0011F\u0005\u0005\u0003\u0017\n\tDA\u0005UQJ|w/\u00192mKFJ1%a\u0014\u0002R\u0005M\u0013\u0011\t\b\u0004I\u0005E\u0013bAA!KE*!\u0005J\u0013\u0002V\t)1oY1mCF\u001aa%!\t\u0002\u0013\u001d,G/Q:KCZ\fWCAA/!\u0019\ty&!\u001b,G5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'\u0001\u0003vi&d'BAA4\u0003\u0011Q\u0017M^1\n\u00075\f\t\u0007K\u0003\u0010\u00037\ti'\r\u0004\u001fW\u0005=\u0014QO\u0019\nG\u0005]\u00121HA9\u0003{\t\u0014bIA(\u0003#\n\u0019(!\u00112\u000b\t\"S%!\u00162\u0007\u0019\n\t#\u0001\u0005sK\u001eL7\u000f^3s)\rq\u00161\u0010\u0005\u0007\u0007B\u0001\r!! 1\t\u0005}\u00141\u0011\t\u0005u)\u000b\t\tE\u0002N\u0003\u0007#1\"!\"\u0002|\u0005\u0005\t\u0011!B\u0001+\n\u0019q\fJ\u001a\u0002\u0015Ut'/Z4jgR,'\u000fF\u0001_\u0003!ygNR5oSNDGc\u00010\u0002\u0010\"9\u0011\u0011\u0013\nA\u0002\u0005M\u0015AA9f!\u0011\t)*a'\u000e\u0005\u0005]%bAAM3\u0005IQ\r_3dkRLwN\\\u0005\u0005\u0003;\u000b9J\u0001\bRk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8\u0002\u0017=\u00137/\u001a:wCRLwN\u001c\t\u0003uQ\u0019\"\u0001F\u0012\u0015\u0005\u0005\u0005\u0016!B1qa2LHcA\u001d\u0002,\")\u0011f\u0006a\u0001W\u0001")
public class Observation {
    private final String name;
    private final ObservationListener listener;
    private volatile Option<Dataset<?>> ds;
    private volatile Option<scala.collection.immutable.Map<String, Object>> metrics;

    public static Observation apply(String name) {
        return Observation$.MODULE$.apply(name);
    }

    public static Observation apply() {
        return Observation$.MODULE$.apply();
    }

    public String name() {
        return this.name;
    }

    private ObservationListener listener() {
        return this.listener;
    }

    private Option<Dataset<?>> ds() {
        return this.ds;
    }

    private void ds_$eq(Option<Dataset<?>> x$1) {
        this.ds = x$1;
    }

    private Option<scala.collection.immutable.Map<String, Object>> metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Option<scala.collection.immutable.Map<String, Object>> x$1) {
        this.metrics = x$1;
    }

    public <T> Dataset<T> on(Dataset<T> ds, Column expr, Seq<Column> exprs) {
        if (ds.isStreaming()) {
            throw new IllegalArgumentException("Observation does not support streaming Datasets.This is because there will be multiple observed metrics as microbatches are constructed. Please register a StreamingQueryListener and get the metric for each microbatch in QueryProgressEvent.progress, or use query.lastProgress or query.recentProgress.");
        }
        this.register(ds);
        return ds.observe(this.name(), expr, exprs);
    }

    public scala.collection.immutable.Map<String, Object> get() throws InterruptedException {
        Observation observation = this;
        synchronized (observation) {
            while (this.metrics().isEmpty()) {
                this.wait();
            }
        }
        return (scala.collection.immutable.Map)this.metrics().get();
    }

    public java.util.Map<String, Object> getAsJava() throws InterruptedException {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)this.get().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                return new Tuple2((Object)key, value);
            }
            throw new MatchError((Object)tuple2);
        })).asJava();
    }

    private void register(Dataset<?> ds) {
        Observation observation = this;
        synchronized (observation) {
            if (this.ds().isDefined()) {
                throw new IllegalArgumentException("An Observation can be used with a Dataset only once");
            }
            this.ds_$eq((Option<Dataset<?>>)new Some(ds));
        }
        ds.sparkSession().listenerManager().register(this.listener());
    }

    private void unregister() {
        this.ds().foreach((Function1 & Serializable)x$1 -> {
            Observation.$anonfun$unregister$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void onFinish(QueryExecution qe) {
        if (this.metrics().isEmpty() && qe.logical().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Observation.$anonfun$onFinish$1(this, x0$1)))) {
            Option row = qe.observedMetrics().get((Object)this.name());
            this.metrics_$eq((Option<scala.collection.immutable.Map<String, Object>>)row.map((Function1 & Serializable)r -> r.getValuesMap((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)r.schema().fieldNames()))));
            if (this.metrics().isDefined()) {
                this.notifyAll();
                this.unregister();
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$unregister$1(Observation $this, Dataset x$1) {
        x$1.sparkSession().listenerManager().unregister($this.listener());
    }

    public static final /* synthetic */ boolean $anonfun$onFinish$1(Observation $this, LogicalPlan x0$1) {
        LogicalPlan logicalPlan2 = x0$1;
        if (logicalPlan2 instanceof CollectMetrics) {
            CollectMetrics collectMetrics = (CollectMetrics)logicalPlan2;
            String name = collectMetrics.name();
            long dataframeId = collectMetrics.dataframeId();
            String string = name;
            String string2 = $this.name();
            return !(string != null ? !string.equals(string2) : string2 != null) && dataframeId == ((Dataset)$this.ds().get()).id();
        }
        return false;
    }

    public Observation(String name) {
        this.name = name;
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        this.listener = new ObservationListener(this);
        this.ds = None$.MODULE$;
        this.metrics = None$.MODULE$;
    }

    public Observation() {
        this(UUID.randomUUID().toString());
    }
}

