/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.AppendData$;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect$;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OptionList;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic$;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect$;
import org.apache.spark.sql.catalyst.plans.logical.TableSpecBase;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedTableSpec;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Stable
@ScalaSignature(bytes="\u0006\u0005\r}b\u0001\u0002!B\u0005)C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\u0007E\u0002!\t!Q2\t\u000f\u0019\u0004!\u0019!C\u0005O\"1q\u000e\u0001Q\u0001\n!DQ\u0001\u001d\u0001\u0005\u0002EDQ\u0001\u001d\u0001\u0005\u0002]Dq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u001e!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005%\u0002bBA\t\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\t\t\u0005\u0001C\u0001\u0003'Bq!!\u001a\u0001\t\u0003\t9\u0007C\u0004\u0002\u0002\u0002!\t!a!\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006bBAQ\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003c\u0003A\u0011BAZ\u0011\u001d\ti\f\u0001C\u0005\u0003\u007fCq!!5\u0001\t\u0013\t\u0019\u000eC\u0004\u0002X\u0002!\t!!7\t\u000f\u0005]\u0007\u0001\"\u0003\u0002`\"9\u0011q\u001b\u0001\u0005\n\u0005u\bb\u0002B\u0006\u0001\u0011%!Q\u0002\u0005\b\u00057\u0001A\u0011\u0002B\u000f\u0011\u001d\u0011\u0019\u0003\u0001C\u0005\u0005KAqA!\u000b\u0001\t\u0003\u0011Y\u0003C\u0004\u0003*\u0001!IAa\f\t\u000f\t%\u0002\u0001\"\u0003\u0003P!9!1\u000b\u0001\u0005\n\tU\u0003b\u0002B-\u0001\u0011%!1\f\u0005\b\u0005W\u0002A\u0011\u0002B7\u0011\u001d\u0011I\b\u0001C\u0001\u0005wBqAa$\u0001\t\u0003\u0011\t\nC\u0004\u0003\u0016\u0002!\tAa&\t\u000f\tm\u0005\u0001\"\u0001\u0003\u001e\"9!\u0011\u0015\u0001\u0005\u0002\t\r\u0006b\u0002BT\u0001\u0011\u0005!\u0011\u0016\u0005\b\u0005[\u0003A\u0011\u0001BX\u0011\u001d\u0011\u0019\f\u0001C\u0005\u0005kCqAa6\u0001\t\u0013\u0011I\u000eC\u0005\u0002\u0010\u0001\u0001\r\u0011\"\u0003\u0003d\"I!Q\u001d\u0001A\u0002\u0013%!q\u001d\u0005\b\u0005[\u0004\u0001\u0015)\u0003z\u0011!\u0001\b\u00011A\u0005\n\t=\b\"\u0003By\u0001\u0001\u0007I\u0011\u0002Bz\u0011\u001d\u00119\u0010\u0001Q!\nQD\u0011B!?\u0001\u0001\u0004%IAa?\t\u0013\tu\b\u00011A\u0005\n\t}\b\u0002CB\u0002\u0001\u0001\u0006K!!1\t\u0013\r\u0015\u0001\u00011A\u0005\n\r\u001d\u0001\"CB\u0006\u0001\u0001\u0007I\u0011BB\u0007\u0011!\u0019\t\u0002\u0001Q!\n\r%\u0001\"CB\n\u0001\u0001\u0007I\u0011BB\u0004\u0011%\u0019)\u0002\u0001a\u0001\n\u0013\u00199\u0002\u0003\u0005\u0004\u001c\u0001\u0001\u000b\u0015BB\u0005\u0011%\t9\t\u0001a\u0001\n\u0013\u0019i\u0002C\u0005\u0004\"\u0001\u0001\r\u0011\"\u0003\u0004$!A1q\u0005\u0001!B\u0013\u0019y\u0002C\u0005\u0004*\u0001\u0001\r\u0011\"\u0003\u0004\b!I11\u0006\u0001A\u0002\u0013%1Q\u0006\u0005\t\u0007c\u0001\u0001\u0015)\u0003\u0004\n\tyA)\u0019;b\rJ\fW.Z,sSR,'O\u0003\u0002C\u0007\u0006\u00191/\u001d7\u000b\u0005\u0011+\u0015!B:qCJ\\'B\u0001$H\u0003\u0019\t\u0007/Y2iK*\t\u0001*A\u0002pe\u001e\u001c\u0001!\u0006\u0002L3N\u0011\u0001\u0001\u0014\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0007\u0003:L(+\u001a4\u0002\u0005\u0011\u001c\bc\u0001+V/6\t\u0011)\u0003\u0002W\u0003\n9A)\u0019;bg\u0016$\bC\u0001-Z\u0019\u0001!QA\u0017\u0001C\u0002m\u0013\u0011\u0001V\t\u00039~\u0003\"!T/\n\u0005ys%a\u0002(pi\"Lgn\u001a\t\u0003\u001b\u0002L!!\u0019(\u0003\u0007\u0005s\u00170\u0001\u0004=S:LGO\u0010\u000b\u0003I\u0016\u00042\u0001\u0016\u0001X\u0011\u0015\u0011&\u00011\u0001T\u0003\t!g-F\u0001i!\tIGN\u0004\u0002UU&\u00111.Q\u0001\ba\u0006\u001c7.Y4f\u0013\tigNA\u0005ECR\fgI]1nK*\u00111.Q\u0001\u0004I\u001a\u0004\u0013\u0001B7pI\u0016$\"\u0001\u001a:\t\u000bM,\u0001\u0019\u0001;\u0002\u0011M\fg/Z'pI\u0016\u0004\"\u0001V;\n\u0005Y\f%\u0001C*bm\u0016lu\u000eZ3\u0015\u0005\u0011D\b\"B:\u0007\u0001\u0004I\bc\u0001>\u0002\u00049\u00111p \t\u0003y:k\u0011! \u0006\u0003}&\u000ba\u0001\u0010:p_Rt\u0014bAA\u0001\u001d\u00061\u0001K]3eK\u001aLA!!\u0002\u0002\b\t11\u000b\u001e:j]\u001eT1!!\u0001O\u0003\u00191wN]7biR\u0019A-!\u0004\t\r\u0005=q\u00011\u0001z\u0003\u0019\u0019x.\u001e:dK\u00061q\u000e\u001d;j_:$R\u0001ZA\u000b\u00033Aa!a\u0006\t\u0001\u0004I\u0018aA6fs\"1\u00111\u0004\u0005A\u0002e\fQA^1mk\u0016$R\u0001ZA\u0010\u0003CAa!a\u0006\n\u0001\u0004I\bbBA\u000e\u0013\u0001\u0007\u00111\u0005\t\u0004\u001b\u0006\u0015\u0012bAA\u0014\u001d\n9!i\\8mK\u0006tG#\u00023\u0002,\u00055\u0002BBA\f\u0015\u0001\u0007\u0011\u0010C\u0004\u0002\u001c)\u0001\r!a\f\u0011\u00075\u000b\t$C\u0002\u000249\u0013A\u0001T8oOR)A-a\u000e\u0002:!1\u0011qC\u0006A\u0002eDq!a\u0007\f\u0001\u0004\tY\u0004E\u0002N\u0003{I1!a\u0010O\u0005\u0019!u.\u001e2mK\u00069q\u000e\u001d;j_:\u001cHc\u00013\u0002F!9\u0011\u0011\t\u0007A\u0002\u0005\u001d\u0003CBA%\u0003\u001fJ\u00180\u0004\u0002\u0002L)\u0019\u0011Q\n(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002R\u0005-#aA'baR\u0019A-!\u0016\t\u000f\u0005\u0005S\u00021\u0001\u0002XA1\u0011\u0011LA2sfl!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u0005kRLGN\u0003\u0002\u0002b\u0005!!.\u0019<b\u0013\u0011\t\t&a\u0017\u0002\u0017A\f'\u000f^5uS>t')\u001f\u000b\u0004I\u0006%\u0004bBA6\u001d\u0001\u0007\u0011QN\u0001\tG>dg*Y7fgB!Q*a\u001cz\u0013\r\t\tH\u0014\u0002\u000byI,\u0007/Z1uK\u0012t\u0004f\u0001\b\u0002vA!\u0011qOA?\u001b\t\tIHC\u0002\u0002|9\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ty(!\u001f\u0003\u000fY\f'/\u0019:hg\u0006A!-^2lKR\u0014\u0015\u0010F\u0004e\u0003\u000b\u000by)a%\t\u000f\u0005\u001du\u00021\u0001\u0002\n\u0006Qa.^7Ck\u000e\\W\r^:\u0011\u00075\u000bY)C\u0002\u0002\u000e:\u00131!\u00138u\u0011\u0019\t\tj\u0004a\u0001s\u000691m\u001c7OC6,\u0007bBA6\u001f\u0001\u0007\u0011Q\u000e\u0015\u0004\u001f\u0005U\u0014AB:peR\u0014\u0015\u0010F\u0003e\u00037\u000bi\n\u0003\u0004\u0002\u0012B\u0001\r!\u001f\u0005\b\u0003W\u0002\u0002\u0019AA7Q\r\u0001\u0012QO\u0001\u0005g\u00064X\r\u0006\u0003\u0002&\u0006-\u0006cA'\u0002(&\u0019\u0011\u0011\u0016(\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003[\u000b\u0002\u0019A=\u0002\tA\fG\u000f\u001b\u000b\u0003\u0003K\u000bAb]1wK&sG/\u001a:oC2$B!!*\u00026\"9\u0011QV\nA\u0002\u0005]\u0006\u0003B'\u0002:fL1!a/O\u0005\u0019y\u0005\u000f^5p]\u0006\u0011r-\u001a;PaRLwN\\:XSRD\u0007+\u0019;i)\u0011\t\t-a4\u0011\u000b\u0005\r\u00171Z=\u000e\u0005\u0005\u0015'\u0002BA/\u0003\u000fT1!!3B\u0003!\u0019\u0017\r^1msN$\u0018\u0002BAg\u0003\u000b\u0014!cQ1tK&s7/\u001a8tSRLg/Z'ba\"9\u0011Q\u0016\u000bA\u0002\u0005]\u0016AD:bm\u0016$vNV\u0019T_V\u00148-\u001a\u000b\u0005\u0003K\u000b)\u000eC\u0004\u0002.V\u0001\r!a.\u0002\u0015%t7/\u001a:u\u0013:$x\u000e\u0006\u0003\u0002&\u0006m\u0007BBAo-\u0001\u0007\u00110A\u0005uC\ndWMT1nKR1\u0011QUAq\u0003gDq!a9\u0018\u0001\u0004\t)/A\u0004dCR\fGn\\4\u0011\t\u0005\u001d\u0018q^\u0007\u0003\u0003STA!a9\u0002l*\u0019\u0011Q^!\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002BAy\u0003S\u0014QbQ1uC2|w\r\u00157vO&t\u0007bBA{/\u0001\u0007\u0011q_\u0001\u0006S\u0012,g\u000e\u001e\t\u0005\u0003O\fI0\u0003\u0003\u0002|\u0006%(AC%eK:$\u0018NZ5feR!\u0011QUA\u0000\u0011\u001d\u0011\t\u0001\u0007a\u0001\u0005\u0007\t!\u0002^1cY\u0016LE-\u001a8u!\u0011\u0011)Aa\u0002\u000e\u0005\u0005\u001d\u0017\u0002\u0002B\u0005\u0003\u000f\u0014q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM]\u0001\u000eO\u0016$()^2lKR\u001c\u0006/Z2\u0016\u0005\t=\u0001#B'\u0002:\nE\u0001\u0003\u0002B\n\u0005/i!A!\u0006\u000b\t\u0005\r\u0018qY\u0005\u0005\u00053\u0011)B\u0001\u0006Ck\u000e\\W\r^*qK\u000e\f\u0011#Y:tKJ$hj\u001c;Ck\u000e\\W\r^3e)\u0011\t)Ka\b\t\r\t\u0005\"\u00041\u0001z\u0003%y\u0007/\u001a:bi&|g.\u0001\u000bbgN,'\u000f\u001e(piB\u000b'\u000f^5uS>tW\r\u001a\u000b\u0005\u0003K\u00139\u0003\u0003\u0004\u0003\"m\u0001\r!_\u0001\fg\u00064X-Q:UC\ndW\r\u0006\u0003\u0002&\n5\u0002BBAo9\u0001\u0007\u0011\u0010\u0006\u0005\u0002&\nE\"\u0011\bB\u001e\u0011\u001d\t\u0019/\ba\u0001\u0005g\u0001B!a:\u00036%!!qGAu\u00051!\u0016M\u00197f\u0007\u0006$\u0018\r\\8h\u0011\u001d\t)0\ba\u0001\u0003oDqA!\u0010\u001e\u0001\u0004\u0011y$A\u0005oC6,\u0007+\u0019:ugB)!\u0011\tB%s:!!1\tB$\u001d\ra(QI\u0005\u0002\u001f&\u00111NT\u0005\u0005\u0005\u0017\u0012iEA\u0002TKFT!a\u001b(\u0015\t\u0005\u0015&\u0011\u000b\u0005\b\u0005\u0003q\u0002\u0019\u0001B\u0002\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\t\u0005\u0015&q\u000b\u0005\b\u0005\u0003y\u0002\u0019\u0001B\u0002\u0003A\u0001\u0018M\u001d;ji&|g.\u001b8h\u0003N4&'\u0006\u0002\u0003^A1!\u0011\tB%\u0005?\u0002BA!\u0019\u0003h5\u0011!1\r\u0006\u0005\u0005K\nY/A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002\u0002B5\u0005G\u0012\u0011\u0002\u0016:b]N4wN]7\u0002?\rDWmY6QCJ$\u0018\u000e^5p]&tw-T1uG\",7O\u0016\u001aUC\ndW\r\u0006\u0003\u0002&\n=\u0004b\u0002B9C\u0001\u0007!1O\u0001\u000eKbL7\u000f^5oOR\u000b'\r\\3\u0011\t\u0005\u001d(QO\u0005\u0005\u0005o\nIOA\u0003UC\ndW-\u0001\u0003kI\n\u001cG\u0003CAS\u0005{\u0012\tI!\"\t\r\t}$\u00051\u0001z\u0003\r)(\u000f\u001c\u0005\u0007\u0005\u0007\u0013\u0003\u0019A=\u0002\u000bQ\f'\r\\3\t\u000f\t\u001d%\u00051\u0001\u0003\n\u0006!2m\u001c8oK\u000e$\u0018n\u001c8Qe>\u0004XM\u001d;jKN\u0004B!!\u0017\u0003\f&!!QRA.\u0005)\u0001&o\u001c9feRLWm]\u0001\u0005UN|g\u000e\u0006\u0003\u0002&\nM\u0005BBAWG\u0001\u0007\u00110A\u0004qCJ\fX/\u001a;\u0015\t\u0005\u0015&\u0011\u0014\u0005\u0007\u0003[#\u0003\u0019A=\u0002\u0007=\u00148\r\u0006\u0003\u0002&\n}\u0005BBAWK\u0001\u0007\u00110\u0001\u0003uKb$H\u0003BAS\u0005KCa!!,'\u0001\u0004I\u0018aA2tmR!\u0011Q\u0015BV\u0011\u0019\tik\na\u0001s\u0006\u0019\u00010\u001c7\u0015\t\u0005\u0015&\u0011\u0017\u0005\u0007\u0003[C\u0003\u0019A=\u0002\u0015I,hnQ8n[\u0006tG\r\u0006\u0003\u00038\n5G\u0003BAS\u0005sCqAa/*\u0001\u0004\u0011i,A\u0004d_6l\u0017M\u001c3\u0011\t\t}&\u0011Z\u0007\u0003\u0005\u0003TAAa1\u0003F\u00069An\\4jG\u0006d'\u0002\u0002Bd\u0003\u000f\fQ\u0001\u001d7b]NLAAa3\u0003B\nYAj\\4jG\u0006d\u0007\u000b\\1o\u0011\u001d\u0011y-\u000ba\u0001\u0005#\fqa]3tg&|g\u000eE\u0002U\u0005'L1A!6B\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003Aawn\\6vaZ\u0013\u0004K]8wS\u0012,'\u000f\u0006\u0002\u0003\\B)Q*!/\u0003^B!\u0011q\u001dBp\u0013\u0011\u0011\t/!;\u0003\u001bQ\u000b'\r\\3Qe>4\u0018\u000eZ3s+\u0005I\u0018AC:pkJ\u001cWm\u0018\u0013fcR!\u0011Q\u0015Bu\u0011!\u0011Y\u000fLA\u0001\u0002\u0004I\u0018a\u0001=%c\u000591o\\;sG\u0016\u0004S#\u0001;\u0002\u00115|G-Z0%KF$B!!*\u0003v\"A!1^\u0018\u0002\u0002\u0003\u0007A/A\u0003n_\u0012,\u0007%\u0001\u0007fqR\u0014\u0018m\u00149uS>t7/\u0006\u0002\u0002B\u0006\u0001R\r\u001f;sC>\u0003H/[8og~#S-\u001d\u000b\u0005\u0003K\u001b\t\u0001C\u0005\u0003lJ\n\t\u00111\u0001\u0002B\u0006iQ\r\u001f;sC>\u0003H/[8og\u0002\n1\u0003]1si&$\u0018n\u001c8j]\u001e\u001cu\u000e\\;n]N,\"a!\u0003\u0011\u000b5\u000bILa\u0010\u0002/A\f'\u000f^5uS>t\u0017N\\4D_2,XN\\:`I\u0015\fH\u0003BAS\u0007\u001fA\u0011Ba;6\u0003\u0003\u0005\ra!\u0003\u0002)A\f'\u000f^5uS>t\u0017N\\4D_2,XN\\:!\u0003E\u0011WoY6fi\u000e{G.^7o\u001d\u0006lWm]\u0001\u0016EV\u001c7.\u001a;D_2,XN\u001c(b[\u0016\u001cx\fJ3r)\u0011\t)k!\u0007\t\u0013\t-\b(!AA\u0002\r%\u0011A\u00052vG.,GoQ8mk6tg*Y7fg\u0002*\"aa\b\u0011\u000b5\u000bI,!#\u0002\u001d9,XNQ;dW\u0016$8o\u0018\u0013fcR!\u0011QUB\u0013\u0011%\u0011YoOA\u0001\u0002\u0004\u0019y\"A\u0006ok6\u0014UoY6fiN\u0004\u0013aD:peR\u001cu\u000e\\;n]:\u000bW.Z:\u0002'M|'\u000f^\"pYVlgNT1nKN|F%Z9\u0015\t\u0005\u00156q\u0006\u0005\n\u0005Wt\u0014\u0011!a\u0001\u0007\u0013\t\u0001c]8si\u000e{G.^7o\u001d\u0006lWm\u001d\u0011)\u0007\u0001\u0019)\u0004\u0005\u0003\u00048\rmRBAB\u001d\u0015\r\tYhQ\u0005\u0005\u0007{\u0019ID\u0001\u0004Ti\u0006\u0014G.\u001a")
public final class DataFrameWriter<T> {
    private final Dataset<Row> df;
    private String source;
    private SaveMode mode;
    private CaseInsensitiveMap<String> extraOptions;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> bucketColumnNames;
    private Option<Object> numBuckets;
    private Option<Seq<String>> sortColumnNames;

    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataFrameWriter<T> mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter<T> mode(String saveMode) {
        block14: {
            String string = saveMode.toLowerCase(Locale.ROOT);
            switch (string == null ? 0 : string.hashCode()) {
                case -1411068134: {
                    if ("append".equals(string)) {
                        return this.mode(SaveMode.Append);
                    }
                    break block14;
                }
                case -1190396462: {
                    if ("ignore".equals(string)) {
                        return this.mode(SaveMode.Ignore);
                    }
                    break block14;
                }
                case -745078901: {
                    if ("overwrite".equals(string)) {
                        return this.mode(SaveMode.Overwrite);
                    }
                    break block14;
                }
                case 96784904: {
                    if ("error".equals(string)) {
                        break;
                    }
                    break block14;
                }
                case 691225025: {
                    if ("errorifexists".equals(string)) {
                        break;
                    }
                    break block14;
                }
                case 1544803905: {
                    if ("default".equals(string)) {
                        break;
                    }
                    break block14;
                }
                default: {
                    break block14;
                }
            }
            return this.mode(SaveMode.ErrorIfExists);
        }
        throw new IllegalArgumentException("Unknown save mode: " + saveMode + ". Accepted save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists', 'default'.");
    }

    public DataFrameWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter<T> option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataFrameWriter<T> option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataFrameWriter<T> option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataFrameWriter<T> option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public DataFrameWriter<T> options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(options).asScala());
        return this;
    }

    public DataFrameWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        this.numBuckets_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)));
        String string = colName;
        this.bucketColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string)));
        return this;
    }

    public DataFrameWriter<T> sortBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.sortColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string)));
        return this;
    }

    public void save(String path) {
        if (!this.df().sparkSession().sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw QueryCompilationErrors$.MODULE$.pathOptionNotSetCorrectlyWhenWritingError();
        }
        this.saveInternal((Option<String>)new Some((Object)path));
    }

    public void save() {
        this.saveInternal((Option<String>)None$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveInternal(Option<String> path) {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("write");
        }
        this.assertNotBucketed("save");
        Option<TableProvider> maybeV2Provider = this.lookupV2Provider();
        if (maybeV2Provider.isDefined()) {
            TableProvider provider = (TableProvider)maybeV2Provider.get();
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(provider, this.df().sparkSession().sessionState().conf());
            CaseInsensitiveMap<String> optionsWithPath = this.getOptionsWithPath(path);
            scala.collection.immutable.Map finalOptions = (scala.collection.immutable.Map)sessionOptions.view().filterKeys((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataFrameWriter.$anonfun$saveInternal$1(optionsWithPath, x$1))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)optionsWithPath.originalMap());
            CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)finalOptions).asJava());
            CatalogManager catalogManager = this.df().sparkSession().sessionState().catalogManager();
            SaveMode saveMode = this.mode();
            if (SaveMode.Append.equals(saveMode) ? true : SaveMode.Overwrite.equals(saveMode)) {
                Tuple3 tuple3;
                TableProvider tableProvider = provider;
                if (tableProvider instanceof SupportsCatalogOptions) {
                    SupportsCatalogOptions supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                    Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                    TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                    tuple3 = new Tuple3((Object)catalog.loadTable(ident), (Object)new Some((Object)catalog), (Object)new Some((Object)ident));
                } else {
                    if (tableProvider == null) throw new MatchError((Object)tableProvider);
                    Table t = this.getTable$1(provider, dsOptions);
                    if (DataSourceV2Implicits$.MODULE$.TableHelper(t).supports(TableCapability.BATCH_WRITE)) {
                        tuple3 = new Tuple3((Object)t, (Object)None$.MODULE$, (Object)None$.MODULE$);
                    } else {
                        this.saveToV1Source(path);
                        return;
                    }
                }
                Tuple3 tuple32 = tuple3;
                if (tuple32 == null) {
                    throw new MatchError((Object)tuple32);
                }
                Table table = (Table)tuple32._1();
                Option catalog = (Option)tuple32._2();
                Option ident = (Option)tuple32._3();
                Tuple3 tuple33 = new Tuple3((Object)table, (Object)catalog, (Object)ident);
                Table table2 = (Table)tuple33._1();
                Option catalog2 = (Option)tuple33._2();
                Option ident2 = (Option)tuple33._3();
                DataSourceV2Relation relation = DataSourceV2Relation$.MODULE$.create(table2, catalog2, ident2, dsOptions);
                this.checkPartitioningMatchesV2Table(table2);
                SaveMode saveMode2 = this.mode();
                SaveMode saveMode3 = SaveMode.Append;
                if (!(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null)) {
                    this.runCommand(this.df().sparkSession(), (LogicalPlan)AppendData$.MODULE$.byName((NamedRelation)relation, this.df().logicalPlan(), finalOptions));
                    return;
                }
                this.runCommand(this.df().sparkSession(), (LogicalPlan)OverwriteByExpression$.MODULE$.byName((NamedRelation)relation, this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), finalOptions));
                return;
            }
            TableProvider tableProvider = provider;
            if (tableProvider instanceof SupportsCatalogOptions) {
                SupportsCatalogOptions supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                UnresolvedTableSpec tableSpec = new UnresolvedTableSpec(Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), new OptionList((Seq)package$.MODULE$.Seq().empty()), this.extraOptions().get("path"), this.extraOptions().get("comment"), (Option)None$.MODULE$, false);
                String string3 = catalog.name();
                SaveMode saveMode4 = saveMode;
                SaveMode saveMode5 = SaveMode.Ignore;
                this.runCommand(this.df().sparkSession(), (LogicalPlan)new CreateTableAsSelect((LogicalPlan)new UnresolvedIdentifier((Seq)((SeqOps)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).$plus$colon((Object)string3)).$colon$plus((Object)ident.name()), UnresolvedIdentifier$.MODULE$.apply$default$2()), this.partitioningAsV2(), this.df().queryExecution().analyzed(), (TableSpecBase)tableSpec, finalOptions, !(saveMode4 != null ? !saveMode4.equals(saveMode5) : saveMode5 != null), CreateTableAsSelect$.MODULE$.apply$default$7()));
                return;
            } else {
                if (tableProvider == null) throw new MatchError((Object)tableProvider);
                if (DataSourceV2Implicits$.MODULE$.TableHelper(this.getTable$1(provider, dsOptions)).supports(TableCapability.BATCH_WRITE)) {
                    throw QueryCompilationErrors$.MODULE$.writeWithSaveModeUnsupportedBySourceError(this.source(), saveMode.name());
                }
                this.saveToV1Source(path);
            }
            return;
        }
        this.saveToV1Source(path);
    }

    private CaseInsensitiveMap<String> getOptionsWithPath(Option<String> path) {
        if (path.isEmpty()) {
            return this.extraOptions();
        }
        return this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), path.get()));
    }

    private void saveToV1Source(Option<String> path) {
        this.partitioningColumns().foreach((Function1 & Serializable)columns -> {
            this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.PARTITIONING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)columns))));
            return BoxedUnit.UNIT;
        });
        CaseInsensitiveMap<String> optionsWithPath = this.getOptionsWithPath(path);
        SparkSession x$1 = this.df().sparkSession();
        String x$2 = this.source();
        Seq x$3 = (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        scala.collection.immutable.Map x$4 = optionsWithPath.originalMap();
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        this.runCommand(this.df().sparkSession(), new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$3, x$7, (scala.collection.immutable.Map<String, String>)x$4, x$8).planForWriting(this.mode(), this.df().logicalPlan()));
    }

    public void insertInto(String tableName) {
        Option option;
        Option option2;
        Option option3;
        this.assertNotBucketed("insertInto");
        if (this.partitioningColumns().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.partitionByDoesNotAllowedWhenUsingInsertIntoError();
        }
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined();
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        if (seq != null && !(option3 = this.df().sparkSession().sessionState().analyzer().NonSessionCatalogAndIdentifier().unapply(seq)).isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option3.get())._1();
            Identifier ident = (Identifier)((Tuple2)option3.get())._2();
            this.insertInto(catalog, ident);
            return;
        }
        if (seq != null && !(option2 = this.df().sparkSession().sessionState().analyzer().SessionCatalogAndIdentifier().unapply(seq)).isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option2.get())._1();
            Identifier ident = (Identifier)((Tuple2)option2.get())._2();
            if (canUseV2 && ident.namespace().length <= 1) {
                this.insertInto(catalog, ident);
                return;
            }
        }
        if (seq != null && !(option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) {
            TableIdentifier tableIdentifier = (TableIdentifier)option.get();
            this.insertInto(tableIdentifier);
            return;
        }
        throw QueryCompilationErrors$.MODULE$.cannotFindCatalogToHandleIdentifierError(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void insertInto(CatalogPlugin catalog, Identifier ident) {
        block4: {
            block5: {
                block3: {
                    var7_3 = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog().loadTable(ident);
                    if (var7_3 instanceof V1Table) {
                        this.insertInto(TableIdentifier$.MODULE$.apply(ident.name(), ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()))));
                        return;
                    }
                    table = DataSourceV2Relation$.MODULE$.create(var7_3, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
                    var9_5 = this.mode();
                    if (!(SaveMode.Append.equals(var9_5) != false ? true : (SaveMode.ErrorIfExists.equals(var9_5) != false ? true : SaveMode.Ignore.equals(var9_5) != false))) break block3;
                    v0 /* !! */  = AppendData$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap());
                    break block4;
                }
                if (!SaveMode.Overwrite.equals(var9_5)) break block5;
                conf = this.df().sparkSession().sessionState().conf();
                if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])table.table().partitioning())) <= 0) ** GOTO lbl-1000
                v1 = conf.partitionOverwriteMode();
                var12_7 = SQLConf.PartitionOverwriteMode$.MODULE$.DYNAMIC();
                if (!(v1 != null ? v1.equals(var12_7) == false : var12_7 != null)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = dynamicPartitionOverwrite = false;
                }
                v0 /* !! */  = dynamicPartitionOverwrite ? OverwritePartitionsDynamic$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap()) : OverwriteByExpression$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.extraOptions().toMap());
                break block4;
            }
            throw new MatchError((Object)var9_5);
        }
        command = v0 /* !! */ ;
        this.runCommand(this.df().sparkSession(), (LogicalPlan)command);
    }

    private void insertInto(TableIdentifier tableIdent) {
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        this.runCommand(this.df().sparkSession(), (LogicalPlan)new InsertIntoStatement((LogicalPlan)UnresolvedRelation$.MODULE$.apply(tableIdent), Predef$.MODULE$.Map().empty(), (Seq)Nil$.MODULE$, this.df().logicalPlan(), !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null), false, InsertIntoStatement$.MODULE$.apply$default$7()));
    }

    private Option<BucketSpec> getBucketSpec() {
        if (this.sortColumnNames().isDefined() && this.numBuckets().isEmpty()) {
            throw QueryCompilationErrors$.MODULE$.sortByWithoutBucketingError();
        }
        return this.numBuckets().map((Function1 & Serializable)n -> DataFrameWriter.$anonfun$getBucketSpec$1(this, BoxesRunTime.unboxToInt((Object)n)));
    }

    private void assertNotBucketed(String operation) {
        if (this.getBucketSpec().isDefined()) {
            if (this.sortColumnNames().isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.bucketByUnsupportedByOperationError(operation);
            }
            throw QueryCompilationErrors$.MODULE$.bucketByAndSortByUnsupportedByOperationError(operation);
        }
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.operationNotSupportPartitioningError(operation);
        }
    }

    public void saveAsTable(String tableName) {
        Option option;
        Option option2;
        Option option3;
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined();
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        if (seq != null && !(option3 = this.df().sparkSession().sessionState().analyzer().NonSessionCatalogAndIdentifier().unapply(seq)).isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option3.get())._1();
            Identifier ident = (Identifier)((Tuple2)option3.get())._2();
            this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident, (Seq<String>)seq);
            return;
        }
        if (seq != null && !(option2 = this.df().sparkSession().sessionState().analyzer().SessionCatalogAndIdentifier().unapply(seq)).isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option2.get())._1();
            Identifier ident = (Identifier)((Tuple2)option2.get())._2();
            if (canUseV2 && ident.namespace().length <= 1) {
                this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident, (Seq<String>)seq);
                return;
            }
        }
        if (seq != null && !(option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) {
            TableIdentifier tableIdentifier = (TableIdentifier)option.get();
            this.saveAsTable(tableIdentifier);
            return;
        }
        throw QueryCompilationErrors$.MODULE$.cannotFindCatalogToHandleIdentifierError(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted());
    }

    /*
     * Unable to fully structure code
     */
    private void saveAsTable(TableCatalog catalog, Identifier ident, Seq<String> nameParts) {
        try {
            v0 = Option$.MODULE$.apply((Object)catalog.loadTable(ident));
        }
        catch (NoSuchTableException v1) {
            v0 = None$.MODULE$;
        }
        tableOpt = v0;
        var7_5 = new Tuple2((Object)this.mode(), (Object)tableOpt);
        if (var7_5 != null && (var8_6 = (Option)var7_5._2()) instanceof Some && (var9_7 = (Some)var8_6).value() instanceof V1Table) {
            this.saveAsTable(TableIdentifier$.MODULE$.apply(ident.name(), ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()))));
            return;
        }
        if (var7_5 == null) ** GOTO lbl-1000
        var10_8 = (SaveMode)var7_5._1();
        var11_9 = (Option)var7_5._2();
        if (SaveMode.Append.equals(var10_8) && var11_9 instanceof Some) {
            var12_10 = (Some)var11_9;
            table = (Table)var12_10.value();
            this.checkPartitioningMatchesV2Table(table);
            v2Relation = DataSourceV2Relation$.MODULE$.create(table, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
            v2 = AppendData$.MODULE$.byName((NamedRelation)v2Relation, this.df().logicalPlan(), this.extraOptions().toMap());
        } else if (var7_5 != null && SaveMode.Overwrite.equals(var15_13 = (SaveMode)var7_5._1())) {
            tableSpec = new UnresolvedTableSpec(Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), new OptionList((Seq)package$.MODULE$.Seq().empty()), this.extraOptions().get("path"), this.extraOptions().get("comment"), (Option)None$.MODULE$, false);
            v2 = new ReplaceTableAsSelect((LogicalPlan)new UnresolvedIdentifier(nameParts, UnresolvedIdentifier$.MODULE$.apply$default$2()), this.partitioningAsV2(), this.df().queryExecution().analyzed(), (TableSpecBase)tableSpec, this.extraOptions().toMap(), true, ReplaceTableAsSelect$.MODULE$.apply$default$7());
        } else if (var7_5 != null) {
            other = (SaveMode)var7_5._1();
            tableSpec = new UnresolvedTableSpec(Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), new OptionList((Seq)package$.MODULE$.Seq().empty()), this.extraOptions().get("path"), this.extraOptions().get("comment"), (Option)None$.MODULE$, false);
            v3 = other;
            var19_17 = SaveMode.Ignore;
            v4 = !(v3 != null ? v3.equals(var19_17) == false : var19_17 != null);
            v2 = new CreateTableAsSelect((LogicalPlan)new UnresolvedIdentifier(nameParts, UnresolvedIdentifier$.MODULE$.apply$default$2()), this.partitioningAsV2(), this.df().queryExecution().analyzed(), (TableSpecBase)tableSpec, this.extraOptions().toMap(), v4, CreateTableAsSelect$.MODULE$.apply$default$7());
        } else {
            throw new MatchError((Object)var7_5);
        }
        command = v2;
        this.runCommand(this.df().sparkSession(), (LogicalPlan)command);
    }

    private void saveAsTable(TableIdentifier tableIdent) {
        SessionCatalog catalog = this.df().sparkSession().sessionState().catalog();
        TableIdentifier qualifiedIdent = catalog.qualifyIdentifier(tableIdent);
        boolean tableExists = catalog.tableExists(qualifiedIdent);
        String tableName = qualifiedIdent.unquotedString();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)tuple2._2();
            if (bl && SaveMode.Ignore.equals(saveMode)) {
                return;
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)tuple2._2();
            if (bl && SaveMode.ErrorIfExists.equals(saveMode)) {
                throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(qualifiedIdent);
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)tuple2._2();
            if (bl && SaveMode.Overwrite.equals(saveMode)) {
                HiveTableRelation hiveTableRelation;
                BaseRelation baseRelation;
                LogicalRelation logicalRelation;
                BaseRelation dest;
                Seq srcRelations = this.df().logicalPlan().collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        A1 A1 = x1;
                        if (A1 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)A1).relation()) != null) {
                            BaseRelation baseRelation = src;
                            return (B1)baseRelation;
                        }
                        if (A1 instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                            return (B1)hiveTableRelation.tableMeta().identifier();
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        LogicalPlan logicalPlan2 = x1;
                        if (logicalPlan2 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null) {
                            return true;
                        }
                        return logicalPlan2 instanceof HiveTableRelation;
                    }
                });
                LogicalPlan tableRelation = this.df().sparkSession().table(qualifiedIdent).queryExecution().analyzed();
                LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(tableRelation);
                if (logicalPlan2 instanceof LogicalRelation && (dest = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null && srcRelations.contains((Object)(baseRelation = dest))) {
                    throw QueryCompilationErrors$.MODULE$.cannotOverwriteTableThatIsBeingReadFromError(qualifiedIdent);
                }
                if (logicalPlan2 instanceof HiveTableRelation && srcRelations.contains((Object)(hiveTableRelation = (HiveTableRelation)logicalPlan2).tableMeta().identifier())) {
                    throw QueryCompilationErrors$.MODULE$.cannotOverwriteTableThatIsBeingReadFromError(qualifiedIdent);
                }
                catalog.dropTable(qualifiedIdent, true, false);
                this.createTable(qualifiedIdent);
                catalog.refreshTable(qualifiedIdent);
                return;
            }
        }
        this.createTable(qualifiedIdent);
    }

    private void createTable(TableIdentifier tableIdent) {
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap());
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, new StructType(), (Option)new Some((Object)this.source()), (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$), this.getBucketSpec(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
        this.runCommand(this.df().sparkSession(), new CreateTable(tableDesc, this.mode(), (Option<LogicalPlan>)new Some((Object)this.df().logicalPlan())));
    }

    private Seq<Transform> partitioningAsV2() {
        Seq partitioning2 = (Seq)this.partitioningColumns().map((Function1 & Serializable)colNames -> (Seq)colNames.map((Function1 & Serializable)name -> new IdentityTransform(FieldReference$.MODULE$.apply(name)))).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
        Seq bucketing = Option$.MODULE$.option2Iterable(this.getBucketSpec().map((Function1 & Serializable)spec -> CatalogV2Implicits$.MODULE$.BucketSpecHelper(spec).asTransform())).toSeq();
        return (Seq)partitioning2.$plus$plus((IterableOnce)bucketing);
    }

    private void checkPartitioningMatchesV2Table(Table existingTable) {
        Seq<Transform> v2Partitions = this.partitioningAsV2();
        if (v2Partitions.isEmpty()) {
            return;
        }
        Predef$.MODULE$.require(v2Partitions.sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])existingTable.partitioning())), (Function0 & Serializable)() -> "The provided partitioning does not match of the table.\n - provided: " + v2Partitions.mkString(", ") + "\n - table: " + Predef$.MODULE$.wrapRefArray((Object[])existingTable.partitioning()).mkString(", "));
    }

    public void jdbc(String url, String table, Properties connectionProperties) {
        this.assertNotPartitioned("jdbc");
        this.assertNotBucketed("jdbc");
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(connectionProperties).asScala()));
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((IterableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)table), (List)Nil$.MODULE$))));
        this.format("jdbc").save();
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    public void text(String path) {
        this.format("text").save(path);
    }

    public void csv(String path) {
        this.format("csv").save(path);
    }

    public void xml(String path) {
        this.format("xml").save(path);
    }

    private void runCommand(SparkSession session, LogicalPlan command) {
        QueryExecution qe = new QueryExecution(session, command, this.df().queryExecution().tracker(), QueryExecution$.MODULE$.$lessinit$greater$default$4());
        qe.assertCommandExecuted();
    }

    private Option<TableProvider> lookupV2Provider() {
        Some some;
        Option<TableProvider> option = DataSource$.MODULE$.lookupDataSourceV2(this.source(), this.df().sparkSession().sessionState().conf());
        if (option instanceof Some && (some = (Some)option).value() instanceof FileDataSourceV2) {
            return None$.MODULE$;
        }
        return option;
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private Option<Seq<String>> bucketColumnNames() {
        return this.bucketColumnNames;
    }

    private void bucketColumnNames_$eq(Option<Seq<String>> x$1) {
        this.bucketColumnNames = x$1;
    }

    private Option<Object> numBuckets() {
        return this.numBuckets;
    }

    private void numBuckets_$eq(Option<Object> x$1) {
        this.numBuckets = x$1;
    }

    private Option<Seq<String>> sortColumnNames() {
        return this.sortColumnNames;
    }

    private void sortColumnNames_$eq(Option<Seq<String>> x$1) {
        this.sortColumnNames = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$saveInternal$1(CaseInsensitiveMap optionsWithPath$1, String x$1) {
        return !optionsWithPath$1.contains(x$1);
    }

    private final Table getTable$1(TableProvider provider$1, CaseInsensitiveStringMap dsOptions$1) {
        if (provider$1.supportsExternalMetadata()) {
            return provider$1.getTable(this.df().schema().asNullable(), (Transform[])this.partitioningAsV2().toArray(ClassTag$.MODULE$.apply(Transform.class)), dsOptions$1.asCaseSensitiveMap());
        }
        return DataSourceV2Utils$.MODULE$.getTableFromProvider(provider$1, dsOptions$1, (Option<StructType>)None$.MODULE$);
    }

    public static final /* synthetic */ BucketSpec $anonfun$getBucketSpec$1(DataFrameWriter $this, int n) {
        return new BucketSpec(n, (Seq)$this.bucketColumnNames().get(), (Seq)$this.sortColumnNames().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$));
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        this.partitioningColumns = None$.MODULE$;
        this.bucketColumnNames = None$.MODULE$;
        this.numBuckets = None$.MODULE$;
        this.sortColumnNames = None$.MODULE$;
    }
}

