/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.aggregate.BloomFilterAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.CountMinSketchAgg;
import org.apache.spark.sql.execution.stat.FrequentItems$;
import org.apache.spark.sql.execution.stat.StatFunctions$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.sketch.BloomFilter;
import org.apache.spark.util.sketch.CountMinSketch;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Stable
@ScalaSignature(bytes="\u0006\u0005\t]a\u0001\u0002\u000e\u001c\u0005\u0011B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0007i\u0001!\taG\u001b\t\u000ba\u0002A\u0011A\u001d\t\u000ba\u0002A\u0011A)\t\ra\u0002A\u0011A\u000fY\u0011\u0015i\u0007\u0001\"\u0001o\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u0015\u0019\b\u0001\"\u0001z\u0011\u0015a\b\u0001\"\u0001~\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007Aq!!\u0001\u0001\t\u0003\tY\u0001C\u0004\u0002\u0002\u0001!\t!a\u0004\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u001c!9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002bBA\u0010\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003?\u0001A\u0011AA7\u0011\u001d\ty\u0002\u0001C\u0001\u0003\u0007Cq!a%\u0001\t\u0003\t)\nC\u0004\u0002\u0014\u0002!\t!!/\t\u000f\u0005M\u0005\u0001\"\u0001\u0002H\"9\u00111\u0013\u0001\u0005\u0002\u0005E\u0007bBAn\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u00037\u0004A\u0011AAx\u0011\u001d\tY\u000e\u0001C\u0001\u0003oDq!a7\u0001\t\u0003\u0011\tA\u0001\fECR\fgI]1nKN#\u0018\r\u001e$v]\u000e$\u0018n\u001c8t\u0015\taR$A\u0002tc2T!AH\u0010\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0001\n\u0013AB1qC\u000eDWMC\u0001#\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VMZ\u0001\u0003I\u001a\u0004\"!L\u0019\u000f\u00059zS\"A\u000e\n\u0005AZ\u0012a\u00029bG.\fw-Z\u0005\u0003eM\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005AZ\u0012A\u0002\u001fj]&$h\b\u0006\u00027oA\u0011a\u0006\u0001\u0005\u0006W\t\u0001\r\u0001L\u0001\u000fCB\u0004(o\u001c=Rk\u0006tG/\u001b7f)\u0011Q\u0004)T(\u0011\u0007\u0019ZT(\u0003\u0002=O\t)\u0011I\u001d:bsB\u0011aEP\u0005\u0003\u007f\u001d\u0012a\u0001R8vE2,\u0007\"B!\u0004\u0001\u0004\u0011\u0015aA2pYB\u00111I\u0013\b\u0003\t\"\u0003\"!R\u0014\u000e\u0003\u0019S!aR\u0012\u0002\rq\u0012xn\u001c;?\u0013\tIu%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00172\u0013aa\u0015;sS:<'BA%(\u0011\u0015q5\u00011\u0001;\u00035\u0001(o\u001c2bE&d\u0017\u000e^5fg\")\u0001k\u0001a\u0001{\u0005i!/\u001a7bi&4X-\u0012:s_J$BAU*W/B\u0019ae\u000f\u001e\t\u000bQ#\u0001\u0019A+\u0002\t\r|Gn\u001d\t\u0004Mm\u0012\u0005\"\u0002(\u0005\u0001\u0004Q\u0004\"\u0002)\u0005\u0001\u0004iD\u0003B-cU2\u00042AW0b\u001b\u0005Y&B\u0001/^\u0003\u0011)H/\u001b7\u000b\u0003y\u000bAA[1wC&\u0011\u0001m\u0017\u0002\u0005\u0019&\u001cH\u000fE\u0002[?vBQ\u0001V\u0003A\u0002\r\u00042\u0001\u001a5C\u001d\t)wM\u0004\u0002FM&\t\u0001&\u0003\u00021O%\u0011\u0001-\u001b\u0006\u0003a\u001dBQAT\u0003A\u0002-\u00042\u0001\u001a5>\u0011\u0015\u0001V\u00011\u0001>\u0003\r\u0019wN\u001e\u000b\u0004{=\f\b\"\u00029\u0007\u0001\u0004\u0011\u0015\u0001B2pYFBQA\u001d\u0004A\u0002\t\u000bAaY8me\u0005!1m\u001c:s)\u0011iTO^<\t\u000bA<\u0001\u0019\u0001\"\t\u000bI<\u0001\u0019\u0001\"\t\u000ba<\u0001\u0019\u0001\"\u0002\r5,G\u000f[8e)\ri$p\u001f\u0005\u0006a\"\u0001\rA\u0011\u0005\u0006e\"\u0001\rAQ\u0001\tGJ|7o\u001d;bER\u0019AF`@\t\u000bAL\u0001\u0019\u0001\"\t\u000bIL\u0001\u0019\u0001\"\u0002\u0013\u0019\u0014X-]%uK6\u001cH#\u0002\u0017\u0002\u0006\u0005\u001d\u0001\"\u0002+\u000b\u0001\u0004)\u0006BBA\u0005\u0015\u0001\u0007Q(A\u0004tkB\u0004xN\u001d;\u0015\u00071\ni\u0001C\u0003U\u0017\u0001\u0007Q\u000bF\u0003-\u0003#\tI\u0002\u0003\u0004U\u0019\u0001\u0007\u00111\u0003\t\u0005I\u0006U!)C\u0002\u0002\u0018%\u00141aU3r\u0011\u0019\tI\u0001\u0004a\u0001{Q\u0019A&!\b\t\rQk\u0001\u0019AA\n\u0003!\u0019\u0018-\u001c9mK\nKX\u0003BA\u0012\u0003k!r\u0001LA\u0013\u0003O\t9\u0005C\u0003B\u001d\u0001\u0007!\tC\u0004\u0002*9\u0001\r!a\u000b\u0002\u0013\u0019\u0014\u0018m\u0019;j_:\u001c\bCB\"\u0002.\u0005ER(C\u0002\u000201\u00131!T1q!\u0011\t\u0019$!\u000e\r\u0001\u00119\u0011q\u0007\bC\u0002\u0005e\"!\u0001+\u0012\t\u0005m\u0012\u0011\t\t\u0004M\u0005u\u0012bAA O\t9aj\u001c;iS:<\u0007c\u0001\u0014\u0002D%\u0019\u0011QI\u0014\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002J9\u0001\r!a\u0013\u0002\tM,W\r\u001a\t\u0004M\u00055\u0013bAA(O\t!Aj\u001c8h+\u0011\t\u0019&a\u0018\u0015\u000f1\n)&a\u0016\u0002l!)\u0011i\u0004a\u0001\u0005\"9\u0011\u0011F\bA\u0002\u0005e\u0003c\u0002.\u0002\\\u0005u\u0013\u0011M\u0005\u0004\u0003_Y\u0006\u0003BA\u001a\u0003?\"q!a\u000e\u0010\u0005\u0004\tI\u0004\u0005\u0003\u0002d\u0005%TBAA3\u0015\r\t9'X\u0001\u0005Y\u0006tw-C\u0002@\u0003KBq!!\u0013\u0010\u0001\u0004\tY%\u0006\u0003\u0002p\u0005}Dc\u0002\u0017\u0002r\u0005e\u0014\u0011\u0011\u0005\u0007\u0003B\u0001\r!a\u001d\u0011\u00079\n)(C\u0002\u0002xm\u0011aaQ8mk6t\u0007bBA\u0015!\u0001\u0007\u00111\u0010\t\u0007\u0007\u00065\u0012QP\u001f\u0011\t\u0005M\u0012q\u0010\u0003\b\u0003o\u0001\"\u0019AA\u001d\u0011\u001d\tI\u0005\u0005a\u0001\u0003\u0017*B!!\"\u0002\u0010R9A&a\"\u0002\n\u0006E\u0005BB!\u0012\u0001\u0004\t\u0019\bC\u0004\u0002*E\u0001\r!a#\u0011\u000fi\u000bY&!$\u0002bA!\u00111GAH\t\u001d\t9$\u0005b\u0001\u0003sAq!!\u0013\u0012\u0001\u0004\tY%\u0001\bd_VtG/T5o'.,Go\u00195\u0015\u0015\u0005]\u0015QUAU\u0003g\u000b9\f\u0005\u0003\u0002\u001a\u0006\u0005VBAAN\u0015\u0011\ti*a(\u0002\rM\\W\r^2i\u0015\taV$\u0003\u0003\u0002$\u0006m%AD\"pk:$X*\u001b8TW\u0016$8\r\u001b\u0005\u0007\u0003O\u0013\u0002\u0019\u0001\"\u0002\u000f\r|GNT1nK\"9\u00111\u0016\nA\u0002\u00055\u0016!\u00023faRD\u0007c\u0001\u0014\u00020&\u0019\u0011\u0011W\u0014\u0003\u0007%sG\u000fC\u0004\u00026J\u0001\r!!,\u0002\u000b]LG\r\u001e5\t\u000f\u0005%#\u00031\u0001\u0002.RQ\u0011qSA^\u0003{\u000b\t-!2\t\r\u0005\u001d6\u00031\u0001C\u0011\u0019\tyl\u0005a\u0001{\u0005\u0019Q\r]:\t\r\u0005\r7\u00031\u0001>\u0003)\u0019wN\u001c4jI\u0016t7-\u001a\u0005\b\u0003\u0013\u001a\u0002\u0019AAW))\t9*!3\u0002L\u00065\u0017q\u001a\u0005\u0007\u0003R\u0001\r!a\u001d\t\u000f\u0005-F\u00031\u0001\u0002.\"9\u0011Q\u0017\u000bA\u0002\u00055\u0006bBA%)\u0001\u0007\u0011Q\u0016\u000b\u000b\u0003/\u000b\u0019.!6\u0002X\u0006e\u0007BB!\u0016\u0001\u0004\t\u0019\b\u0003\u0004\u0002@V\u0001\r!\u0010\u0005\u0007\u0003\u0007,\u0002\u0019A\u001f\t\u000f\u0005%S\u00031\u0001\u0002.\u0006Y!\r\\8p[\u001aKG\u000e^3s)!\ty.!:\u0002h\u0006-\b\u0003BAM\u0003CLA!a9\u0002\u001c\nY!\t\\8p[\u001aKG\u000e^3s\u0011\u0019\t9K\u0006a\u0001\u0005\"9\u0011\u0011\u001e\fA\u0002\u0005-\u0013\u0001E3ya\u0016\u001cG/\u001a3Ok6LE/Z7t\u0011\u0019\tiO\u0006a\u0001{\u0005\u0019a\r\u001d9\u0015\u0011\u0005}\u0017\u0011_Az\u0003kDa!Q\fA\u0002\u0005M\u0004bBAu/\u0001\u0007\u00111\n\u0005\u0007\u0003[<\u0002\u0019A\u001f\u0015\u0011\u0005}\u0017\u0011`A~\u0003{Da!a*\u0019\u0001\u0004\u0011\u0005bBAu1\u0001\u0007\u00111\n\u0005\b\u0003\u007fD\u0002\u0019AA&\u0003\u001dqW/\u001c\"jiN$\u0002\"a8\u0003\u0004\t\u0015!q\u0001\u0005\u0007\u0003f\u0001\r!a\u001d\t\u000f\u0005%\u0018\u00041\u0001\u0002L!9\u0011q`\rA\u0002\u0005-\u0003f\u0001\u0001\u0003\fA!!Q\u0002B\n\u001b\t\u0011yAC\u0002\u0003\u0012u\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Ba\u0004\u0003\rM#\u0018M\u00197f\u0001")
public final class DataFrameStatFunctions {
    private final Dataset<Row> df;

    public double[] approxQuantile(String col, double[] probabilities, double relativeError) {
        return (double[])package$.MODULE$.withOrigin((Function0 & Serializable)() -> (double[])ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])this.approxQuantile((String[])((Object[])new String[]{col}), probabilities, relativeError))));
    }

    public double[][] approxQuantile(String[] cols, double[] probabilities, double relativeError) {
        return (double[][])package$.MODULE$.withOrigin((Function0 & Serializable)() -> (double[][])((IterableOnceOps)StatFunctions$.MODULE$.multipleApproxQuantiles($this.df.select((scala.collection.immutable.Seq<Column>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])cols), (Function1 & Serializable)colName -> functions$.MODULE$.col((String)colName), ClassTag$.MODULE$.apply(Column.class)))), (scala.collection.immutable.Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)cols), (scala.collection.immutable.Seq<Object>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)probabilities), relativeError).map((Function1 & Serializable)x$1 -> (double[])x$1.toArray((ClassTag)ClassTag$.MODULE$.Double()))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    public java.util.List<java.util.List<Object>> approxQuantile(List<String> cols, List<Object> probabilities, double relativeError) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.approxQuantile((String[])cols.toArray(ClassTag$.MODULE$.apply(String.class)), (double[])probabilities.toArray((ClassTag)ClassTag$.MODULE$.Double()), relativeError)), (Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapDoubleArray(x$2).toList()).asJava(), ClassTag$.MODULE$.apply(java.util.List.class))).toList()).asJava();
    }

    public double cov(String col1, String col2) {
        return BoxesRunTime.unboxToDouble(package$.MODULE$.withOrigin((JFunction0.mcD.sp & Serializable)() -> StatFunctions$.MODULE$.calculateCov($this.df, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)col1, (List)new .colon.colon((Object)col2, (List)Nil$.MODULE$)))));
    }

    public double corr(String col1, String col2, String method) {
        return BoxesRunTime.unboxToDouble(package$.MODULE$.withOrigin((JFunction0.mcD.sp & Serializable)() -> {
            String string = method;
            String string2 = "pearson";
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "Currently only the calculation of the Pearson Correlation coefficient is supported.");
            return StatFunctions$.MODULE$.pearsonCorrelation($this.df, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)col1, (List)new .colon.colon((Object)col2, (List)Nil$.MODULE$)));
        }));
    }

    public double corr(String col1, String col2) {
        return this.corr(col1, col2, "pearson");
    }

    public Dataset<Row> crosstab(String col1, String col2) {
        return (Dataset)package$.MODULE$.withOrigin((Function0 & Serializable)() -> StatFunctions$.MODULE$.crossTabulate($this.df, col1, col2));
    }

    public Dataset<Row> freqItems(String[] cols, double support) {
        return (Dataset)package$.MODULE$.withOrigin((Function0 & Serializable)() -> FrequentItems$.MODULE$.singlePassFreqItems($this.df, (scala.collection.immutable.Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)cols), support));
    }

    public Dataset<Row> freqItems(String[] cols) {
        return (Dataset)package$.MODULE$.withOrigin((Function0 & Serializable)() -> FrequentItems$.MODULE$.singlePassFreqItems($this.df, (scala.collection.immutable.Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)cols), 0.01));
    }

    public Dataset<Row> freqItems(scala.collection.immutable.Seq<String> cols, double support) {
        return (Dataset)package$.MODULE$.withOrigin((Function0 & Serializable)() -> FrequentItems$.MODULE$.singlePassFreqItems($this.df, cols, support));
    }

    public Dataset<Row> freqItems(scala.collection.immutable.Seq<String> cols) {
        return (Dataset)package$.MODULE$.withOrigin((Function0 & Serializable)() -> FrequentItems$.MODULE$.singlePassFreqItems($this.df, cols, 0.01));
    }

    public <T> Dataset<Row> sampleBy(String col, scala.collection.immutable.Map<T, Object> fractions, long seed) {
        return this.sampleBy(Column$.MODULE$.apply(col), fractions, seed);
    }

    public <T> Dataset<Row> sampleBy(String col, Map<T, Double> fractions, long seed) {
        return this.sampleBy(col, CollectionConverters$.MODULE$.MapHasAsScala(fractions).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), seed);
    }

    public <T> Dataset<Row> sampleBy(Column col, scala.collection.immutable.Map<T, Object> fractions, long seed) {
        return (Dataset)package$.MODULE$.withOrigin((Function0 & Serializable)() -> {
            Predef$.MODULE$.require(fractions.values().forall((Function1)(JFunction1.mcZD.sp & Serializable)p -> p >= 0.0 && p <= 1.0), (Function0 & Serializable)() -> "Fractions must be in [0, 1], but got " + fractions + ".");
            Column r = functions$.MODULE$.rand(seed);
            UserDefinedFunction f = functions$.MODULE$.udf((Function2 & Serializable)(stratum, x) -> BoxesRunTime.boxToBoolean((boolean)DataFrameStatFunctions.$anonfun$sampleBy$4(fractions, stratum, BoxesRunTime.unboxToDouble((Object)x))), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Boolean(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Any(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double());
            return $this.df.filter(f.apply((scala.collection.immutable.Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{col, r})));
        });
    }

    public <T> Dataset<Row> sampleBy(Column col, Map<T, Double> fractions, long seed) {
        return this.sampleBy(col, CollectionConverters$.MODULE$.MapHasAsScala(fractions).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), seed);
    }

    public CountMinSketch countMinSketch(String colName, int depth, int width, int seed) {
        return this.countMinSketch(Column$.MODULE$.apply(colName), depth, width, seed);
    }

    public CountMinSketch countMinSketch(String colName, double eps, double confidence, int seed) {
        return this.countMinSketch(Column$.MODULE$.apply(colName), eps, confidence, seed);
    }

    public CountMinSketch countMinSketch(Column col, int depth, int width, int seed) {
        double eps = 2.0 / (double)width;
        double confidence = 1.0 - 1.0 / Math.pow(2.0, depth);
        return this.countMinSketch(col, eps, confidence, seed);
    }

    public CountMinSketch countMinSketch(Column col, double eps, double confidence, int seed) {
        return (CountMinSketch)package$.MODULE$.withOrigin((Function0 & Serializable)() -> {
            CountMinSketchAgg countMinSketchAgg = new CountMinSketchAgg(col.expr(), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)eps), (DataType)DoubleType$.MODULE$), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)confidence), (DataType)DoubleType$.MODULE$), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)seed), (DataType)IntegerType$.MODULE$));
            byte[] bytes = (byte[])$this.df.select((scala.collection.immutable.Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply((Expression)countMinSketchAgg.toAggregateExpression(false, countMinSketchAgg.toAggregateExpression$default$2()))})).head().getAs(0);
            return countMinSketchAgg.deserialize(bytes);
        });
    }

    public BloomFilter bloomFilter(String colName, long expectedNumItems, double fpp) {
        return this.bloomFilter(Column$.MODULE$.apply(colName), expectedNumItems, fpp);
    }

    public BloomFilter bloomFilter(Column col, long expectedNumItems, double fpp) {
        long numBits = BloomFilter.optimalNumOfBits((long)expectedNumItems, (double)fpp);
        return this.bloomFilter(col, expectedNumItems, numBits);
    }

    public BloomFilter bloomFilter(String colName, long expectedNumItems, long numBits) {
        return this.bloomFilter(Column$.MODULE$.apply(colName), expectedNumItems, numBits);
    }

    public BloomFilter bloomFilter(Column col, long expectedNumItems, long numBits) {
        return (BloomFilter)package$.MODULE$.withOrigin((Function0 & Serializable)() -> {
            BloomFilterAggregate bloomFilterAgg = new BloomFilterAggregate(col.expr(), (Expression)new Literal((Object)BoxesRunTime.boxToLong((long)expectedNumItems), (DataType)LongType$.MODULE$), (Expression)new Literal((Object)BoxesRunTime.boxToLong((long)numBits), (DataType)LongType$.MODULE$));
            byte[] bytes = (byte[])$this.df.select((scala.collection.immutable.Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Column$.MODULE$.apply((Expression)bloomFilterAgg.toAggregateExpression(false, bloomFilterAgg.toAggregateExpression$default$2()))})).head().getAs(0);
            return bloomFilterAgg.deserialize(bytes);
        });
    }

    public static final /* synthetic */ boolean $anonfun$sampleBy$4(scala.collection.immutable.Map fractions$1, Object stratum, double x) {
        return x < BoxesRunTime.unboxToDouble((Object)fractions$1.getOrElse(stratum, (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
    }

    public DataFrameStatFunctions(Dataset<Row> df) {
        this.df = df;
    }
}

