/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.connector.catalog.functions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.functions.AggregateFunction;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.StructType;

public class JavaAverage
implements UnboundFunction {
    public String name() {
        return "avg";
    }

    public BoundFunction bind(StructType inputType) {
        if (inputType.fields().length != 1) {
            throw new UnsupportedOperationException("Expect exactly one argument");
        }
        if (inputType.fields()[0].dataType() instanceof DoubleType) {
            return new JavaDoubleAverage();
        }
        throw new UnsupportedOperationException("Unsupported non-integral type: " + inputType.fields()[0].dataType());
    }

    public String description() {
        return null;
    }

    public static class JavaDoubleAverage
    implements AggregateFunction<State<Double>, Double> {
        public State<Double> newAggregationState() {
            return new State<Double>(0.0, 0.0);
        }

        public State<Double> update(State<Double> state, InternalRow input) {
            if (input.isNullAt(0)) {
                return state;
            }
            return new State<Double>((Double)state.sum + input.getDouble(0), (Double)state.count + 1.0);
        }

        public Double produceResult(State<Double> state) {
            return (Double)state.sum / (Double)state.count;
        }

        public State<Double> merge(State<Double> leftState, State<Double> rightState) {
            return new State<Double>((Double)leftState.sum + (Double)rightState.sum, (Double)leftState.count + (Double)rightState.count);
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.DoubleType};
        }

        public DataType resultType() {
            return DataTypes.DoubleType;
        }

        public String name() {
            return "davg";
        }
    }

    public static class State<T>
    implements Serializable {
        T sum;
        T count;

        State(T sum, T count) {
            this.sum = sum;
            this.count = count;
        }
    }
}

