/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.connector;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import test.org.apache.spark.sql.connector.JavaRangeInputPartition;

class JavaSimpleReaderFactory
implements PartitionReaderFactory {
    JavaSimpleReaderFactory() {
    }

    public PartitionReader<InternalRow> createReader(InputPartition partition) {
        final JavaRangeInputPartition p = (JavaRangeInputPartition)partition;
        return new PartitionReader<InternalRow>(){
            private int current;
            {
                this.current = p.start - 1;
            }

            public boolean next() {
                ++this.current;
                return this.current < p.end;
            }

            public InternalRow get() {
                return new GenericInternalRow(new Object[]{this.current, -this.current});
            }

            public void close() {
            }
        };
    }
}

