/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import test.org.apache.spark.sql.MyDoubleAvg;

public class JavaUDAFSuite {
    private transient SparkSession spark;

    @BeforeEach
    public void setUp() {
        this.spark = SparkSession.builder().master("local[*]").appName("testing").getOrCreate();
    }

    @AfterEach
    public void tearDown() {
        this.spark.stop();
        this.spark = null;
    }

    @Test
    public void udf1Test() {
        this.spark.range(1L, 10L).toDF(new String[]{"value"}).createOrReplaceTempView("df");
        this.spark.udf().registerJavaUDAF("myDoubleAvg", MyDoubleAvg.class.getName());
        Row result = (Row)this.spark.sql("SELECT myDoubleAvg(value) as my_avg from df").head();
        Assertions.assertEquals((double)105.0, (double)result.getDouble(0), (double)1.0E-6);
    }
}

