/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.test.TestSparkSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JavaSparkSessionSuite {
    private SparkSession spark;

    @AfterEach
    public void tearDown() {
        this.spark.stop();
        this.spark = null;
    }

    @Test
    public void config() {
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("string", "");
                this.put("boolean", true);
                this.put("double", 0.0);
                this.put("long", 0L);
            }
        };
        this.spark = SparkSession.builder().master("local[*]").appName("testing").config((Map)map).getOrCreate();
        for (Map.Entry e : map.entrySet()) {
            Assertions.assertEquals((Object)this.spark.conf().get((String)e.getKey()), (Object)e.getValue().toString());
        }
    }

    @Test
    public void testPositionalParameters() {
        this.spark = new TestSparkSession();
        int[] emptyArgs = new int[]{};
        List collected1 = this.spark.sql("select 'abc'", (Object)emptyArgs).collectAsList();
        Assertions.assertEquals((Object)"abc", (Object)((Row)collected1.get(0)).getString(0));
        String[] singleArg = new String[]{"abc"};
        List collected2 = this.spark.sql("select ?", (Object)singleArg).collectAsList();
        Assertions.assertEquals((Object)"abc", (Object)((Row)collected2.get(0)).getString(0));
        int[] args = new int[]{1, 2, 3};
        List collected3 = this.spark.sql("select ?, ?, ?", (Object)args).collectAsList();
        Row r0 = (Row)collected3.get(0);
        Assertions.assertEquals((int)1, (int)r0.getInt(0));
        Assertions.assertEquals((int)2, (int)r0.getInt(1));
        Assertions.assertEquals((int)3, (int)r0.getInt(2));
        Object[] mixedArgs = new Object[]{1, "abc"};
        List collected4 = this.spark.sql("select ?, ?", (Object)mixedArgs).collectAsList();
        Row r1 = (Row)collected4.get(0);
        Assertions.assertEquals((int)1, (int)r1.getInt(0));
        Assertions.assertEquals((Object)"abc", (Object)r1.getString(1));
    }
}

