/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import java.io.File;
import java.util.HashMap;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavaDataFrameReaderWriterSuite {
    private SparkSession spark = new TestSparkSession();
    private StructType schema = new StructType().add("s", "string");
    private transient String input;
    private transient String output;

    @BeforeEach
    public void setUp() {
        this.input = Utils.createTempDir((String)System.getProperty("java.io.tmpdir"), (String)"input").toString();
        File f = Utils.createTempDir((String)System.getProperty("java.io.tmpdir"), (String)"output");
        f.delete();
        this.output = f.toString();
    }

    @AfterEach
    public void tearDown() {
        this.spark.stop();
        this.spark = null;
    }

    @Test
    public void testFormatAPI() {
        this.spark.read().format("org.apache.spark.sql.test").load().write().format("org.apache.spark.sql.test").save();
    }

    @Test
    public void testOptionsAPI() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("e", "1");
        this.spark.read().option("a", "1").option("b", 1L).option("c", 1.0).option("d", true).options(map).text(new String[0]).write().option("a", "1").option("b", 1L).option("c", 1.0).option("d", true).options(map).format("org.apache.spark.sql.test").save();
    }

    @Test
    public void testSaveModeAPI() {
        this.spark.range(10L).write().format("org.apache.spark.sql.test").mode(SaveMode.ErrorIfExists).save();
    }

    @Test
    public void testLoadAPI() {
        this.spark.read().format("org.apache.spark.sql.test").load();
        this.spark.read().format("org.apache.spark.sql.test").load(this.input);
        this.spark.read().format("org.apache.spark.sql.test").load(new String[]{this.input, this.input, this.input});
        this.spark.read().format("org.apache.spark.sql.test").load(new String[]{this.input, this.input});
    }

    @Test
    public void testTextAPI() {
        this.spark.read().text(new String[0]);
        this.spark.read().text(this.input);
        this.spark.read().text(new String[]{this.input, this.input, this.input});
        this.spark.read().text(new String[]{this.input, this.input}).write().text(this.output);
    }

    @Test
    public void testTextFileAPI() {
        this.spark.read().textFile(new String[0]);
        this.spark.read().textFile(this.input);
        this.spark.read().textFile(new String[]{this.input, this.input, this.input});
        this.spark.read().textFile(new String[]{this.input, this.input});
    }

    @Test
    public void testCsvAPI() {
        this.spark.read().schema(this.schema).csv(new String[0]);
        this.spark.read().schema(this.schema).csv(this.input);
        this.spark.read().schema(this.schema).csv(new String[]{this.input, this.input, this.input});
        this.spark.read().schema(this.schema).csv(new String[]{this.input, this.input}).write().csv(this.output);
    }

    @Test
    public void testJsonAPI() {
        this.spark.read().schema(this.schema).json(new String[0]);
        this.spark.read().schema(this.schema).json(this.input);
        this.spark.read().schema(this.schema).json(new String[]{this.input, this.input, this.input});
        this.spark.read().schema(this.schema).json(new String[]{this.input, this.input}).write().json(this.output);
    }

    @Test
    public void testParquetAPI() {
        this.spark.read().schema(this.schema).parquet(new String[0]);
        this.spark.read().schema(this.schema).parquet(this.input);
        this.spark.read().schema(this.schema).parquet(new String[]{this.input, this.input, this.input});
        this.spark.read().schema(this.schema).parquet(new String[]{this.input, this.input}).write().parquet(this.output);
    }

    public void testOrcAPI() {
        this.spark.read().schema(this.schema).orc(new String[0]);
        this.spark.read().schema(this.schema).orc(this.input);
        this.spark.read().schema(this.schema).orc(new String[]{this.input, this.input, this.input});
        this.spark.read().schema(this.schema).orc(new String[]{this.input, this.input}).write().orc(this.output);
    }
}

