/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.continuous;

import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.IntegratedUDFTestUtils;
import org.apache.spark.sql.IntegratedUDFTestUtils$;
import org.apache.spark.sql.IntegratedUDFTestUtils$TestPythonUDF$;
import org.apache.spark.sql.IntegratedUDFTestUtils$TestScalaUDF$;
import org.apache.spark.sql.IntegratedUDFTestUtils$TestScalarPandasUDF$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousTaskRetryException;
import org.apache.spark.sql.execution.streaming.sources.ContinuousMemoryStream;
import org.apache.spark.sql.execution.streaming.sources.ContinuousMemoryStream$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.StreamTest;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.streaming.continuous.ContinuousSuite$;
import org.apache.spark.sql.streaming.continuous.ContinuousSuiteBase;
import org.apache.spark.tags.SlowSQLTest;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.enablers.Retrying$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@SlowSQLTest
@ScalaSignature(bytes="\u0006\u0005}1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\ty1i\u001c8uS:,x.^:Tk&$XM\u0003\u0002\u0005\u000b\u0005Q1m\u001c8uS:,x.^:\u000b\u0005\u00199\u0011!C:ue\u0016\fW.\u001b8h\u0015\tA\u0011\"A\u0002tc2T!AC\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u00051i\u0011AB1qC\u000eDWMC\u0001\u000f\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013'5\t1!\u0003\u0002\u0015\u0007\t\u00192i\u001c8uS:,x.^:Tk&$XMQ1tK\u00061A(\u001b8jiz\"\u0012a\u0006\t\u0003%\u0001A#\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0005qI\u0011\u0001\u0002;bONL!AH\u000e\u0003\u0017Mcwn^*R\u0019R+7\u000f\u001e")
public class ContinuousSuite
extends ContinuousSuiteBase {
    public static final /* synthetic */ int $anonfun$new$4(Row x$2) {
        return x$2.getInt(0) * 2;
    }

    public static final /* synthetic */ Seq $anonfun$new$7(int n) {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, n, n * 2}));
    }

    public static final /* synthetic */ Seq $anonfun$new$8(int n) {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, n, n * 2}));
    }

    public static final /* synthetic */ boolean $anonfun$new$18(ContinuousSuite $this, LongRef taskId$1, StreamExecution x$3) {
        $this.eventually($this.timeout($this.streamingTimeout()), (Function0 & Serializable)() -> {
            long $org_scalatest_assert_macro_left = taskId$1.elem;
            int $org_scalatest_assert_macro_right = -1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left != (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        }, $this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        SparkContext qual$1 = $this.spark().sparkContext();
        long x$1 = taskId$1.elem;
        boolean x$2 = qual$1.killTaskAttempt$default$2();
        String x$32 = qual$1.killTaskAttempt$default$3();
        return qual$1.killTaskAttempt(x$1, x$2, x$32);
    }

    public ContinuousSuite() {
        this.test("basic", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            this.testStream(input.toDF(), this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}), this.testImplicits().newIntEncoder()), this.StopStream(), this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5}), this.testImplicits().newIntEncoder())}));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("SPARK-29642: basic with various types", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newStringEncoder(), this.sqlContext());
            this.testStream(input.toDF(), this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2"})), this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2"}), this.testImplicits().newStringEncoder())}));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ContinuousSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_continuous_ContinuousSuite$$typecreator13$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_continuous_ContinuousSuite$$typecreator13$1(ContinuousSuite $outer) {
                }
            }
            ContinuousMemoryStream input2 = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_continuous_ContinuousSuite$$typecreator13$1(null))), this.sqlContext());
            Timestamp timestamp = Timestamp.valueOf("2015-06-11 10:10:10.100");
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[2];
            streamActionArray[0] = this.AddData().apply(input2, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)timestamp), new Tuple2((Object)"1", (Object)timestamp)}));
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ContinuousSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_continuous_ContinuousSuite$$typecreator18$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_continuous_ContinuousSuite$$typecreator18$1(ContinuousSuite $outer) {
                }
            }
            streamActionArray[1] = this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)timestamp), new Tuple2((Object)"1", (Object)timestamp)}), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_continuous_ContinuousSuite$$typecreator18$1(null))));
            this.testStream(input2.toDF(), this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])streamActionArray));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("map", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ContinuousSuite.$anonfun$new$4(x$2)), this.testImplicits().newIntEncoder());
            this.testStream(df, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2}), this.testImplicits().newIntEncoder()), this.StopStream(), this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 6, 8}), this.testImplicits().newIntEncoder())}));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        this.test("flatMap", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF().flatMap((Function1 & Serializable)r -> (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, r.getInt(0), r.getInt(0) * 2})), this.testImplicits().newIntEncoder());
            this.testStream(df, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), this.CheckAnswer().apply((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1).flatMap((Function1 & Serializable)n -> ContinuousSuite.$anonfun$new$7(BoxesRunTime.unboxToInt((Object)n))), this.testImplicits().newIntEncoder()), this.StopStream(), this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).flatMap((Function1 & Serializable)n -> ContinuousSuite.$anonfun$new$8(BoxesRunTime.unboxToInt((Object)n))), this.testImplicits().newIntEncoder())}));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        this.test("filter", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF().where(this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).$greater((Object)BoxesRunTime.boxToInteger((int)2)));
            this.testStream(df, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), this.CheckAnswer().apply((Seq<Row>)Nil$.MODULE$), this.StopStream(), this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4}), this.testImplicits().newIntEncoder())}));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        this.test("deduplicate", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF().dropDuplicates();
            AnalysisException except = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testStream(df, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4())})), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168))));
            String $org_scalatest_assert_macro_left = except.message();
            String $org_scalatest_assert_macro_right = "Continuous processing does not support Deduplicate operations.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("timestamp", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.current_timestamp()}));
            AnalysisException except = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testStream(df, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4())})), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180))));
            String $org_scalatest_assert_macro_left = except.message();
            String $org_scalatest_assert_macro_right = "Continuous processing does not support current time operations.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test("subquery alias", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"memory"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            input.toDF().createOrReplaceTempView("memory");
            Dataset test = this.spark().sql("select value from memory where value > 2");
            this.testStream(test, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), this.CheckAnswer().apply((Seq<Row>)Nil$.MODULE$), this.StopStream(), this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4}), this.testImplicits().newIntEncoder())}));
        }), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        this.test("repeatedly restart", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF();
            this.testStream(df, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}), this.testImplicits().newIntEncoder()), this.StopStream(), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.StopStream(), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.StopStream(), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.StopStream(), this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), new StreamTest.StartStream(this, this.StartStream().apply$default$1(), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}), this.testImplicits().newIntEncoder()), this.StopStream()}));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.test("task failure kills the query", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), this.sqlContext());
            Dataset df = input.toDF();
            LongRef taskId = LongRef.create((long)-1L);
            SparkListener listener = new SparkListener(null, taskId){
                private final LongRef taskId$1;

                public void onTaskStart(SparkListenerTaskStart start) {
                    this.taskId$1.elem = start.taskInfo().taskId();
                }
                {
                    this.taskId$1 = taskId$1;
                }
            };
            this.spark().sparkContext().addSparkListener((SparkListenerInterface)listener);
            try {
                this.testStream(df, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream(this, Trigger.Continuous((long)100L), this.StartStream().apply$default$2(), this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ContinuousSuite.$anonfun$new$18(this, taskId, x$3))), new StreamTest.ExpectFailure(this, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable)e -> {
                    bl = e.getCause() != null && e.getCause().getCause() instanceof ContinuousTaskRetryException;
                    return BoxedUnit.UNIT;
                }, this.ExpectFailure().apply$default$2(), ClassTag$.MODULE$.apply(SparkException.class))}));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                this.spark().sparkContext().removeSparkListener((SparkListenerInterface)listener);
            }
            return boxedUnit;
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        this.test("query without test harness", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Dataset df = this.spark().readStream().format("rate").option("numPartitions", "2").option("rowsPerSecond", "2").load().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)}));
            StreamingQuery query = df.writeStream().format("memory").queryName("noharness").trigger(Trigger.Continuous((long)100L)).start();
            scala.collection.immutable.Set expected = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
            ContinuousExecution continuousExecution = (ContinuousExecution)((StreamingQueryWrapper)query).streamingQuery();
            this.waitForRateSourceCommittedValue(continuousExecution, (Map<Object, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)3L))}))), 20000L);
            query.stop();
            Row[] results = (Row[])this.spark().read().table("noharness").collect();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((SetOps)expected.map((Function1 & Serializable)x$4 -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$4))})))).subsetOf((Set)Predef$.MODULE$.wrapRefArray((Object[])results).toSet()), "expected.map[org.apache.spark.sql.Row](((x$4: Int) => org.apache.spark.sql.Row.apply(x$4))).subsetOf(scala.Predef.wrapRefArray[org.apache.spark.sql.Row](results).toSet[org.apache.spark.sql.Row])", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Result set " + Predef$.MODULE$.wrapRefArray((Object[])results).toSet() + " are not a superset of " + expected + "!"), Prettifier$.MODULE$.default(), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        new .colon.colon((Object)new IntegratedUDFTestUtils.TestScalaUDF("udf", IntegratedUDFTestUtils$TestScalaUDF$.MODULE$.apply$default$2()), (List)new .colon.colon((Object)new IntegratedUDFTestUtils.TestPythonUDF("udf", IntegratedUDFTestUtils$TestPythonUDF$.MODULE$.apply$default$2()), (List)new .colon.colon((Object)new IntegratedUDFTestUtils.TestScalarPandasUDF("udf", IntegratedUDFTestUtils$TestScalarPandasUDF$.MODULE$.apply$default$2()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)udf -> {
            this.test("continuous mode with various UDFs - " + ((IntegratedUDFTestUtils.TestUDF)udf).prettyName(), (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
                Bool bool;
                Bool bool2;
                Bool bool3;
                Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPandasUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPandasUDFs", Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left.value()) {
                    Product $org_scalatest_assert_macro_left2 = udf;
                    bool3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.IntegratedUDFTestUtils.TestScalarPandasUDF", $org_scalatest_assert_macro_left2 instanceof IntegratedUDFTestUtils.TestScalarPandasUDF, Prettifier$.MODULE$.default());
                } else {
                    bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right = bool3;
                Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left3.value()) {
                    bool2 = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                } else {
                    Bool bool4;
                    Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.simpleMacroBool(IntegratedUDFTestUtils$.MODULE$.shouldTestPythonUDFs(), "org.apache.spark.sql.IntegratedUDFTestUtils.shouldTestPythonUDFs", Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left4.value()) {
                        Product $org_scalatest_assert_macro_left5 = udf;
                        bool4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.IntegratedUDFTestUtils.TestPythonUDF", $org_scalatest_assert_macro_left5 instanceof IntegratedUDFTestUtils.TestPythonUDF, Prettifier$.MODULE$.default());
                    } else {
                        bool4 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                    }
                    Bool $org_scalatest_assert_macro_right2 = bool4;
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool2;
                Bool $org_scalatest_assert_macro_left6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left6.value()) {
                    bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                } else {
                    Product $org_scalatest_assert_macro_left7 = udf;
                    bool = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.IntegratedUDFTestUtils.TestScalaUDF", $org_scalatest_assert_macro_left7 instanceof IntegratedUDFTestUtils.TestScalaUDF, Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right4 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "||", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left6.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
                ContinuousMemoryStream input = ContinuousMemoryStream$.MODULE$.apply($this.testImplicits().newIntEncoder(), $this.sqlContext());
                Dataset df = input.toDF();
                $this.testStream(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{((IntegratedUDFTestUtils.TestUDF)udf).apply((Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{df.apply("value")})).cast("int")})), $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}), $this.testImplicits().newIntEncoder()), $this.StopStream(), $this.AddData().apply(input, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5}), $this.testImplicits().newIntEncoder())}));
            }, new Position("ContinuousSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
            return BoxedUnit.UNIT;
        });
    }
}

