/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.execution.columnar.ColumnAccessor;
import org.apache.spark.sql.execution.columnar.ColumnAccessor$;
import org.apache.spark.sql.execution.columnar.ColumnBuilder;
import org.apache.spark.sql.execution.columnar.ColumnDictionary;
import org.apache.spark.sql.execution.columnar.compression.ColumnBuilderHelper$;
import org.apache.spark.sql.execution.vectorized.Dictionary;
import org.apache.spark.sql.execution.vectorized.MutableColumnarRow;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarRow;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005M4Aa\u0003\u0007\u00013!)a\u0005\u0001C\u0001O!)!\u0006\u0001C\u0005W!)Q\b\u0001C\u0005}!)a\n\u0001C\u0005\u001f\"9\u0011\r\u0001b\u0001\n\u0003\u0011\u0007B\u00024\u0001A\u0003%1\rC\u0004h\u0001\t\u0007I\u0011\u00015\t\r1\u0004\u0001\u0015!\u0003j\u0011\u001di\u0007A1A\u0005\u00029DaA\u001d\u0001!\u0002\u0013y'!E\"pYVlgNV3di>\u00148+^5uK*\u0011QBD\u0001\u000bm\u0016\u001cGo\u001c:ju\u0016$'BA\b\u0011\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0012%\u0005\u00191/\u001d7\u000b\u0005M!\u0012!B:qCJ\\'BA\u000b\u0017\u0003\u0019\t\u0007/Y2iK*\tq#A\u0002pe\u001e\u001c\u0001aE\u0002\u00015y\u0001\"a\u0007\u000f\u000e\u0003II!!\b\n\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tyB%D\u0001!\u0015\t\t#%A\u0003qY\u0006t7O\u0003\u0002$!\u0005A1-\u0019;bYf\u001cH/\u0003\u0002&A\tI1+\u0015'IK2\u0004XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\u000b\u0001\u000e\u00031\t!b^5uQZ+7\r^8s)\ta3\b\u0006\u0002.gA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t!QK\\5u\u0011\u0015!$\u00011\u00016\u0003\u0015\u0011Gn\\2l!\u0011qc\u0007O\u0017\n\u0005]z#!\u0003$v]\u000e$\u0018n\u001c82!\tI\u0013(\u0003\u0002;\u0019\t!rK]5uC\ndWmQ8mk6tg+Z2u_JDQ\u0001\u0010\u0002A\u0002a\naA^3di>\u0014\u0018aC<ji\"4Vm\u0019;peN$2aP!G)\ti\u0003\tC\u00035\u0007\u0001\u0007Q\u0007C\u0003C\u0007\u0001\u00071)\u0001\u0003tSj,\u0007C\u0001\u0018E\u0013\t)uFA\u0002J]RDQaR\u0002A\u0002!\u000b!\u0001\u001a;\u0011\u0005%cU\"\u0001&\u000b\u0005-\u0003\u0012!\u0002;za\u0016\u001c\u0018BA'K\u0005!!\u0015\r^1UsB,\u0017a\u0003;fgR4Vm\u0019;peN$B\u0001\u0015*`AR\u0011Q&\u0015\u0005\u0006i\u0011\u0001\r!\u000e\u0005\u0006'\u0012\u0001\r\u0001V\u0001\u0005]\u0006lW\r\u0005\u0002V9:\u0011aK\u0017\t\u0003/>j\u0011\u0001\u0017\u0006\u00033b\ta\u0001\u0010:p_Rt\u0014BA.0\u0003\u0019\u0001&/\u001a3fM&\u0011QL\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m{\u0003\"\u0002\"\u0005\u0001\u0004\u0019\u0005\"B$\u0005\u0001\u0004A\u0015!C1se\u0006LH+\u001f9f+\u0005\u0019\u0007CA%e\u0013\t)'JA\u0005BeJ\f\u0017\u0010V=qK\u0006Q\u0011M\u001d:bsRK\b/\u001a\u0011\u0002\u000f5\f\u0007\u000fV=qKV\t\u0011\u000e\u0005\u0002JU&\u00111N\u0013\u0002\b\u001b\u0006\u0004H+\u001f9f\u0003!i\u0017\r\u001d+za\u0016\u0004\u0013AC:ueV\u001cG\u000fV=qKV\tq\u000e\u0005\u0002Ja&\u0011\u0011O\u0013\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017aC:ueV\u001cG\u000fV=qK\u0002\u0002")
public class ColumnVectorSuite
extends SparkFunSuite
implements SQLHelper {
    private final ArrayType arrayType;
    private final MapType mapType;
    private final StructType structType;
    private String sparkHome;
    private volatile boolean bitmap$0;

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    private String sparkHome$lzycompute() {
        ColumnVectorSuite columnVectorSuite = this;
        synchronized (columnVectorSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private void withVector(WritableColumnVector vector, Function1<WritableColumnVector, BoxedUnit> block) {
        try {
            block.apply((Object)vector);
        }
        finally {
            vector.close();
        }
    }

    private void withVectors(int size, DataType dt, Function1<WritableColumnVector, BoxedUnit> block) {
        this.withVector((WritableColumnVector)new OnHeapColumnVector(size, dt), block);
        this.withVector((WritableColumnVector)new OffHeapColumnVector(size, dt), block);
    }

    private void testVectors(String name, int size, DataType dt, Function1<WritableColumnVector, BoxedUnit> block) {
        this.test(name, (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withVectors(size, dt, block), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
    }

    public ArrayType arrayType() {
        return this.arrayType;
    }

    public MapType mapType() {
        return this.mapType;
    }

    public StructType structType() {
        return this.structType;
    }

    public static final /* synthetic */ Assertion $anonfun$new$3(ColumnVectorSuite $this, ColumnarArray array$1, ArrayData arrayCopy$1, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$1.get(i, (DataType)BooleanType$.MODULE$));
        boolean $org_scalatest_assert_macro_right = i % 2 == 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$1.get(i, (DataType)BooleanType$.MODULE$));
        boolean $org_scalatest_assert_macro_right2 = i % 2 == 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
    }

    public static final /* synthetic */ void $anonfun$new$1(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendBoolean(i % 2 == 0));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$3($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$6(ColumnVectorSuite $this, ColumnarArray array$2, ArrayData arrayCopy$2, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$2.get(i, (DataType)ByteType$.MODULE$));
        byte $org_scalatest_assert_macro_right = (byte)i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$2.get(i, (DataType)ByteType$.MODULE$));
        byte $org_scalatest_assert_macro_right2 = (byte)i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
    }

    public static final /* synthetic */ void $anonfun$new$4(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendByte((byte)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$6($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$9(ColumnVectorSuite $this, ColumnarArray array$3, ArrayData arrayCopy$3, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$3.get(i, (DataType)ShortType$.MODULE$));
        short $org_scalatest_assert_macro_right = (short)i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$3.get(i, (DataType)ShortType$.MODULE$));
        short $org_scalatest_assert_macro_right2 = (short)i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
    }

    public static final /* synthetic */ void $anonfun$new$7(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendShort((short)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$9($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$12(ColumnVectorSuite $this, ColumnarArray array$4, ArrayData arrayCopy$4, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$4.get(i, (DataType)IntegerType$.MODULE$));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$4.get(i, (DataType)IntegerType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
    }

    public static final /* synthetic */ void $anonfun$new$10(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendInt(i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$12($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$15(ColumnVectorSuite $this, ColumnarArray array$5, ArrayData arrayCopy$5, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$5.get(i, (DataType)DateType$.MODULE$));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$5.get(i, (DataType)DateType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
    }

    public static final /* synthetic */ void $anonfun$new$13(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendInt(i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$15($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$18(ColumnVectorSuite $this, ColumnarArray array$6, ArrayData arrayCopy$6, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$6.get(i, (DataType)LongType$.MODULE$));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$6.get(i, (DataType)LongType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
    }

    public static final /* synthetic */ void $anonfun$new$16(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendLong((long)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$18($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$21(ColumnVectorSuite $this, ColumnarArray array$7, ArrayData arrayCopy$7, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$7.get(i, (DataType)TimestampType$.MODULE$));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$7.get(i, (DataType)TimestampType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
    }

    public static final /* synthetic */ void $anonfun$new$19(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendLong((long)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$21($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$24(ColumnVectorSuite $this, ColumnarArray array$8, ArrayData arrayCopy$8, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$8.get(i, (DataType)TimestampNTZType$.MODULE$));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$8.get(i, (DataType)TimestampNTZType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
    }

    public static final /* synthetic */ void $anonfun$new$22(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendLong((long)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$24($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$27(ColumnVectorSuite $this, ColumnarArray array$9, ArrayData arrayCopy$9, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$9.get(i, (DataType)FloatType$.MODULE$));
        float $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$9.get(i, (DataType)FloatType$.MODULE$));
        float $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
    }

    public static final /* synthetic */ void $anonfun$new$25(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendFloat((float)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$27($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$30(ColumnVectorSuite $this, ColumnarArray array$10, ArrayData arrayCopy$10, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$10.get(i, (DataType)DoubleType$.MODULE$));
        double $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$10.get(i, (DataType)DoubleType$.MODULE$));
        double $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
    }

    public static final /* synthetic */ void $anonfun$new$28(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendDouble((double)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$30($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$33(ColumnVectorSuite $this, ColumnarArray array$11, ArrayData arrayCopy$11, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$11.get(i, (DataType)StringType$.MODULE$));
        UTF8String $org_scalatest_assert_macro_right = UTF8String.fromString((String)("str" + i));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$11.get(i, (DataType)StringType$.MODULE$));
        UTF8String $org_scalatest_assert_macro_right2 = UTF8String.fromString((String)("str" + i));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
    }

    public static final /* synthetic */ void $anonfun$new$31(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcII.sp & Serializable)i -> {
            byte[] utf8 = ("str" + i).getBytes("utf8");
            return testVector.appendByteArray(utf8, 0, utf8.length);
        });
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$33($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$36(ColumnVectorSuite $this, ColumnarArray array$12, ArrayData arrayCopy$12, int i) {
        byte[] utf8 = ("str" + i).getBytes("utf8");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$12.get(i, (DataType)BinaryType$.MODULE$));
        byte[] $org_scalatest_assert_macro_right = utf8;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$12.get(i, (DataType)BinaryType$.MODULE$));
        byte[] $org_scalatest_assert_macro_right2 = utf8;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
    }

    public static final /* synthetic */ void $anonfun$new$34(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcII.sp & Serializable)i -> {
            byte[] utf8 = ("str" + i).getBytes("utf8");
            return testVector.appendByteArray(utf8, 0, utf8.length);
        });
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$36($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$40(ColumnVectorSuite $this, ColumnarArray array$13, YearMonthIntervalType dt$2, ArrayData arrayCopy$13, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$13.get(i, (DataType)dt$2));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$13.get(i, (DataType)dt$2));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
    }

    public static final /* synthetic */ void $anonfun$new$38(ColumnVectorSuite $this, YearMonthIntervalType dt$2, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendInt(i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$40($this, array, dt$2, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$44(ColumnVectorSuite $this, ColumnarArray array$14, DayTimeIntervalType dt$3, ArrayData arrayCopy$14, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$14.get(i, (DataType)dt$3));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$14.get(i, (DataType)dt$3));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
    }

    public static final /* synthetic */ void $anonfun$new$42(ColumnVectorSuite $this, DayTimeIntervalType dt$3, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendLong((long)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$44($this, array, dt$3, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$47(ColumnVectorSuite $this, MutableColumnarRow mutableRow$1, int i) {
        mutableRow$1.rowId = i;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mutableRow$1.getInt(0)));
        int $org_scalatest_assert_macro_right = 10 - i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
    }

    public static final /* synthetic */ void $anonfun$new$45(ColumnVectorSuite $this, WritableColumnVector testVector) {
        MutableColumnarRow mutableRow = new MutableColumnarRow((WritableColumnVector[])((Object[])new WritableColumnVector[]{testVector}));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            mutableRow$1.rowId = i;
            mutableRow.setInt(0, 10 - i);
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$47($this, mutableRow, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ void $anonfun$new$48(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector data = testVector.arrayData();
        for (int i = 0; i < 6; ++i) {
            data.putInt(i, i);
        }
        testVector.putArray(0, 0, 1);
        testVector.putArray(1, 1, 2);
        testVector.putArray(2, 3, 0);
        testVector.putArray(3, 3, 3);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector.getArray(0).toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{0};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(testVector.getArray(1).toIntArray());
        int[] $org_scalatest_assert_macro_right2 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testVector.getArray(2).toIntArray());
        int[] $org_scalatest_assert_macro_right3 = (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(testVector.getArray(3).toIntArray());
        int[] $org_scalatest_assert_macro_right4 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
    }

    public static final /* synthetic */ void $anonfun$new$49(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector data = testVector.arrayData();
        testVector.appendArray(1);
        data.appendInt(0);
        testVector.appendArray(2);
        data.appendInt(1);
        data.appendInt(2);
        testVector.appendArray(0);
        testVector.appendArray(3);
        data.appendInt(3);
        data.appendInt(4);
        data.appendInt(5);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector.getArray(0).toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{0};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(testVector.getArray(1).toIntArray());
        int[] $org_scalatest_assert_macro_right2 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testVector.getArray(2).toIntArray());
        int[] $org_scalatest_assert_macro_right3 = (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(testVector.getArray(3).toIntArray());
        int[] $org_scalatest_assert_macro_right4 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
    }

    public static final /* synthetic */ UTF8String $anonfun$new$51(int i) {
        return UTF8String.fromString((String)("str" + i));
    }

    public static final /* synthetic */ UTF8String $anonfun$new$52(int i) {
        return UTF8String.fromString((String)("str" + i));
    }

    public static final /* synthetic */ void $anonfun$new$50(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector keys = testVector.getChild(0);
        WritableColumnVector values = testVector.getChild(1);
        for (int i2 = 0; i2 < 6; ++i2) {
            keys.appendInt(i2);
            byte[] utf8 = ("str" + i2).getBytes("utf8");
            values.appendByteArray(utf8, 0, utf8.length);
        }
        testVector.putArray(0, 0, 1);
        testVector.putArray(1, 1, 2);
        testVector.putArray(2, 3, 0);
        testVector.putArray(3, 3, 3);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector.getMap(0).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{0};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(testVector.getMap(0).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right2 = (UTF8String[])((Object[])new UTF8String[]{UTF8String.fromString((String)"str0")});
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testVector.getMap(1).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right3 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(testVector.getMap(1).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right4 = (UTF8String[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).map((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$51(BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(testVector.getMap(2).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right5 = (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int());
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(testVector.getMap(2).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right6 = (UTF8String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(testVector.getMap(3).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right7 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(testVector.getMap(3).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right8 = (UTF8String[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).map((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$52(BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
    }

    private static final void appendPair$1(int i, WritableColumnVector keys$1, WritableColumnVector values$1) {
        keys$1.appendInt(i);
        byte[] utf8 = ("str" + i).getBytes("utf8");
        values$1.appendByteArray(utf8, 0, utf8.length);
    }

    public static final /* synthetic */ UTF8String $anonfun$new$54(int i) {
        return UTF8String.fromString((String)("str" + i));
    }

    public static final /* synthetic */ UTF8String $anonfun$new$55(int i) {
        return UTF8String.fromString((String)("str" + i));
    }

    public static final /* synthetic */ void $anonfun$new$53(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector keys = testVector.getChild(0);
        WritableColumnVector values = testVector.getChild(1);
        testVector.appendArray(1);
        ColumnVectorSuite.appendPair$1(0, keys, values);
        testVector.appendArray(2);
        ColumnVectorSuite.appendPair$1(1, keys, values);
        ColumnVectorSuite.appendPair$1(2, keys, values);
        testVector.appendArray(0);
        testVector.appendArray(3);
        ColumnVectorSuite.appendPair$1(3, keys, values);
        ColumnVectorSuite.appendPair$1(4, keys, values);
        ColumnVectorSuite.appendPair$1(5, keys, values);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector.getMap(0).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{0};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(testVector.getMap(0).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right2 = (UTF8String[])((Object[])new UTF8String[]{UTF8String.fromString((String)"str0")});
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testVector.getMap(1).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right3 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(testVector.getMap(1).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right4 = (UTF8String[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).map((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$54(BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(testVector.getMap(2).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right5 = (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int());
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(testVector.getMap(2).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right6 = (UTF8String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(testVector.getMap(3).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right7 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(testVector.getMap(3).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right8 = (UTF8String[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).map((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$55(BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
    }

    public static final /* synthetic */ void $anonfun$new$56(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector c1 = testVector.getChild(0);
        WritableColumnVector c2 = testVector.getChild(1);
        c1.putInt(0, 123);
        c2.putDouble(0, 3.45);
        c1.putInt(1, 456);
        c2.putDouble(1, 5.67);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector.getStruct(0).get(0, (DataType)IntegerType$.MODULE$));
        int $org_scalatest_assert_macro_right = 123;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(testVector.getStruct(0).get(1, (DataType)DoubleType$.MODULE$));
        double $org_scalatest_assert_macro_right2 = 3.45;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testVector.getStruct(1).get(0, (DataType)IntegerType$.MODULE$));
        int $org_scalatest_assert_macro_right3 = 456;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(testVector.getStruct(1).get(1, (DataType)DoubleType$.MODULE$));
        double $org_scalatest_assert_macro_right4 = 5.67;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
    }

    public static final /* synthetic */ void $anonfun$new$57(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new int[]{7, 8, 9});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        int $org_scalatest_assert_macro_left = testVector.getInts(0, 3)[0];
        int $org_scalatest_assert_macro_right = 7;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
        int $org_scalatest_assert_macro_left2 = testVector.getInts(0, 3)[1];
        int $org_scalatest_assert_macro_right2 = 8;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        int $org_scalatest_assert_macro_left3 = testVector.getInts(0, 3)[2];
        int $org_scalatest_assert_macro_right3 = 9;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
    }

    public static final /* synthetic */ void $anonfun$new$58(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new int[]{7, 8, 9});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        short $org_scalatest_assert_macro_left = testVector.getShorts(0, 3)[0];
        short $org_scalatest_assert_macro_right = 7;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
        short $org_scalatest_assert_macro_left2 = testVector.getShorts(0, 3)[1];
        short $org_scalatest_assert_macro_right2 = 8;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
        short $org_scalatest_assert_macro_left3 = testVector.getShorts(0, 3)[2];
        short $org_scalatest_assert_macro_right3 = 9;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
    }

    public static final /* synthetic */ void $anonfun$new$59(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new int[]{7, 8, 9});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        byte $org_scalatest_assert_macro_left = testVector.getBytes(0, 3)[0];
        byte $org_scalatest_assert_macro_right = 7;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
        byte $org_scalatest_assert_macro_left2 = testVector.getBytes(0, 3)[1];
        byte $org_scalatest_assert_macro_right2 = 8;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        byte $org_scalatest_assert_macro_left3 = testVector.getBytes(0, 3)[2];
        byte $org_scalatest_assert_macro_right3 = 9;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
    }

    public static final /* synthetic */ void $anonfun$new$60(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new long[]{0x80000000L, 0x80000001L, 0x80000002L});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        long $org_scalatest_assert_macro_left = testVector.getLongs(0, 3)[0];
        long $org_scalatest_assert_macro_right = 0x80000000L;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
        long $org_scalatest_assert_macro_left2 = testVector.getLongs(0, 3)[1];
        long $org_scalatest_assert_macro_right2 = 0x80000001L;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        long $org_scalatest_assert_macro_left3 = testVector.getLongs(0, 3)[2];
        long $org_scalatest_assert_macro_right3 = 0x80000002L;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
    }

    public static final /* synthetic */ void $anonfun$new$61(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new float[]{0.1f, 0.2f, 0.3f});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        float $org_scalatest_assert_macro_left = testVector.getFloats(0, 3)[0];
        float $org_scalatest_assert_macro_right = 0.1f;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
        float $org_scalatest_assert_macro_left2 = testVector.getFloats(0, 3)[1];
        float $org_scalatest_assert_macro_right2 = 0.2f;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
        float $org_scalatest_assert_macro_left3 = testVector.getFloats(0, 3)[2];
        float $org_scalatest_assert_macro_right3 = 0.3f;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
    }

    public static final /* synthetic */ void $anonfun$new$62(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new double[]{1342.17727, 1342.17728, 1342.17729});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        double $org_scalatest_assert_macro_left = testVector.getDoubles(0, 3)[0];
        double $org_scalatest_assert_macro_right = 1342.17727;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
        double $org_scalatest_assert_macro_left2 = testVector.getDoubles(0, 3)[1];
        double $org_scalatest_assert_macro_right2 = 1342.17728;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
        double $org_scalatest_assert_macro_left3 = testVector.getDoubles(0, 3)[2];
        double $org_scalatest_assert_macro_right3 = 1342.17729;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
    }

    public static final /* synthetic */ Assertion $anonfun$new$67(ColumnVectorSuite $this, WritableColumnVector testVector$15, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector$15.getArray(i).toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{i};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
    }

    public static final /* synthetic */ void $anonfun$new$64(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector data = testVector.arrayData();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> data.putInt(i, i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> testVector.putArray(i, i, 1));
        testVector.reserve(16);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$67($this, testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$71(WritableColumnVector testVector$16, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$16.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = i % 2 == 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
    }

    public static final /* synthetic */ void $anonfun$new$69(WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            if (i % 2 == 0) {
                testVector.putNull(i);
                return;
            }
            testVector.putNotNull(i);
        });
        testVector.reserve(16);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$71(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$75(WritableColumnVector testVector$17, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$17.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
        boolean $org_scalatest_assert_macro_left2 = testVector$17.getBoolean(i);
        boolean $org_scalatest_assert_macro_right2 = i % 2 == 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
    }

    public static final /* synthetic */ void $anonfun$new$74(BooleanType$ dataType$1, ColumnBuilder columnBuilder$1, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$1, columnBuilder$1.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$75(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$79(WritableColumnVector testVector$18, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$18.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
        byte $org_scalatest_assert_macro_left2 = testVector$18.getByte(i);
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
    }

    public static final /* synthetic */ void $anonfun$new$78(ByteType$ dataType$2, ColumnBuilder columnBuilder$2, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$2, columnBuilder$2.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$79(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$83(WritableColumnVector testVector$19, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$19.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568));
        short $org_scalatest_assert_macro_left2 = testVector$19.getShort(i);
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
    }

    public static final /* synthetic */ void $anonfun$new$82(ShortType$ dataType$3, ColumnBuilder columnBuilder$3, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$3, columnBuilder$3.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$83(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$87(WritableColumnVector testVector$20, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$20.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 592));
        int $org_scalatest_assert_macro_left2 = testVector$20.getInt(i);
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
    }

    public static final /* synthetic */ void $anonfun$new$86(IntegerType$ dataType$4, ColumnBuilder columnBuilder$4, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$4, columnBuilder$4.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$87(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$92(WritableColumnVector testVector$21, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$21.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
        long $org_scalatest_assert_macro_left2 = testVector$21.getLong(i);
        long $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617));
    }

    public static final /* synthetic */ void $anonfun$new$91(AtomicType dataType$5, ColumnBuilder columnBuilder$5, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$5, columnBuilder$5.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$92(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ void $anonfun$new$89(ColumnVectorSuite $this, AtomicType dataType) {
        ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
        SpecificInternalRow row = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new AtomicType[]{dataType}));
        row.setNullAt(0);
        columnBuilder.appendFrom((InternalRow)row, 0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            row.setLong(0, (long)i);
            columnBuilder.appendFrom((InternalRow)row, 0);
        });
        $this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$91(dataType, columnBuilder, testVector);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Assertion $anonfun$new$96(WritableColumnVector testVector$22, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$22.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
        float $org_scalatest_assert_macro_left2 = testVector$22.getFloat(i);
        float $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
    }

    public static final /* synthetic */ void $anonfun$new$95(FloatType$ dataType$6, ColumnBuilder columnBuilder$6, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$6, columnBuilder$6.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$96(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$100(WritableColumnVector testVector$23, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$23.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 665));
        double $org_scalatest_assert_macro_left2 = testVector$23.getDouble(i);
        double $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 666));
    }

    public static final /* synthetic */ void $anonfun$new$99(DoubleType$ dataType$7, ColumnBuilder columnBuilder$7, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$7, columnBuilder$7.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 663));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$100(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$107(ColumnVectorSuite $this, WritableColumnVector v$1, YearMonthIntervalType dt$4, int i) {
        ColumnarRow row = v$1.getStruct(i);
        InternalRow rowCopy = row.copy();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(row.get(0, (DataType)dt$4));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(rowCopy.get(0, (DataType)dt$4));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 710));
    }

    public static final /* synthetic */ void $anonfun$new$105(ColumnVectorSuite $this, YearMonthIntervalType dt$4, WritableColumnVector v) {
        WritableColumnVector column = v.getChild(0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> column.putInt(i, i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$107($this, v, dt$4, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ void $anonfun$new$104(ColumnVectorSuite $this, YearMonthIntervalType dt) {
        StructType structType = new StructType().add(dt.typeName(), (DataType)dt);
        $this.testVectors("ColumnarRow " + dt.typeName(), 10, (DataType)structType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)v -> {
            ColumnVectorSuite.$anonfun$new$105($this, dt, v);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Assertion $anonfun$new$111(ColumnVectorSuite $this, WritableColumnVector v$2, DayTimeIntervalType dt$5, int i) {
        ColumnarRow row = v$2.getStruct(i);
        InternalRow rowCopy = row.copy();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(row.get(0, (DataType)dt$5));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(rowCopy.get(0, (DataType)dt$5));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
    }

    public static final /* synthetic */ void $anonfun$new$109(ColumnVectorSuite $this, DayTimeIntervalType dt$5, WritableColumnVector v) {
        WritableColumnVector column = v.getChild(0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> column.putLong(i, (long)i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$111($this, v, dt$5, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ void $anonfun$new$108(ColumnVectorSuite $this, DayTimeIntervalType dt) {
        StructType structType = new StructType().add(dt.typeName(), (DataType)dt);
        $this.testVectors("ColumnarRow " + dt.typeName(), 10, (DataType)structType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)v -> {
            ColumnVectorSuite.$anonfun$new$109($this, dt, v);
            return BoxedUnit.UNIT;
        });
    }

    public ColumnVectorSuite() {
        SQLHelper.$init$((SQLHelper)this);
        this.testVectors("boolean", 10, (DataType)BooleanType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$1(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("byte", 10, (DataType)ByteType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$4(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("short", 10, (DataType)ShortType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$7(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("int", 10, (DataType)IntegerType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$10(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("date", 10, (DataType)DateType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$13(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("long", 10, (DataType)LongType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$16(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("timestamp", 10, (DataType)TimestampType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$19(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("timestamp_ntz", 10, (DataType)TimestampNTZType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$22(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("float", 10, (DataType)FloatType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$25(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("double", 10, (DataType)DoubleType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$28(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("string", 10, (DataType)StringType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$31(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("binary", 10, (DataType)BinaryType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$34(this, testVector);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)dt -> {
            this.testVectors(dt.typeName(), 10, (DataType)dt, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$38($this, dt, testVector);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)dt -> {
            this.testVectors(dt.typeName(), 10, (DataType)dt, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$42($this, dt, testVector);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.testVectors("mutable ColumnarRow", 10, (DataType)IntegerType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$45(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.arrayType = new ArrayType((DataType)IntegerType$.MODULE$, true);
        this.testVectors("array", 10, (DataType)this.arrayType(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$48(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-35898: array append", 1, (DataType)this.arrayType(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$49(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.mapType = MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$);
        this.testVectors("SPARK-35898: map", 5, (DataType)this.mapType(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$50(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-35898: map append", 1, (DataType)this.mapType(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$53(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.structType = new StructType().add("int", (DataType)IntegerType$.MODULE$).add("double", (DataType)DoubleType$.MODULE$);
        this.testVectors("struct", 10, (DataType)this.structType(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$56(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getInts with dictionary", 3, (DataType)IntegerType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$57(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getShorts with dictionary", 3, (DataType)ShortType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$58(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getBytes with dictionary", 3, (DataType)ByteType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$59(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getLongs with dictionary", 3, (DataType)LongType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$60(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getFloats with dictionary", 3, (DataType)FloatType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$61(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getDoubles with dictionary", 3, (DataType)DoubleType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$62(testVector);
            return BoxedUnit.UNIT;
        });
        this.test("[SPARK-22092] off-heap column vector reallocation corrupts array data", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withVector((WritableColumnVector)new OffHeapColumnVector(8, (DataType)this.arrayType()), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$64(this, testVector);
            return BoxedUnit.UNIT;
        }), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
        this.test("[SPARK-22092] off-heap column vector reallocation corrupts struct nullability", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withVector((WritableColumnVector)new OffHeapColumnVector(8, (DataType)this.structType()), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$69(testVector);
            return BoxedUnit.UNIT;
        }), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
        this.test("CachedBatch boolean Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            BooleanType$ dataType = BooleanType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new BooleanType$[]{dataType}));
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setBoolean(0, i % 2 == 0);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$74(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
        this.test("CachedBatch byte Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ByteType$ dataType = ByteType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new ByteType$[]{dataType}));
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setByte(0, (byte)i);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$78(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
        this.test("CachedBatch short Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ShortType$ dataType = ShortType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new ShortType$[]{dataType}));
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setShort(0, (short)i);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$82(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
        this.test("CachedBatch int Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            IntegerType$ dataType = IntegerType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new IntegerType$[]{dataType}));
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setInt(0, i);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$86(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 574));
        this.test("CachedBatch long Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)LongType$.MODULE$, (List)new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)TimestampNTZType$.MODULE$, (List)Nil$.MODULE$))).foreach((Function1 & Serializable)dataType -> {
            ColumnVectorSuite.$anonfun$new$89(this, dataType);
            return BoxedUnit.UNIT;
        }), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 598));
        this.test("CachedBatch float Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            FloatType$ dataType = FloatType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new FloatType$[]{dataType}));
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setFloat(0, (float)i);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$95(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 623));
        this.test("CachedBatch double Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DoubleType$ dataType = DoubleType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new DoubleType$[]{dataType}));
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setDouble(0, (double)i);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$99(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 647));
        this.test("SPARK-44239: Test column vector reserve policy", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.VECTORIZED_HUGE_VECTOR_THRESHOLD().key()), (Object)"300"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.VECTORIZED_HUGE_VECTOR_RESERVE_RATIO().key()), (Object)"1.2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            ByteType$ dataType = ByteType$.MODULE$;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])new WritableColumnVector[]{new OnHeapColumnVector(80, (DataType)dataType), new OffHeapColumnVector(80, (DataType)dataType)}), (Function1 & Serializable)vector -> {
                Assertion assertion;
                try {
                    vector.appendBytes(100, (byte)0);
                    int $org_scalatest_assert_macro_left = vector.capacity;
                    int $org_scalatest_assert_macro_right = 200;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
                    vector.reset();
                    int $org_scalatest_assert_macro_left2 = vector.capacity;
                    int $org_scalatest_assert_macro_right2 = 200;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 684));
                    vector.appendBytes(300, (byte)0);
                    int $org_scalatest_assert_macro_left3 = vector.capacity;
                    int $org_scalatest_assert_macro_right3 = 360;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
                    vector.reset();
                    int $org_scalatest_assert_macro_left4 = vector.capacity;
                    int $org_scalatest_assert_macro_right4 = 80;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
                }
                finally {
                    vector.close();
                }
                return assertion;
            });
        }), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
        DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)dt -> {
            ColumnVectorSuite.$anonfun$new$104(this, dt);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)dt -> {
            ColumnVectorSuite.$anonfun$new$108(this, dt);
            return BoxedUnit.UNIT;
        });
    }
}

