/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.LocalSparkContext$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.streaming.CreateAtomicTestManager;
import org.apache.spark.sql.execution.streaming.CreateAtomicTestManager$;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.state.HDFSBackedStateStoreMap;
import org.apache.spark.sql.execution.streaming.state.HDFSBackedStateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.RenameLikeHDFSFileSystem;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorSuite$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCustomMetric;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreMetrics;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StateStoreSuiteBase;
import org.apache.spark.sql.execution.streaming.state.StateStoreTestsHelper$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.tags.ExtendedSQLTest;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.PrivateMethodTester;
import org.scalatest.Status;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span;
import org.scalatest.time.Span$;
import org.scalatest.time.SpanSugar$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ExtendedSQLTest
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f\u0001B\n\u0015\u0001\rBQ!\r\u0001\u0005\u0002IBQ\u0001\u000e\u0001\u0005BUBQ\u0001\u000e\u0001\u0005BYBQ\u0001\u000e\u0001\u0005\u0002qBQ\u0001\u000e\u0001\u0005B\u001dCQA\u0015\u0001\u0005BMCQ\u0001\u001b\u0001\u0005B%DQA\u001c\u0001\u0005B=DQ\u0001\u000e\u0001\u0005\u0002aD\u0011\"!\u0005\u0001#\u0003%\t!a\u0005\t\u0013\u0005%\u0002!%A\u0005\u0002\u0005-\u0002\"CA\u0018\u0001E\u0005I\u0011AA\n\u0011%\t\t\u0004AI\u0001\n\u0003\t\u0019\u0002C\u0005\u00024\u0001\t\n\u0011\"\u0001\u00026!1A\u0007\u0001C!\u0003sAq!a\u0010\u0001\t\u0003\t\t\u0005C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\ny1\u000b^1uKN#xN]3Tk&$XM\u0003\u0002\u0016-\u0005)1\u000f^1uK*\u0011q\u0003G\u0001\ngR\u0014X-Y7j]\u001eT!!\u0007\u000e\u0002\u0013\u0015DXmY;uS>t'BA\u000e\u001d\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003;y\tQa\u001d9be.T!a\b\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0013aA8sO\u000e\u00011c\u0001\u0001%WA\u0019QE\n\u0015\u000e\u0003QI!a\n\u000b\u0003'M#\u0018\r^3Ti>\u0014XmU;ji\u0016\u0014\u0015m]3\u0011\u0005\u0015J\u0013B\u0001\u0016\u0015\u0005qAEIR*CC\u000e\\W\rZ*uCR,7\u000b^8sKB\u0013xN^5eKJ\u0004\"\u0001L\u0018\u000e\u00035R!A\f\u0011\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018B\u0001\u0019.\u00059\u0011UMZ8sK\u0006sG-\u00114uKJ\fa\u0001P5oSRtD#A\u001a\u0011\u0005\u0015\u0002\u0011\u0001\u00058foN#xN]3Qe>4\u0018\u000eZ3s)\u0005ACC\u0001\u00158\u0011\u0015A4\u00011\u0001:\u0003\u001d\u0019Ho\u001c:f\u0013\u0012\u0004\"!\n\u001e\n\u0005m\"\"\u0001D*uCR,7\u000b^8sK&#Gc\u0001\u0015>}!)\u0001\b\u0002a\u0001s!)q\b\u0002a\u0001\u0001\u0006!1m\u001c8g!\t\tU)D\u0001C\u0015\ty4I\u0003\u0002E=\u00051\u0001.\u00193p_BL!A\u0012\"\u0003\u001b\r{gNZ5hkJ\fG/[8o)\rA\u0003\n\u0015\u0005\u0006\u0013\u0016\u0001\rAS\u0001\u0015[&tG)\u001a7uCN4uN]*oCB\u001c\bn\u001c;\u0011\u0005-sU\"\u0001'\u000b\u00035\u000bQa]2bY\u0006L!a\u0014'\u0003\u0007%sG\u000fC\u0003R\u000b\u0001\u0007!*A\rok6|eMV3sgR{'+\u001a;bS:Le.T3n_JL\u0018!D4fi2\u000bG/Z:u\t\u0006$\u0018\r\u0006\u0002UMB\u0019Q\u000bX0\u000f\u0005YS\u0006CA,M\u001b\u0005A&BA-#\u0003\u0019a$o\\8u}%\u00111\fT\u0001\u0007!J,G-\u001a4\n\u0005us&aA*fi*\u00111\f\u0014\t\u0005\u0017\u0002\u0014'*\u0003\u0002b\u0019\n1A+\u001e9mKJ\u0002Ba\u00131d\u0015B\u0011Q\u000bZ\u0005\u0003Kz\u0013aa\u0015;sS:<\u0007\"B4\u0007\u0001\u0004A\u0013!D:u_J,\u0007K]8wS\u0012,'/A\u0004hKR$\u0015\r^1\u0015\u0007QSG\u000eC\u0003l\u000f\u0001\u0007\u0001&\u0001\u0005qe>4\u0018\u000eZ3s\u0011\u0015iw\u00011\u0001K\u0003\u001d1XM]:j_:\f\u0011cZ3u\t\u00164\u0017-\u001e7u'Fc5i\u001c8g)\r\u0001ho\u001e\t\u0003cRl\u0011A\u001d\u0006\u0003gj\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003kJ\u0014qaU)M\u0007>tg\rC\u0003J\u0011\u0001\u0007!\nC\u0003R\u0011\u0001\u0007!\nF\u0007)sz\f\t!!\u0002\u0002\n\u0005-\u0011Q\u0002\u0005\u0006u&\u0001\ra_\u0001\u0005_BLE\r\u0005\u0002Ly&\u0011Q\u0010\u0014\u0002\u0005\u0019>tw\rC\u0003\u0000\u0013\u0001\u0007!*A\u0005qCJ$\u0018\u000e^5p]\"A\u00111A\u0005\u0011\u0002\u0003\u0007!*\u0001\tok6\u001cu\u000e\\:Qe\u00164\u0017\u000e_&fs\"A\u0011qA\u0005\u0011\u0002\u0003\u00071-A\u0002eSJDq!S\u0005\u0011\u0002\u0003\u0007!\nC\u0004R\u0013A\u0005\t\u0019\u0001&\t\u0011\u0005=\u0011\u0002%AA\u0002\u0001\u000b!\u0002[1e_>\u00048i\u001c8g\u0003iqWm^*u_J,\u0007K]8wS\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t)BK\u0002K\u0003/Y#!!\u0007\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Ga\u0015AC1o]>$\u0018\r^5p]&!\u0011qEA\u000f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001b]\u0016<8\u000b^8sKB\u0013xN^5eKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003[Q3aYA\f\u0003iqWm^*u_J,\u0007K]8wS\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003iqWm^*u_J,\u0007K]8wS\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003iqWm^*u_J,\u0007K]8wS\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\t9DK\u0002A\u0003/!2\u0001KA\u001e\u0011\u0019\tid\u0004a\u0001\u0015\u0006ia.^7Qe\u00164\u0017\u000e_\"pYN\f1c\u00195fG.du.\u00193fIZ+'o]5p]N$\"\"a\u0011\u0002J\u0005\r\u0014qMA6!\rY\u0015QI\u0005\u0004\u0003\u000fb%\u0001B+oSRDq!a\u0013\u0011\u0001\u0004\ti%\u0001\u0006m_\u0006$W\rZ'baN\u0004r!a\u0014\u0002Zm\fi&\u0004\u0002\u0002R)!\u00111KA+\u0003\u0011)H/\u001b7\u000b\u0005\u0005]\u0013\u0001\u00026bm\u0006LA!a\u0017\u0002R\tI1k\u001c:uK\u0012l\u0015\r\u001d\t\u0004K\u0005}\u0013bAA1)\t9\u0002\n\u0012$T\u0005\u0006\u001c7.\u001a3Ti\u0006$Xm\u0015;pe\u0016l\u0015\r\u001d\u0005\u0007\u0003K\u0002\u0002\u0019\u0001&\u0002\u000b\r|WO\u001c;\t\r\u0005%\u0004\u00031\u0001|\u0003-)\u0017M\u001d7jKN$8*Z=\t\r\u00055\u0004\u00031\u0001|\u0003%a\u0017\r^3ti.+\u00170\u0001\u0007dQ\u0016\u001c7NV3sg&|g\u000e\u0006\u0005\u0002D\u0005M\u0014QOA<\u0011\u001d\tY%\u0005a\u0001\u0003\u001bBQ!\\\tA\u0002mDq!!\u001f\u0012\u0001\u0004\tY(\u0001\u0007fqB,7\r^3e\t\u0006$\u0018\rE\u0003V\u0003{\u0012'*C\u0002\u0002\u0000y\u00131!T1q\u0003-\u0019wN\u001d:vaR4\u0015\u000e\\3\u0015\u0011\u0005\r\u0013QQAD\u0003\u0013CQa\u001b\nA\u0002!BQ!\u001c\nA\u0002mDq!a#\u0013\u0001\u0004\ti)\u0001\u0006jgNs\u0017\r]:i_R\u00042aSAH\u0013\r\t\t\n\u0014\u0002\b\u0005>|G.Z1oQ\r\u0001\u0011Q\u0013\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*\u0019\u00111\u0014\u000f\u0002\tQ\fwm]\u0005\u0005\u0003?\u000bIJA\bFqR,g\u000eZ3e'FcE+Z:u\u0001")
public class StateStoreSuite
extends StateStoreSuiteBase<HDFSBackedStateStoreProvider>
implements BeforeAndAfter {
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider() {
        return this.newStoreProvider(Random$.MODULE$.nextInt(), 0, this.newStoreProvider$default$3(), this.newStoreProvider$default$4(), this.newStoreProvider$default$5(), this.newStoreProvider$default$6(), this.newStoreProvider$default$7());
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(StateStoreId storeId) {
        long x$1 = storeId.operatorId();
        int x$2 = storeId.partitionId();
        String x$3 = storeId.checkpointRootLocation();
        int x$4 = this.newStoreProvider$default$3();
        int x$5 = this.newStoreProvider$default$5();
        int x$6 = this.newStoreProvider$default$6();
        Configuration x$7 = this.newStoreProvider$default$7();
        return this.newStoreProvider(x$1, x$2, x$4, x$3, x$5, x$6, x$7);
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(StateStoreId storeId, Configuration conf) {
        long x$1 = storeId.operatorId();
        int x$2 = storeId.partitionId();
        String x$3 = storeId.checkpointRootLocation();
        Configuration x$4 = conf;
        int x$5 = this.newStoreProvider$default$3();
        int x$6 = this.newStoreProvider$default$5();
        int x$7 = this.newStoreProvider$default$6();
        return this.newStoreProvider(x$1, x$2, x$5, x$3, x$6, x$7, x$4);
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(int minDeltasForSnapshot, int numOfVersToRetainInMemory) {
        long x$1 = Random$.MODULE$.nextInt();
        boolean x$2 = false;
        int x$3 = minDeltasForSnapshot;
        int x$4 = numOfVersToRetainInMemory;
        int x$5 = this.newStoreProvider$default$3();
        String x$6 = this.newStoreProvider$default$4();
        Configuration x$7 = this.newStoreProvider$default$7();
        return this.newStoreProvider(x$1, 0, x$5, x$6, x$3, x$4, x$7);
    }

    @Override
    public Set<Tuple2<Tuple2<String, Object>, Object>> getLatestData(HDFSBackedStateStoreProvider storeProvider) {
        return this.getData(storeProvider, -1);
    }

    @Override
    public Set<Tuple2<Tuple2<String, Object>, Object>> getData(HDFSBackedStateStoreProvider provider, int version) {
        return (Set)this.tryWithProviderResource(this.newStoreProvider(provider.stateStoreId()), (Function1 & Serializable)reloadedProvider -> {
            if (version < 0) {
                return reloadedProvider.latestIterator().map((Function1 & Serializable)row -> StateStoreTestsHelper$.MODULE$.rowPairToDataPair((UnsafeRowPair)row)).toSet();
            }
            return reloadedProvider.getStore((long)version).iterator().map((Function1 & Serializable)row -> StateStoreTestsHelper$.MODULE$.rowPairToDataPair((UnsafeRowPair)row)).toSet();
        });
    }

    @Override
    public SQLConf getDefaultSQLConf(int minDeltasForSnapshot, int numOfVersToRetainInMemory) {
        SQLConf sqlConf = new SQLConf();
        sqlConf.setConf(SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT(), (Object)BoxesRunTime.boxToInteger((int)minDeltasForSnapshot));
        sqlConf.setConf(SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY(), (Object)BoxesRunTime.boxToInteger((int)numOfVersToRetainInMemory));
        sqlConf.setConf(SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN(), (Object)BoxesRunTime.boxToInteger((int)2));
        sqlConf.setConf(SQLConf$.MODULE$.STATE_STORE_COMPRESSION_CODEC(), (Object)SQLConf$.MODULE$.get().stateStoreCompressionCodec());
        return sqlConf;
    }

    public HDFSBackedStateStoreProvider newStoreProvider(long opId, int partition, int numColsPrefixKey, String dir, int minDeltasForSnapshot, int numOfVersToRetainInMemory, Configuration hadoopConf) {
        SQLConf sqlConf = this.getDefaultSQLConf(minDeltasForSnapshot, numOfVersToRetainInMemory);
        HDFSBackedStateStoreProvider provider = new HDFSBackedStateStoreProvider();
        provider.init(new StateStoreId(dir, opId, partition, StateStoreId$.MODULE$.apply$default$4()), this.keySchema(), this.valueSchema(), numColsPrefixKey, new StateStoreConf(sqlConf, StateStoreConf$.MODULE$.$lessinit$greater$default$2()), hadoopConf);
        return provider;
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(int numPrefixCols) {
        return this.newStoreProvider(Random$.MODULE$.nextInt(), 0, numPrefixCols, this.newStoreProvider$default$4(), this.newStoreProvider$default$5(), this.newStoreProvider$default$6(), this.newStoreProvider$default$7());
    }

    public int newStoreProvider$default$3() {
        return 0;
    }

    public String newStoreProvider$default$4() {
        return StateStoreTestsHelper$.MODULE$.newDir();
    }

    public int newStoreProvider$default$5() {
        return BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT().defaultValue().get());
    }

    public int newStoreProvider$default$6() {
        return BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY().defaultValue().get());
    }

    public Configuration newStoreProvider$default$7() {
        return new Configuration();
    }

    public void checkLoadedVersions(SortedMap<Object, HDFSBackedStateStoreMap> loadedMaps, int count, long earliestKey, long latestKey) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedMaps.size()));
        int $org_scalatest_assert_macro_right = count;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 861));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(loadedMaps.firstKey());
        long $org_scalatest_assert_macro_right2 = earliestKey;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 862));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(loadedMaps.lastKey());
        long $org_scalatest_assert_macro_right3 = latestKey;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 863));
    }

    public void checkVersion(SortedMap<Object, HDFSBackedStateStoreMap> loadedMaps, long version, Map<Tuple2<String, Object>, Object> expectedData) {
        Map originValueMap = ((HDFSBackedStateStoreMap)loadedMaps.get(BoxesRunTime.boxToLong((long)version))).iterator().map((Function1 & Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(StateStoreTestsHelper$.MODULE$.keyRowToData(entry.key())), (Object)BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.valueRowToData(entry.value())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(originValueMap);
        Map<Tuple2<String, Object>, Object> $org_scalatest_assert_macro_right = expectedData;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 874));
    }

    public void corruptFile(HDFSBackedStateStoreProvider provider, long version, boolean isSnapshot) {
        PrivateMethodTester.PrivateMethod method = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "baseDir"));
        Path basePath = (Path)this.anyRefToInvoker(provider).invokePrivate(method.apply((Seq)Nil$.MODULE$));
        String fileName = isSnapshot ? version + ".snapshot" : version + ".delta";
        File filePath = new File(basePath.toString(), fileName);
        filePath.delete();
        filePath.createNewFile();
    }

    public static final /* synthetic */ void $anonfun$new$4(StateStoreSuite $this, HDFSBackedStateStoreProvider provider) {
        int currentVersion = 0;
        currentVersion = $this.incrementVersion((StateStoreProvider)provider, currentVersion);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getLatestData(provider));
        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        SortedMap loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 1, 1L, 1L);
        $this.checkVersion(loadedMaps, 1L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}))));
        currentVersion = $this.incrementVersion((StateStoreProvider)provider, currentVersion);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.getLatestData(provider));
        Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 2, 2L, 1L);
        $this.checkVersion(loadedMaps, 2L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        $this.checkVersion(loadedMaps, 1L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}))));
        currentVersion = $this.incrementVersion((StateStoreProvider)provider, currentVersion);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer($this.getLatestData(provider));
        Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)3))}));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 2, 3L, 2L);
        $this.checkVersion(loadedMaps, 3L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)3))}))));
        $this.checkVersion(loadedMaps, 2L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}))));
    }

    public static final /* synthetic */ void $anonfun$new$6(StateStoreSuite $this, HDFSBackedStateStoreProvider provider) {
        int currentVersion = 0;
        currentVersion = $this.incrementVersion((StateStoreProvider)provider, currentVersion);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getLatestData(provider));
        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        SortedMap loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 1, 1L, 1L);
        $this.checkVersion(loadedMaps, 1L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}))));
        currentVersion = $this.incrementVersion((StateStoreProvider)provider, currentVersion);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.getLatestData(provider));
        Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 1, 2L, 2L);
        $this.checkVersion(loadedMaps, 2L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        currentVersion = 1;
        StateStore store = provider.getStore((long)currentVersion);
        StateStoreTestsHelper$.MODULE$.put(store, "a", 0, -2);
        store.commit();
        ++currentVersion;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer($this.getLatestData(provider));
        Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)-2))}));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 1, 2L, 2L);
        $this.checkVersion(loadedMaps, 2L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)-2))}))));
    }

    public static final /* synthetic */ boolean $anonfun$new$15(File x$1) {
        return x$1.getName().startsWith("temp-");
    }

    public static final /* synthetic */ void $anonfun$new$17(StateStoreSuite $this, HDFSBackedStateStoreProvider provider) {
        SparkException e;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            StateStore store = provider.getStore((long)(i - 1));
            StateStoreTestsHelper$.MODULE$.put(store, "a", 0, i);
            store.commit();
            provider.doMaintenance();
        });
        int snapshotVersion = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10).find((Function1)(JFunction1.mcZI.sp & Serializable)version -> $this.fileExists(provider, version, true)).getOrElse((Function0 & Serializable)() -> $this.fail("snapshot file not found", new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247))));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getData(provider, snapshotVersion));
        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)snapshotVersion))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        $this.corruptFile(provider, snapshotVersion, true);
        SparkException x$36 = e = (SparkException)$this.intercept((Function0 & Serializable)() -> $this.getData(provider, snapshotVersion), ClassTag$.MODULE$.apply(SparkException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        String x$37 = "CANNOT_LOAD_STATE_STORE.UNCATEGORIZED";
        Map x$38 = Predef$.MODULE$.Map().empty();
        Option x$39 = $this.checkError$default$3();
        boolean x$40 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$41 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$36, "CANNOT_LOAD_STATE_STORE.UNCATEGORIZED", x$39, x$38, x$40, x$41);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.getData(provider, snapshotVersion - 1));
        Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)(snapshotVersion - 1)))}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        $this.corruptFile(provider, snapshotVersion - 1, false);
        SparkException x$42 = e = (SparkException)$this.intercept((Function0 & Serializable)() -> $this.getData(provider, snapshotVersion - 1), ClassTag$.MODULE$.apply(SparkException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        String x$43 = "CANNOT_LOAD_STATE_STORE.UNCATEGORIZED";
        Map x$44 = Predef$.MODULE$.Map().empty();
        Option x$45 = $this.checkError$default$3();
        boolean x$46 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$47 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$42, "CANNOT_LOAD_STATE_STORE.UNCATEGORIZED", x$45, x$44, x$46, x$47);
        $this.deleteFilesEarlierThanVersion(provider, snapshotVersion);
        e = (SparkException)$this.intercept((Function0 & Serializable)() -> $this.getData(provider, snapshotVersion - 1), ClassTag$.MODULE$.apply(SparkException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        SparkThrowable x$48 = (SparkThrowable)e.getCause();
        String x$49 = "CANNOT_LOAD_STATE_STORE.CANNOT_READ_DELTA_FILE_NOT_EXISTS";
        Map x$50 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fileToRead"), (Object)(provider.stateStoreId().storeCheckpointLocation() + "/1.delta")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)String.valueOf(provider.toString()))}));
        Option x$51 = $this.checkError$default$3();
        boolean x$52 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$53 = $this.checkError$default$6();
        $this.checkError(x$48, "CANNOT_LOAD_STATE_STORE.CANNOT_READ_DELTA_FILE_NOT_EXISTS", x$51, x$50, x$52, x$53);
    }

    public static final /* synthetic */ boolean $anonfun$new$25(Tuple2 x$2) {
        String string = ((StateStoreCustomMetric)x$2._1()).name();
        String string2 = "stateOnCurrentVersionSizeBytes";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final long getSizeOfStateForCurrentVersion$1(StateStoreMetrics metrics) {
        Option metricPair = metrics.customMetrics().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$25(x$2)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metricPair.isDefined(), "metricPair.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
        return ((Tuple2)metricPair.get())._2$mcJ$sp();
    }

    private final void generateStoreVersions$1(StateStoreProviderId storeProviderId1$1, IntRef latestStoreVersion$1, StateStoreConf storeConf$1, Configuration hadoopConf$1) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            StateStore store = StateStore$.MODULE$.get(storeProviderId1$1, this.keySchema(), this.valueSchema(), 0, (long)latestStoreVersion$1.elem, storeConf$1, hadoopConf$1);
            StateStoreTestsHelper$.MODULE$.put(store, "a", 0, i);
            store.commit();
            ++latestStoreVersion$1.elem;
        });
    }

    public static final /* synthetic */ void $anonfun$new$31(StateStoreSuite $this, Span timeoutDuration$1, StateStoreProviderId storeProviderId1$1, IntRef latestStoreVersion$1, StateStoreConf storeConf$1, Configuration hadoopConf$1, StateStoreProviderId storeProviderId2$1, StateStoreCoordinatorRef coordinatorRef) {
        Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning(), (Function0 & Serializable)() -> "StateStore is unexpectedly running");
        $this.generateStoreVersions$1(storeProviderId1$1, latestStoreVersion$1, storeConf$1, hadoopConf$1);
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable)() -> {
            Option $org_scalatest_assert_macro_left = coordinatorRef.getLocation(storeProviderId1$1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"active instance was not reported", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isMaintenanceRunning(), "StateStore.isMaintenanceRunning", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Maintenance task is not running", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
            return (Assertion)$this.tryWithProviderResource($this.newStoreProvider(storeProviderId1$1.storeId()), (Function1 & Serializable)provider -> {
                IndexedSeq snapshotVersions;
                IndexedSeq $org_scalatest_assert_macro_left = snapshotVersions = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), latestStoreVersion$1.elem).filter((Function1)(JFunction1.mcZI.sp & Serializable)version -> $this.fileExists(provider, version, true));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no snapshot file found", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
            });
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
        $this.generateStoreVersions$1(storeProviderId1$1, latestStoreVersion$1, storeConf$1, hadoopConf$1);
        $this.tryWithProviderResource($this.newStoreProvider(storeProviderId1$1.storeId()), (Function1 & Serializable)provider -> (Assertion)Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.fileExists(provider, 1L, false), "StateStoreSuite.this.fileExists(provider, 1L, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"earliest file not deleted", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368)));
        coordinatorRef.deactivateInstances(storeProviderId1$1.queryRunId());
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        StateStore$.MODULE$.get(storeProviderId1$1, $this.keySchema(), $this.valueSchema(), 0, (long)latestStoreVersion$1.elem, storeConf$1, hadoopConf$1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
        coordinatorRef.reportActiveInstance(storeProviderId1$1, "other-host", "other-exec", (Seq)scala.package$.MODULE$.Seq().empty());
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        StateStore$.MODULE$.get(storeProviderId1$1, $this.keySchema(), $this.valueSchema(), 0, (long)latestStoreVersion$1.elem, storeConf$1, hadoopConf$1);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        coordinatorRef.reportActiveInstance(storeProviderId1$1, "other-host", "other-exec", (Seq)scala.package$.MODULE$.Seq().empty());
        StateStore$.MODULE$.get(storeProviderId2$1, $this.keySchema(), $this.valueSchema(), 0, 0L, storeConf$1, hadoopConf$1);
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId2$1), "StateStore.isLoaded(storeProviderId2)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
    }

    private final void generateStoreVersions$2(StateStoreProviderId storeProviderId1$2, IntRef latestStoreVersion$2, StateStoreConf storeConf$2, Configuration hadoopConf$2) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            StateStore store = StateStore$.MODULE$.get(storeProviderId1$2, this.keySchema(), this.valueSchema(), 0, (long)latestStoreVersion$2.elem, storeConf$2, hadoopConf$2);
            StateStoreTestsHelper$.MODULE$.put(store, "a", 0, i);
            store.commit();
            ++latestStoreVersion$2.elem;
        });
    }

    public static final /* synthetic */ void $anonfun$new$45(StateStoreSuite $this, Span timeoutDuration$2, StateStoreProviderId storeProviderId1$2, IntRef latestStoreVersion$2, StateStoreConf storeConf$2, Configuration hadoopConf$2, StateStoreCoordinatorRef coordinatorRef) {
        Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning(), (Function0 & Serializable)() -> "StateStore is unexpectedly running");
        $this.generateStoreVersions$2(storeProviderId1$2, latestStoreVersion$2, storeConf$2, hadoopConf$2);
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$2), (Function0 & Serializable)() -> {
            Option $org_scalatest_assert_macro_left = coordinatorRef.getLocation(storeProviderId1$2);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"active instance was not reported", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isMaintenanceRunning(), "StateStore.isMaintenanceRunning", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Maintenance task is not running", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
            return (Assertion)$this.tryWithProviderResource($this.newStoreProvider(storeProviderId1$2.storeId()), (Function1 & Serializable)provider -> {
                IndexedSeq snapshotVersions;
                IndexedSeq $org_scalatest_assert_macro_left = snapshotVersions = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), latestStoreVersion$2.elem).filter((Function1)(JFunction1.mcZI.sp & Serializable)version -> $this.fileExists(provider, version, true));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no snapshot file found", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
            });
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
        $this.generateStoreVersions$2(storeProviderId1$2, latestStoreVersion$2, storeConf$2, hadoopConf$2);
        coordinatorRef.deactivateInstances(storeProviderId1$2.queryRunId());
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$2), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$2), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
        $this.tryWithProviderResource($this.newStoreProvider(storeProviderId1$2.storeId()), (Function1 & Serializable)provider -> (Assertion)Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$2), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.fileExists(provider, 1L, false), "StateStoreSuite.this.fileExists(provider, 1L, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"earliest file not deleted", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$55(StateStoreSuite $this, HDFSBackedStateStoreProvider provider$7, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.fileExists(provider$7, i, false), "StateStoreSuite.this.fileExists(provider, i.toLong, false)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.fileExists(provider$7, i, true), "StateStoreSuite.this.fileExists(provider, i.toLong, true)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
    }

    private static final int numTempFiles$1(File deltaFileDir$1) {
        if (deltaFileDir$1.exists()) {
            return ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])deltaFileDir$1.listFiles()), (Function1 & Serializable)x$3 -> x$3.getName(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)n.endsWith(".tmp")));
        }
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$new$64(String n) {
        return n.contains(".delta") && !n.startsWith(".");
    }

    private static final int numDeltaFiles$1(File deltaFileDir$1) {
        if (deltaFileDir$1.exists()) {
            return ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])deltaFileDir$1.listFiles()), (Function1 & Serializable)x$4 -> x$4.getName(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$64(n)));
        }
        return 0;
    }

    private final Object shouldNotCreateTempFile$1(Function0 body, File deltaFileDir$1) {
        int before = StateStoreSuite.numTempFiles$1(deltaFileDir$1);
        Object result = body.apply();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir$1)));
        int $org_scalatest_assert_macro_right = before;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 559));
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$new$67(Tuple2 x$5) {
        Object object = x$5._1();
        String string = "a";
        return !(object != null ? !object.equals(string) : string != null);
    }

    private final Seq runQueryAndGetLoadedProviders$1(MemoryStream inputData$1, File checkpointLocation$1) {
        Seq seq;
        HashMap loadedProvidersMap;
        Dataset aggregated = inputData$1.toDF().groupBy("value", (Seq)Nil$.MODULE$).agg((Column)functions$.MODULE$.count("*"), (Seq)Nil$.MODULE$);
        StreamingQuery query = aggregated.writeStream().format("memory").outputMode("complete").queryName("query").option("checkpointLocation", checkpointLocation$1.toString()).start();
        inputData$1.addData((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        query.processAllAvailable();
        Predef$.MODULE$.require(query.lastProgress() != null);
        PrivateMethodTester.PrivateMethod loadedProvidersMethod = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "loadedProviders"));
        HashMap hashMap = loadedProvidersMap = (HashMap)this.anyRefToInvoker(StateStore$.MODULE$).invokePrivate(loadedProvidersMethod.apply((Seq)Nil$.MODULE$));
        synchronized (hashMap) {
            seq = loadedProvidersMap.values().toSeq();
        }
        Seq loadedProviders = seq;
        query.stop();
        return loadedProviders;
    }

    public static final /* synthetic */ void $anonfun$new$70(SparkSession spark) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])spark.streams().active()), (Function1 & Serializable)x$6 -> {
            x$6.stop();
            return BoxedUnit.UNIT;
        });
        spark.stop();
    }

    public static final /* synthetic */ String $anonfun$new$75(long x$7) {
        return Long.toString(x$7);
    }

    public static final /* synthetic */ boolean $anonfun$new$80(String name$1, Tuple2 x$8) {
        String string = ((StateStoreCustomMetric)x$8._1()).name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final long getCustomMetric$1(StateStoreMetrics metrics, String name) {
        Option metricPair = metrics.customMetrics().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$80(name, x$8)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metricPair.isDefined(), "metricPair.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 697));
        return ((Tuple2)metricPair.get())._2$mcJ$sp();
    }

    private static final long getLoadedMapSizeMetric$1(StateStoreMetrics metrics) {
        return metrics.memoryUsedBytes();
    }

    private final void assertCacheHitAndMiss$1(StateStoreMetrics metrics, long expectedCacheHitCount, long expectedCacheMissCount) {
        long cacheHitCount = StateStoreSuite.getCustomMetric$1(metrics, "loadedMapCacheHitCount");
        long cacheMissCount = StateStoreSuite.getCustomMetric$1(metrics, "loadedMapCacheMissCount");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cacheHitCount));
        long $org_scalatest_assert_macro_right = expectedCacheHitCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cacheMissCount));
        long $org_scalatest_assert_macro_right2 = expectedCacheMissCount;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
    }

    public static final /* synthetic */ boolean $anonfun$new$82(Tuple2 x$9) {
        return ((String)x$9._1()).startsWith("a");
    }

    public static final /* synthetic */ void $anonfun$new$81(StateStoreSuite $this, ObjectRef store$2, LongRef loadedMapSizeForVersion1$1, HDFSBackedStateStoreProvider provider) {
        long loadedMapSizeForVersion1And2;
        long initialLoadedMapSize;
        Set<Tuple2<Tuple2<String, Object>, Object>> $org_scalatest_assert_macro_left = $this.getLatestData(provider);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 719));
        store$2.elem = provider.getStore(0L);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((StateStore)store$2.elem).hasCommitted(), "store.hasCommitted", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)((StateStore)store$2.elem).metrics().numKeys()));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
        long $org_scalatest_assert_macro_left3 = initialLoadedMapSize = StateStoreSuite.getLoadedMapSizeMetric$1(((StateStore)store$2.elem).metrics());
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 >= (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
        $this.assertCacheHitAndMiss$1(((StateStore)store$2.elem).metrics(), 0L, 0L);
        StateStoreTestsHelper$.MODULE$.put((StateStore)store$2.elem, "a", 0, 1);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)((StateStore)store$2.elem).metrics().numKeys()));
        int $org_scalatest_assert_macro_right3 = 1;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
        StateStoreTestsHelper$.MODULE$.put((StateStore)store$2.elem, "b", 0, 2);
        StateStoreTestsHelper$.MODULE$.put((StateStore)store$2.elem, "aa", 0, 3);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)((StateStore)store$2.elem).metrics().numKeys()));
        int $org_scalatest_assert_macro_right4 = 3;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 735));
        StateStoreTestsHelper$.MODULE$.remove((StateStore)store$2.elem, (Function1<Tuple2<String, Object>, Object>)(Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$82(x$9)));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)((StateStore)store$2.elem).metrics().numKeys()));
        int $org_scalatest_assert_macro_right5 = 1;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 737));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)((StateStore)store$2.elem).commit()));
        int $org_scalatest_assert_macro_right6 = 1;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(((StateStore)store$2.elem).hasCommitted(), "store.hasCommitted", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 740));
        long $org_scalatest_assert_macro_left8 = loadedMapSizeForVersion1$1.elem = StateStoreSuite.getLoadedMapSizeMetric$1(((StateStore)store$2.elem).metrics());
        long $org_scalatest_assert_macro_right7 = initialLoadedMapSize;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left8), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8 > $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
        $this.assertCacheHitAndMiss$1(((StateStore)store$2.elem).metrics(), 0L, 0L);
        StateStore storeV2 = provider.getStore(1L);
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(storeV2.hasCommitted(), "storeV2.hasCommitted", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeV2.metrics().numKeys()));
        int $org_scalatest_assert_macro_right8 = 1;
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 748));
        StateStoreTestsHelper$.MODULE$.put(storeV2, "cc", 0, 4);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeV2.metrics().numKeys()));
        int $org_scalatest_assert_macro_right9 = 2;
        Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 751));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeV2.commit()));
        int $org_scalatest_assert_macro_right10 = 2;
        Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 752));
        Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(storeV2.hasCommitted(), "storeV2.hasCommitted", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
        long $org_scalatest_assert_macro_left12 = loadedMapSizeForVersion1And2 = StateStoreSuite.getLoadedMapSizeMetric$1(storeV2.metrics());
        long $org_scalatest_assert_macro_right11 = loadedMapSizeForVersion1$1.elem;
        Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left12), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left12 > $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 757));
        $this.assertCacheHitAndMiss$1(storeV2.metrics(), 1L, 0L);
    }

    public static final /* synthetic */ void $anonfun$new$83(StateStoreSuite $this, LongRef loadedMapSizeForVersion1$1, HDFSBackedStateStoreProvider reloadedProvider) {
        StateStore reloadedStore = reloadedProvider.getStore(1L);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)reloadedStore.metrics().numKeys()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
        $this.assertCacheHitAndMiss$1(reloadedStore.metrics(), 0L, 1L);
        StateStore reloadedStoreV2 = reloadedProvider.getStore(2L);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)reloadedStoreV2.metrics().numKeys()));
        int $org_scalatest_assert_macro_right2 = 2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 772));
        long $org_scalatest_assert_macro_left3 = StateStoreSuite.getLoadedMapSizeMetric$1(reloadedStoreV2.metrics());
        long $org_scalatest_assert_macro_right3 = loadedMapSizeForVersion1$1.elem;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 774));
        $this.assertCacheHitAndMiss$1(reloadedStoreV2.metrics(), 0L, 2L);
    }

    public StateStoreSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            StateStore$.MODULE$.stop();
            Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning());
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            StateStore$.MODULE$.stop();
            Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning());
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("retaining only two latest versions when MAX_BATCHES_TO_RETAIN_IN_MEMORY set to 2", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.tryWithProviderResource(this.newStoreProvider(10, 2), (Function1 & Serializable)provider -> {
            StateStoreSuite.$anonfun$new$4(this, provider);
            return BoxedUnit.UNIT;
        }), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("failure after committing with MAX_BATCHES_TO_RETAIN_IN_MEMORY set to 1", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long x$1 = Random$.MODULE$.nextInt();
            boolean x$2 = false;
            boolean x$3 = true;
            int x$4 = this.newStoreProvider$default$3();
            String x$5 = this.newStoreProvider$default$4();
            int x$6 = this.newStoreProvider$default$5();
            Configuration x$7 = this.newStoreProvider$default$7();
            this.tryWithProviderResource(this.newStoreProvider(x$1, 0, x$4, x$5, x$6, 1, x$7), (Function1 & Serializable)provider -> {
                StateStoreSuite.$anonfun$new$6(this, provider);
                return BoxedUnit.UNIT;
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        this.test("no cache data with MAX_BATCHES_TO_RETAIN_IN_MEMORY set to 0", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long x$8 = Random$.MODULE$.nextInt();
            boolean x$9 = false;
            boolean x$10 = false;
            int x$11 = this.newStoreProvider$default$3();
            String x$12 = this.newStoreProvider$default$4();
            int x$13 = this.newStoreProvider$default$5();
            Configuration x$14 = this.newStoreProvider$default$7();
            return (Assertion)this.tryWithProviderResource(this.newStoreProvider(x$8, 0, x$11, x$12, x$13, 0, x$14), (Function1 & Serializable)provider -> {
                int currentVersion = 0;
                currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider));
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
                SortedMap loadedMaps = provider.getLoadedMaps();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedMaps.size()));
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
                currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider));
                Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
                loadedMaps = provider.getLoadedMaps();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedMaps.size()));
                int $org_scalatest_assert_macro_right4 = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test("cleaning", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long x$15 = Random$.MODULE$.nextInt();
            boolean x$16 = false;
            int x$17 = 5;
            int x$18 = this.newStoreProvider$default$3();
            String x$19 = this.newStoreProvider$default$4();
            int x$20 = this.newStoreProvider$default$6();
            Configuration x$21 = this.newStoreProvider$default$7();
            return (Assertion)this.tryWithProviderResource(this.newStoreProvider(x$15, 0, x$18, x$19, 5, x$20, x$21), (Function1 & Serializable)provider -> {
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    StateStore store = provider.getStore((long)(i - 1));
                    StateStoreTestsHelper$.MODULE$.put(store, "a", 0, i);
                    store.commit();
                    provider.doMaintenance();
                });
                Predef$.MODULE$.require(this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.rowPairsToDataSet((Iterator<UnsafeRowPair>)provider.latestIterator())).$eq$eq$eq(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)20))})), Equality$.MODULE$.default()), (Function0 & Serializable)() -> "store not updated correctly");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.fileExists(provider, 1L, false), "StateStoreSuite.this.fileExists(provider, 1L, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData((HDFSBackedStateStoreProvider)provider, 20));
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)20))}));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getData((HDFSBackedStateStoreProvider)provider, 19));
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)19))}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.testQuietly("SPARK-19677: Committing a delta file atop an existing one should not fail on HDFS", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Configuration conf = new Configuration();
            conf.set("fs.fake.impl", RenameLikeHDFSFileSystem.class.getName());
            conf.set("fs.defaultFS", "fake:///");
            long x$22 = Random$.MODULE$.nextInt();
            boolean x$23 = false;
            Configuration x$24 = conf;
            int x$25 = this.newStoreProvider$default$3();
            String x$26 = this.newStoreProvider$default$4();
            int x$27 = this.newStoreProvider$default$5();
            int x$28 = this.newStoreProvider$default$6();
            this.tryWithProviderResource(this.newStoreProvider(x$22, 0, x$25, x$26, x$27, x$28, x$24), (Function1 & Serializable)provider -> {
                Iterable tempFiles;
                provider.getStore(0L).commit();
                provider.getStore(0L).commit();
                Iterable $org_scalatest_assert_macro_left = tempFiles = (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(FileUtils.listFiles((File)new File(provider.stateStoreId().checkpointRootLocation()), null, (boolean)true)).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$15(x$1)));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            });
        });
        this.test("corrupted file handling", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long x$29 = Random$.MODULE$.nextInt();
            boolean x$30 = false;
            int x$31 = 5;
            int x$32 = this.newStoreProvider$default$3();
            String x$33 = this.newStoreProvider$default$4();
            int x$34 = this.newStoreProvider$default$6();
            Configuration x$35 = this.newStoreProvider$default$7();
            this.tryWithProviderResource(this.newStoreProvider(x$29, 0, x$32, x$33, 5, x$34, x$35), (Function1 & Serializable)provider -> {
                StateStoreSuite.$anonfun$new$17(this, provider);
                return BoxedUnit.UNIT;
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        this.test("reports memory usage on current version", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource(this.newStoreProvider(), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            long noDataMemoryUsed = StateStoreSuite.getSizeOfStateForCurrentVersion$1(store.metrics());
            StateStoreTestsHelper$.MODULE$.put(store, "a", 0, 1);
            store.commit();
            long $org_scalatest_assert_macro_left = StateStoreSuite.getSizeOfStateForCurrentVersion$1(store.metrics());
            long $org_scalatest_assert_macro_right = noDataMemoryUsed;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
        }), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        this.test("maintenance", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("test");
            int opId = 0;
            String dir1 = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeProviderId1 = new StateStoreProviderId(new StateStoreId(dir1, (long)opId, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            String dir2 = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeProviderId2 = new StateStoreProviderId(new StateStoreId(dir2, (long)opId, 1, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            SQLConf sqlConf = this.getDefaultSQLConf(BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT().defaultValue().get()), BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY().defaultValue().get()));
            sqlConf.setConf(SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN(), (Object)BoxesRunTime.boxToInteger((int)2));
            sqlConf.setConf(SQLConf$.MODULE$.STREAMING_MAINTENANCE_INTERVAL(), (Object)BoxesRunTime.boxToLong((long)10L));
            StateStoreConf storeConf = StateStoreConf$.MODULE$.apply(sqlConf);
            Configuration hadoopConf = new Configuration();
            IntRef latestStoreVersion = IntRef.create((int)0);
            Span timeoutDuration = SpanSugar$.MODULE$.convertIntToGrainOfTime(1).minute();
            return (Assertion)package$.MODULE$.quietly((Function0 & Serializable)() -> {
                LocalSparkContext$.MODULE$.withSpark(SparkContext$.MODULE$.getOrCreate(conf), (Function1 & Serializable)sc -> {
                    StateStoreCoordinatorSuite$.MODULE$.withCoordinatorRef(sc, (Function1<StateStoreCoordinatorRef, BoxedUnit>)(Function1 & Serializable)coordinatorRef -> {
                        StateStoreSuite.$anonfun$new$31($this, timeoutDuration$1, storeProviderId1$1, latestStoreVersion$1, storeConf$1, hadoopConf$1, storeProviderId2$1, coordinatorRef);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return (Assertion)Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration), (Function0 & Serializable)() -> {
                    Predef$.MODULE$.require(this.convertToEqualizer(SparkEnv$.MODULE$.get()).$eq$eq$eq(null));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId2), "StateStore.isLoaded(storeProviderId2)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isMaintenanceRunning(), "StateStore.isMaintenanceRunning", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        this.test("SPARK-40492: maintenance before unload", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("SPARK-40492");
            int opId = 0;
            String dir1 = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeProviderId1 = new StateStoreProviderId(new StateStoreId(dir1, (long)opId, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            SQLConf sqlConf = this.getDefaultSQLConf(BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT().defaultValue().get()), BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY().defaultValue().get()));
            sqlConf.setConf(SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN(), (Object)BoxesRunTime.boxToInteger((int)2));
            sqlConf.setConf(SQLConf$.MODULE$.STREAMING_MAINTENANCE_INTERVAL(), (Object)BoxesRunTime.boxToLong((long)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).minute()).toMillis()));
            StateStoreConf storeConf = StateStoreConf$.MODULE$.apply(sqlConf);
            Configuration hadoopConf = new Configuration();
            IntRef latestStoreVersion = IntRef.create((int)0);
            Span timeoutDuration = SpanSugar$.MODULE$.convertIntToGrainOfTime(1).minute();
            package$.MODULE$.quietly((Function0)(JFunction0.mcV.sp & Serializable)() -> LocalSparkContext$.MODULE$.withSpark(SparkContext$.MODULE$.getOrCreate(conf), (Function1 & Serializable)sc -> {
                StateStoreCoordinatorSuite$.MODULE$.withCoordinatorRef(sc, (Function1<StateStoreCoordinatorRef, BoxedUnit>)(Function1 & Serializable)coordinatorRef -> {
                    StateStoreSuite.$anonfun$new$45($this, timeoutDuration$2, storeProviderId1$2, latestStoreVersion$2, storeConf$2, hadoopConf$2, coordinatorRef);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            }));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
        this.test("snapshotting", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource(this.newStoreProvider(5, 2), (Function1 & Serializable)provider -> {
            Option latestSnapshotVersion;
            Option snapshotVersion;
            int currentVersion = 0;
            currentVersion = this.updateVersionTo((StateStoreProvider)provider, currentVersion, 2);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider)).$eq$eq$eq(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))})), Equality$.MODULE$.default()));
            provider.doMaintenance();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), currentVersion).foreach((Function1 & Serializable)i -> StateStoreSuite.$anonfun$new$55(this, provider, BoxesRunTime.unboxToInt((Object)i)));
            currentVersion = this.updateVersionTo((StateStoreProvider)provider, currentVersion, 6);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider)).$eq$eq$eq(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)6))})), Equality$.MODULE$.default()), (Function0 & Serializable)() -> "store not updated correctly");
            provider.doMaintenance();
            Option $org_scalatest_assert_macro_left2 = snapshotVersion = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6).find((Function1)(JFunction1.mcZI.sp & Serializable)version -> this.fileExists(provider, version, true));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"snapshot file not generated", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
            this.deleteFilesEarlierThanVersion(provider, BoxesRunTime.unboxToInt((Object)snapshotVersion.get()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getData((HDFSBackedStateStoreProvider)provider, BoxesRunTime.unboxToInt((Object)snapshotVersion.get())));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), snapshotVersion.get())}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"snapshotting messed up the data of the snapshotted version", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)6))}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"snapshotting messed up the data of the final version", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
            currentVersion = this.updateVersionTo((StateStoreProvider)provider, currentVersion, 20);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider)).$eq$eq$eq(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)20))})), Equality$.MODULE$.default()), (Function0 & Serializable)() -> "store not updated correctly");
            provider.doMaintenance();
            Option $org_scalatest_assert_macro_left5 = latestSnapshotVersion = ((IterableOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 20).filter((Function1)(JFunction1.mcZI.sp & Serializable)version -> this.fileExists(provider, version, true))).lastOption();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"no snapshot file found", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
            int $org_scalatest_assert_macro_left6 = BoxesRunTime.unboxToInt((Object)latestSnapshotVersion.get());
            int $org_scalatest_assert_macro_right4 = BoxesRunTime.unboxToInt((Object)snapshotVersion.get());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left6 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"newer snapshot not generated", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
            this.deleteFilesEarlierThanVersion(provider, BoxesRunTime.unboxToInt((Object)latestSnapshotVersion.get()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider));
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)20))}));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"snapshotting messed up the data", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
        }), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
        this.test("SPARK-18416: do not create temp delta file until the store is updated", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String dir = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeId = new StateStoreProviderId(new StateStoreId(dir, 0L, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            StateStoreConf storeConf = StateStoreConf$.MODULE$.empty();
            Configuration hadoopConf = new Configuration();
            File deltaFileDir = new File(dir + "/0/0/");
            StateStore store0 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), 0, 0L, storeConf, hadoopConf), deltaFileDir);
            StateStoreTestsHelper$.MODULE$.put(store0, "a", 0, 1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
            store0.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 577));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
            StateStore store1 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), 0, 1L, storeConf, hadoopConf), deltaFileDir);
            StateStoreTestsHelper$.MODULE$.remove(store1, (Function1<Tuple2<String, Object>, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$67(x$5)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 588));
            store1.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right7 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 592));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right8 = 2;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
            StateStore store2 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), 0, 2L, storeConf, hadoopConf), deltaFileDir);
            store2.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right9 = 0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 602));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right10 = 3;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
        this.test("SPARK-21145: Restarted queries create new provider instances", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            try {
                File checkpointLocation = Utils$.MODULE$.createTempDir().getAbsoluteFile();
                SparkSession spark2 = SparkSession$.MODULE$.builder().master("local[2]").getOrCreate();
                SparkSession$.MODULE$.setActiveSession(spark2);
                SQLContext sqlContext = spark2.sqlContext();
                spark2.conf().set(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key(), "1");
                MemoryStream inputData = MemoryStream$.MODULE$.apply(spark2.implicits().newIntEncoder(), sqlContext);
                Seq loadedProvidersAfterRun1 = this.runQueryAndGetLoadedProviders$1(inputData, checkpointLocation);
                Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedProvidersAfterRun1.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                Seq loadedProvidersAfterRun2 = this.runQueryAndGetLoadedProviders$1(inputData, checkpointLocation);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedProvidersAfterRun2.length()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((StateStoreProvider)loadedProvidersAfterRun2.apply(0)).stateStoreId());
                StateStoreId $org_scalatest_assert_macro_right2 = ((StateStoreProvider)loadedProvidersAfterRun2.apply(1)).stateStoreId();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644));
                StateStoreProvider $org_scalatest_assert_macro_left3 = (StateStoreProvider)loadedProvidersAfterRun2.apply(0);
                StateStoreProvider $org_scalatest_assert_macro_right3 = (StateStoreProvider)loadedProvidersAfterRun2.apply(1);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "ne", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 != $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
            }
            finally {
                SparkSession$.MODULE$.getActiveSession().foreach((Function1 & Serializable)spark -> {
                    StateStoreSuite.$anonfun$new$70(spark);
                    return BoxedUnit.UNIT;
                });
            }
            return assertion;
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
        this.test("error writing [version].delta cancels the output stream", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Configuration hadoopConf = new Configuration();
            hadoopConf.set(SQLConf$.MODULE$.STREAMING_CHECKPOINT_FILE_MANAGER_CLASS().parent().key(), CreateAtomicTestManager.class.getName());
            String remoteDir = Utils$.MODULE$.createTempDir().getAbsolutePath();
            long x$54 = Random$.MODULE$.nextInt();
            boolean x$55 = false;
            String x$56 = remoteDir;
            Configuration x$57 = hadoopConf;
            int x$58 = this.newStoreProvider$default$3();
            int x$59 = this.newStoreProvider$default$5();
            int x$60 = this.newStoreProvider$default$6();
            return (Assertion)this.tryWithProviderResource(this.newStoreProvider(x$54, 0, x$58, x$56, x$59, x$60, x$57), (Function1 & Serializable)provider -> {
                CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(false);
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1)(JFunction1.mcJI.sp & Serializable)version -> {
                    StateStore store = provider.getStore((long)(version - 1));
                    StateStoreTestsHelper$.MODULE$.put(store, Integer.toString(version), 0, version);
                    return store.commit();
                });
                Set version10Data = ((IterableOnceOps)((IndexedSeqOps)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)10L)).map((Function1 & Serializable)x$7 -> StateStoreSuite.$anonfun$new$75(BoxesRunTime.unboxToLong((Object)x$7)))).map((Function1 & Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x), x))).toSet();
                CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic_$eq(false);
                StateStore store = provider.getStore(10L);
                CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(true);
                StateStoreTestsHelper$.MODULE$.put(store, "11", 0, 11);
                SparkException e = (SparkException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)package$.MODULE$.quietly((Function0)(JFunction0.mcJ.sp & Serializable)() -> store.commit())), ClassTag$.MODULE$.apply(SparkException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 680));
                Throwable $org_scalatest_assert_macro_left = e.getCause();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "java.io.IOException", $org_scalatest_assert_macro_left instanceof IOException, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 681));
                String $org_scalatest_assert_macro_left2 = e.getMessage();
                String $org_scalatest_assert_macro_right = "Cannot perform commit";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
                CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(false);
                CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic_$eq(false);
                StateStore store2 = provider.getStore(10L);
                StateStoreTestsHelper$.MODULE$.put(store2, "11", 0, 11);
                store2.abort();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic(), "org.apache.spark.sql.execution.streaming.CreateAtomicTestManager.cancelCalledInCreateAtomic", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 655));
        this.test("expose metrics with custom metrics to StateStoreMetrics", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ObjectRef store = ObjectRef.create(null);
            LongRef loadedMapSizeForVersion1 = LongRef.create((long)-1L);
            this.tryWithProviderResource(this.newStoreProvider(), (Function1 & Serializable)provider -> {
                StateStoreSuite.$anonfun$new$81(this, store, loadedMapSizeForVersion1, provider);
                return BoxedUnit.UNIT;
            });
            this.tryWithProviderResource(this.newStoreProvider(((StateStore)store.elem).id()), (Function1 & Serializable)reloadedProvider -> {
                StateStoreSuite.$anonfun$new$83(this, loadedMapSizeForVersion1, reloadedProvider);
                return BoxedUnit.UNIT;
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 694));
        Statics.releaseFence();
    }
}

