/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.streaming.CheckpointFileManagerTests;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005m2Q\u0001B\u0003\u0002\u0002IAQa\b\u0001\u0005\u0002\u0001BQA\t\u0001\u0005\u0012\rBQa\u000e\u0001\u0005\u0012a\u00121e\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'\u000fV3tiN|e\u000eT8dC245O\u0003\u0002\u0007\u000f\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u0011%\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005)Y\u0011aA:rY*\u0011A\"D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0019r\u0003\u0005\u0002\u0015+5\tQ!\u0003\u0002\u0017\u000b\tQ2\t[3dWB|\u0017N\u001c;GS2,W*\u00198bO\u0016\u0014H+Z:ugB\u0011\u0001$H\u0007\u00023)\u0011!dG\u0001\u0006a2\fgn\u001d\u0006\u00039%\t\u0001bY1uC2L8\u000f^\u0005\u0003=e\u0011\u0011bU)M\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005\t\u0003C\u0001\u000b\u0001\u0003I9\u0018\u000e\u001e5UK6\u0004\b*\u00193p_B\u0004\u0016\r\u001e5\u0015\u0005\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#\u0001B+oSRDQa\u000b\u0002A\u00021\n\u0011\u0001\u001d\t\u0005K5zC%\u0003\u0002/M\tIa)\u001e8di&|g.\r\t\u0003aUj\u0011!\r\u0006\u0003eM\n!AZ:\u000b\u0005Qj\u0011A\u00025bI>|\u0007/\u0003\u00027c\t!\u0001+\u0019;i\u0003Q\u0019\u0007.Z2l\u0019\u0016\f7.\u001b8h\u0007J\u001cg)\u001b7fgR\u0011A%\u000f\u0005\u0006u\r\u0001\raL\u0001\u0005a\u0006$\b\u000e")
public abstract class CheckpointFileManagerTestsOnLocalFs
extends CheckpointFileManagerTests
implements SQLHelper {
    private String sparkHome;
    private volatile boolean bitmap$0;

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    private String sparkHome$lzycompute() {
        CheckpointFileManagerTestsOnLocalFs checkpointFileManagerTestsOnLocalFs = this;
        synchronized (checkpointFileManagerTestsOnLocalFs) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    @Override
    public void withTempHadoopPath(Function1<Path, BoxedUnit> p) {
        this.withTempDir((Function1 & Serializable)f -> {
            CheckpointFileManagerTestsOnLocalFs.$anonfun$withTempHadoopPath$1(p, f);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void checkLeakingCrcFiles(Path path) {
        Seq fileNames = (Seq)((IterableOps)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])new File(path.toString()).listFiles())).filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.isFile()))).map((Function1 & Serializable)p -> p.getName());
        Seq crcFiles = (Seq)fileNames.filter((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)CheckpointFileManagerTestsOnLocalFs.$anonfun$checkLeakingCrcFiles$3(n)));
        Seq originFileNamesForExistingCrcFiles = (Seq)crcFiles.map((Function1 & Serializable)name -> name.substring(1, name.length() - 4));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(originFileNamesForExistingCrcFiles.toSet().subsetOf((Set)fileNames.toSet()), "originFileNamesForExistingCrcFiles.toSet[String].subsetOf(fileNames.toSet[String])", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Some of origin files for crc files don't exist - crc files: " + crcFiles + " / expected origin files: " + originFileNamesForExistingCrcFiles + " / actual files: " + fileNames), Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
    }

    public static final /* synthetic */ void $anonfun$withTempHadoopPath$1(Function1 p$1, File f) {
        Path basePath = new Path(f.getAbsolutePath());
        p$1.apply((Object)basePath);
    }

    public static final /* synthetic */ boolean $anonfun$checkLeakingCrcFiles$3(String n) {
        return n.startsWith(".") && n.endsWith(".crc");
    }

    public CheckpointFileManagerTestsOnLocalFs() {
        SQLHelper.$init$((SQLHelper)this);
    }
}

